C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C
C			Copyright (c) 1995 by
C			Kubota Graphics Technology Inc.
C			All Rights Reserved
C	
C	This software comprises unpublished confidential information of
C	Kubota Graphics Technology Inc. and may not be used, copied or
C	made available to anyone, except in accordance with the license
C	under which it is furnished.
C	
C       module name   :  Contour Lines
C       file name     :  contourline.f
C       exe           :  contourline
C
C       creates contour lines for 2D (scalar or 2-vector) field.
C	
C **********************************************************************
C  Module Description
C **********************************************************************
      integer function Create_linecont_desc()
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
      integer in_port,in_port2,out_port,param1,param2
      external Create_linecont_compute
      integer Create_linecont_compute

C Set the module name and type
      call AVSset_module_name('Contour Lines', 'mapper')
      call AVSset_module_flags(single_arg_data)

C Create an input port (name, type) 
      in_port = AVScreate_input_port('input1'
     *          ,'field 2D 3-space real irregular',REQUIRED)
      in_port2 = AVScreate_input_port
     *         ('input2','colormap',REQUIRED)

C Create an output port for the result (name, type) 
      out_port = AVScreate_output_port('Geometry', 'geom')

C Add parameter
      param1 = AVSadd_parameter('On/Off','boolean',1,0,1)
      param1 = AVSadd_parameter('just', 'oneshot',0,0,0)
      param1 = AVSadd_parameter('color option', 'boolean',0,0,1)


      param1 = AVSadd_parameter
     *      ('min', 'real',-0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)
      param1 = AVSadd_parameter
     *      ('max', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)
      param1 = AVSadd_parameter('line_num ', 'integer',5,5,50)

      param1 = AVSadd_parameter('file option','boolean',0,0,1)

      param1 = AVSadd_parameter
     *     ('target file','string',' ',' ',' ')
      call AVSconnect_widget(param1,'browser')

      param1 = AVSadd_parameter
     * ('information min', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)
      param2 = AVSadd_parameter
     * ('information max', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)

      call AVSconnect_widget(param1,'typein_real')
      call AVSconnect_widget(param2,'typein_real')

      call AVSautofree_output(out_port)
      call AVSset_compute_proc(Create_linecont_compute)

      Create_linecont_desc = 1
      return
      end

C **********************************************************************
C  Module Compute Routine
C **********************************************************************
      integer function Create_linecont_compute
     &                (input1,colormap,output1
     &                ,ionoff,ijust,icoption
     &                ,pmin,pmax,nline1
     &                ,ifoption,targetfile
     &                ,infommin,infommax)

C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'

C Input port data for "field"
#ifdef OSF1 
      integer*8 input1
      integer*8 pfield,pcoords
#else
      integer input1
      integer pfield,pcoords
#endif
      integer idim,dims(2),ni,nj,nvlen

C Input port data for "colormap"
#ifdef OSF1
      integer*8 colormap
#else
      integer colormap
#endif
      integer size
      real lower,upper
      real hue(256), sat(256), val(256), alpha(256)
      real color_tbl(3,256)

C Output port data for "geometry"
#ifdef OSF1
      integer*8 output1,obj0
#else
      integer output1,obj0
#endif

C Parameter
      real pmin,pmax
      real cmax,cmin
      real infommin,infommax
      integer nline1

C target file 
      character*(*) targetfile

C Dimension for verts & color 
      dimension verts(6),colors(3,2)

C create line data 
      real w(1)
#ifdef OSF1
      integer*8 pw,ow
#else
      integer pw,ow
#endif

C Get input data
      idim = AVSfield_get_dimensions(input1,dims)
      ni = dims(1)
      nj = dims(2)
      nvlen = AVSfield_get_int(input1,AVS_field_veclen) 
      pfield = AVSfield_data_ptr(input1)
      pcoords = AVSfield_points_ptr(input1)

      write(6,*) 'ni,nj,nvlen = ',ni,nj,nvlen

C Error 
      if(nvlen.ge.3) goto 994

C Information
      call minmax(%val(pfield),ni,nj,ppmin,ppmax,nvlen)
      call AVSmodify_parameter
     *        ('information min',AVS_VALUE,ppmin,0.0,0.0)
      call AVSmodify_parameter
     *        ('information max',AVS_VALUE,ppmax,0.0,0.0)
 
C Oneshot change just
      ich = AVSparameter_changed('just')
      if(ich.eq.1) then
         call AVSmodify_parameter('max',AVS_VALUE,ppmax,0.0,0.0)
         call AVSmodify_parameter('min',AVS_VALUE,ppmin,0.0,0.0)
         pmax = ppmax
         pmin = ppmin
      endif

C Not polygon
      if( ionoff .eq. 0) then
         obj0 =  geom_create_obj(GEOM_POLYTRI,GEOM_NULL)
         output1 = geom_init_edit_list(output1)
         call geom_edit_geometry(output1,'contourline',obj0)
         call geom_destroy_obj(obj0)
         Create_linecont_compute = 1
         return
      endif
 
C Create OBJ
      obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)

C Create color table
      iresult = AVScolormap_get
     &         (colormap,256,size,lower,upper,hue,sat,val,alpha)
      do L = 1,256
          call hsv_to_rgb(color_tbl(1,L),color_tbl(2,L),
     *                    color_tbl(3,L),hue(L),sat(L),val(L))
      enddo

C Color option
      if(icoption.eq.1) then
         cmax = upper
         cmin = lower
         call AVSmodify_parameter('max',AVS_VALUE,cmax,0.0,0.0)
         call AVSmodify_parameter('min',AVS_VALUE,cmin,0.0,0.0)
         pmax = cmax
         pmin = cmin
      else
         cmax = pmax
         cmin = pmin
      endif

C  for line data
#ifdef OSF1
      call falloc(ni*nj*6,4,0,w,pw,ow)
#else
      call ffalloc(ni*nj*6,4,0,w,pw,ow)
#endif

      div = abs(cmax - cmin)
      if( div .lt. 0.0000000001) then
          fact = 1.
      else
          fact = 1./(cmax - cmin)
      endif

C SET TARGET 
C   file 
      if(ifoption.eq.1) then
        open(unit=33,file=targetfile
     *              ,form='formatted',status='old',err=991)
        read(33,*,err=993) nline2
        if(nline2.gt.50) goto 992

        do L = 1,nline2
          read(33,*,err=993) target
          indexc=255*max(0.,min(1.0,(target - cmin)*fact)) + 1
          colors(1,1) = color_tbl(1,indexc)
          colors(2,1) = color_tbl(2,indexc)
          colors(3,1) = color_tbl(3,indexc)
          colors(1,2) = colors(1,1)
          colors(2,2) = colors(2,1)
          colors(3,2) = colors(3,1)
          call con(target,%val(pcoords),%val(pfield)
     *                        ,ni,nj,w(ow+1),numl,nvlen)
          do LL = 1,numl
            do ii = 1,6
              verts(ii) = w(ow+ii+6*(LL-1))
            enddo
            call geom_add_disjoint_line
     *          (obj0,verts,colors,2,GEOM_COPY_DATA)
          enddo
        enddo
        close(33)
        
C   auto 
      else
        do L = 1,nline1
          target=pmin+float(L-1)*(pmax-pmin)/float(nline1-1)
          indexc=255*max(0.,min(1.0,(target - cmin)*fact)) + 1
          colors(1,1) = color_tbl(1,indexc)
          colors(2,1) = color_tbl(2,indexc)
          colors(3,1) = color_tbl(3,indexc)
          colors(1,2) = colors(1,1)
          colors(2,2) = colors(2,1)
          colors(3,2) = colors(3,1)
          call con(target,%val(pcoords),%val(pfield)
     *                        ,ni,nj,w(ow+1),numl,nvlen)
          do LL = 1,numl
            do ii = 1,6
              verts(ii) = w(ow+ii+6*(LL-1))
            enddo
            call geom_add_disjoint_line
     *          (obj0,verts,colors,2,GEOM_COPY_DATA)
          enddo
        enddo
      endif

      call geom_gen_normals(obj0,0)
      output1 = geom_init_edit_list(output1)
      call geom_edit_geometry(output1,'contourline',obj0)
      call geom_destroy_obj(obj0)
#ifdef OSF1
      call free(pw)
#else
      call ffree(pw)
#endif
      Create_linecont_compute = 1
      return

 991  call AVSwarning(' can not open target file ')
      Create_linecont_compute = 0
      close(33)
      return
 992  call AVSwarning(' number of line < 50 ')
      Create_linecont_compute = 0
      close(33)
      return
 993  call AVSwarning(' read err ')
      Create_linecont_compute = 0
      close(33)
      return
 994  call AVSwarning(' veclen < 3 ')
      Create_linecont_compute = 0
      return
      end

C **********************************************************************
C  Initialization for modules contained in this file.
C **********************************************************************
      subroutine AVSinit_modules
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
      external Create_linecont_desc
      integer Create_linecont_desc
      call AVSmodule_from_desc(Create_linecont_desc)
      end

C **********************************************************************
C  User routine 
C **********************************************************************
      subroutine con(target,xyz,data,ni,nj,line,numl,nvlen)
c
c  target  value of line
c  data    scalar value
c  line    line data
c  numl    number of line
c  nvlen   number of input data(1 or 2)
c             1 = scalar value
c             2 = scalar value + flag data
c             data(2,i,j) = 1.0 : fluid node
c                         = 0.0 : non fluid node
c
      real target,xyz(ni,nj,3),data(nvlen,ni,nj),line(6,*)
      real w1,w2,w3
      real xyz12(6)
      real t1,t2,t3
      integer numl

C count number of line
      numl = 0

C include flag data 
      if(nvlen.eq.2) then
      do i = 1, ni-1
       do j = 1, nj-1
C flag check if
        if((data(2,i  ,j  ).eq.0.) .and.
     &     (data(2,i+1,j  ).eq.0.) .and.
     &     (data(2,i+1,j+1).eq.0.) .and.
     &     (data(2,i  ,j+1).eq.0.)) then
C fluid cell
        else
         w1 = data(1,i,j)   - target
         w2 = data(1,i+1,j) - target
         w3 = data(1,i,j+1) - target
c    (w1*w2<0)
         if(w1*w2 .lt. 0.)then
           w4 = data(1,i+1,j) - data(1,i,j)
           do L = 1,3
             xyz12(L)= xyz(i+1,j,L)
            if(w4.ne.0.0) then
             xyz12(L)=
     *          xyz(i+1,j,L)-w2/w4*(xyz(i+1,j,L)-xyz(i,j,L))
            endif
           enddo
           if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i,j)
            do L = 1,3
             xyz12(L+3)= xyz(i,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i,j,L)-w1/w4*(xyz(i,j+1,L)-xyz(i,j,L))
             endif
            enddo  
          else
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
          endif
          numl = numl + 1
          do L = 1,6
           line(L,numl) = xyz12(L)
          enddo
c    (w1*w2=>0)
         else     
          if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i,j)
            do L = 1,3
             xyz12(L)= xyz(i,j,L)
             if(w4.ne.0.0) then
              xyz12(L)=
     *        xyz(i,j,L)-w1/w4*(xyz(i,j+1,L)-xyz(i,j,L))
             endif
            enddo
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
            numl = numl + 1
            do L = 1,6
             line(L,numl) = xyz12(L)
            enddo
          endif 
         endif
c    (w1*w2)
         w1 = data(1,i+1,j+1) - target
         w2 = data(1,i+1,j) - target
         w3 = data(1,i,j+1) - target
c    (w1*w2<0)
         if(w1*w2 .lt. 0.)then
           w4 = data(1,i+1,j) - data(1,i+1,j+1)
           do L = 1,3
            xyz12(L)= xyz(i+1,j,L)
            if(w4.ne.0.0) then
             xyz12(L)=
     *       xyz(i+1,j,L)-w2/w4*(xyz(i+1,j,L)-xyz(i+1,j+1,L))
            endif
           enddo
           if(w1*w3 .lt. 0.)then
             w4 = data(1,i,j+1) - data(1,i+1,j+1)
             do L = 1,3
              xyz12(L+3)= xyz(i+1,j+1,L)
              if(w4.ne.0.) then
               xyz12(L+3)=
     *         xyz(i+1,j+1,L)-w1/w4*(xyz(i,j+1,L)-xyz(i+1,j+1,L))
              endif
             enddo
           else
             w4 = data(1,i,j+1) - data(1,i+1,j)
             do L = 1,3
              xyz12(L+3)= xyz(i+1,j,L)
              if(w4.ne.0.0) then
               xyz12(L+3)=
     *         xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
              endif
             enddo
           endif
           numl = numl + 1
           do L = 1,6
            line(L,numl) = xyz12(L)
           enddo
c    (w1*w2=>0)
         else
           if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i+1,j+1)
            do L = 1,3
             xyz12(L)= xyz(i+1,j+1,L)
             if(w4.ne.0.0) then
              xyz12(L)=
     *        xyz(i+1,j+1,L)-w1/w4*(xyz(i,j+1,L)-xyz(i+1,j+1,L))
             endif
            enddo
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
            numl = numl + 1
            do L = 1,6
             line(L,numl) = xyz12(L)
            enddo
           endif  
         endif
c  flag check if
        endif
c    (w1*w2)
       enddo  
      enddo 
C
C not flag data
      else
      do i = 1, ni-1
       do j = 1, nj-1
         w1 = data(1,i,j)   - target
         w2 = data(1,i+1,j) - target
         w3 = data(1,i,j+1) - target
c    (w1*w2<0)
         if(w1*w2 .lt. 0.)then
           w4 = data(1,i+1,j) - data(1,i,j)
           do L = 1,3
             xyz12(L)= xyz(i+1,j,L)
            if(w4.ne.0.0) then
             xyz12(L)=
     *          xyz(i+1,j,L)-w2/w4*(xyz(i+1,j,L)-xyz(i,j,L))
            endif
           enddo
           if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i,j)
            do L = 1,3
             xyz12(L+3)= xyz(i,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i,j,L)-w1/w4*(xyz(i,j+1,L)-xyz(i,j,L))
             endif
            enddo  
          else
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
          endif
          numl = numl + 1
          do L = 1,6
           line(L,numl) = xyz12(L)
          enddo
c    (w1*w2=>0)
         else     
          if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i,j)
            do L = 1,3
             xyz12(L)= xyz(i,j,L)
             if(w4.ne.0.0) then
              xyz12(L)=
     *        xyz(i,j,L)-w1/w4*(xyz(i,j+1,L)-xyz(i,j,L))
             endif
            enddo
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
            numl = numl + 1
            do L = 1,6
             line(L,numl) = xyz12(L)
            enddo
          endif 
         endif

c    (w1*w2)
         w1 = data(1,i+1,j+1) - target
         w2 = data(1,i+1,j) - target
         w3 = data(1,i,j+1) - target
c    (w1*w2<0)
         if(w1*w2 .lt. 0.)then
           w4 = data(1,i+1,j) - data(1,i+1,j+1)
           do L = 1,3
            xyz12(L)= xyz(i+1,j,L)
            if(w4.ne.0.0) then
             xyz12(L)=
     *       xyz(i+1,j,L)-w2/w4*(xyz(i+1,j,L)-xyz(i+1,j+1,L))
            endif
           enddo
           if(w1*w3 .lt. 0.)then
             w4 = data(1,i,j+1) - data(1,i+1,j+1)
             do L = 1,3
              xyz12(L+3)= xyz(i+1,j+1,L)
              if(w4.ne.0.) then
               xyz12(L+3)=
     *         xyz(i+1,j+1,L)-w1/w4*(xyz(i,j+1,L)-xyz(i+1,j+1,L))
              endif
             enddo
           else
             w4 = data(1,i,j+1) - data(1,i+1,j)
             do L = 1,3
              xyz12(L+3)= xyz(i+1,j,L)
              if(w4.ne.0.0) then
               xyz12(L+3)=
     *         xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
              endif
             enddo
           endif
           numl = numl + 1
           do L = 1,6
            line(L,numl) = xyz12(L)
           enddo
c    (w1*w2=>0)
         else
           if(w1*w3 .lt. 0.)then
            w4 = data(1,i,j+1) - data(1,i+1,j+1)
            do L = 1,3
             xyz12(L)= xyz(i+1,j+1,L)
             if(w4.ne.0.0) then
              xyz12(L)=
     *        xyz(i+1,j+1,L)-w1/w4*(xyz(i,j+1,L)-xyz(i+1,j+1,L))
             endif
            enddo
            w4 = data(1,i,j+1) - data(1,i+1,j)
            do L = 1,3
             xyz12(L+3)= xyz(i+1,j,L)
             if(w4.ne.0.0) then
              xyz12(L+3)=
     *        xyz(i+1,j,L)-w2/w4*(xyz(i,j+1,L)-xyz(i+1,j,L))
             endif
            enddo
            numl = numl + 1
            do L = 1,6
             line(L,numl) = xyz12(L)
            enddo
           endif  
         endif
c    (w1*w2)
       enddo  
      enddo 
C flag if
      endif

      return
      end

C***********************************************************************
C        subroutine minmax
C***********************************************************************
      subroutine minmax(data,ni,nj,ppmin,ppmax,nvlen)
      real data(nvlen,ni,nj)
      real ppmin,ppmax

      if(nvlen.eq.2) then
       write(6,*) ' include flag data '
        do j = 1,nj
         do i = 1,ni
            if((data(2,i  ,j  ).eq.0.) .and.
     &         (data(2,i+1,j  ).eq.0.) .and.
     &         (data(2,i  ,j+1).eq.0.) .and.
     &         (data(2,i+1,j+1).eq.0.)) then
            else
                imin = i
                jmin = j
                goto 111
            endif
         enddo
        enddo
 111   continue
       ppmin = data(1,imin,jmin)
       ppmax = data(1,imin,jmin)
        do j = 1,nj
         do i = 1,ni
            if((data(2,i  ,j  ).eq.0.) .and.
     &         (data(2,i+1,j  ).eq.0.) .and.
     &         (data(2,i  ,j+1).eq.0.) .and.
     &         (data(2,i+1,j+1).eq.0.)) then
            else
              ppmin = min(data(1,i,j),ppmin)
              ppmax = max(data(1,i,j),ppmax)
            endif
         enddo
        enddo
      else
       write(6,*) ' not flag data '
       ppmin = data(1,1,1)
       ppmax = data(1,1,1)
        do j = 1,nj
         do i = 1,ni
            ppmin = min(data(1,i,j),ppmin)
            ppmax = max(data(1,i,j),ppmax)
         enddo
        enddo
      endif

      write(6,*) ' input min max data = ',ppmin,ppmax
      return
      end

C **********************************************************************
C  hsv to rgb 
C **********************************************************************
       subroutine hsv_to_rgb(r,g,b,ht,s,v)
       real f, p, q, t
       real r, g, b
       real ht, s, v
       real h
C Make sure not to trash the input colormap
       h = ht
       if(v.eq.0) then
        r=0
        g=0
        b=0
        goto 100
       elseif(s.eq.0) then
        r = v
        g = v
        b = v
        goto 100
       else
        h = h * 6.0
        if(h.ge.6.0) then
          h = 0.0
        endif

        i = h
        f = h - i
        p = v*(1.0-s)
        q = v*(1.0-s*f)
        t = v*(1.0-s*(1.0-f))
       endif

       if(i.eq.0) then
          r = v
          g = t
          b = p
      elseif(i.eq.1) then
         r = q
         g = v
         b = p
      elseif(i.eq.2) then
         r = p
         g = v
         b = t
      elseif(i.eq.3) then
         r = p
         g = q
         b = v
      elseif(i.eq.4) then
         r = t
         g = p
         b = v
      elseif(i.eq.5) then
         r = v
         g = p
         b = q
      endif
  100 continue
      return
      end
