C                  INTERNATIONAL AVS CENTER
C        (This disclaimer must remain at the top of all files)
C
C WARRANTY DISCLAIMER
C
C This module and the files associated with it are distributed free of charge.
C It is placed in the public domain and permission is granted for anyone to use,
C duplicate, modify, and redistribute it unless otherwise noted.  Some modules
C may be copyrighted.  You agree to abide by the conditions also included in
C the AVS Licensing Agreement, version 1.0, located in the main module
C directory located at the International AVS Center ftp site and to include
C the AVS Licensing Agreement when you distribute any files downloaded from
C that site.
C
C The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module provide absolutely
C NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
C the quality and performance of this software is with the user.  IN NO EVENT
C WILL The International AVS Center, MCNC, the AVS Consortium and the individual
C submitting the module and files associated with said module BE LIABLE TO
C ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
C WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
C SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.
C
C This AVS module and associated files are public domain software unless
C otherwise noted.  Permission is hereby granted to do whatever you like with
C it, subject to the conditions that may exist in copyrighted materials. Should
C you wish to make a contribution toward the improvement, modification, or
C general performance of this module, please send us your comments:  why you
C liked or disliked it, how you use it, and most important, how it helps your
C work. We will receive your comments at avs@ncsc.org.
C
C Please send AVS module bug reports to avs@ncsc.org.
C
C
C			Copyright (c) 1995 by
C			Kubota Graphics Technology Inc.
C			All Rights Reserved
C	
C	This software comprises unpublished confidential information of
C	Kubota Graphics Technology Inc. and may not be used, copied or
C	made available to anyone, except in accordance with the license
C	under which it is furnished.
C	
C       module name   :  Contour Mesh
C       file name     :  contourmesh.f
C       exe           :  contourmesh
C
C       creates contour surface for 2D (scalar or 2-vector) field.
C	
C **********************************************************************
C  Module Description
C **********************************************************************
      integer function Create_fillcont_desc()
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
      integer in_port,in_port2,out_port,param1,param2
      external Create_fillcont_compute
      integer Create_fillcont_compute

C Set the module name and type
      call AVSset_module_name('Contour Mesh', 'mapper')
      call AVSset_module_flags(single_arg_data)

C Create an input port (name, type) 
      in_port = AVScreate_input_port('input1'
     *          ,'field 2D 3-space real irregular',REQUIRED)
      in_port2 = AVScreate_input_port
     *         ('input2','colormap',REQUIRED)

C Create an output port for the result (name, type) 
      out_port = AVScreate_output_port('Geometry', 'geom')

C Add parameter
      param1 = AVSadd_parameter('On/Off','boolean',1,0,1)
      param1 = AVSadd_parameter('just', 'oneshot',0,0,0)
      param1 = AVSadd_parameter('color option','boolean',0,0,1)

      param1 = AVSadd_parameter
     *      ('min', 'real',-0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)
      param1 = AVSadd_parameter
     *      ('max', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)

      param1 = AVSadd_parameter
     * ('information min', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)
      param2 = AVSadd_parameter
     * ('information max', 'real',0.5,FLOAT_UNBOUND,FLOAT_UNBOUND)

      call AVSconnect_widget(param1,'typein_real')
      call AVSconnect_widget(param2,'typein_real')

      call AVSautofree_output(out_port)
      call AVSset_compute_proc(Create_fillcont_compute)

      Create_fillcont_desc = 1
      return
      end

C **********************************************************************
C  Module Compute Routine
C **********************************************************************
      integer function Create_fillcont_compute
     &                (input1,colormap,output1
     &                ,ionoff,ijust,icoption
     &                ,pmin,pmax
     &                ,infommin,infommax)

C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'

C Input port data for "field"
#ifdef OSF1
      integer*8 input1
      integer*8 pfield,pcoords
#else
      integer input1
      integer pfield,pcoords
#endif
      integer idim,dims(2),ni,nj,nvlen

C Input port data for "colormap"
#ifdef OSF1
      integer*8 colormap
#else
      integer colormap
#endif
      integer size
      real lower, upper
      real hue(256), sat(256), val(256), alpha(256)
      real color_tbl(3,256)

C Output port data for "geometry"
#ifdef OSF1
      integer*8 output1,obj0
#else
      integer output1,obj0
#endif

C Parameter
      integer ionoff,ijust
      real pmin,pmax
      real cmin,cmax
      real infommin,infommax

C Memory allocation
      real cc(1)
      real ww(1)
      integer vl(1)
#ifdef OSF1
      integer*8 pww,oww
      integer*8 pvl,ovl
      integer*8 pcc,occ
#else
      integer pww,oww
      integer pvl,ovl
      integer pcc,occ
#endif

C Get input data
      idim = AVSfield_get_dimensions(input1,dims)
      ni = dims(1)
      nj = dims(2)
      nvlen = AVSfield_get_int(input1,AVS_field_veclen)
      pfield = AVSfield_data_ptr(input1)
      pcoords = AVSfield_points_ptr(input1)
   
      write(6,*) 'ni,nj,nvlen = ',ni,nj,nvlen

C Error
      if(nvlen.ge.3) goto 994

C Information
      call minmax(%val(pfield),ni,nj,ppmin,ppmax,nvlen)
      call AVSmodify_parameter
     &         ('information min',AVS_VALUE,ppmin,0.0,0.0)
      call AVSmodify_parameter
     &         ('information max',AVS_VALUE,ppmax,0.0,0.0)
 
C Oneshot change just 
      ich = AVSparameter_changed('just')
      if(ich.eq.1) then
         call AVSmodify_parameter('min',AVS_VALUE,ppmin,0.0,0.0)
         call AVSmodify_parameter('max',AVS_VALUE,ppmax,0.0,0.0)
         pmax = ppmax
         pmin = ppmin
      endif

C Not polygon 
      if( ionoff .eq. 0) then
         obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)
         output1 = geom_init_edit_list(output1)
         call geom_edit_geometry(output1,'contourmesh',obj0)
         call geom_destroy_obj(obj0)
         Create_fillcont_compute = 1
         return
      endif

C Create OBJ
      obj0 = geom_create_obj(GEOM_POLYTRI,GEOM_NULL)
 
C Create color table 
      iresult = AVScolormap_get
     &         (colormap,256,size,lower,upper,hue,sat,val,alpha)
      do L = 1,256
          call hsv_to_rgb(color_tbl(1,L),color_tbl(2,L),
     &                    color_tbl(3,L),hue(L),sat(L),val(L))
      enddo

C Color option
      if(icoption.eq.1) then
         cmax = upper
         cmin = lower
         call AVSmodify_parameter('max',AVS_VALUE,cmax,0.0,0.0)
         call AVSmodify_parameter('min',AVS_VALUE,cmin,0.0,0.0)
         pmax = cmax
         pmin = cmin
      else
         cmax = pmax
         cmin = pmin
      endif
 
C Memory alloc for color 
#ifdef OSF1
      call falloc(ni*nj*3,4,0,cc,pcc,occ)
      call falloc(ni*nj*3,4,0,ww,pww,oww)
      call falloc(ni*nj*5+1,4,0,vl,pvl,ovl)
#else
      call ffalloc(ni*nj*3,4,0,cc,pcc,occ)
      call ffalloc(ni*nj*3,4,0,ww,pww,oww)
      call ffalloc(ni*nj*5+1,4,0,vl,pvl,ovl)
#endif
 
C Set float color and make data
      div = abs(cmax - cmin)
      if( div .lt. 0.0000000001 ) then
         fact = 1.
      else
         fact = 1./(cmax-cmin)
      endif

C Set color/verts list
      call set_color(cc(occ+1),color_tbl
     &              ,%val(pfield),fact,cmin,ni*nj,nvlen)
      call set_vlist(vl(ovl+1),%val(pfield),ni,nj,nvlen)
      call reverse(ww(oww+1),%val(pcoords),ni*nj)
 
C Create object
      obj0 = GEOM_create_obj(GEOM_POLYHEDRON,GEOM_NULL)
      call GEOM_add_vertices
     &       (obj0,ww(oww+1),ni*nj,GEOM_COPY_DATA)
      call GEOM_add_float_colors
     &       (obj0,cc(occ+1),ni*nj,GEOM_COPY_DATA)
      call GEOM_add_polygons
     &       (obj0,vl(ovl+1),GEOM_CONVEX,GEOM_COPY_DATA)
      call geom_gen_normals(obj0,0)

      output1 = geom_init_edit_list(output1)
 
      call geom_edit_geometry(output1,'contourmesh',obj0)
      call geom_edit_render_mode(output1,'contourmesh','no_light')
      call geom_destroy_obj(obj0)
 
C Memory free
#ifdef OSF1
      call free(pcc)
      call free(pww)
      call free(pvl)
#else 
      call ffree(pcc)
      call ffree(pww)
      call ffree(pvl)
#endif
      Create_fillcont_compute = 1
      return

 994  Create_fillcont_compute = 0
      return
      end

C **********************************************************************
C  Initialization for modules contained in this file.
C **********************************************************************
      subroutine AVSinit_modules
C   IAC CODE CHANGE :       include 'avs/avs.inc'
	INCLUDE '/usr/avs/include/avs.inc'
C   IAC CODE CHANGE :       include 'avs/geom.inc'
	INCLUDE '/usr/avs/include/geom.inc'
      external Create_fillcont_desc
      integer Create_fillcont_desc
      call AVSmodule_from_desc(Create_fillcont_desc)
      end

C **********************************************************************
C  Subroutine set_color
C **********************************************************************
      subroutine set_color(color,ctbl,data,fact,cmin,isize,nvlen)
      real color(3,isize),ctbl(3,*),data(nvlen,*),fact,cmin

       do j = 1,isize
          indexc = 255* max(0.,min(1.0,(data(1,j)-cmin)*fact))+1
          color(1,j) = ctbl(1,indexc)
          color(2,j) = ctbl(2,indexc)
          color(3,j) = ctbl(3,indexc)
       enddo

      return
      end

C **********************************************************************
C subroutine   set_vlist
C **********************************************************************
      subroutine set_vlist(vlist,data,ni,nj,nvlen)
      integer vlist(5,*)
      real data(nvlen,ni,nj)
 
      icnt = 0
C include flag data
      if( nvlen.eq.2 ) then
       do j = 1,nj-1
        do i = 1,ni-1
          ib = i + ni*(j-1)
          if((data(2,i  ,j  ).eq.0.) .and.
     &       (data(2,i+1,j  ).eq.0.) .and.
     &       (data(2,i  ,j+1).eq.0.) .and.
     &       (data(2,i+1,j+1).eq.0.)) then
          else
           icnt = icnt + 1
           vlist(1,icnt) = 4
           vlist(2,icnt) = ib
           vlist(3,icnt) = ib + 1
           vlist(4,icnt) = ib + ni + 1
           vlist(5,icnt) = ib + ni 
          endif
        enddo
       enddo
C not flag
      else 
       do j = 1,nj-1
        do i = 1,ni-1
          ib = i + ni*(j-1)
          icnt = icnt + 1
          vlist(1,icnt) = 4
          vlist(2,icnt) = ib
          vlist(3,icnt) = ib + 1
          vlist(4,icnt) = ib + ni + 1
          vlist(5,icnt) = ib + ni 
        enddo
       enddo
      endif

      vlist(1,icnt+1) = 0 

      return
      end

C **********************************************************************
C  subroutine   reverse
C **********************************************************************
      subroutine reverse(out,in,isize)
      real out(3,*),in(isize,3)
       do L = 1,isize
          out(1,L) = in(L,1)
          out(2,L) = in(L,2)
          out(3,L) = in(L,3)
       enddo
      return
      end

C **********************************************************************
C  subroutine minmax
C **********************************************************************
      subroutine minmax(data,ni,nj,ppmin,ppmax,nvlen)
      real data(nvlen,ni,nj)
      real ppmin,ppmax

      if(nvlen.eq.2) then
       write(6,*) ' include flag data '
        do j = 1,nj
         do i = 1,ni
            if((data(2,i  ,j  ).eq.0.) .and.
     &         (data(2,i+1,j  ).eq.0.) .and.
     &         (data(2,i  ,j+1).eq.0.) .and.
     &         (data(2,i+1,j+1).eq.0.)) then
            else
                imin = i
                jmin = j
                goto 111
            endif
         enddo
        enddo
 111   continue
       ppmin = data(1,imin,jmin)
       ppmax = data(1,imin,jmin)
        do j = 1,nj
         do i = 1,ni
            if((data(2,i  ,j  ).eq.0.) .and.
     &         (data(2,i+1,j  ).eq.0.) .and.
     &         (data(2,i  ,j+1).eq.0.) .and.
     &         (data(2,i+1,j+1).eq.0.)) then
            else
              ppmin = min(data(1,i,j),ppmin)
              ppmax = max(data(1,i,j),ppmax)
            endif
         enddo
        enddo
      else
       write(6,*) ' not flag data '
       ppmin = data(1,1,1)
       ppmax = data(1,1,1)
        do j = 1,nj
         do i = 1,ni
            ppmin = min(data(1,i,j),ppmin)
            ppmax = max(data(1,i,j),ppmax)
         enddo
        enddo
      endif

      write(6,*) ' input min max data = ',ppmin,ppmax
      return
      end

C **********************************************************************
C  hsv to rgb 
C **********************************************************************
       subroutine hsv_to_rgb(r,g,b,ht,s,v)
       real f, p, q, t
       real r, g, b
       real ht, s, v
       real h
C Make sure not to trash the input colormap
       h = ht
       if(v.eq.0) then
        r=0
        g=0
        b=0
        goto 100
       elseif(s.eq.0) then
        r = v
        g = v
        b = v
        goto 100
       else
        h = h * 6.0
        if(h.ge.6.0) then
          h = 0.0
        endif

        i = h
        f = h - i
        p = v*(1.0-s)
        q = v*(1.0-s*f)
        t = v*(1.0-s*(1.0-f))
       endif

       if(i.eq.0) then
          r = v
          g = t
          b = p
      elseif(i.eq.1) then
         r = q
         g = v
         b = p
      elseif(i.eq.2) then
         r = p
         g = v
         b = t
      elseif(i.eq.3) then
         r = p
         g = q
         b = v
      elseif(i.eq.4) then
         r = t
         g = p
         b = v
      elseif(i.eq.5) then
         r = v
         g = p
         b = q
      endif
  100 continue
      return
      end
