/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

*****************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "Field To Polygons" (Mapper) (Subroutine)                  */
/* Author: Jeff Wang,NCSC,248-9242                                       */
/* Date Created: Tue Oct  5 14:29:37 1993                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* End of Module Description Comments                                    */

#include <stdio.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/avs.h>
#include <avs/flow.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
#define MASK 0xFF

void round();
void unpack();
float x_cut();
float y_cut();
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int Field_To_Polygons_desc()
{

	int in_port, out_port, param;
        int p;
	extern int Field_To_Polygons_compute();

	AVSset_module_name("Field To Polygons", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("infield", 
		"field 1D 1-vector 4-space irregular", REQUIRED);
	in_port = AVScreate_input_port("incolor", "colormap", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("outgeom", "geom");

	p=AVSadd_parameter("Number steps","integer",4,1,255);
	AVSconnect_widget(p,"typein_integer");
	p=AVSadd_float_parameter("Low data value",0.0,FLOAT_UNBOUND,
		FLOAT_UNBOUND);
	AVSconnect_widget(p,"typein_real");
	p=AVSadd_float_parameter("High data value",0.0,FLOAT_UNBOUND,
		FLOAT_UNBOUND);
	AVSconnect_widget(p,"typein_real");
	AVSadd_parameter("Min/Max of field","boolean",0,0,1);
        param = AVSadd_float_parameter("INPUT x min", 0.0, FLOAT_UNBOUND,
                FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
        param = AVSadd_float_parameter("INPUT x max", 0.0, FLOAT_UNBOUND,
                 FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
        param = AVSadd_float_parameter("INPUT y min", 0.0, FLOAT_UNBOUND,
                 FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");
        param = AVSadd_float_parameter("INPUT y max", 0.0, FLOAT_UNBOUND,
                 FLOAT_UNBOUND);
        AVSconnect_widget(param, "typein_real");

	AVSset_compute_proc(Field_To_Polygons_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int Field_To_Polygons_compute( 
infield, 
incolor, 
outgeom,
nsteps,
low,
high,
minmax,
minx, maxx, miny, maxy 
)
	AVSfield *infield;
	AVScolormap *incolor;
	GEOMedit_list *outgeom;
        int nsteps;
        float *low;
        float *high;
        int minmax;
        float *minx, *maxx, *miny, *maxy;
{

/*  THIS IS A 'HINTS' AREA - YOU MAY CUT AND PASTE AT WILL FROM IT       */
   GEOMobj *areaobjs;
   static float locations[300];
   static float colors[300];
   static float tempx, tempy, tempz, tempx_end, tempy_end, min, max;
   static float regn_xmin, regn_xmax, regn_ymin, regn_ymax, tempj;
   int ii, jj, i, k, ivert, jvert, ndim, ndata, pass, update;
   double cstep;
   double cbound[256];
   unsigned char byte_data;
   float float_data;
   double double_data;
   int int_data;
   unsigned int color_lut[256],*colori;
   unsigned int *cverts;
   float dstep,dbound[256];
   unsigned int itempa, itempr, itempg, itempb;

/*                                                                       */
/*  Detect the zoom activities                                           */
/*                                                                       */
update = 0;
if (AVSparameter_changed("INPUT x min") ||
    AVSparameter_changed("INPUT x max") ||
    AVSparameter_changed("INPUT y min") ||
    AVSparameter_changed("INPUT y max") )
{
   if (pass > 0)
   {
      update = 1;
   }
   else
   {
      pass++;
   }
}

/* get the maximum extent of the field */
ndata = MAXX(infield);
if (ndata == 0)
{
AVSwarning("No Data In The Input Field\n");
return(1);
}

regn_xmin = *minx; regn_xmax = *maxx;
regn_ymin = *miny; regn_ymax = *maxy;
if (((maxx - minx) == 0.0) || ((maxy - miny) == 0.0))
{
   regn_xmin = regn_xmax = infield->points[0];
   regn_ymin = regn_ymax = infield->points[1];
   for(i=1;i<ndata;i++)
   {
            tempx = infield->points[4*i];
            tempy = infield->points[4*i+1];
            tempz = infield->points[4*i+2];
            if (tempx < regn_xmin) regn_xmin = tempx;
            if (tempx > regn_xmax) regn_xmax = tempx;
            if (tempy < regn_ymin) regn_ymin = tempy;
            if (tempy > regn_ymax) regn_ymax = tempy;
   }
}


/* find minimum and maximum of infield data set */
switch(infield->type)
{
        case AVS_TYPE_BYTE:
            min = max = (float)infield->field_data[0];
            for(i=0;i<ndata;i++)
            {
                if((float)infield->field_data[i] < min)
                    min = (float)infield->field_data[i];
                else if((float)infield->field_data[i] > max)
                    max = (float)infield->field_data[i];
            }
        break;
        case AVS_TYPE_REAL:
            min = max = (float)infield->field_data_float[0];
            for(i=0;i<ndata;i++)
            {
                if((float)infield->field_data_float[i] < min)
                    min = (float)infield->field_data_float[i];
                else if((float)infield->field_data_float[i] > max)
                    max = (float)infield->field_data_float[i];
            }
        break;
        case AVS_TYPE_DOUBLE:
            min = max = (float)infield->field_data_double[0];
            for(i=0;i<ndata;i++)
            {
                if((float)infield->field_data_double[i] < min)
                    min = (float)infield->field_data_double[i];
                else if((float)infield->field_data_double[i] > max)
                    max = (float)infield->field_data_double[i];
            }
        break;
        case AVS_TYPE_INTEGER:
            min = max = (float)infield->field_data_int[0];
            for(i=0;i<ndata;i++)
            {
                if((float)infield->field_data_int[i] < min)
                    min = (float)infield->field_data_int[i];
                else if((float)infield->field_data_int[i] > max)
                    max = (float)infield->field_data_int[i];
            }
}

/* allocate for infield colormap and store rgb colors from colormap */
if((colori = (unsigned int *)ALLOC_LOCAL(ndata*sizeof(unsigned int))) == NULL)
{
       AVSerror("Field To Polygons: out of memory error\n");
       return(0);
}
for (i=0; i<incolor->size; i++)
{
         hsv_to_rgb(&color_lut[i],incolor->hue[i],
                                  incolor->saturation[i],
                                  incolor->value[i],
                                  incolor->alpha[i]);
}

/* compute color boundaries */
cstep = 255.0/(double)nsteps;
for(i=0; i < nsteps; ++i)
{
        cbound[i] = (double)i*cstep;
        round(&cbound[i],1);
}
cbound[nsteps] = 255.0;

/* modify min and max parameters if requested */
if(minmax)
{
        *low  = min;
        *high = max;
        AVSmodify_float_parameter("Low data value",AVS_VALUE,*low,NULL,NULL);
        AVSmodify_float_parameter("High data value",AVS_VALUE,*high,NULL,NULL);
}

/* compute data boundaries */
dstep = (*high-*low)/(float)nsteps;
for(i=0; i < nsteps; ++i)
        dbound[i] = *low+dstep*(float)i;
dbound[nsteps] = *high;

/* map data values to color */
switch (infield->type) {
   case AVS_TYPE_BYTE:
       for (i=0; i<ndata; i++) {
                byte_data = infield->field_data[i];
                if(byte_data <= (unsigned char)*low)
                    colori[i] = color_lut[0];
                else if(byte_data >= (unsigned char)*high)
                    colori[i] = color_lut[(int)cbound[nsteps]];
                else
                {
                    k=1;
                    while(byte_data > (unsigned char)dbound[k])
                        ++k;
                    colori[i] = color_lut[(int)cbound[k]];
                }
       }
     break;

   case AVS_TYPE_REAL:
         for (i=0; i<ndata; i++)
         {
                float_data = infield->field_data_float[i];
                if(float_data <= (float)*low)
                    colori[i] = color_lut[0];
                else if(float_data >= (float)*high)
                    colori[i] = color_lut[(int)cbound[nsteps]];
                else
                {
                    k=0;
                    while(float_data > (float)dbound[k])
                        ++k;
                    colori[i] = color_lut[(int)cbound[k]];
                }
         }
     break;


   case AVS_TYPE_DOUBLE:
         for (i=0; i<ndata; i++)
         {
                double_data = infield->field_data_double[i];
                if(double_data <= (double)*low)
                    colori[i] = color_lut[0];
                else if(double_data >= (double)*high)
                    colori[i] = color_lut[(int)cbound[nsteps]];
                else
                {
                    k=0;
                    while(double_data > (double)dbound[k])
                        ++k;
                    colori[i] = color_lut[(int)cbound[k]];
                }
         }
     break;


   case AVS_TYPE_INTEGER:
         for (i=0; i<ndata; i++)
         {
                int_data = infield->field_data_int[i];
                if(int_data <= (int)*low)
                    colori[i] = color_lut[0];
                else if(int_data >= (int)*high)
                    colori[i] = color_lut[(int)cbound[nsteps]];
                else
                {
                    k=0;
                    while(int_data > (int)dbound[k])
                        ++k;
                    colori[i] = color_lut[(int)cbound[k]];
                }
         }
}

/* Create the outgeom object                                             */
areaobjs  = GEOMcreate_obj( GEOM_POLYHEDRON, GEOM_NULL);

i = 0;
while(i<=ndata)
{
        tempx = infield->points[4*i];
        tempy = infield->points[4*i+1];
        tempx = x_cut(&tempx, &regn_xmin, &regn_xmax);
        tempy = y_cut(&tempy, &regn_ymin, &regn_ymax);
        tempz = infield->points[4*i+2];
        ndim = infield->points[4*i+3];
        locations[0] = tempx;
        locations[1] = tempy;
        locations[2] = tempz;
        unpack(colori[i], &itempa, &itempr, &itempg, &itempb);
        colors[0] = itempr/255.0;
        colors[1] = itempg/255.0;
        colors[2] = itempb/255.0;
        i++;
	for (ii = 1; ii<=ndim; ii++)
        {
           tempx = infield->points[4*i];
           tempy = infield->points[4*i+1];
           tempx = x_cut(&tempx, &regn_xmin, &regn_xmax);
           tempy = y_cut(&tempy, &regn_ymin, &regn_ymax);
           tempz = infield->points[4*i+2];
           tempj = infield->points[4*i+3];
           locations[3*ii] = tempx;
           locations[3*ii+1] = tempy;
           locations[3*ii+2] = tempz;
           unpack(colori[i], &itempa, &itempr, &itempg, &itempb);
           colors[ii*3] = itempr/255.0;
           colors[ii*3+1] = itempg/255.0;
           colors[ii*3+2] = itempb/255.0;
           i++;
        }
        jvert = ndim;
        for (jj=1; jj <ndim; jj++)
           {
              if ((locations[(jj-1)*3] == locations[jj*3]) &&
                  (locations[(jj-1)*3+1] == locations[jj*3+1]))
              {
                  for (ii=1; ii<ndim; ii++)
                  {
                      locations[ii*3] = locations[(ii+1)*3];
                      locations[ii*3+1] = locations[(ii+1)*3+1];
                      locations[ii*3+2] = locations[(ii+1)*3+2];
                      colors[ii*3] = colors[(ii+1)*3];
                      colors[ii*3+1] = colors[(ii+1)*3+1];
                      colors[ii*3+2] = colors[(ii+1)*3+2];
                  }
                  jvert = jvert - 1;
              }
        }
        if (jvert > 1 )
        {
           GEOMadd_disjoint_polygon(areaobjs, locations, NULL, colors,
                   jvert, GEOM_CONVEX, GEOM_COPY_DATA);
        }
}

/* Create the GEOM Edit List for outgeom                                 */
*outgeom = GEOMinit_edit_list(*outgeom);
GEOMedit_geometry(*outgeom, "outgeom", areaobjs);
GEOMdestroy_obj(areaobjs);
/* free any locally allocated data                                       */
/* THIS IS THE END OF THE 'HINTS' AREA. ADD YOUR OWN CODE BETWEEN THE    */
/* FOLLOWING COMMENTS. THE CODE YOU SUPPLY WILL NOT BE OVERWRITTEN.      */
 
/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	Field_To_Polygons_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/

/* Routine to round a set of input data points */
void round(data,ndata)
double *data;
int ndata;
{
    double frac;                    /* fractional portion of division */
    double int_portion;             /* integer portion of division */
    register int i;                 /* loop counter */

    /* for all data points */
    for(i=0; i < ndata; ++i)
    {
        /* seperate the integer and fractional portions */
        frac = modf(*(data + i)/1.0,&int_portion);

        /* round to next whole number or current whole number */
        if(frac >= 0.5)
            *(data + i) = (int_portion + 1.0);
        else
            *(data + i) = int_portion;
    }
}

void unpack(p, a, r, g, b)
  unsigned int p;
  unsigned int *a, *r, *g, *b;
{
/* comment out the next line for SGI; leave in for DEC and SET */
/* #define DEC5000 1 */
#ifdef DEC5000
    *a = p & MASK;
    *r = (p >> 8) & MASK;
    *g = (p >> 16) & MASK;
    *b = (p >> 24) & MASK;
#else
    *b = p & MASK;
    *g = (p >> 8) & MASK;
    *r = (p >> 16) & MASK;
    *a = (p >> 24) & MASK;
#endif
}

/**********************************************************
   Following hsv_to_rgb routine obtained from field2mesh
   module written by:
        Wes Bethel
        Lawrence Berkeley Laboratory
        1 Cyclotron Rd.   Mail Stop 50-F
        Berkeley CA 94720
        415-486-6626
        ewbethel@lbl.gov

     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce field2mesh2.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  field2mesh2.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  field2mesh2.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     field2mesh2.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
field2mesh2.c, or any part thereof.
*************************************************************/
static hsv_to_rgb(pixel,h,s,v)
unsigned int *pixel;
float h,s,v;
{
    float f, p, q, t, a;
    float r, g, b;
    float ht;
    int i;

/*  Make sure not to trash the input colormap */
    ht = h;

    a=0.0;

    if (v == 0.0)
    {
        r=0.0;
        g=0.0;
        b=0.0;
    }
    else
    {
        if (s == 0.0)
        {
            r = v;
            g = v;
            b = v;
        }
        else
        {
            ht = ht * 6.0;
            if (ht >= 6.0)
                ht = 0.0;

            i = ht;
            f = ht - i;
            p = v*(1.0-s);
            q = v*(1.0-s*f);
            t = v*(1.0-s*(1.0-f));

            if (i == 0)
            {
                r = v;
                g = t;
                b = p;
            }
            else if (i == 1)
            {
                r = q;
                g = v;
                b = p;
            }
            else if (i == 1)
            {
                r = q;
                g = v;
                b = p;
            }
            else if (i == 2)
            {
                r = p;
                g = v;
                b = t;
            }
            else if (i == 3)
            {
                r = p;
                g = q;
                b = v;
            }
            else if (i == 4)
            {
                r = t;
                g = p;
                b = v;
            }
            else if (i == 5)
            {
                r = v;
                g = p;
                b = q;
            }
        }
    }

/* comment out the next line for SGI; leave in for DEC and SET */
/* #define DEC5000 1 */
#ifdef DEC5000
    *pixel= ((int)(b*255.0))<<24
                | ((int)(g*255.0))<<16
                    | ((int)(r*255.0))<<8
                        | ((int)(a*255.0));
#else
    *pixel= ((int)(a*255.0))<<24
                | ((int)(r*255.0))<<16
                    | ((int)(g*255.0))<<8
                        | ((int)(b*255.0));
#endif
}

float x_cut(x,min,max)
float *x, *min, *max;
{
float xout;

xout = *x;
if (xout < *min) xout = *min;
if (xout > *max) xout = *max;

return (xout);
}

float y_cut(y,min,max)
float *y, *min, *max;
{
float yout;

yout = *y;
if (yout < *min) yout = *min;
if (yout > *max) yout = *max;

return (yout);
}
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */

