/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 *-----------------------------------------------------------------------
 *
 *      (C) Copyright Evans & Sutherland Computer Limited 1992
 *
 *  EVANS & SUTHERLAND ASSUMES NO RESPONSIBILITY FOR ANY USE OR INABILITY
 *  TO USE THIS SOFTWARE. THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY
 *  OF ANY KIND WHATSOEVER. EVANS & SUTHERLAND DISCLAIMS ALL IMPLIED WARRANTIES
 *  INCLUDING THOSE OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  PERMISSION IS GRANTED TO USE, COPY, MODIFY AND DISTRIBUTE THIS SOFTWARE
 *  PROVIDED THAT: ALL SUBSEQUENT DISTRIBUTION IS FREE OF CHARGE; THE
 *  COPYRIGHT NOTICE AND THIS PERMISSION NOTICE ARE PRESERVED IN ALL COPIES.
 *
 *-----------------------------------------------------------------------
 *
 *      ISOBAND SLICE module
 *
 *      Author:   Mike French, Evans & Sutherland UK
 *
 *      Date:     18 March 1992
 *
 *      Revision: 31 August 1993, IanC: Removed hsva_rgb Fortran depend
 *                                IanC: Fixed Arg bug in Geom calls
 *                10 Sept   1993  IanC: added drop holes on out of range data
 *                                      added on/off control
 *
 *-----------------------------------------------------------------------
 */

#include <stdio.h>

#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/geom.h>
#include <avs/field.h>
#include <avs/colormap.h>
#include <avs/field.h>


/* maximum number of contours */
#define MAX_N_CONTOURS 20

/* constant for string comparison */
#define EQUAL 0

/* think of a large number */
#define INFINITY 1E10

/* max no. of vertices generated for a contour band */
#define MAX_BAND_VERTS 8

/* max no. of vertices for a ucd face */
#define MAX_FACE_VERTS  4

/* local macros */
#define MIN(a,b)  (a<b?a:b)
#define MAX(a,b)  (a>b?a:b)

/* UI panel switches */
typedef enum { DIAL_HIDE, DIAL_SHOW } DialSwitch;

static enum { FALSE, TRUE };
static enum { X, Y, Z, NON_PLANAR };
static enum { R, G, B };
static enum { ERROR, OK };

/* banding data types */
typedef struct {
                  float levela;
                  float levelm;
                  float levelb;
                  float r;
                  float g;
                  float b;
                  float h;
                  float s;
                  float v;
               } Band;

typedef Band BandMap[MAX_N_CONTOURS+1];

/* vertex pointer look-up table */
typedef struct _LUT
{
      int  n1;
      int  ptr1[4];
      int  n2;
      int  ptr2[4];
} LUT;


/* =============== isoband slice description ============================ */

isoband_slice_desc()
{
  int isoband_slice(), param, oport;

  AVSset_module_name( "Isoband Slice", MODULE_MAPPER );

  AVScreate_input_port( "input field", 
                        "field 2D scalar real 3-space", REQUIRED );
  AVScreate_input_port( "input cmap", "colormap", OPTIONAL );
  AVScreate_input_port( "contour levels",
                        "field 1D uniform scalar float", OPTIONAL );

  oport = AVScreate_output_port( "isoband_slice", "geom" );
  AVSautofree_output( oport );
  oport = AVScreate_output_port( "output cmap", "colormap" );
  AVSautofree_output( oport );

  param = AVSadd_parameter( "N", "integer", 10, 2, MAX_N_CONTOURS );

  param = AVSadd_parameter( "Colourmap Boundary", "boolean", 0, 0, 1 );
  AVSadd_parameter_prop( param, "layout", "string_block",
        "manipulator \"$Module:Colourmap Boundary\" -xy 10,150" );
  AVSadd_parameter_prop( param, "width", "integer", 3 );

  param = AVSadd_parameter( "Smooth Surface", "boolean", 1, 0, 1 );
  AVSadd_parameter_prop( param, "layout", "string_block",
        "manipulator \"$Module:Smooth Surface\" -xy 10,180" );
  AVSadd_parameter_prop( param, "width", "integer", 3 );

  param = AVSadd_parameter( "Leave Holes", "boolean", 0, 0, 1 );
  param = AVSadd_parameter( "On/Off", "boolean", 1, 0, 1 );

  AVSset_compute_proc ( isoband_slice );
  AVSset_module_flags( COOPERATIVE | REENTRANT );
}  

/* =============== isoband slice init =================================== */

#ifdef SEP_EXE
AVSinit_modules()
{
  AVSmodule_from_desc( isoband_slice_desc );
}
#endif

/* =============== compute routine ====================================== */

static isoband_slice( fptr, cmap_ptr, level_ptr, output, cout_ptr,
                    ncparam, show_bound, smooth, leave_holes, on_off )
   AVSfield_float  *fptr;
   AVScolormap     *cmap_ptr;
   AVSfield_float  *level_ptr;
   GEOMedit_list   *output;
   AVScolormap    **cout_ptr;
   int              ncparam;
   int              show_bound;
   int              smooth;
   int              leave_holes;
   int              on_off;
{

#define UNIFORM_CELL(p,q) \
       { register int ii, jj, k, ind;\
         for ( k=0; k<4; k++ ) \
         {   ii = p + ioff[k];\
             jj = q + joff[k];\
             ind = MAXY(fptr)*jj + ii;\
             vert[k][ix] = xpos[ii];\
             vert[k][iy] = ypos[jj];\
             vert[k][iz] = zval;\
             fval[k] = fptr->data[ind];}}

#define IRREGULAR_CELL(p,q) \
       { register int k, ind; \
         for ( k=0; k<4; k++ ) \
         {   ind = p + ioff[k] + MAXX(fptr)*(q+joff[k]);\
             vert[k][X] = fptr->points[ind];\
             vert[k][Y] = fptr->points[ind+maxxy1];\
             vert[k][Z] = fptr->points[ind+maxxy2];\
             fval[k] = fptr->data[ind];\
    	     if (smooth) \
	     { vn[k][X] = vnorms[ind];\
	       vn[k][Y] = vnorms[ind+maxxy1];\
	       vn[k][Z] = vnorms[ind+maxxy2];}}  \
         if (smooth) vnptr = &vn[0][0]; else vnptr = NULL;}

#define CHECK_INRANGE \
       ( fval[0] >= lo && fval[0] <= hi &&    \
         fval[1] >= lo && fval[1] <= hi &&    \
         fval[2] >= lo && fval[2] <= hi &&    \
         fval[3] >= lo && fval[3] <= hi )


    static  DialSwitch  Nshow = DIAL_SHOW;
    static  DialSwitch  Sshow = DIAL_SHOW;
    static  int         First = TRUE;      
    static  int         was_cmap = FALSE;
    static  int         debug_normals = FALSE;
    static  int         ioff[4] = { 0, 1, 1, 0 };
    static  int         joff[4] = { 0, 0, 1, 1 };

    BandMap       bmap;
    AVScolormap  *cptr;
    GEOMobj      *obj;

    int     vertex_normals();

    int     ftype, ncontour, cdim[1], bcount, percent;
    int     maxxy1, maxxy2, ix, iy, iz, imax, ii;

    float   cmin[1], cmax[1], fract, levels[MAX_N_CONTOURS];
    float   lrange, lwidth, bsum, bwidth[MAX_N_CONTOURS+1];
    float   xmin, xmax, ymin, ymax, zval, griddx, griddy;
    float   *xpos, *ypos, *vnorms, *vnptr;
    float   vert[MAX_FACE_VERTS][3], fval[MAX_FACE_VERTS];
    float   vn[MAX_FACE_VERTS][3];
       
    register int i, j, n, b;
       
    float lo, hi;

     /* if Off, take short cut and return, killing output geom */
     if ( !on_off )
     {
         obj = GEOMcreate_obj ( GEOM_POLYTRI, GEOM_NULL );
         *output = GEOMinit_edit_list(*output);
         GEOMedit_geometry(*output,"isoband_slice",obj);
         GEOMedit_geometry(*output,"normals", obj );       
         GEOMdestroy_obj(obj);
         return(1);
     }


    /*-- initialize parameter dial visibility --*/
    if (First)
    {
       AVSparameter_visible( "N", Nshow );
       AVSparameter_visible( "Smooth Surface", Sshow );
       First = FALSE;
    }

    /*-- get field type --*/
    ftype = AVSfield_get_int( fptr, AVS_FIELD_UNIFORM );
    if (ftype==RECTILINEAR)
    {
        AVSerror( "Cannot contour rectilinear field (yet)\n" );
        return(ERROR);
    }
    maxxy1 = MAXX(fptr) * MAXY(fptr);
    maxxy2 = 2 * maxxy1;

    /*-- initialize contour levels --*/
    if (level_ptr) 
    {
         /*-- there is contour level input --*/
         if (Nshow==DIAL_SHOW)
         {
            /*-- the dial must be removed --*/
            Nshow = DIAL_HIDE;
            AVSparameter_visible( "N", Nshow );
         }

         /*-- copy contour levels from input field to local array --*/
         ncontour = MIN( MAX_N_CONTOURS, MAXX(level_ptr) );
         if (!level_ptr->data)
         {
            AVSerror( "Cannot get contour level field data pointer\n" );
            return(ERROR);
         }
         for ( n=0; n<ncontour; n++ )
             levels[n] = level_ptr->data[n];
    }
    else
    {
        /*-- there is no contour level input ---*/
        if (Nshow==DIAL_HIDE)
        {
           /*-- dial must be replaced --*/
           Nshow = DIAL_SHOW;
           AVSparameter_visible( "N", Nshow );
        }

        /*-- generate local contour levels --*/
        ncontour = ncparam;
        if ( !AVSfield_get_minmax(fptr,cmin,cmax) )
        {
           AVSfield_reset_minmax( fptr );  
           AVSfield_get_minmax( fptr, cmin, cmax );
        }
        for ( n=0; n<ncontour; n++ )
            levels[n] = cmin[0]+(cmax[0]-cmin[0])*(float)n/(float)(ncontour-1);
    }

    if ( levels[0] == levels[ncontour-1] )
    {
	ncontour=1;

    }
    /*-- band level recurrence relations --*/
    bmap[0].levela = -INFINITY;
    bmap[0].levelm =  levels[0];
    bmap[0].levelb =  levels[0];
    for ( n=1; n<ncontour; n++ )
    {
       bmap[n].levela =  levels[n-1];
       bmap[n].levelm = (levels[n-1] + levels[n]) / 2.0;
       bmap[n].levelb =  levels[n];
    }
    bmap[ncontour].levela = levels[ncontour-1];
    bmap[ncontour].levelm = levels[ncontour-1];
    bmap[ncontour].levelb = INFINITY;

    /*-- test for colourmap input, build band levels and colours --*/
    if (cmap_ptr)
    {
       /*-- there is colour map input --*/
       float h, s, v, r, g, b, nlevelm;
       int   index;

       lo = cmap_ptr->lower;
       hi = cmap_ptr->upper;
       for ( n=0; n<ncontour+1; n++ )
       {
           nlevelm = bmap[n].levelm;
           if (nlevelm<=lo)
               index = 0;
           else if (nlevelm>=hi)
               index = 255;
           else
               index = (int)( 255.0 * (nlevelm-lo) / (hi-lo) );
           h = cmap_ptr->hue[index];
           s = cmap_ptr->saturation[index];
           v = cmap_ptr->value[index];
           bmap[n].h = h; bmap[n].s = s; bmap[n].v = v;
           PIXELhsv_to_rgb( h, s, v, &r, &g, &b );
           bmap[n].r = r; bmap[n].g = g; bmap[n].b = b;
       }
    }
    else
    {
       /*-- no colour map input, set default greyscale --*/
       for ( n=0; n<ncontour+1; n++ )
       {
           fract = (float)n / (float)ncontour;
           bmap[n].h = 0.0;   bmap[n].s = 0.0;   bmap[n].v = fract;
           bmap[n].r = fract; bmap[n].g = fract; bmap[n].b = fract;
       }
    }

    /*-- create output colour map --*/
    cdim[0] = 256;
    cptr = (AVScolormap*) AVSdata_alloc( "colormap", cdim );
    if (!cptr)
    {
       AVSerror( "Can't allocate output colormap.\n" );
       return (ERROR);
    }
    cptr->size  = cdim[0];
    cptr->lower = levels[0];
    cptr->upper = levels[ncontour-1];
    lrange = levels[ncontour-1] - levels[0];
    for ( i=1, bsum=0; i<ncontour; i++ )
    {
      if ( lrange == 0.0 )
      {
	lrange = 1.0;
	bwidth[i]=0;
      }
      else
      {
        lwidth = levels[i] - levels[i-1];
        bwidth[i] = (int)( 254.0 * lwidth / lrange ) - 1;
      }
        bsum += bwidth[i];
        if (!show_bound)  bwidth[i]++;
    }
    if (!show_bound)  bsum--;
    bwidth[0] = (int)( (256 - ncontour - bsum) / 2 );
    bwidth[ncontour] =  256 - ncontour - bsum - bwidth[0];

    for ( n=0, bcount=0; n<ncontour+1; n++ )
    {
        for ( b=0; b<bwidth[n]; b++, bcount++ )
        {
            cptr->hue[bcount]        = bmap[n].h;
            cptr->saturation[bcount] = bmap[n].s;
            cptr->value[bcount]      = bmap[n].v;
            cptr->alpha[bcount]      = 0.0;
        }
        if ( show_bound && (n!=ncontour) )
        {
            cptr->hue[bcount]        = 0.0;
            cptr->saturation[bcount] = 0.0;
            cptr->value[bcount]      = 0.0;
            cptr->alpha[bcount]      = 0.0;
            bcount++;
        }
    }
    *cout_ptr = cptr;

    /*-- prevent new contouring if just the "show_bounds" has changed --*/
    if ( AVSinput_changed( "input field",    0 ) ||
         AVSinput_changed( "input cmap",     1 ) ||	
         (was_cmap && !cmap_ptr)                 ||
	 AVSinput_changed( "contour levels", 2 ) ||	
	 AVSparameter_changed( "N" )             ||
	 AVSparameter_changed( "Leave Holes" )   ||
	 AVSparameter_changed( "On/Off" )        ||
	 AVSparameter_changed( "Smooth Surface")  )
    {
    
       /*-- create output geometry object --*/
       *output =  GEOMinit_edit_list( *output );
       obj     =  GEOMcreate_obj( GEOM_POLYHEDRON, NULL );
   
       /*-- get grid parameters, loop over grid faces --*/
       if (ftype==UNIFORM) 
       {
          /*-- surface is planar --*/
          if (Sshow==DIAL_SHOW)
          {
             /*-- remove boolean --*/
             Sshow = DIAL_HIDE;
             AVSparameter_visible( "Smooth Surface", Sshow );
          }

          /*-- find plane of grid --*/
          if (fptr->points[0] == fptr->points[1])
          {
             /*-- x-plane --*/
             iz = X; iy = Y; ix = Z;
          }
          else if (fptr->points[2] == fptr->points[3])
          {
             /*-- y-plane --*/
             ix = X; iz = Y; iy = Z;
          }
          else if (fptr->points[4] == fptr->points[5])
          {
             /*-- z-plane --*/
             ix = X; iy = Y; iz = Z;
          }
          else
          {
             /*-- none of the planes --*/
             AVSerror( "Cannot find plane of slice for uniform field\n" );
             return(ERROR);
          }

          /*-- allocate positions --*/
	  xmin = fptr->points[2*ix];
	  xmax = fptr->points[2*ix+1];
	  ymin = fptr->points[2*iy];
	  ymax = fptr->points[2*iy+1];
	  zval = fptr->points[2*iz];

	  /*-- set uniform grid cell widths --*/
	  griddx = (xmax-xmin) / (float)(MAXX(fptr)-1);
	  griddy = (ymax-ymin) / (float)(MAXY(fptr)-1);

	  /*-- produce rectilinear arrays for quick look-up --*/
	  xpos = (float*) malloc (MAXX(fptr)*sizeof(float));
	  ypos = (float*) malloc (MAXY(fptr)*sizeof(float));
	  if (!(xpos && ypos))
	  {
	     AVSerror( "malloc fialed in Isoband Slice\n" );
	     return(ERROR);
	  }
          for ( i=0; i<MAXX(fptr); i++ )
              xpos[i] = xmin + (float)i * griddx; 
          for ( j=0; j<MAXY(fptr); j++ )
              ypos[j] = ymin + (float)j * griddy;     

          /*-- contour each patch in the grid --*/
          imax = MAXX(fptr) - 1;
          for ( i=0; i<imax; i++ )
          {
              percent = 10 + (int)( 80.0 * (float)i/(float)imax);
              AVSmodule_status( "Contour banding", percent );

              for ( j=0; j<MAXY(fptr)-1; j++ )
              {
                  UNIFORM_CELL( i, j );
                  if ( !leave_holes || leave_holes && CHECK_INRANGE )
                  face_band( bmap,4,vert,NULL,fval,obj,ncontour,iz);
              }
          }

/* IAC CODE CHANGE :           if (xpos)  free( xpos ); */
          if (xpos)   free(xpos );

/* IAC CODE CHANGE :           if (ypos)  free( ypos ); */
          if (ypos)   free(ypos );
       }
       else if (ftype==IRREGULAR) 
       {
          /*-- surface can be smoothed --*/
          if (Sshow==DIAL_HIDE)
          {
             /*-- replace boolean --*/
             Sshow = DIAL_SHOW;
             AVSparameter_visible( "Smooth Surface", Sshow );
          }

  	  /*-- build normals for the grid --*/
	  if (smooth) 
	  {
	     vnorms = (float*) malloc ( 3*maxxy1*sizeof(float) );
	     if (vnorms) 
		vertex_normals( MAXX(fptr), MAXY(fptr), fptr->points, vnorms );
	     else
	     {
		AVSerror( "malloc error in Isoband Slice\n" );
		smooth = FALSE;
		AVSmodify_parameter( "Smooth Surface", AVS_VALUE, smooth, 0, 1);
	     }
	  }
	
          /*-- contour each patch in the grid --*/
          imax = MAXX(fptr) - 1;
          for ( i=0; i<imax; i++ )
          {
              percent = 10 + (int)( 80.0 * (float)i/(float)imax);
              AVSmodule_status( "Contour banding", percent );

              for ( j=0; j<MAXY(fptr)-1; j++ )
              {
                  IRREGULAR_CELL( i, j );
                  if ( !leave_holes || leave_holes && CHECK_INRANGE )
                  face_band( bmap,4,vert,vnptr,fval,obj,ncontour,NON_PLANAR);
              }
          }

/* IAC CODE CHANGE : 	  if (vnorms)  free(vnorms); */
	  if (vnorms)   free(vnorms);
       }

       /*-- output geometry --*/
       if (smooth)
           GEOMgen_normals( obj, 0 );
       GEOMcvt_polyh_to_polytri( obj,
            GEOM_NO_CONNECTIVITY | GEOM_SURFACE | GEOM_WIREFRAME );
       GEOMedit_geometry( *output, "isoband_slice", obj );
       GEOMedit_transform_mode( *output, "isoband_slice", "parent" );

       /*-- display the normal vectors on the surface --*/
       if (smooth && debug_normals)
       {
          GEOMobj *obj2;    
          obj2 = GEOMcreate_normal_object( obj, 0.1 );
          GEOMedit_geometry( *output, "normals", obj2 );       
          GEOMdestroy_obj(obj2);
       }
       GEOMdestroy_obj(obj);
     }

     if (cmap_ptr)  was_cmap = TRUE;
     else           was_cmap = FALSE;
	
     return(OK);
}

/* =============== contour routine ====================================== */

face_band( bmap, nverts, vert, norm, fval, obj, ncontour, planar )
    BandMap bmap;
    int     nverts;
    float   vert[MAX_FACE_VERTS][3];
    float   norm[MAX_FACE_VERTS][3];
    float   fval[MAX_FACE_VERTS];
    GEOMobj *obj;
    int     ncontour;
    int     planar;
{

#define LINEAR(p,f,q,r) \
        { v[p][X] = vert[q][X];\
	  if (X!=planar)  v[p][X] += f * (vert[r][X]-vert[q][X]);\
          v[p][Y] = vert[q][Y];\
          if (Y!=planar)  v[p][Y] += f * (vert[r][Y]-vert[q][Y]);\
          v[p][Z] = vert[q][Z];\
          if (Z!=planar)  v[p][Z] += f * (vert[r][Z]-vert[q][Z]);\
          if (norm) \
          { vnorm[p][X] = norm[q][X] + f * (norm[r][X]-norm[q][X]);\
            vnorm[p][Y] = norm[q][Y] + f * (norm[r][Y]-norm[q][Y]);\
            vnorm[p][Z] = norm[q][Z] + f * (norm[r][Z]-norm[q][Z]);}}

#define DIRECT(p,q) \
        { v[p][X] = vert[q][X];\
          v[p][Y] = vert[q][Y];\
          v[p][Z] = vert[q][Z];\
          if (norm) \
          { vnorm[p][X] = norm[q][X];\
            vnorm[p][Y] = norm[q][Y];\
            vnorm[p][Z] = norm[q][Z];}}

#define GATHER(p,q) \
        { pverts[p][X] = v[q][X];\
          pverts[p][Y] = v[q][Y];\
          pverts[p][Z] = v[q][Z];\
          if (norm) \
          { pnorms[p][X] = vnorm[q][X];\
            pnorms[p][Y] = vnorm[q][Y];\
            pnorms[p][Z] = vnorm[q][Z];}}


    /*                       0  1  2  3  4  5  6  7  8  9          */
    /*                                                             */
    static int saddle[] =  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /*  0 */
                             1, 2, 0, 0, 0, 0, 0, 0, 0, 3,   /* 10 */
                             4, 0, 0, 5, 0, 0, 0, 0, 0, 0,   /* 20 */
                             6, 0, 0, 7, 0, 0, 0, 0, 0, 0,   /* 30 */
                             0, 0, 0, 0, 0, 0, 0, 8, 0, 0,   /* 40 */
                             9, 0, 0, 0, 0, 0, 0,10, 0, 0,   /* 50 */
                            11,12, 0, 0, 0, 0, 0, 0, 0,13,   /* 60 */
                            14, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 70 */
                             0                               /* 80 */
                           };

    static LUT lut[15] = { { 0, {0,0,0,0}, 0, {0,0,0,0} },   /* unused */
                           { 3, {1,2,3,0}, 3, {4,5,6,0} },   /*  1 */
                           { 3, {1,2,3,0}, 4, {4,5,6,7} },   /*  2 */
                           { 4, {1,2,3,4}, 3, {5,6,7,0} },   /*  3 */
                           { 4, {1,2,3,4}, 4, {5,6,7,8} },   /*  4 */
                           { 4, {1,2,6,7}, 3, {3,4,5,0} },   /*  5 */
                           { 3, {1,2,6,0}, 3, {3,4,5,0} },   /*  6 */
                           { 3, {1,2,7,0}, 4, {3,4,5,6} },   /*  7 */
                           { 3, {1,2,7,0}, 4, {3,4,5,6} },   /*  8 */
                           { 3, {1,2,6,0}, 3, {3,4,5,0} },   /*  9 */
                           { 4, {1,2,6,7}, 3, {3,4,5,0} },   /* 10 */
                           { 4, {1,2,7,8}, 4, {3,4,5,6} },   /* 11 */
                           { 4, {1,2,3,4}, 3, {5,6,7,0} },   /* 12 */
                           { 3, {1,2,3,0}, 4, {4,5,6,7} },   /* 13 */
                           { 3, {1,2,3,0}, 3, {4,5,6,0} }    /* 14 */
                         };

   int   av_below, av_between, av_above;
   int   k1, k2, nv, index, ptr, exp, nv1, nv2;
   int   step, pind, vlist[MAX_N_CONTOURS+1][MAX_BAND_VERTS];
   int   vcount[MAX_N_CONTOURS+1], vband[MAX_FACE_VERTS], powtab[MAX_FACE_VERTS];
   float f1, f2, fac, avf, la, lb, df, *nptr;
   float v[MAX_N_CONTOURS*MAX_BAND_VERTS][3];
   float vnorm[MAX_N_CONTOURS*MAX_BAND_VERTS][3];
   float pverts[MAX_BAND_VERTS][3], pnorms[MAX_BAND_VERTS][3];
   float cols[MAX_N_CONTOURS+1][MAX_BAND_VERTS][3];

   register int j, k, n;

   /*-- precalculate power series --*/
   for ( k=0; k<nverts; k++ )
       powtab[k] = (int) pow( (double)3, (double)(nverts-1-k) );
   
   /*-- initialize vertex counts --*/
   for ( n=0; n<ncontour+1; n++ )
       vcount[n] = 0;

   /*-- get band numbers for face vertices --*/
   for ( k=0; k<nverts; k++ )
   {
       for ( n=0; n<ncontour+1; n++ )
           if (fval[k]>=bmap[n].levela && fval[k]<bmap[n].levelb)  
           {
               vband[k] = n;
               break;
           }
   }

   /*-- build colour table --*/
   for ( n=0; n<ncontour+1; n++ )
   {
       for ( j=0; j<MAX_BAND_VERTS; j++ )
       {
           cols[n][j][R] = bmap[n].r;
           cols[n][j][G] = bmap[n].g;
           cols[n][j][B] = bmap[n].b;
       }
   }

   /*-- interpolate along edges --*/
   for ( k=0, nv=0; k<nverts; k++ )
   {
       /*-- use modulo arithmetic to close the perimeter --*/
       k1 = k;
       k2 = (k+1) % nverts;

       /*-- store the first vertex on this edge, tag the relevant lists --*/
       DIRECT( nv, k1 );
       n = vband[k1];
       vlist[n][vcount[n]] = nv;
       vcount[n]++;
       nv++;

       /*-- loop over bands which occur along this edge --*/
       if (vband[k1]==vband[k2])
           /*-- no more bands on this edge --*/
           continue;
       else if (vband[k1]<vband[k2])
       {
           /*-- ascending band sequence use upper boundaries --*/
           df = fval[k2] - fval[k1];
           for ( n=vband[k1]; n<vband[k2]; n++ )
           {
               fac = (bmap[n].levelb-fval[k1]) / df;
               LINEAR( nv, fac, k1, k2 );
               vlist[n][vcount[n]]     = nv;   vcount[n]++;
               vlist[n+1][vcount[n+1]] = nv;   vcount[n+1]++;
               nv++;
           }
       }
       else
       {
           /*-- descending band sequence use lower boundaries --*/
           df = fval[k2] - fval[k1];
           for ( n=vband[k1]; n>vband[k2]; n-- )
           {
               fac = (bmap[n].levela-fval[k1]) / df;
               LINEAR( nv, fac, k1, k2 );
               vlist[n][vcount[n]]     = nv;   vcount[n]++;
               vlist[n-1][vcount[n-1]] = nv;   vcount[n-1]++;
               nv++;
           }
       }
   }

   /*-- loop over contour bands --*/
   for ( n=0; n<ncontour+1; n++ )
   {
       /*-- test if polygon required --*/
       if (vcount[n]<3)  continue;

       /*-- test for simple shape --*/
       if (vcount[n]<6)
          goto OnePolygon;
 
       /*-- copy levels --*/
       la = bmap[n].levela;
       lb = bmap[n].levelb;

       /*-- calculate index --*/
       for ( k=0, index=0; k<nverts; k++ )
       {
           if      (fval[k]<la)   continue;
	   else if (fval[k]>=lb)  index += 2.0 * powtab[k]; 
           else                   index += powtab[k];
       }

       /*-- test for saddles --*/
       if (!saddle[index])
          goto OnePolygon;

       /*-- handle saddle points --*/

       /*-- find average mid-cell value --*/
       avf = (fval[0]+fval[1]+fval[2]+fval[3]) / 4.0;
       av_below = av_between = av_above = FALSE;
       if      (avf<la)   av_below   = TRUE;
       else if (avf>=lb)  av_above   = TRUE;
       else               av_between = TRUE;

       /*-- find saddles that only give one polygon --*/

       /*-- 6-sided --*/
       if ( (index==10 && !av_below)  ||
            (index==30 && !av_below)  ||
            (index==50 && !av_above)  ||
            (index==70 && !av_above)   )
          goto OnePolygon;

       /*-- 7-sided --*/
       if ( (index==61 && !av_above)  ||
            (index==47 && !av_above)  ||
            (index==69 && !av_above)  ||
            (index==23 && !av_above)  ||
            (index==19 && !av_below)  ||
            (index==33 && !av_below)  ||
            (index==11 && !av_below)  ||
            (index==57 && !av_below)   )
          goto OnePolygon;

       /*-- 8-sided --*/
       if ( (index==20 && av_between) ||
            (index==60 && av_between)  )
          goto OnePolygon;

       /*-- swap orientation for symmetric 8-vertex 2-quad saddle points --*/
       if      (index==20 && av_above)   index=60;
       else if (index==60 && av_above)   index=20;

   /*--------------*/
   /* TwoPolygons: */
   /*--------------*/

       /*-- double gather first polygon vertices and normals --*/
       nv1 = lut[saddle[index]].n1;
       for ( j=0; j<nv1; j++ )
       {
           ptr = lut[saddle[index]].ptr1[j] - 1;
           pind = vlist[n][ptr];
           GATHER( j, pind );
       }

       /*-- switch normal information --*/
       if (norm)  nptr = &pnorms[0][X];
       else       nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], nv1,
                                (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA );  

       /*-- double gather second polygon vertices and normals --*/
       nv2 = lut[saddle[index]].n2;
       for ( j=0; j<nv2; j++ )
       {
           ptr = lut[saddle[index]].ptr2[j] - 1;
           pind = vlist[n][ptr];
           GATHER( j, pind );
       }

       /*-- switch normal information --*/
       if (norm)  nptr = &pnorms[0][X];
       else       nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], nv2,
                                (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA );  
       continue;

   /*-------*/
   OnePolygon:
   /*-------*/

       /*-- gather polygon vertices and normals --*/
       for ( j=0; j<vcount[n]; j++ )
       {
           pind = vlist[n][j];
           GATHER( j, pind );
       }

       /*-- switch normal information --*/
       if (norm)  nptr = &pnorms[0][X];
       else       nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], vcount[n],
                                (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA );  
   }
   return(OK);
}

/*============ vertex normal =================================================*/

vertex_normals( nx, ny, vert, vnorms )
    int    nx, ny;
    float  *vert;
    float  *vnorms;
{
#define EPSILON 1E-10
    
    int   ind, ind3, i1, i2, j1, j2, maxxy1, maxxy2;
    float ax, ay, az, bx, by, bz;
    float vnx, vny, vnz, len;

    register int i, j;
    
    maxxy1 = nx*ny;
    maxxy2 = 2*maxxy1;

    for ( j=0, ind=0; j<ny; j++ )
    {
	for ( i=0; i<nx; i++, ind++ )
	{
           /*-- allocate x basis vector --*/
           if ( i>0 && i<nx-1 )
           {
               /*-- central zone --*/
               i1 = ind - 1;        /* i-1, j */
               i2 = ind + 1;        /* i+1, j */
           }    
	   else if (i==0)
	   {
	       /*-- left edge -----*/
	       i1 = ind;            /* i,   j */
	       i2 = ind + 1;        /* i+1, j */
	   }       
	   else if (i==nx-1)
	   {
	       /*-- right edge ----*/
	       i1 = ind - 1;        /* i-1, j */
	       i2 = ind;            /* i,   j */
	   }       
	   ax = vert[i1]        - vert[i2];
	   ay = vert[i1+maxxy1] - vert[i2+maxxy1];
	   az = vert[i1+maxxy2] - vert[i2+maxxy2];

	   /*-- allocate y basis vector --*/
	   if ( j>0 && j<ny-1 )
	   {
	       /*-- central zone --*/
	       j1 = ind - nx;       /* i, j-1 */
	       j2 = ind + nx;       /* i, j+1 */
	   }    
	   else if (j==0)
	   {
	       /*-- lower edge ----*/
	       j1 = ind;            /* i, j   */
	       j2 = ind + nx;       /* i, j+1 */
	   }       
	   else if (j==ny-1)
	   {
	       /*-- upper edge ----*/
	       j1 = ind - nx;       /* i, j-1 */
	       j2 = ind;            /* i, j   */
	   }
	   bx = vert[j1]        - vert[j2];
	   by = vert[j1+maxxy1] - vert[j2+maxxy1];
	   bz = vert[j1+maxxy2] - vert[j2+maxxy2];

	   /*-- vector product of basis vectors --*/
	   vnx = ay*bz - az*by;
	   vny = az*bx - ax*bz;
	   vnz = ax*by - ay*bx;

	   /*-- normalize --*/
	   len = sqrt( vnx*vnx + vny*vny + vnz*vnz );
	   if (len>EPSILON)
	   {
	       vnorms[ind]        = vnx/len;
	       vnorms[ind+maxxy1] = vny/len;
	       vnorms[ind+maxxy2] = vnz/len;
	   }
	   else
	   {
	       printf( "ERROR: vertex normal has zero length\n" );
	       vnorms[ind]        = 0.0;
	       vnorms[ind+maxxy1] = 0.0;
	       vnorms[ind+maxxy2] = 1.0;
	   }	
       }
    }
    return(OK);
}

/*============================================================================*/







