/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 *-----------------------------------------------------------------------
 *
 *      (C) Copyright Evans & Sutherland Computer Limited 1992
 *
 *  EVANS & SUTHERLAND ASSUMES NO RESPONSIBILITY FOR ANY USE OR INABILITY
 *  TO USE THIS SOFTWARE. THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY
 *  OF ANY KIND WHATSOEVER. EVANS & SUTHERLAND DISCLAIMS ALL IMPLIED WARRANTIES
 *  INCLUDING THOSE OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  PERMISSION IS GRANTED TO USE, COPY, MODIFY AND DISTRIBUTE THIS SOFTWARE
 *  PROVIDED THAT: ALL SUBSEQUENT DISTRIBUTION IS FREE OF CHARGE; THE
 *  COPYRIGHT NOTICE AND THIS PERMISSION NOTICE ARE PRESERVED IN ALL COPIES.
 *
 *-----------------------------------------------------------------------
 *
 *      ISOBAND UCD module
 * 
 *      Author:   Mike French, Evans & Sutherland UK
 *
 *      Date:     10 June 1992
 *
 *      Revision  23 Aug  1993 IanC: Removed Fortran hsva_rgb dependency
 *                                   Fixed GEOM arg reversal
 *                                   Added Normal generation for shading
 *
 *-----------------------------------------------------------------------
 */

#include <stdio.h>

#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/geom.h>
#include <avs/field.h>
#include <avs/colormap.h>
#include <avs/ucd_defs.h>

/* maximum number of contours */
#define MAX_N_CONTOURS 20

/* constant for string comparison */
#define EQUAL 0 

/* think of a large number */
#define INFINITY 1E10

/* max no. of vertices generated for a contour band */
#define MAX_BAND_VERTS 8

/* max no. of vertices for a ucd face */
#define MAX_FACE_VERTS  4

/* local macros */
#define MIN(a,b)  (a<b?a:b)
#define MAX(a,b)  (a>b?a:b)

/* UI panel switches */
typedef enum { DIAL_HIDE, DIAL_SHOW } DialSwitch;

static enum { FALSE, TRUE };
static enum { X, Y, Z };
static enum { R, G, B };
static enum { ERROR, OK };

/* banding data types */
typedef struct {
                  float levela; 
		  float levelm; 
		  float levelb;
                  float r;      
		  float g;      
		  float b;
		  float h;      
		  float s;     
		  float v;
	       } Band; 

typedef Band BandMap[MAX_N_CONTOURS+1];

/* vertex pointer look-up table */
typedef struct _LUT 
{
      int  n1;
      int  ptr1[4];
      int  n2;
      int  ptr2[4];
} LUT;

/* util function types for removing interior faces */
typedef struct   _UCD_Face_List 
{
        unsigned char         num_vtx;
        int                   vtx_index[4];
        int                   mat_id;
        int                   cell_id;
} UCD_Face_List;

typedef struct   _UCD_Line_List 
{
        int                   vtx_index[2];
        int                   mat_id;
        int                   cell_id;
} UCD_Line_List;

/* =============== compute routine ====================================== */

static ucd_isoband( input, cmap_ptr, level_ptr, output, cout_ptr,
		    ncparam, show_bound )

  UCD_structure  *input;
  AVScolormap    *cmap_ptr;
  AVSfield_float *level_ptr;
  GEOMedit_list  **output;
  AVScolormap    **cout_ptr;
  int             ncparam;
  int             show_bound;  
{
    static       DialSwitch Nshow = DIAL_SHOW;
    
    BandMap      bmap;
    char         model_name[80];
    GEOMobj     *obj, *lobj;
    AVScolormap *cptr;
    float       *xc, *yc, *zc, *node_data, min_node_data[1], max_node_data[1];
    float        levels[MAX_N_CONTOURS];
    float        cmin, cmax, fract;
    int          cell, i, name_flag, util_flag, data_len, cell_len, dim[1];
    int          node_len, num_nodes, num_cells, ncontour, *comp;
    float        lrange, lwidth;
    int          bwidth[MAX_N_CONTOURS+1], cdim[1], bsum;
    static int   was_cmap = 0;

                 /* loop counters */
    register int n, v, bcount, b;

    /* get general sizes */
    if ( !UCDstructure_get_header( input, model_name, &data_len, &name_flag, 
  		 	           &num_cells, &cell_len, &num_nodes, &node_len,
			           &util_flag ) )
    {
       AVSerror ("ERROR in Isoband UCD: can't get header.\n"); 
       return (ERROR);
    }

    /* make sure there are some cells */
    if (!num_cells || !num_nodes)
    {
       AVSerror ("ERROR in Isoband UCD: empty ucd\n" );
       return (ERROR);
    }
    /* make sure node data is single scalar component */
    if ( node_len != 1 )
    {
       AVSerror ("ERROR in Isoband UCD: not single node component\n" );
       return (ERROR);
    }
    if ( !UCDstructure_get_node_components( input, &comp ) )
    {
       AVSerror ("ERROR in Isoband UCD: cannot get node component data\n" );
       return (ERROR);
    }
    if ( comp[0] != 1 )
    {
       AVSerror ("ERROR in Isoband UCD: node component is not scalar\n" );
       return (ERROR);
    }

    /* find out where the nodes are */
    if ( !UCDstructure_get_node_positions( input, &xc, &yc, &zc ) )
    {
       AVSerror ( "ERROR in Isoband UCD: can't get node coordinates.\n" ); 
       return (ERROR);
    }

    /* get a pointer to where the node data is stored */
    if ( !UCDstructure_get_node_data( input, &node_data ) )
    {
       AVSerror ( "ERROR in Isoband UCD: can't get node data.\n" ); 
       return (ERROR); 
    }

    /* test for contour level input */
    if (level_ptr)
    {
       /* there is contour level input */
       if (Nshow==DIAL_SHOW)
       {
	  /* the dial must be removed */
	  Nshow = DIAL_HIDE;
          AVSparameter_visible( "N", Nshow );
       }
	
       /* copy contour levels from input field to local array */
       if (!level_ptr->dimensions)
       {
	  AVSerror( "ERROR in Isoband UCD: cannot get field dimensions\n" );
	  return(ERROR);
       }
       ncontour = MIN( MAX_N_CONTOURS, level_ptr->dimensions[0] );
       if (!level_ptr->data)
       {
          AVSerror( "ERROR in Isoband UCD: cannot get field data pointer\n" );
          return(ERROR);
       }
       for ( n=0; n<ncontour; n++ )
  	   levels[n] = level_ptr->data[n];
    }
    else
    {
	/* there is no contour level input */
	if (Nshow==DIAL_HIDE)
	{
	   /* dial must be replaced */
	   Nshow = DIAL_SHOW;
           AVSparameter_visible( "N", Nshow );	    
        }
	
        /* generate local contour levels */
        ncontour = ncparam;
	if (UCDstructure_get_node_minmax( input,min_node_data,max_node_data ))
	{
	   cmin = min_node_data[0];
           cmax = max_node_data[0];
        }
	else
	{
           /* calculate min/max */
	   printf( "WARNING in Isoband UCD: calculating node data min/max\n" );
           cmin =  1E10;
           cmax = -1E10;
           for ( v=0; v=num_nodes; v++ )
           { 
               cmin = MIN( cmin, node_data[v] );
               cmax = MAX( cmax, node_data[v] );
           }
        }
    
	/* calculate contour levels */
	for ( n=0; n<ncontour; n++ )
	    levels[n] = cmin + (cmax-cmin) * (float)n / (float)(ncontour-1);
    }	    

    /* band level recurrence relations */
    bmap[0].levela = -INFINITY;
    bmap[0].levelm =  levels[0];
    bmap[0].levelb =  levels[0];
    for ( n=1; n<ncontour; n++ )
    {
       bmap[n].levela =  levels[n-1];
       bmap[n].levelm = (levels[n-1] + levels[n]) / 2.0;  
       bmap[n].levelb =  levels[n];
    }	   
    bmap[ncontour].levela = levels[ncontour-1];
    bmap[ncontour].levelm = levels[ncontour-1];
    bmap[ncontour].levelb = INFINITY;
	       
    /* test for colourmap input, build band levels and colours */
    if (cmap_ptr)
    {
       /* there is colour map input */
       float lo, hi, h, s, v, r, g, b, nlevelm;
       int   index;

       lo = cmap_ptr->lower;
       hi = cmap_ptr->upper;
       for ( n=0; n<ncontour+1; n++ )
       {
	   nlevelm = bmap[n].levelm;
	   if (nlevelm<=lo)
	       index = 0;
	   else if (nlevelm>=hi)
	       index = 255;      
	   else
	       index = (int)( 255.0 * (nlevelm-lo) / (hi-lo) );
	   h = cmap_ptr->hue[index];
	   s = cmap_ptr->saturation[index];
	   v = cmap_ptr->value[index];
	   bmap[n].h = h;
	   bmap[n].s = s;
	   bmap[n].v = v;
           PIXELhsv_to_rgb( h, s, v, &r, &g, &b );
	   bmap[n].r = r;
	   bmap[n].g = g;
	   bmap[n].b = b;
       }
    }
    else
    {
       /* no colour map input, set default greyscale */
	for ( n=0; n<ncontour+1; n++ )
	{
	    fract = (float)n / (float)ncontour;
	    bmap[n].h = 0.0;
	    bmap[n].s = 0.0;
	    bmap[n].v = fract;
	    bmap[n].r = fract;
	    bmap[n].g = fract;
	    bmap[n].b = fract;
	}
    }

    /* create output colour map */
    cdim[0] = 256;
    cptr = (AVScolormap*) AVSdata_alloc( "colormap", cdim );
    if (!cptr) 
    {
       AVSerror( "ERROR in Isoband UCD: can't allocate output colormap.\n" ); 
       return (ERROR); 
    }
    cptr->size = cdim[0];
    cptr->lower = levels[0];
    cptr->upper = levels[ncontour-1];
    lrange = levels[ncontour-1] - levels[0];
    for ( i=1, bsum=0; i<ncontour; i++ )
    {
	lwidth = levels[i] - levels[i-1];
	bwidth[i] = (int)( 254.0 * lwidth / lrange ) - 1;
	bsum += bwidth[i];
	if (!show_bound)  bwidth[i]++;
    }
    if (!show_bound)  bsum--;
    bwidth[0] = (256 - ncontour - bsum) / 2; 
    bwidth[ncontour] =  256 - ncontour - bsum - bwidth[0];
    
    for ( n=0, bcount=0; n<ncontour+1; n++ )
    {
        for ( b=0; b<bwidth[n]; b++, bcount++ )
	{
	    cptr->hue[bcount]        = bmap[n].h;
	    cptr->saturation[bcount] = bmap[n].s;
	    cptr->value[bcount]      = bmap[n].v;
	    cptr->alpha[bcount]      = 0.0;
	}
	if ( show_bound && (n!=ncontour) )
	{  
	    cptr->hue[bcount]        = 0.0;
	    cptr->saturation[bcount] = 0.0;
	    cptr->value[bcount]      = 0.0;
	    cptr->alpha[bcount]      = 0.0;
	    bcount++;
	}
    }
    *cout_ptr = cptr;


    /* create the geometry output object */
    /* don't redraw if its only the output colormap which needs changing */
    /* need extra test for disconnection of the colour map input */
    if ( AVSinput_changed( "input ucd",      0 ) ||
	 AVSinput_changed( "input cmap",     1 ) ||
         (was_cmap && !cmap_ptr)                 ||
	 AVSinput_changed( "contour levels", 2 ) ||
	 AVSparameter_changed( "N" )              )
    {
	*output = (GEOMedit_list*) GEOMinit_edit_list( *output );
	obj    =  GEOMcreate_obj( GEOM_POLYHEDRON, NULL );

	/* draw the geometry from the cell list */
	if (!display_isoband( input, num_cells, num_nodes, obj, 
			     xc, yc, zc, node_len, node_data, 
			     ncontour, bmap ) )
	{	
	    GEOMdestroy_obj( obj );
	    return(0);
	}

	/* complete the geometry to output port process */
        GEOMgen_normals( obj, 0 );
	GEOMcvt_polyh_to_polytri( obj,
           GEOM_SURFACE|GEOM_WIREFRAME|GEOM_NO_CONNECTIVITY );
	GEOMedit_geometry( *output, "ucd_isoband", obj );
	GEOMdestroy_obj( obj );
	GEOMedit_transform_mode( *output, "ucd_isoband", "parent" );
 
	/* use the new AVS4 geometry viewer option on ESV */
	/* GEOMedit_render_mode( *output, "ucd_isoband", "push_surface" ); */
    }

    if (cmap_ptr) 
        was_cmap = 1;
    else
	was_cmap = 0;

    return(OK);
}

/* =============== display isoband ====================================== */

static display_isoband( input, num_cells, num_nodes, obj, 
 		        xc, yc, zc, node_len, node_data, 
		        ncontour, bmap )

    UCD_structure *input;           /* ucd input port */
    int            num_cells;       /* how many cells */
    int            num_nodes;       /* how many nodes */
    GEOMobj       *obj;             /* add polygons to this object */
    float         *xc, *yc, *zc;    /* node position arrays */
    int            node_len;        /* node vector length */
    float         *node_data;       /* node data */
    int            ncontour;        /* number of contours */
    BandMap        bmap;            /* set of band levels and colors */
{
    int            face_index, v;
    float          fval[MAX_FACE_VERTS];
    float          verts[MAX_FACE_VERTS][3];
    float          cols[MAX_N_CONTOURS+1][MAX_BAND_VERTS][3];
    int            percent, num_face_verts;
    int   	   faces_count, verts_count, lines_count;
    UCD_Line_List *line_list;
    UCD_Face_List *face_list;

                 /* loop counters */
    register int f, j, n, np;

    /* show status */
    AVSmodule_status( "Remove interior faces", 10 );

    /* convert ucd to list of external faces */
    if (!ucd_rm_interior_polys( input, num_cells, num_nodes, 
			        &faces_count, &verts_count, &face_list,
                                &lines_count, &line_list, NULL ) )
    {
       AVSerror ( "ERROR in Isoband UCD: can't remove interior faces.\n" ); 
       return (ERROR); 
    }

    /* test for external faces */
    if (!faces_count) 
    {
       AVSerror( "ERROR in Isoband UCD: no external faces found.\n" );
       return(ERROR);
    }

    /*-- loop over external cell faces --*/
    for ( f=0; f<faces_count; f++ )
    {
        /*-- show status --*/
        percent = 10 + (int)( 80.0 * (float)f/(float)faces_count );
        AVSmodule_status( "Contour band faces", percent );      

        /*-- get number of vertices in this face 00*/ 
        num_face_verts = (int)face_list[f].num_vtx;
        if ((num_face_verts!=3) && (num_face_verts!=4))
	{
	   printf( "Warning in Isoband UCD: unrecognized face type\n");
	   continue;
	}
	  
        /*-- load face coordinates --*/
	/*-- loop over vertices in the face --*/
        for ( j=0; j<num_face_verts; j++ )
        {
	    v = face_list[f].vtx_index[j];
	    verts[j][X] = xc[v];
	    verts[j][Y] = yc[v];
	    verts[j][Z] = zc[v];
	    fval[j] = node_data[v];    /*-- node data is scalar --*/
        }  

        /*-- contour band the cell face --*/
        face_band( bmap, num_face_verts, verts, NULL, fval, obj, ncontour );

    }   /*-- end of loop over faces -- f --*/
}

/* =============== contour routine ====================================== */

face_band( bmap, nverts, vert, norm, fval, obj, ncontour )
    BandMap bmap;
    int     nverts;
    float   vert[MAX_FACE_VERTS][3];
    float   norm[MAX_FACE_VERTS][3];
    float   fval[MAX_FACE_VERTS];
    GEOMobj *obj;
    int     ncontour;
{

#define LINEAR(p,f,q,r) \
        { v[p][X] = vert[q][X] + f * (vert[r][X]-vert[q][X]);\
          v[p][Y] = vert[q][Y] + f * (vert[r][Y]-vert[q][Y]);\
          v[p][Z] = vert[q][Z] + f * (vert[r][Z]-vert[q][Z]);\
          if (norm) \
          { vnorm[p][X] = norm[q][X] + f * (norm[r][X]-norm[q][X]);\
            vnorm[p][Y] = norm[q][Y] + f * (norm[r][Y]-norm[q][Y]);\
            vnorm[p][Z] = norm[q][Z] + f * (norm[r][Z]-norm[q][Z]);}}

#define DIRECT(p,q) \
        { v[p][X] = vert[q][X];\
          v[p][Y] = vert[q][Y];\
          v[p][Z] = vert[q][Z];\
          if (norm) \
          { vnorm[p][X] = norm[q][X];\
            vnorm[p][Y] = norm[q][Y];\
            vnorm[p][Z] = norm[q][Z];}}

#define GATHER(p,q) \
        { pverts[p][X] = v[q][X];\
          pverts[p][Y] = v[q][Y];\
          pverts[p][Z] = v[q][Z];\
          if (norm) \
          { pnorms[p][X] = vnorm[q][X];\
            pnorms[p][Y] = vnorm[q][Y];\
            pnorms[p][Z] = vnorm[q][Z];}}


    /*                       0  1  2  3  4  5  6  7  8  9          */
    /*								   */
    static int saddle[] =  { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /*  0 */
			     1, 2, 0, 0, 0, 0, 0, 0, 0, 3,   /* 10 */
			     4, 0, 0, 5, 0, 0, 0, 0, 0, 0,   /* 20 */
			     6, 0, 0, 7, 0, 0, 0, 0, 0, 0,   /* 30 */
			     0, 0, 0, 0, 0, 0, 0, 8, 0, 0,   /* 40 */
			     9, 0, 0, 0, 0, 0, 0,10, 0, 0,   /* 50 */
			    11,12, 0, 0, 0, 0, 0, 0, 0,13,   /* 60 */
			    14, 0, 0, 0, 0, 0, 0, 0, 0, 0,   /* 70 */
			     0  			     /* 80 */
		           };

    static LUT lut[15] = { { 0, {0,0,0,0}, 0, {0,0,0,0} },   /* unused */
			   { 3, {1,2,3,0}, 3, {4,5,6,0} },   /*  1 */
			   { 3, {1,2,3,0}, 4, {4,5,6,7} },   /*  2 */
			   { 4, {1,2,3,4}, 3, {5,6,7,0} },   /*  3 */
			   { 4, {1,2,3,4}, 4, {5,6,7,8} },   /*  4 */
			   { 4, {1,2,6,7}, 3, {3,4,5,0} },   /*  5 */
			   { 3, {1,2,6,0}, 3, {3,4,5,0} },   /*  6 */
			   { 3, {1,2,7,0}, 4, {3,4,5,6} },   /*  7 */
			   { 3, {1,2,7,0}, 4, {3,4,5,6} },   /*  8 */
			   { 3, {1,2,6,0}, 3, {3,4,5,0} },   /*  9 */
		 	   { 4, {1,2,6,7}, 3, {3,4,5,0} },   /* 10 */
		      	   { 4, {1,2,7,8}, 4, {3,4,5,6} },   /* 11 */
			   { 4, {1,2,3,4}, 3, {5,6,7,0} },   /* 12 */
			   { 3, {1,2,3,0}, 4, {4,5,6,7} },   /* 13 */
			   { 3, {1,2,3,0}, 3, {4,5,6,0} }    /* 14 */
		         };

   int   av_below, av_between, av_above;
   int   k1, k2, nv, index, ptr, exp, nv1, nv2;
   int   step, pind, vlist[MAX_N_CONTOURS+1][MAX_BAND_VERTS];
   int   vcount[MAX_N_CONTOURS+1], vband[MAX_FACE_VERTS], powtab[MAX_FACE_VERTS];
   float f1, f2, fac, avf, la, lb, df, *nptr;
   float v[MAX_N_CONTOURS*MAX_BAND_VERTS][3];
   float vnorm[MAX_N_CONTOURS*MAX_BAND_VERTS][3];
   float pverts[MAX_BAND_VERTS][3], pnorms[MAX_BAND_VERTS][3];
   float cols[MAX_N_CONTOURS+1][MAX_BAND_VERTS][3];

   register int j, k, n;
       
   /*-- precalculate power series --*/
   for ( k=0; k<nverts; k++ )
       powtab[k] = (int) pow( (double)3, (double)(nverts-1-k) );

   /*-- initialize vertex counts --*/
   for ( n=0; n<ncontour+1; n++ )
       vcount[n] = 0;

   /*-- get band numbers for face vertices --*/
   for ( k=0; k<nverts; k++ )
   {
       for ( n=0; n<ncontour+1; n++ )
           if (fval[k]>=bmap[n].levela && fval[k]<bmap[n].levelb)
           {
               vband[k] = n;
               break;
           }
   }

   /*-- build colour table --*/
   for ( n=0; n<ncontour+1; n++ )
   {	    
       for ( j=0; j<MAX_BAND_VERTS; j++ )
       {
	   cols[n][j][R] = bmap[n].r;
 	   cols[n][j][G] = bmap[n].g;
	   cols[n][j][B] = bmap[n].b;
       }
   }

   /*-- interpolate along edges --*/
   for ( k=0, nv=0; k<nverts; k++ )
   {
       k1 = k;
       k2 = (k+1) % nverts;

       /*-- store the first vertex on this edge, tag the relevant list --*/
       DIRECT( nv, k1 );
       n = vband[k1];
       vlist[n][vcount[n]] = nv;
       vcount[n]++;
       nv++;

       /*-- loop over bands which occur along this edge --*/
       if (vband[k1]==vband[k2])
           /*-- no more bands on this edge --*/
           continue;
       else if (vband[k1]<vband[k2])
       {
           /*-- ascending band sequence use upper boundaries --*/
           df = fval[k2] - fval[k1];
           for ( n=vband[k1]; n<vband[k2]; n++ )
           {
               fac = (bmap[n].levelb-fval[k1]) / df;
               LINEAR( nv, fac, k1, k2 );
               vlist[n][vcount[n]]     = nv;   vcount[n]++;
               vlist[n+1][vcount[n+1]] = nv;   vcount[n+1]++;
               nv++;
           }
       }
       else
       {
           /*-- descending band sequence use lower boundaries --*/
           df = fval[k2] - fval[k1];
           for ( n=vband[k1]; n>vband[k2]; n-- )
           {
               fac = (bmap[n].levela-fval[k1]) / df;
               LINEAR( nv, fac, k1, k2 );
               vlist[n][vcount[n]]     = nv;   vcount[n]++;
               vlist[n-1][vcount[n-1]] = nv;   vcount[n-1]++;
               nv++;
           }
       }
   }

   /*-- loop over contour bands --*/
   for ( n=0; n<ncontour+1; n++ )
   {
       /*-- test if polygon required --*/
       if (vcount[n]<3)  continue;

       /*-- test for simple shape --*/
       if (vcount[n]<6)
	  goto OnePolygon;

       /*-- copy levels --*/
       la = bmap[n].levela;
       lb = bmap[n].levelb;

       /*-- calculate index --*/
       for ( k=0, index=0; k<nverts; k++ )
       {
           if      (fval[k]>lb)  index += 2.0 * powtab[k];
           else if (fval[k]>la)  index += powtab[k];
       }

       /*-- test for saddles --*/
       if (!saddle[index])
          goto OnePolygon;

       /*-- handle saddle points --*/

       /*-- find average mid-cell value --*/
       avf = (fval[0]+fval[1]+fval[2]+fval[3]) / 4.0;
       av_below = av_between = av_above = FALSE;
       if      (avf<=la)  av_below   = TRUE;
       else if (avf>lb)   av_above   = TRUE;
       else               av_between = TRUE;

       /*-- find saddles that only give one polygon --*/

       /*-- 6-sided --*/
       if ( (index==10 && !av_below)  ||
	    (index==30 && !av_below)  ||
	    (index==50 && !av_above)  ||
	    (index==70 && !av_above)   )
	  goto OnePolygon;

       /*-- 7-sided --*/
       if ( (index==61 && !av_above)  ||
            (index==47 && !av_above)  ||
	    (index==69 && !av_above)  ||
	    (index==23 && !av_above)  ||
	    (index==19 && !av_below)  ||
	    (index==33 && !av_below)  ||
	    (index==11 && !av_below)  ||
	    (index==57 && !av_below)   )
	  goto OnePolygon;

       /*-- 8-sided --*/
       if ( (index==20 && av_between) ||
            (index==60 && av_between)  )
          goto OnePolygon;

       /*-- swap orientation for symmetric 8-vertex 2-quad saddle points --*/
       if      (index==20 && av_above)   index=60;
       else if (index==60 && av_above)   index=20;

   /*--------------*/
   /* TwoPolygons: */
   /*--------------*/
    
       /*-- double gather first polygon vertices and normals --*/
       nv1 = lut[saddle[index]].n1;
       for ( j=0; j<nv1; j++ )
       {
           ptr = lut[saddle[index]].ptr1[j] - 1;
           pind = vlist[n][ptr];
           GATHER( j, pind );
       }

       /*-- switch on normal information --*/
       if (norm)
          nptr = &pnorms[0][X];
       else
          nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], nv1, 
				  (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA);

       /*-- double gather second polygon vertices and normals --*/
       nv2 = lut[saddle[index]].n2;
       for ( j=0; j<nv2; j++ )
       {
           ptr = lut[saddle[index]].ptr2[j] - 1;
           pind = vlist[n][ptr];
           GATHER( j, pind );
       }

       /*-- switch on normal information --*/
       if (norm)
          nptr = &pnorms[0][X];
       else
          nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], nv2,
				  (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA);

       continue;
    
   /*-------*/
   OnePolygon:
   /*-------*/
    
       /*-- gather polygon vertices and normals --*/
       for ( j=0; j<vcount[n]; j++ )
       {
           pind = vlist[n][j];
           GATHER( j, pind );
       }

       /*-- switch on normal information --*/
       if (norm)
          nptr = &pnorms[0][X];
       else
          nptr = NULL;

       GEOMadd_disjoint_polygon( obj, pverts, nptr, &cols[n][0][0], vcount[n], 
				  (GEOM_NOT_SHARED|GEOM_CONVEX),GEOM_COPY_DATA);
   }
   return(OK);
}


/*-----------------------------------------------------*
 *                                                     *
 *        ****  ucd_isoband ****                       *
 *                                                     *
 *-----------------------------------------------------*/
ucd_isoband_desc()
{
  int ucd_isoband(), param, oport;

  /* name on the box */
  AVSset_module_name( "Isoband UCD", MODULE_MAPPER );

  /* input ucd structure to draw */
  AVScreate_input_port( "input ucd", "ucd", REQUIRED );

  /* input colour map */
  AVScreate_input_port( "input cmap", "colormap", OPTIONAL ); 

  /* input contour level field */
  AVScreate_input_port( "contour levels", 	
		        "field 1D uniform scalar float", OPTIONAL );

  /* output geometry to draw */
  oport = AVScreate_output_port( "ucd_isoband", "geom" );
  AVSautofree_output( oport );

  /* output colormap */
  oport = AVScreate_output_port( "output cmap", "colormap" );
/**
  AVSautofree_output( oport );
 **/

  /* number of contours */
  param = AVSadd_parameter( "N", "integer", 10, 2, MAX_N_CONTOURS );

  /* switch boundary bands for output colormap */
  param = AVSadd_parameter( "Colourmap Boundary", "boolean", 0, 0, 1 );
  AVSadd_parameter_prop( param, "layout", "string_block",
        "manipulator \"$Module:Colourmap Boundary\" -xy 10,150" );
  AVSadd_parameter_prop( param, "width", "integer", 3 );
    
  /* routine pointers */
  AVSset_compute_proc ( ucd_isoband );

  /* ensure module can be combined into multi-module process */
  AVSset_module_flags( COOPERATIVE | REENTRANT );

}  /* end of description routine */


AVSinit_modules()
{
        AVSmodule_from_desc( ucd_isoband_desc );
}

