/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 *-----------------------------------------------------------------------
 *
 *      (C) Copyright Evans & Sutherland Computer Limited 1992
 *
 *
 *  EVANS & SUTHERLAND ASSUMES NO RESPONSIBILITY FOR ANY USE OR INABILITY
 *  TO USE THIS SOFTWARE. THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY
 *  OF ANY KIND WHATSOEVER. EVANS & SUTHERLAND DISCLAIMS ALL IMPLIED WARRANTIES
 *  INCLUDING THOSE OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  PERMISSION IS GRANTED TO USE, COPY, MODIFY AND DISTRIBUTE THIS SOFTWARE
 *  PROVIDED THAT: ALL SUBSEQUENT DISTRIBUTION IS FREE OF CHARGE; THE
 *  COPYRIGHT NOTICE AND THIS PERMISSION NOTICE ARE PRESERVED IN ALL COPIES.
 *
 *-----------------------------------------------------------------------
 *
 *      ISOLINE UCD module
 * 
 *      Author:   Mike French, Evans & Sutherland UK
 *
 *      Date:     10 June 1992
 *
 *
 *      Revision: 23 Aug  1993 IanC: Revisized memory allocation
 *                 2 Nov  1993 IanC: fixed non-initialized var bug
 *
 *-----------------------------------------------------------------------
 */

#include <stdio.h>

#include <avs/avs.h>
/* IAC CODE CHANGE : #include <avs/avs_math.h> */
#include <avs/avs_math.h>
#include <avs/geom.h>
#include <avs/field.h>
#include <avs/colormap.h>
#include <avs/ucd_defs.h>

/* constant for string comparison */
#define EQUAL 0 

/* max no. of vertices returned from polygon banding routine */
#define MAX_BAND_VERTS 8

/* max no. of vertices for a ucd face */
#define MAX_FACE_VERTS  4

/* maximum number of contours */
#define MAX_N_CONTOURS 20

/* local macros */
#define MIN(a,b)  (a<b?a:b)
#define MAX(a,b)  (a>b?a:b)

/* cell face switch */
static enum { FACE_INVALID, FACE_VALID };

/* boolean constants */
static enum { FALSE, TRUE };

/* cartesian constants */
static enum { X, Y, Z };

/* vertex pairs */
static enum { A, B };

/* UI panel switches */
typedef enum { DIAL_HIDE, DIAL_SHOW } DialSwitch;

/* util function types for removing interior faces */
typedef struct   _UCD_Face_List
{
        unsigned char         num_vtx;
        int                   vtx_index[4];
        int                   mat_id;
        int                   cell_id;
} UCD_Face_List;

typedef struct   _UCD_Line_List
{
        int                   vtx_index[2];
        int                   mat_id;
        int                   cell_id;
} UCD_Line_List;

/* look up table for line interpolation */
typedef struct _LUT
{
    int n;
    int vid[4][2];
} LUT ;

/* simple local disjoint line list */
typedef struct _Lines
{
    int   n;           /* number of vectors in list 0,1,2 */
    float v[4][3];     /* vertex list */
} Lines;

/* no. of nodes for each cell type */
static int NUM_NODES[] = { 1, 2, 3, 4, 4, 5, 6, 8 };

/* =============== compute routine ========================================== */

static ucd_isoline( input, cmap_in, level_ptr, 
		    output, cmap_out, 
		    offset_method, offset, ncparam )

  UCD_structure  *input;
  AVScolormap    *cmap_in;
  AVSfield_float *level_ptr;
  GEOMedit_list  **output;
  AVScolormap    **cmap_out;
  char           *offset_method;
  float          *offset;
  int             ncparam;
{
    static       DialSwitch Nshow = DIAL_SHOW;
    static       DialSwitch Oshow = DIAL_SHOW;
    
    AVScolormap *cmap_ptr;
    char         model_name[80];
    GEOMobj     *obj, *lobj;
    float       *xc, *yc, *zc, *node_data, min_node_data[1], max_node_data[1];
    float        levels[MAX_N_CONTOURS], cmap[MAX_N_CONTOURS][3], cmin, cmax;
    float        min_ext[3], max_ext[3], x_ext, y_ext, z_ext, diag, delta;
    float        cmap_hsv[MAX_N_CONTOURS][3];
    int          cell, i, name_flag, util_flag, data_len, cell_len;
    int          node_len, num_nodes, num_cells, ncontour, *comp;
    int          band, index;
    
                 /* loop counters */
    register int n, v, b;

    /* get general sizes */
    if ( !UCDstructure_get_header( input, model_name, &data_len, &name_flag, 
  		 	           &num_cells, &cell_len, &num_nodes, &node_len,
			           &util_flag ) )
    {
       AVSerror ("ERROR in Isoline UCD: can't get header.\n"); 
       return (0);
    }

    /* make sure there are some cells */
    if (!num_cells || !num_nodes)
    {
       AVSerror ("ERROR in Isoline UCD: empty ucd\n" );
       return (0);
    }
    /* make sure node data is single scalar component */
    if ( node_len != 1 )
    {
       AVSerror ("ERROR in Isoline UCD: not single node component\n" );
       return (0);
    }
    if ( !UCDstructure_get_node_components( input, &comp ) )
    {
       AVSerror ("ERROR in Isoline UCD: cannot get node component data\n" );
       return (0);
    }
    if ( comp[0] != 1 )
    {
       AVSerror ("ERROR in Isoline UCD: node component is not scalar\n" );
       return (0);
    }

    /* find out where the nodes are */
    if ( !UCDstructure_get_node_positions( input, &xc, &yc, &zc ) )
    {
       AVSerror ( "ERROR in Isoline UCD: can't get node coordinates.\n" ); 
       return (0);
    }

    /* get a pointer to where the node data is stored */
    if ( !UCDstructure_get_node_data( input, &node_data ) )
    {
       AVSerror ( "ERROR in Isoline UCD: can't get node data.\n" ); 
       return (0); 
    }

    /* magicians act with the offset dial */
    if ( (strcmp(offset_method,"No offset")==EQUAL) && (Oshow==DIAL_SHOW) )
    {
       /* the dial must be removed */
       Oshow = DIAL_HIDE;  
       AVSparameter_visible( "offset", Oshow );	    
    }

    if ( (strcmp(offset_method,"No offset")!=EQUAL) && (Oshow==DIAL_HIDE) )
    {
       /* the dial must be revealed */
       Oshow = DIAL_SHOW;  
       AVSparameter_visible( "offset", Oshow );	    
    }      

    /* test for contour level input */
    if (level_ptr)
    {
       /* there is contour level input */
       if (Nshow==DIAL_SHOW)
       {
	  /* the dial must be removed */
	  Nshow = DIAL_HIDE;
          AVSparameter_visible( "N", Nshow );
       }
	
       /* copy contour levels from input field to local array */
       if (!level_ptr->dimensions)
       {
	  AVSerror( "ERROR in Isoline UCD: cannot get field dimensions\n" );
	  return(0);
       }
       ncontour = level_ptr->dimensions[0];
       if (!level_ptr->data)
       {
          AVSerror( "ERROR in Isoline UCD: cannot get field data pointer\n" );
          return(0);
       }
       for ( n=0; n<ncontour; n++ )
  	   levels[n] = level_ptr->data[n];
    }
    else
    {
	/* there is no contour level input */
	if (Nshow==DIAL_HIDE)
	{
	   /* dial must be replaced */
	   Nshow = DIAL_SHOW;
           AVSparameter_visible( "N", Nshow );	    
        }
	
        /* generate local contour levels */
        ncontour = ncparam;
	if (UCDstructure_get_node_minmax( input,min_node_data,max_node_data ))
	{
	   cmin = min_node_data[0];
           cmax = max_node_data[0];
        }
	else
	{
           /* calculate min/max */
	   printf( "WARNING in Isoline UCD: calculating node data min/max\n" );
           cmin =  1E10;
           cmax = -1E10;
           for ( v=0; v=num_nodes; v++ )
           { 
               cmin = MIN( cmin, node_data[v] );
               cmin = MIN( cmax, node_data[v] );
           }
        }
    
	/* calculate contour levels */
	for ( n=0; n<ncontour; n++ )
	    levels[n] = cmin + (cmax-cmin) * (float)n / (float)(ncontour-1);
    }	    
    cmap_out = &cmap_ptr;

    /* get absolute shift from offset parameter and diagonal extent */
    if ( UCDstructure_get_extent( input, min_ext, max_ext ) )
    {
       x_ext = max_ext[0] - min_ext[0];
       y_ext = max_ext[1] - min_ext[1];
       z_ext = max_ext[2] - min_ext[2];
       diag = sqrt( x_ext*x_ext + y_ext*y_ext + z_ext*z_ext );
       delta = (*offset) * diag;
    }
    else
       /* default */
       delta = 0.01;

    /* test for colourmap input  */
    if (cmap_in)
    {
       float lo, hi, h, s, v, r, g, b;
       int   index;

       /* there is colour map input */
       lo = cmap_in->lower;
       hi = cmap_in->upper;
       for ( n=0; n<ncontour; n++ )
       {
           /* in C colour index is 0-255, not 1-256 as in Fortran */
	   if (levels[n]<=lo)
	       index = 0;
	   else if (levels[n]<=lo)
	       index = 255;
	   else
	       index = (int)( 255.0 * (levels[n]-lo) / (hi-lo) );
	   h = cmap_in->hue[index];
	   s = cmap_in->saturation[index];
	   v = cmap_in->value[index];

           PIXELhsv_to_rgb( h, s, v, &r, &g, &b );

	   cmap_hsv[n][0] = h;
	   cmap_hsv[n][1] = s;
	   cmap_hsv[n][2] = v;
	   cmap[n][0] = r;
	   cmap[n][1] = g;
	   cmap[n][2] = b;
       }
    }
    else
    {
       /* no colour map input, set default colour black */
	for ( n=0; n<ncontour; n++ )
	{
	    cmap[n][0] = cmap[n][1] = cmap[n][2] = 0.0;
	}
    }

    /* create colormap output */
    if ( cmap_ptr == NULL )
    {
        cmap_ptr = (AVScolormap *) malloc ( sizeof( AVScolormap ));
        cmap_ptr->hue        = (float *) malloc ( sizeof(float) * BYTE_TABLE );
        cmap_ptr->saturation = (float *) malloc ( sizeof(float) * BYTE_TABLE );
        cmap_ptr->value      = (float *) malloc ( sizeof(float) * BYTE_TABLE );
        cmap_ptr->alpha      = (float *) malloc ( sizeof(float) * BYTE_TABLE );
    }
    cmap_ptr->size       = BYTE_TABLE;


    if (!cmap_ptr)
    {
       AVSerror ("ERROR in Isoline UCD: cannot allocate output colormap\n" );
       return (0);
    }
    cmap_ptr->lower = levels[0];
    cmap_ptr->upper = levels[ncontour-1];
    band = (256-1) / (ncontour-1);
    for ( n=0; n<ncontour-1; n++ )
    {
        index = n*band;
        cmap_ptr->hue[index]        = cmap_hsv[n][0]; 
        cmap_ptr->saturation[index] = cmap_hsv[n][1]; 
	cmap_ptr->value[index]      = cmap_hsv[n][2]; 
	for ( b=1; b<band; b++ )
	{
	    index = n*band + b;
	    cmap_ptr->hue[index]        = 0.0;
	    cmap_ptr->saturation[index] = 0.0;
	    cmap_ptr->value[index]      = 0.0;
	}
    }
    for ( index=band*(ncontour-1); index<256; index++ )
    {
        cmap_ptr->hue[index]        = 0.0;
        cmap_ptr->saturation[index] = 0.0;
        cmap_ptr->value[index]      = 0.0;
    }
    index = 255;
    cmap_ptr->hue[index]        = cmap_hsv[ncontour][0]; 
    cmap_ptr->saturation[index] = cmap_hsv[ncontour][1]; 
    cmap_ptr->value[index]      = cmap_hsv[ncontour][2]; 
    
    /* establish the geometry output object */
    *output = (GEOMedit_list*) GEOMinit_edit_list( *output );
    obj    =  GEOMcreate_obj( GEOM_POLYTRI, NULL );

    /* draw the geometry from the cell list */
    if (!display_isoline( input, num_cells, num_nodes, obj, 
                          xc, yc, zc, node_len, node_data, 
		          offset_method, delta, ncontour, levels, cmap ) )
    {
        GEOMdestroy_obj( obj );       
	return(0);
    }
      
    /* complete the geometry to output port process */
    GEOMedit_geometry( *output, "ucd_isoline", obj );
    GEOMdestroy_obj( obj );
    GEOMedit_transform_mode( *output, "ucd_isoline", "parent" );

    return(1);
}

/*-----------------------------------------------------*
 *                                                     *
 *          ****  display_isoline ****                 *
 *                                                     *
 *-----------------------------------------------------*/

static display_isoline( input, num_cells, num_nodes, obj, 
 		        xc, yc, zc, node_len, node_data, 
		        offset_method, delta, ncontour, levels, cmap )

  UCD_structure *input;           /* ucd input port */
  int            num_cells;       /* how many cells */
  int            num_nodes;       /* how many nodes */
  GEOMobj       *obj;             /* add polygons to this object */
  float         *xc, *yc, *zc;    /* node position arrays */
  int            node_len;        /* node vector length */
  float         *node_data;       /* node data */
  char          *offset_method;   /* method of exploding vertices */
  float          delta;           /* absolute magnitude of line offset */
  int            ncontour;        /* number of contours */
  float         *levels;          /* set of contour levels */
  float          cmap[][3];       /* set of contour colours */
{
      float      face_vert[MAX_FACE_VERTS][3], fnormal[3], vnormal[3], cog[3];
      int        face_index, v, num_faces, npt, percent, cid, ctype;
      int        num_face_verts, *nl;
      float      fval[MAX_FACE_VERTS];
      float      x[MAX_FACE_VERTS], y[MAX_FACE_VERTS], z[MAX_FACE_VERTS];
      float      cols[MAX_N_CONTOURS][2][3];

      int            faces_count, verts_count, lines_count;
      UCD_Line_List *line_list;
      UCD_Face_List *face_list;
      Lines          lines;

                   /* loop counters */
      register int c, f, j, con, n;
      
      /* show status */
      AVSmodule_status( "Remove interior faces", 10 );

      /* convert ucd to list of external faces */
      if (!ucd_rm_interior_polys( input, num_cells, num_nodes,
                                  &faces_count, &verts_count, &face_list,
                                  &lines_count, &line_list, NULL ) )
      {
         AVSerror ( "ERROR in Isoline UCD: cannot remove interior faces.\n" );
         return (0);
      }

      /* test for external faces */
      if (!faces_count)
      {
          AVSerror( "ERROR in Isoline UCD: no external faces found\n" );
          return(0);
      }

      /* build colour table */
      for ( con=0; con<ncontour; con++ )
      {
          for ( n=0; n<2; n++ )
              {
                  cols[con][n][0] = cmap[con][0];
                  cols[con][n][1] = cmap[con][1];
                  cols[con][n][2] = cmap[con][2];
              }
      }

      /*********************************************/
      /**** loop over ALL cell  surfaces        ****/
      /*********************************************/

      for ( f=0; f<faces_count; f++ )
      {

          /* show status */
          percent = 10 + (int)( 80.0 * (float)f/(float)faces_count );
          AVSmodule_status( "Contour line faces", percent );

          /* get the cell id and type for this face */
	  cid   = face_list[f].cell_id;
          ctype = input->cell_type[cid];

          /* get number of vertices in this face */
          num_face_verts = (int)face_list[f].num_vtx;
          if ((num_face_verts!=3) && (num_face_verts!=4))
          {
              printf( "Warning in Isoline UCD: unrecognized face type\n");
              continue;
          }

	  /* load face coordinates and data value */
          for ( j=0; j<num_face_verts; j++ )
          {
	      v = face_list[f].vtx_index[j];
	      face_vert[j][0] = xc[v];
	      face_vert[j][1] = yc[v];
	      face_vert[j][2] = zc[v];
	      fval[j] = node_data[v];    /* node data is scalar */
	  }

	  /* offset coordinates */
	  if ( strcmp(offset_method,"No offset") == EQUAL )
          {
      	     /* no action */
	  }
	  else if ( strcmp(offset_method,"Facet") == EQUAL )
	  {
	     /* use facet normal for offset */
	     facet_normal( face_vert, fnormal );
 	     for ( j=0; j<num_face_verts; j++ )
	     {
		 face_vert[j][0] += delta*fnormal[0];
		 face_vert[j][1] += delta*fnormal[1];
		 face_vert[j][2] += delta*fnormal[2];
	     }
	  }
          else if ( strcmp(offset_method,"Vertex") == EQUAL )
	  {
             /* set node array pointer to start of this cell */
/*
 * Potential Bug-
 * "c" is used before being initialized!
 *            nl = input->node_list + input->node_list_ptr[c];
 * changing to "cid"
 */

             nl = input->node_list + input->node_list_ptr[cid];

	     /* find cell centre -- loop over vertices in cell */
	     cog[0] = cog[1] = cog[2] = 0.0;
	     for ( j=0; j<NUM_NODES[ctype]; j++ )
	     {
	         v = nl[j];
	         cog[0] += xc[v];  
	         cog[1] += yc[v]; 
	         cog[2] += zc[v];
	     }
	     cog[0] /= (float)NUM_NODES[ctype];
	     cog[1] /= (float)NUM_NODES[ctype];
	     cog[2] /= (float)NUM_NODES[ctype];

	     /* loop over vertices in the face and offset position */
	     for ( j=0; j<num_face_verts; j++ )
             {
	         /* calculate vertex normal using cell centre */
		 vnormal[0] = face_vert[j][0] - cog[0];
		 vnormal[1] = face_vert[j][1] - cog[1];
		 vnormal[2] = face_vert[j][2] - cog[2];
		 
		 /* make unit vector */
		 vnorm( vnormal );

   	         face_vert[j][0] += delta*vnormal[0]; 
		 face_vert[j][1] += delta*vnormal[1]; 
		 face_vert[j][2] += delta*vnormal[2];
	      }
	   }  
	   else /* don't recognise offset_method string */
	   {
	      AVSerror( "ERROR in Isoline UCD: invalid offset method\n" );
	      return(0);
	   }

	   /* do contouring */
	   for ( con=0; con<ncontour; con++ )
	   {
	       face_lines( levels[con],num_face_verts,face_vert,fval,&lines );
	       for ( n=0; n<lines.n; n++ )
	       {
                   GEOMadd_polyline( obj, lines.v[2*n], &cols[con][0][0],
				     2, GEOM_COPY_DATA );
	       }
	   } /* end of loop over contours -- con */
        }  /* end of loop over faces -- f */
    return(1);
}

/*-----------------  face contour  -------------------------------------------*/

face_lines( l, nverts, vert, fval, lineptr )
float  l;
int    nverts;
float  vert[MAX_FACE_VERTS][3], fval[MAX_FACE_VERTS];
Lines *lineptr;
{

    /*                        n    0    1    2    3        */
    /* 			           A B  A B  A B  A B      */
    static LUT lut4[16] = { 
   			    { 0 },
			    { 1, { 3,4, 4,1 } },
			    { 1, { 2,3, 3,4 } },
			    { 1, { 2,3, 4,1 } },
			    { 1, { 1,2, 2,3 } },
			    { 2, { 1,2, 2,3, 3,4, 4,1 } },
			    { 1, { 1,2, 3,4 } },
			    { 1, { 1,2, 4,1 } },
			    { 1, { 1,2, 4,1 } },
			    { 1, { 1,2, 3,4 } },
			    { 2, { 1,2, 4,1, 2,3, 3,4 } },
			    { 1, { 1,2, 2,3 } },
			    { 1, { 2,3, 4,1 } },
			    { 1, { 2,3, 3,4 } },
			    { 1, { 3,4, 4,1 } },			   
   			    { 0 }
		          };  

    static LUT lut3[8] =  { 
	                    { 0 },
			    { 1, { 2,3, 3,1 } },
			    { 1, { 1,2, 2,3 } },
			    { 1, { 1,2, 3,1 } },
			    { 1, { 1,2, 3,1 } },
			    { 1, { 1,2, 2,3 } },
			    { 1, { 2,3, 3,1 } },
			    { 0 }
			  };

    int      index, ia, ib, i2j;
    float    fac, avf;

    register int i, j, k;

    /* calculate index */
    for ( k=0, index=0; k<nverts; k++ )
	if (fval[k]>l)  index += pow(2,nverts-1-k);
    
    /* draw contour lines for triangular faces */
    if (nverts==3)
    {
       lineptr->n = lut3[index].n;
       if (lineptr->n == 0)
	  /* no lines */
          return;
       else
       {
	  /* one line */
	   for ( j=0; j<2; j++ )
	   {
	       ia = lut3[index].vid[j][A] - 1;
	       ib = lut3[index].vid[j][B] - 1;
               fac = (l-fval[ia]) / (fval[ib]-fval[ia]);	
	       lineptr->v[j][X] = vert[ia][X] + fac*(vert[ib][X]-vert[ia][X]);
	       lineptr->v[j][Y] = vert[ia][Y] + fac*(vert[ib][Y]-vert[ia][Y]);
	       lineptr->v[j][Z] = vert[ia][Z] + fac*(vert[ib][Z]-vert[ia][Z]);

	   }
       }
    }

    else if (nverts==4)
    {
       lineptr->n = lut4[index].n;
       if (lineptr->n==0)
          return;
       else
       {
          /* test for saddles */
          if (index==5)
          {
             avf = (fval[0]+fval[1]+fval[2]+fval[3]) / 4.0;
             if (avf>l)  index = 10;
          }
          else if (index==10)
          {
             avf = (fval[0]+fval[1]+fval[2]+fval[3]) / 4.0;
             if (avf>l)  index = 5;
          }

	  /* one or two lines */
	  for ( i=0; i<lineptr->n; i++ ) 
	  {
	     for ( j=0; j<2; j++ )
	     {
	       i2j = i*2 + j;
	       ia = lut4[index].vid[i2j][A] - 1;
	       ib = lut4[index].vid[i2j][B] - 1;
               fac = (l-fval[ia]) / (fval[ib]-fval[ia]);	
               lineptr->v[i2j][X] = vert[ia][X] + fac*(vert[ib][X]-vert[ia][X]);
	       lineptr->v[i2j][Y] = vert[ia][Y] + fac*(vert[ib][Y]-vert[ia][Y]);
	       lineptr->v[i2j][Z] = vert[ia][Z] + fac*(vert[ib][Z]-vert[ia][Z]);
	     }   
	  }  
       }
    } 
}

/*-----------------  facet normal  -------------------------------------------*/

static facet_normal( vert, fnorm ) 
 
  float vert[][3];
  float fnorm[3];
{
  float v01[3], v02[3];

  /* calculate intermediate vectors */
  v01[0] = vert[0][0] - vert[1][0];
  v01[1] = vert[0][1] - vert[1][1];
  v01[2] = vert[0][2] - vert[1][2];
  v02[0] = vert[0][0] - vert[2][0];
  v02[1] = vert[0][1] - vert[2][1];
  v02[2] = vert[0][2] - vert[2][2];

  /* calculate cross product */
  vcross_prod( v01, v02, fnorm );
  
  /* normalize cross product */
  vnorm( fnorm );

  return(1);  
}

/*-----------------  normalize the length of a 3-vector  ---------------------*/

static vnorm (v)
        float v[3];
{
  static double epsilon = 1e-10;
  double        mag, sqrt();

  mag = sqrt( v[0]*v[0] + v[1]*v[1] + v[2]*v[2] );

  if (mag>epsilon) 
  {
    v[0] = v[0] / mag;
    v[1] = v[1] / mag;
    v[2] = v[2] / mag;
  }
  else 
  {
    v[0] = 1.0;
    v[1] = 0.0;
    v[2] = 0.0;
  }
}

/*-----------------  3-vector cross product  ---------------------------------*/

static vcross_prod (v1,  v2,  v3)
             float *v1, *v2, *v3;
{
  v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
  v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
  v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
}


/*-----------------------------------------------------*
 *                                                     *
 *        ****  ucd_isoline ****                       *
 *                                                     *
 *-----------------------------------------------------*/
ucd_isoline_desc()
{
  int ucd_isoline(), param;

  /* name on the box */
  AVSset_module_name( "Isoline UCD", MODULE_MAPPER );

  /* input ucd structure to draw */
  AVScreate_input_port( "Input", "ucd", REQUIRED );

  /* input colour map */
  AVScreate_input_port( "cmap_in", "colormap", OPTIONAL ); 

  /* input contour level field */
  AVScreate_input_port( "contour level", 	
		        "field 1D uniform scalar float", OPTIONAL );

  /* output geometry to draw */
  AVScreate_output_port( "ucd_isoline", "geom" );

  /* output colour map */
  AVScreate_output_port( "cmap_out", "colormap" );

  /* offset method */
  AVSadd_parameter( "offset method", "choice", "No offset",
		    "No offset!Facet!Vertex", "!" );

  /* offset parameter */
  AVSadd_float_parameter( "offset", 0.0035, 0.0001, 0.0050 );

  /* number of contours */
  AVSadd_parameter( "N", "integer", 10, 2, MAX_N_CONTOURS );

  /* routine pointers */
  AVSset_compute_proc ( ucd_isoline );

  /* ensure module can be combined into multi-module process */
  AVSset_module_flags( COOPERATIVE | REENTRANT );

}  /* end of description routine */

AVSinit_modules()
{
        AVSmodule_from_desc( ucd_isoline_desc );
}




