/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* 
 * KEYFRAME ANIMATOR:
 * created by Brian Kaplan
 *      kaplan@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * Copyright (c) 1993 Brian Kaplan, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

#include <stdio.h>
#include <math.h>
#include "Keyframe.h"
#include "quaternion.h"

/***********************************************
 * ROUTINES FOR HANDLING CHANNEL INTERPOLATION *
 ***********************************************/

Interp_hold(curr, start, end, object, qr,xt,yt,zt,sc)
/**************************************************************/
/* copy the values for the current frame (curr) to all other  */
/* frames in the animation window.  The window will be from   */
/* the frame specified by start to the frame specified by     */
/* end.  The object to be interpolated is specified in        */
/* object.  The other parameters are either 1 to interpolate  */
/* that channel, or 0 to not interpolate that channel.        */
/**************************************************************/
     int curr, start,end,object,qr,xt,yt,zt,sc;
{
    double rot[4];
    double val;
    int i;

    if (qr) {
	GetRot(rot, curr, object);
	for (i=start; i<=end; i++) SetRot(i, object, rot);
    }
    if (xt) {
	val = GetChan(curr, object, XTRN);
	for (i=start; i<=end; i++) SetChan(i, object, XTRN, val);
    }
    if (yt) {
        val = GetChan(curr, object, YTRN);
	for (i=start; i<=end; i++) SetChan(i, object, YTRN, val);
    }
    if (zt) {
        val = GetChan(curr, object, ZTRN);
	for (i=start; i<=end; i++) SetChan(i, object, ZTRN, val);
    }
    if (sc) {
        val = GetChan(curr, object, SIZE);
	for (i=start; i<=end; i++) SetChan(i, object, SIZE, val);
    }
}


Interp_linear(start,end,ei,eo,object,qr,xt,yt,zt,sc) 
/**************************************************************/
/* Linearly interpolate channels based on keyframes.          */
/* The interpolation will be from the frame specified by      */
/* start to the frame specified by end.  The object to be     */
/* interpolated is specified in object.  The other parameters */
/* are either 1 to interpolate that channel, or 0 to not      */
/* interpolate that channel.                                  */
/**************************************************************/
     int start,end,ei,eo,object,qr,xt,yt,zt,sc;
{
  int s,e,ease;

  /* if the keyframes are consecutive or the same, return now */
  if (end-start < 2) return(1);

  if (ei) ease = -1;
  else ease = 0;

  s = start;
  e = 0;

  /* interpolate each animation segment between keyframes */
  while (e < end) {
    e = NextKey(s,end);

    if (eo && (e == end)) ease = 1;

    /* interp from s to e */
    if (qr) qlinterp(s,e,ease,object);
    if (xt) rlinterp(s,e,ease,object,XTRN);
    if (yt) rlinterp(s,e,ease,object,YTRN);
    if (zt) rlinterp(s,e,ease,object,ZTRN);
    if (sc) rlinterp(s,e,ease,object,SIZE);

    ease = 0;
    s = e;
  }  
}

rlinterp(s,e,ease,obj,channel)
/**************************************************************/
     int s,e,ease,obj,channel;
{
  int j, steps;
  double u,deltau,temp,sval;
  double diff;

  diff = GetChan(e, obj, channel) - GetChan(s, obj, channel);
  sval = GetChan(s, obj, channel);
  
  steps = e-s;
  if (steps < 2) return(1);

  deltau = 1.0/steps;
  temp = 0.0;

  /* fill in frames between s and e */
  for (j=1; j<steps; j++) {
    temp+=deltau;
    if (ease < 0) u = 1.0 - sin((1.0-temp)*1.5708);
    else if (ease > 0) u = sin(temp*1.5708);
    else u=temp;

    SetChan(j+s, obj, channel, (sval + (u*diff)));
  }
}

qlinterp(s,e,ease,obj)
/**************************************************************/
     int s,e,ease,obj;
{
  double S[4],E[4],O[4];
  double u,deltau,temp;
  int j,steps;

  /* make sure the quaternions are within 180 degrees of each other */
  correct_quat(s, e, obj);
  
  /* get the start and end quaternions in F and G */
  GetRot(S, s, obj);
  GetRot(E, e, obj);

  steps = e-s;
  if (steps < 2) return(1);

  /* linearly interpolate u from 0 to 1 */
  deltau = 1.0/steps;
  temp = 0.0;

  /* do the interpolations for each frame based on u */
  for (j=1; j<steps; j++) {
    temp+=deltau;
    if (ease < 0) u = 1.0 - sin((1.0-temp)*1.5708);
    else if (ease > 0) u = sin(temp*1.5708);
    else u=temp;

    linterp_quaternion(O,S,E,u);
    SetRot(j+s, obj, O);
  }
}

correct_quat(s, e, obj)
/**************************************************************/
    int s, e, obj;
{
    int j, k;
    double F[4];
    double G[4];
    double qangle();
    
    /* ensure that the quaternions are flipped so that all */
    /* rotations will take the shortest path (less than    */
    /* 180 degrees) between successive quaternions in the  */
    /* specified interval.                                 */

    j = s;
    while (j != e) {
      k = NextKey(j, e);
      GetRot(F, j, obj);
      GetRot(G, k, obj);
      if (qangle(F, G) < 0.0) {
        /* the angle is greater than 180 degrees, flip G */
	qneg(G, G);
	SetRot(k, obj, G);
      }
      j = k;
      k = NextKey(j, e);
    }
}

linterp_quaternion(result, p0, p1, t)
/**************************************************************/
    double result[4];
    double p0[4];
    double p1[4];
    double t;
{
  double theta,dot,st1t,stt,st;
  int i;
  
  /* linearly interpolate between quaternions p0 and p1 */
  /* as parameter t varies from 0 to 1.  the resulting  */
  /* quaternion at each frame is returned in result.    */
  /* this code is modified from code written by Andrew  */
  /* Hanson and Robert Cross of Indiana University      */
  
  dot=0.0;
  for (i=X;i<=W;i++) dot+=p0[i]*p1[i];

  if (dot>1.0) dot = 1.0;
  else if (dot<-1.0) dot = -1.0;
  theta = acos(dot);

  st1t = sin((1.0-t)*theta);
  stt = sin(t*theta);
  st = sin(theta);

  if (fabs(st)<RAYEPS) { /* Small angles */
    if (t<0.5) {
       for (i=X;i<=W;i++) result[i] = p0[i];
       return;
    }
    else {
       for (i=X;i<=W;i++) result[i] = p1[i];
       return;
    }
  }

  result[X] = (p0[X]*st1t + p1[X]*stt)/st;
  result[Y] = (p0[Y]*st1t + p1[Y]*stt)/st;
  result[Z] = (p0[Z]*st1t + p1[Z]*stt)/st;
  result[W] = (p0[W]*st1t + p1[W]*stt)/st;
}


Interp_spline(start,end,ei,eo,object,qr,xt,yt,zt,sc) 
/**************************************************************/
/* Spline interpolate channels based on keyframes.            */
/* The interpolation will be from the frame specified by      */
/* start to the frame specified by end.  ei and eo are 0 or 1 */
/* for an ease-in and/or an ease-out.  The object to be       */
/* interpolated is specified in object.  The other parameters */
/* are either 1 to interpolate that channel, or 0 to not      */
/* interpolate that channel.                                  */
/**************************************************************/
     int start,end,ei,eo,object,qr,xt,yt,zt,sc;
{
  int p,s,e,n,ease;

  /* if the keyframes are consecutive or the same, return now */
  if (end-start < 2) return(1);

  if (ei) ease = -1;
  else ease = 0;

  s = start;
  e = start;
  n = NextKey(e,end);

  /* interpolate each animation segment between keyframes */

  do {
    p = s;
    s = e;
    e = n;
    n = NextKey(e,end);

    if (eo && (e == end)) ease = 1;

    /* interp from s to e using p as previous and n as next keyframes */
    if (qr) qsinterp(p,s,e,n,ease,object);
    if (xt) rsinterp(p,s,e,n,ease,object,XTRN);
    if (yt) rsinterp(p,s,e,n,ease,object,YTRN);
    if (zt) rsinterp(p,s,e,n,ease,object,ZTRN);
    if (sc) rsinterp(p,s,e,n,ease,object,SIZE);

    ease = 0;

  } while (e < end);
}

rsinterp(p,s,e,n,ease,obj,channel)
/**************************************************************/
     int p,s,e,n,ease,obj,channel;
{

  double P,S,E,N, GetChan();
  double u2,u3,U1,U2,U3;
  double deltau,u,temp;
  int steps,i;

  /* determine the values stored in the previous, current, and next keys */
  P = GetChan(p, obj, channel);
  S = GetChan(s, obj, channel);
  E = GetChan(e, obj, channel);
  N = GetChan(n, obj, channel);

  /* Draw a Catmull Rom spline curve */
  /* Parts of this code modified from code written by Andrew Hanson */

  steps = e-s;
  if (steps < 2) return(1);

  temp = 0.0;
  deltau = 1.0/steps;

  for (i=1; i<steps; i++) {
    temp+=deltau;
    /* use a sine curve for ease-ins and ease-outs */
    if (ease < 0) u = 1.0 - sin((1.0-temp)*1.5708);
    else if (ease > 0) u = sin(temp*1.5708);
    else u=temp;

    u2=u*u;
    u3=u*u2;
    U3 = (-P + 3*S - 3*E + N);
    U2 = (2*P - 5*S + 4*E - N);
    U1 = (-P + E);

    SetChan(i+s, obj, channel, (0.5*(u3*U3 + u2*U2 + u*U1) + S));
  }
}

qsinterp(p,s,e,n,ease,obj)
/**************************************************************/
     int p,s,e,n,ease,obj;
{
  double deltau, u, temp;
  int i, steps;
  double qp[4];
  double qs[4];
  double qe[4];
  double qn[4];

  double virtual[4];
  double qalpha[4];
  double qbeta[4];
  double A[4], B[4], C[4], D[4], E[4], result[4];

  /* this code is modified from code written by Andrew  */
  /* Hanson and Robert Cross of Indiana University      */

  /* make sure the quaternions are within 180 degrees of each other */
  correct_quat(p, n, obj);

  GetRot(qp, p, obj);
  GetRot(qs, s, obj);
  GetRot(qe, e, obj);
  GetRot(qn, n, obj);
  
  /* calculate alpha */
/*
  qinv(A,qp);
  qmul(A,qe,A);
  qmul(A,A,qs);
  linterp_quaternion(qalpha,qs,A,1.0/6.0);
*/

  /* calculate beta */
/*
  qinv(A,qn);
  qmul(A,qs,A);
  qmul(A,A,qe);
  linterp_quaternion(qbeta,qe,A,1.0/6.0);
*/
    
  steps = e-s;
  if (steps < 2) return(1);

  temp = 0.0;
  deltau = 1.0/steps;

  for (i=1; i<steps; i++) {
      temp+=deltau;
      /* use a sine curve for ease-ins and ease-outs */
      if (ease < 0) u = 1.0 - sin((1.0-temp)*1.5708);
      else if (ease > 0) u = sin(temp*1.5708);
      else u=temp;

/* 
      linterp_quaternion(A,qs,qalpha,u);
      linterp_quaternion(B,qalpha,qbeta,u);
      linterp_quaternion(C,qbeta,qe,u);
      
      linterp_quaternion(D,A,B,u);
      linterp_quaternion(E,B,C,u);
*/
      
      linterp_quaternion(A,qp,qs,u+1.0);
      linterp_quaternion(B,qs,qe,u);
      linterp_quaternion(C,qe,qn,u-1.0);
      linterp_quaternion(D,A,B,(u+1.0)/2.0);
      linterp_quaternion(E,B,C,u/2.0);

      linterp_quaternion(result,D,E,u);

      SetRot(i+s, obj, result);
  }
}


