/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* 
 * KEYFRAME ANIMATOR:
 * perform keyframe animation and interpolation of objects in a network.
 * rotation and interpolation of rotation can be either standard X-Y-Z matrix
 * rotation, or quaternion rotation.
 *
 * created by Brian Kaplan
 *      kaplan@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * thanks to the following for their help:
 *      Gregory Travis, Eric Ost -- general C help.
 *      Andrew Hanson -- help with interpolation code.
 *
 * Copyright (c) 1991 Brian Kaplan, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

#include <stdio.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/udata.h>
#include <math.h>
#include "Keyframe.h"

/**********************
 * AVS SETUP ROUTINES *
 **********************/

AVSinit_modules()
/*****************************************************************************/
/* The function AVSinit_modules is called from the main() routine supplied   */
/* by AVS.  In it, we call AVSmodule_from_desc with the name of our          */
/* description routine.                                                      */
/*****************************************************************************/
{
	int keyframe_desc();

	AVSmodule_from_desc(keyframe_desc);
}

keyframe_desc()
/*****************************************************************************/
/* The description function is used to define the inputs, outputs, and       */
/* parameters to the module, the init, compute, and destroy routines, and    */
/* other module information.                                                 */
/*****************************************************************************/
{
  int keyframe_compute();                 /* the name of the compute routine */
  int keyframe_init();                       /* the name of the init routine */
  int keyframe_destroy();                 /* the name of the destroy routine */
  int inpt, outpt, parm;
  
  /* Set the module  name 	          type */
  AVSset_module_name("Keyframe Animator", MODULE_MAPPER);
  
  /* Create input ports */
  AVScreate_input_port("Frame",    "integer",             OPTIONAL);

  inpt = AVScreate_input_port("Pick Info","struct upstream_geom",
			      OPTIONAL|INVISIBLE);
  AVSset_input_class(inpt,"upstream_geom");

  inpt = AVScreate_input_port("Trans Info","struct upstream_transform",
			      OPTIONAL|INVISIBLE);
  AVSset_input_class(inpt,"upstream_transform");

  /* Create output ports */
  AVScreate_output_port( "Geometry", "geom");
  outpt = AVScreate_output_port("Frameout", "integer");
  AVSset_output_flags(outpt,INVISIBLE);

  /* Add parameters to the module and place them where they belong */
  parm = AVSadd_parameter(">>>","string","EMPTY-1",NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:>>>\" -w typein -xy 10,54");
    AVSadd_parameter_prop(parm,"width","integer",4);
  parm = AVSadd_parameter("object attributes","choice","name",
			  "name|parent|rotation|colortype","|");
    AVSadd_parameter_prop(parm,"columns","integer",2);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:object attributes\" -w radio_buttons -xy 10,76");

  parm = AVSadd_parameter("new obj","oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:new obj\" -w oneshot -xy 10,130");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("del obj", "oneshot", NULL, NULL, NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:del obj\" -w oneshot -xy 69,130");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("pick obj", "boolean", 0, NULL, NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:pick obj\" -w toggle -xy 128,130");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("next obj","oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:next obj\" -w oneshot -xy 187,130");
    AVSadd_parameter_prop(parm,"width","integer",1);

  parm = AVSadd_parameter("XROTon","boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:XROTon\" -w toggle -xy 10,160");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("YROTon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:YROTon\" -w toggle -xy 10,180");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("ZROTon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ZROTon\" -w toggle -xy 10,200");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("XTRNon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:XTRNon\" -w toggle -xy 69,160");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("YTRNon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:YTRNon\" -w toggle -xy 69,180");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("ZTRNon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ZTRNon\" -w toggle -xy 69,200");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("SCLEon", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:SCLEon\" -w toggle -xy 69,220");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("ALLon", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ALLon\" -w oneshot -xy 128,180");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("ALLoff", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ALLoff\" -w oneshot -xy 128,200");
    AVSadd_parameter_prop(parm,"width","integer",2);

  parm = AVSadd_parameter("initialize dials", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:initialize dials\" -w oneshot -xy 10,250");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("update frame", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:update frame\" -w toggle -xy 10,280");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("animation frame","integer",1,1,150);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:animation frame\" -w islider -xy 10,310");
    AVSadd_parameter_prop(parm,"immediate","boolean",1);
  parm = AVSadd_parameter("   <--", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:   <--\" -w oneshot -xy 10,340");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("   -->", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:   -->\" -w oneshot -xy 187,340");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("prev key", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:prev key\" -w oneshot -xy 69,340");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("next key", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:next key\" -w oneshot -xy 128,340");
    AVSadd_parameter_prop(parm,"width","integer",1);

  parm = AVSadd_parameter("animation speed","integer",1,-50,50);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:animation speed\" -w islider -xy 10,370");
    AVSadd_parameter_prop(parm,"immediate","boolean",1);
  parm = AVSadd_parameter("anim start", "integer",1,1,10000);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:anim start\" -w typein_integer -xy 10,410");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("anim end", "integer",NUMFRAMES,1,10000);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:anim end\" -w typein_integer -xy 128,410");
    AVSadd_parameter_prop(parm,"width","integer",1);

  parm = AVSadd_parameter("save keyframe","oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:save keyframe\" -w oneshot -xy 10,440");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("ease in", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ease in\" -w toggle -xy 10,470");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("ease out", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:ease out\" -w toggle -xy 187,470");
    AVSadd_parameter_prop(parm,"width","integer",1);
  parm = AVSadd_parameter("create linear interpolation",
			  "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:create linear interpolation\" -xy 10,490");
    AVSadd_parameter_prop(parm,"width","integer",4);
  parm = AVSadd_parameter("create spline interpolation",
			  "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:create spline interpolation\" -xy 10,510");
    AVSadd_parameter_prop(parm,"width","integer",4);
  parm = AVSadd_parameter("create hold", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:create hold\" -w oneshot -xy 10,530");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("trace object path", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:trace object path\" -w toggle -xy 10,560");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("clear keyframe", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:clear keyframe\" -w oneshot -xy 10,590");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("clear all keyfms", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:clear all keyfms\" -w oneshot -xy 128,590");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("clear frame information","oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:clear frame information\" -w oneshot -xy 10,610");
    AVSadd_parameter_prop(parm,"width","integer",4);

  parm = AVSadd_parameter("anim filename","string","keyframe.anim",NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:anim filename\" -w typein -xy 10,640");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("load anim", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:load anim\" -w oneshot -xy 10,660");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("save anim", "oneshot",NULL,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:save anim\" -w oneshot -xy 128,660");
    AVSadd_parameter_prop(parm,"width","integer",2);

  parm = AVSadd_parameter("sync with driver", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:sync with driver\" -w toggle -xy 10,690");
    AVSadd_parameter_prop(parm,"width","integer",4); 
  parm = AVSadd_parameter("wait for sync", "boolean",0,NULL,NULL);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:wait for sync\" -w toggle -xy 10,710");
    AVSadd_parameter_prop(parm,"width","integer",2);
  parm = AVSadd_parameter("sync frme", "integer",0,0,10000);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:sync frme\" -w typein_integer -xy 128,710");
    AVSadd_parameter_prop(parm,"width","integer",1);

  parm = AVSadd_float_parameter("rot x", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    /* create a page for the Dialbox Manager and move "rot x" into it */
    AVSadd_parameter_prop(parm,"layout","string",
      "panel TransformDials -w panel -p \"Top Level Stack\" -wh 256,560 -P title string \"Transform Dials\"\n panel dialsbox_mgr -w \"Dialsbox Manager\" -p TransformDials -xy 0,60\n manipulator \"$Module:rot x\" -w dialsbox_client -p \"Dial 0\"");
  parm = AVSadd_float_parameter("rot y", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:rot y\" -w dialsbox_client -p \"Dial 1\"");
  parm = AVSadd_float_parameter("rot z", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:rot z\" -w dialsbox_client -p \"Dial 2\"");
  parm = AVSadd_float_parameter("trans x", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:trans x\" -w dialsbox_client -p \"Dial 4\"");
  parm = AVSadd_float_parameter("trans y", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:trans y\" -w dialsbox_client -p \"Dial 5\"");
  parm = AVSadd_float_parameter("trans z", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:trans z\" -w dialsbox_client -p \"Dial 6\"");
  parm = AVSadd_float_parameter("scale", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:scale\" -w dialsbox_client -p \"Dial 3\"");
  parm = AVSadd_parameter("curr frame","integer",1,1,150);
    AVSadd_parameter_prop(parm,"layout","string",
      "manipulator \"$Module:curr frame\" -w idialsbox_client -p \"Dial 7\"");

/* these aren't used (yet)...
  parm = AVSadd_float_parameter("rot speed", 1.0, 0.1, 10.0);
    AVSadd_parameter_prop(parm,"layout","string",
    "manipulator \"$Module:rot speed\" -w typein_real -p page.0 -xy 10,450");
  parm = AVSadd_float_parameter("trans speed", 1.0, 0.1, 10.0);
    AVSadd_parameter_prop(parm,"layout","string",
    "manipulator \"$Module:trans speed\" -w typein_real -p page.0 -xy 10,480");
*/

  /* Tell AVS what subroutine to call to initialize the module */
  AVSset_init_proc(keyframe_init);

  /* Tell AVS what routine to call to do the computation */
  AVSset_compute_proc(keyframe_compute);

  /* Tell AVS what subroutine to call before destroying the module */
  AVSset_destroy_proc(keyframe_destroy);
}

  
/******************************
 * THE MAIN COMPUTE PROCEDURE *
 ******************************/

keyframe_compute(cframe, pickinfo, transinfo, output, frameout, value, attrib,
		 newobj, delobj, pick, nextobj,
		 xron,yron,zron,xton,yton,zton,scon, allon, alloff,
		 init, update, frame, backward, forward,
		 prevkey, nextkey, speed, start, end, save, 
		 easein, easeout, linterp, sinterp,
		 hold, trace, clear, clearall, clearfr,
		 filename, loadsets, savesets, ddisable, waitsync, syncval,
		 rotx, roty, rotz, tx, ty, tz, sc, cf)
/*****************************************************************************/
/* This is the main compute routine.  This is where all the work is done for */
/* the module.                                                               */
/* There is one parameter to for each input, output, and parameter defined.  */
/* These values are passed into the compute routine by AVS.                  */
/*****************************************************************************/
int cframe;
upstream_geom *pickinfo;
upstream_transform *transinfo;
GEOMedit_list *output;
int *frameout;
char *value, *attrib;
int newobj, delobj, pick, nextobj;
int xron, yron, zron, xton, yton, zton, scon, allon, alloff, init;
int update, frame, backward, forward, prevkey, nextkey;
int speed, start, end, save, easein, easeout, linterp, sinterp, hold, trace;
int clear, clearall, clearfr;
char *filename;
int loadsets, savesets, ddisable, waitsync, syncval;
float *rotx, *roty, *rotz, *tx, *ty, *tz, *sc; 
int cf;
{

  /*******************
   * LOCAL VARIABLES *
   *******************/

  /* some temporary variables */
  int i,j,k,l,s,e;                                    /* temporary integers */
  float scale;                                           /* temporary scale */
  float xform[4][4], tmat[4][4];   /* used to calculate the final transform */
  FILE *fd;                           /* file descriptor for load/save file */
  char ver[16];                       /* holds the version number of a file */
  char *mess     ;                      /* return string from an AVSmessage */
  GEOMobj *traceobj;                      /* contains the trace path object */
  float *Traceverts;                        /* holds vertex data for traces */
  
  float temprotx, temproty, temprotz;           /* used so that the current */
  float temptx, tempty, temptz;                /* values won't be destroyed */
  float tempsc;                              /* when updating objects other */
  float tempQ[4];                                   /* than the current one */
  int tempquatrot;
  char tempstring[256];

  static float oldrotx = 0.;               /* used with quaternion rotation */
  static float oldroty = 0.;              /* to determine relative rotation */
  static float oldrotz = 0.;          /* values based on absolute rotations */
  static float changex = 0.;
  static float changey = 0.;
  static float changez = 0.;
  static float Q[4] = {1.,0.,0.,0.};              /* the current Quaternion */
  static int OBJ = 0;                   /* the current object number less 1 */
  
  /* object attributes that can be converted to ints */
  static int quatrot = 1;        /* 1 if rotations = quaternion, 0 = matrix */
  static int coltype = 0;                               /* 0 = RGB, 1 = HSV */

  static int setup = 1;
  static int moved = 0;

  int mxval, myval;
  static int oldmxval = 0;
  static int oldmyval = 0;


  /* initialize the edit list output */
  *output = GEOMinit_edit_list(*output);

  /**********************************************
   * CHECK FOR CHANGES IN PARAMETERS AND INPUTS *
   **********************************************/

  /* incriment current frame after sync frame is reached */
  if (AVSinput_changed("Frame",0)) {
    /* if we are not currently in sync check to see if we should be */
    if (waitsync && syncval) {
      if (cframe == syncval) {
	waitsync = 0;
	AVSmodify_parameter("wait for sync",AVS_VALUE,0,NULL,NULL);
      }
    }
    /* if we are in sync, incriment the current frame */
    if (waitsync) AVSmark_output_unchanged("Frameout");
    else {
      frame+=speed;
      if (frame > end) frame = start;
      else if (frame < start) frame = end;
      AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
      cf = frame;
      AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
    }
  }

  else if (AVSinput_changed("Trans Info",0)) {
    if (setup) {
      GEOMedit_transform_mode(*output,"%top","redirect",
			      BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
      GEOMedit_selection_mode(*output,"%top","ignore",
			      BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);

      for (i=0; i<Totobjs; i++) {
	if (strncmp(Objlist[i].name,"EMPTY",5)) {
	  GEOMedit_transform_mode(*output,Objlist[i].name,"notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				  BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
	}
      }
      setup = 0;
      return(1);
    }

    /* return 0 now if the transformations should be disabled */
    if (ddisable) return(0);

    /* mouse position in pixels */
    mxval = transinfo->x;
    myval = transinfo->y;

    if (transinfo->flags == BUTTON_UP) {
      if (!moved) {
	if (pick) {
	  GEOMedit_selection_mode(*output,"%top","ignore",
				  BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
	  for (i=0; i<Totobjs; i++) {
	    if (strncmp(Objlist[i].name,"EMPTY",5)) 
	      GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				      BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  }

	  pick = 0;
	  AVSmodify_parameter("pick obj",AVS_VALUE,0,NULL,NULL);
	}
	else {
	  /* the mouse hasn't moved since the button was pressed down */
	  GEOMedit_selection_mode(*output,"%top","notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  for (i=0; i<Totobjs; i++) {
	    if (strncmp(Objlist[i].name,"EMPTY",5)) 
	      GEOMedit_selection_mode(*output,Objlist[i].name,"notify",
				      BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  }
	  pick = 1;
	  AVSmodify_parameter("pick obj",AVS_VALUE,1,NULL,NULL);
	}
	return(1);
      }

      return(0);
    }
    else if (transinfo->flags == BUTTON_DOWN) {
      oldmxval = mxval;
      oldmyval = myval;
      moved = 0;
      return(0);
    }
    else if (transinfo->flags == BUTTON_MOVING) moved = 1;

    i = transinfo->width;
    j = transinfo->height;


    if (button3pressed()) {
      if (shiftpressed()) {
	k = oldmxval-mxval;
	l = oldmyval-myval;
	*tz -= ((fabs((double)k) > fabs((double)l)) ? k : -l);
	AVSmodify_float_parameter("trans z",AVS_VALUE,*tz,NULL,NULL);

	AVSmodify_parameter("ZTRNon",AVS_VALUE,1,NULL,NULL);
	zton = 1;
      }
      else {
	*tx -= (oldmxval - mxval) * 2.0;
	AVSmodify_float_parameter("trans x",AVS_VALUE,*tx,NULL,NULL);
	*ty += (oldmyval - myval) * 2.0;
	AVSmodify_float_parameter("trans y",AVS_VALUE,*ty,NULL,NULL);

	AVSmodify_parameter("XTRNon",AVS_VALUE,1,NULL,NULL);
	xton = 1;
	AVSmodify_parameter("YTRNon",AVS_VALUE,1,NULL,NULL);
	yton = 1;
      }

      AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
      update = 0;
    }

    else if (button2pressed()) {
      if (shiftpressed()) {
	k = oldmxval-mxval;
	l = oldmyval-myval;
	*sc -= ((fabs((double)k) > fabs((double)l)) ? k : -l);
	AVSmodify_float_parameter("scale",AVS_VALUE,*sc,NULL,NULL);

	AVSmodify_parameter("SCLEon",AVS_VALUE,1,NULL,NULL);
	scon = 1;
      }
      else {
	*rotx += ((oldmyval - myval)/(float)i) * 180.0;
	AVSmodify_float_parameter("rot x",AVS_VALUE,*rotx,NULL,NULL);
	*roty += ((oldmxval - mxval)/(float)j) * 180.0;
	AVSmodify_float_parameter("rot y",AVS_VALUE,*roty,NULL,NULL);
	
	AVSmodify_parameter("XROTon",AVS_VALUE,1,NULL,NULL);
	xron = 1;
	AVSmodify_parameter("YROTon",AVS_VALUE,1,NULL,NULL);
	yron = 1;
	if (quatrot) {
	  AVSmodify_parameter("ZROTon",AVS_VALUE,1,NULL,NULL);
	  zron = 1;
	}
      }

      AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
      update = 0;
    }

    oldmxval = mxval;
    oldmyval = myval;

  }

  else if (AVSinput_changed("Pick Info",0)) { 
    /* make sure that objects are pickable, but unable to be manipulated */
    /* with the mouse.  Also, this supresses a message from the initial */
    /* connection of the upstream_geom input port. */

    if (setup) {
      GEOMedit_transform_mode(*output,"%top","redirect",
			      BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
      GEOMedit_selection_mode(*output,"%top","ignore",
			      BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);

      for (i=0; i<Totobjs; i++) {
	if (strncmp(Objlist[i].name,"EMPTY",5)) {
	  GEOMedit_transform_mode(*output,Objlist[i].name,"notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				  BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
	}
      }
      setup = 0;
      return(1);
    }

    if (!pick) return(0);

    GEOMedit_selection_mode(*output,"%top","ignore",
			    BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
    for (i=0; i<Totobjs; i++) {
      if (strncmp(Objlist[i].name,"EMPTY",5)) 
	GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
    }

    pick = 0;
    AVSmodify_parameter("pick obj",AVS_VALUE,0,NULL,NULL);

    /* find out the name of the object picked */
    if (strlen(pickinfo->picked_obj) < 1) 
      sprintf(tempstring,"%s%d","%camera",pickinfo->camera_index);
    else
      sprintf(tempstring,"%%%s",pickinfo->picked_obj);

    /* see if that object already exists in the database */
    for (i=0; i<Totobjs; i++) {
      if (!strcmp(Objlist[i].name,tempstring)) {

	/* the object exists -- make it the current object */
	OBJ = i;

	AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
	AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
	if (!strcmp(Objlist[OBJ].rotation,"quaternion")) quatrot = 1;
	else quatrot = 0;
	if (!strcmp(Objlist[OBJ].colortype,"RGB")) coltype = 0;
	else coltype = 1;

	/* reset the dials */
	changex = 0.0;
	changey = 0.0;
	changez = 0.0;
	oldrotx = 0.0;
	oldroty = 0.0;
	oldrotz = 0.0;
	Quat_init(Q);

	*rotx = 0.0;
	AVSmodify_float_parameter("rot x",AVS_VALUE,0.0,NULL,NULL);
	*roty = 0.0;
	AVSmodify_float_parameter("rot y",AVS_VALUE,0.0,NULL,NULL);
	*rotz = 0.0;
	AVSmodify_float_parameter("rot z",AVS_VALUE,0.0,NULL,NULL);
	*tx = 0.0;
	AVSmodify_float_parameter("trans x",AVS_VALUE,0.0,NULL,NULL);
	*ty = 0.0;
	AVSmodify_float_parameter("trans y",AVS_VALUE,0.0,NULL,NULL);
	*tz = 0.0;
	AVSmodify_float_parameter("trans z",AVS_VALUE,0.0,NULL,NULL);
	*sc = 0.0;
	AVSmodify_float_parameter("scale",AVS_VALUE,0.0,NULL,NULL);

	/* turn off all active dials */
	xron = 0;
	AVSmodify_parameter("XROTon",AVS_VALUE,0,NULL,NULL);
	yron = 0;
	AVSmodify_parameter("YROTon",AVS_VALUE,0,NULL,NULL);
	zron = 0;
	AVSmodify_parameter("ZROTon",AVS_VALUE,0,NULL,NULL);
	xton = 0;
	AVSmodify_parameter("XTRNon",AVS_VALUE,0,NULL,NULL);
	yton = 0;
	AVSmodify_parameter("YTRNon",AVS_VALUE,0,NULL,NULL);
	zton = 0;
	AVSmodify_parameter("ZTRNon",AVS_VALUE,0,NULL,NULL);
	scon = 0;
	AVSmodify_parameter("SCLEon",AVS_VALUE,0,NULL,NULL);

	update = 1;
	AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);

	break;
      }
    }

    if (i == Totobjs) {
      /* if it doesn't exist, ask to add it to the database, */
      /* or replace the current object with it */
      mess = AVSmessage(VERSION,AVS_Warning,NULL,"PICK OBJ",
	"ADD OBJ!REPLACE OBJ!ABORT",
	"The object %%%s is not currently being animated.\n%s%s%s",
	tempstring,
	"Press ADD OBJ to add the object.\n",
        "Press REPLACE OBJ to replace the current object with that object.\n",
        "Press ABORT to do nothing.\n");
      if (!strcmp(mess,"ABORT")) return(1);
      else if (!strcmp(mess,"REPLACE OBJ")) {
	/* replace the current object with the new one */

	/* reset the old object */
	if (strncmp(Objlist[OBJ].name,"EMPTY",5)) {
	  GEOMedit_transform_mode(*output,Objlist[OBJ].name,"normal",
				  BUTTON_UP|BUTTON_MOVING);
	  GEOMedit_selection_mode(*output,Objlist[OBJ].name,"normal",
				  BUTTON_DOWN);
	}

	strncpy(Objlist[OBJ].name,tempstring,MAXNAMELENGTH-4);

	/* fix the new object for manipulation with the mouse */
	if (strncmp(tempstring,"EMPTY",5)) {
	  GEOMedit_transform_mode(*output,tempstring,"notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  GEOMedit_selection_mode(*output,tempstring,"ignore",
				  BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
	}

	AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
	AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
      }
      else {
	/* add the new object to the database */
	if (Anim_addobjects(1) < 0) {
	  AVSfatal("\n\nUnable to allocate memory for object information!\n");
	  return(0);
	}
	OBJ = Totobjs-1;
	strncpy(Objlist[OBJ].name,tempstring,MAXNAMELENGTH-4);
	AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
	AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
	quatrot = 1;
	coltype = 0;

	/* fix the new object for manipulation with the mouse */
	if (strncmp(tempstring,"EMPTY",5)) {
	  GEOMedit_transform_mode(*output,tempstring,"notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	  GEOMedit_selection_mode(*output,tempstring,"ignore",
				  BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
	}
      }
    }
  }

  /* disable the dials and turn on update */
  else if (AVSparameter_changed("sync with driver")) {
    if (ddisable) {
      update = 1;
      AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
    }
    return(0);
  }

  /* make sure end is not less than start and that the animation window */
  /* reflects the start and end */
  else if (AVSparameter_changed("anim start")) {
    if (start > end) {
      end = start;
      AVSmodify_parameter("anim end",AVS_VALUE,start,NULL,NULL);
    }
    AVSmodify_parameter("anim end",AVS_MINVAL,NULL,start,NULL);
    AVSmodify_parameter("animation frame",AVS_MINVAL|AVS_MAXVAL,
			NULL,start,end);
    AVSmodify_parameter("curr frame",AVS_MINVAL|AVS_MAXVAL,
			NULL,start,end);
    if (start > frame) {
      frame = start;
      AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
      cf = frame;
      AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
    }

    /* allocate more memory for frame arrays if needed */
    if (end > Totframes) if (Anim_addframes(end-Totframes) < 0) {
      AVSfatal("\n\nUnable to allocate memory for frame information!\n");
      return(0);
    }
  }
  else if (AVSparameter_changed("anim end")) {
    if (start > end) {
      end = start;
      AVSmodify_parameter("anim end",AVS_VALUE,start,NULL,NULL);
    }
    AVSmodify_parameter("animation frame",AVS_MAXVAL,NULL,NULL,end);
    AVSmodify_parameter("curr frame",AVS_MAXVAL,NULL,NULL,end);
    if (end < frame) {
      frame = end;
      AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
      cf = frame;
      AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
    }

    /* allocate more memory for frame arrays if needed */
    if (end > Totframes) if (Anim_addframes(end-Totframes) < 0) {
      AVSfatal("\n\nUnable to allocate memory for frame information!\n");
      return(0);
    }
  }

  /* change the current attribute */
  else if (AVSparameter_changed("object attributes")) {
    if (!strcmp(attrib,"name")) 
      AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,
			  NULL,NULL);
    else if (!strcmp(attrib,"parent")) 
      AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].parent,
			  NULL,NULL);
    else if (!strcmp(attrib,"rotation"))
      AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].rotation,
			  NULL,NULL);
    else if (!strcmp(attrib,"colortype"))
      AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].colortype,
			  NULL,NULL);
    return(0);
  }    
  /* change the value of the current attribute */
  else if (AVSparameter_changed(">>>")) {
    if (!strcmp(attrib,"name")) {
      /* reset the old object */
      if (strncmp(Objlist[OBJ].name,"EMPTY",5)) {
	GEOMedit_transform_mode(*output,Objlist[OBJ].name,"normal",
				BUTTON_UP|BUTTON_MOVING);
	GEOMedit_selection_mode(*output,Objlist[OBJ].name,"normal",
				BUTTON_DOWN);
      }

      strncpy(Objlist[OBJ].name,value,MAXNAMELENGTH-4);

      /* fix the new object for manipulation with the mouse */
      if (strncmp(value,"EMPTY",5)) {
	GEOMedit_transform_mode(*output,value,"notify",
				BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	GEOMedit_selection_mode(*output,value,"ignore",
				BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
      }
    }
    else if (!strcmp(attrib,"parent")) {
      strncpy(Objlist[OBJ].parent,value,MAXNAMELENGTH-4);

      GEOMedit_parent(*output,Objlist[OBJ].name,Objlist[OBJ].parent);
      return(1);
    }

    else if (!strcmp(attrib,"rotation")) {
      if (!strncmp(value,"M",1) ||
	  !strncmp(value,"m",1)) {
	strcpy(Objlist[OBJ].rotation,"matrix");
	AVSmodify_parameter(">>>",AVS_VALUE,"matrix",NULL,NULL);
	quatrot = 0;

	*rotx = Anim[frame-1][OBJ][XROT];
	AVSmodify_float_parameter("rot x",AVS_VALUE,*rotx,NULL,NULL);
	*roty = Anim[frame-1][OBJ][YROT];
	AVSmodify_float_parameter("rot y",AVS_VALUE,*roty,NULL,NULL);
	*rotz = Anim[frame-1][OBJ][ZROT];
	AVSmodify_float_parameter("rot z",AVS_VALUE,*rotz,NULL,NULL);
      }
      else {
	strcpy(Objlist[OBJ].rotation,"quaternion");
	AVSmodify_parameter(">>>",AVS_VALUE,"quaternion",NULL,NULL);
	quatrot = 1;

	Q[0] = Anim[frame-1][OBJ][QTRC];
	Q[1] = Anim[frame-1][OBJ][QTRX];
	Q[2] = Anim[frame-1][OBJ][QTRY];
	Q[3] = Anim[frame-1][OBJ][QTRZ];
	*rotx = 0.0;
	AVSmodify_float_parameter("rot x",AVS_VALUE,0.0,NULL,NULL);
	*roty = 0.0;
	AVSmodify_float_parameter("rot y",AVS_VALUE,0.0,NULL,NULL);
	*rotz = 0.0;
	AVSmodify_float_parameter("rot z",AVS_VALUE,0.0,NULL,NULL);
	oldrotx = 0.0;
	oldroty = 0.0;
	oldrotz = 0.0;
      }

      /* turn off the rotation buttons */
      xron = 0;
      AVSmodify_parameter("XROTon",AVS_VALUE,0,NULL,NULL);
      yron = 0;
      AVSmodify_parameter("YROTon",AVS_VALUE,0,NULL,NULL);
      zron = 0;
      AVSmodify_parameter("ZROTon",AVS_VALUE,0,NULL,NULL);
    }
    else if (!strcmp(attrib,"colortype")) {
      if (!strncmp(value,"H",1) ||
	  !strncmp(value,"h",1)) {
	strcpy(Objlist[OBJ].colortype,"HSV");
	AVSmodify_parameter(">>>",AVS_VALUE,"HSV",NULL,NULL);
	coltype = 1;
      }
      else {
	strcpy(Objlist[OBJ].colortype,"RGB");
	AVSmodify_parameter(">>>",AVS_VALUE,"RGB",NULL,NULL);
	coltype = 0;
      }
      return(1);
    }
  }

  else if (AVSparameter_changed("pick obj")) {
    if (pick) {
      /* the mouse hasn't moved since the button was pressed down */
      GEOMedit_selection_mode(*output,"%top","notify",
			      BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
      for (i=0; i<Totobjs; i++) {
	if (strncmp(Objlist[i].name,"EMPTY",5)) 
	  GEOMedit_selection_mode(*output,Objlist[i].name,"notify",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
      }
    }
    else {
      GEOMedit_selection_mode(*output,"%top","ignore",
			      BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
      for (i=0; i<Totobjs; i++) {
	if (strncmp(Objlist[i].name,"EMPTY",5)) 
	  GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				  BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
      }
    }

    return(1);
  }

  /* add a new object and allocate more memory for it */
  else if (AVSparameter_changed("new obj")) {
    if (Anim_addobjects(1) < 0) {
      AVSfatal("\n\nUnable to allocate memory for object information!\n");
      return(0);
    }
    OBJ = Totobjs-1;
    AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
    AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
    quatrot = 1;
    coltype = 0;
    return(0);
  }
  /* change the current object to an empty object */
  else if (AVSparameter_changed("del obj")) {
    /* reset the old object */
    if (strncmp(Objlist[OBJ].name,"EMPTY",5)) {
      GEOMedit_transform_mode(*output,Objlist[OBJ].name,"normal",
			      BUTTON_UP|BUTTON_MOVING);
      GEOMedit_selection_mode(*output,Objlist[OBJ].name,"normal",
			      BUTTON_DOWN);
    }

    /* set the names for the objects */
    sprintf(Objlist[OBJ].name,"%s-%d","EMPTY",OBJ+1);

    /* set the objects parents */
    strcpy(Objlist[OBJ].parent,"%top");

    /* set the default quaternion rotations for the objects */
    strcpy(Objlist[OBJ].rotation,"quaternion");

    /* set the default color type for the objects */
    strcpy(Objlist[OBJ].colortype,"RGB");

    AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
    AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
    quatrot = 1;
    coltype = 0;
    return(1);
  }
  /* go to the next object */
  else if (AVSparameter_changed("next obj")) {
    OBJ++;
    if (OBJ >= Totobjs) OBJ = 0;

    AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
    AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
    if (!strcmp(Objlist[OBJ].rotation,"quaternion")) quatrot = 1;
    else quatrot = 0;
    if (!strcmp(Objlist[OBJ].colortype,"RGB")) coltype = 0;
    else coltype = 1;

    /* reset the dials */
    changex = 0.0;
    changey = 0.0;
    changez = 0.0;
    oldrotx = 0.0;
    oldroty = 0.0;
    oldrotz = 0.0;
    Quat_init(Q);

    *rotx = 0.0;
    AVSmodify_float_parameter("rot x",AVS_VALUE,0.0,NULL,NULL);
    *roty = 0.0;
    AVSmodify_float_parameter("rot y",AVS_VALUE,0.0,NULL,NULL);
    *rotz = 0.0;
    AVSmodify_float_parameter("rot z",AVS_VALUE,0.0,NULL,NULL);
    *tx = 0.0;
    AVSmodify_float_parameter("trans x",AVS_VALUE,0.0,NULL,NULL);
    *ty = 0.0;
    AVSmodify_float_parameter("trans y",AVS_VALUE,0.0,NULL,NULL);
    *tz = 0.0;
    AVSmodify_float_parameter("trans z",AVS_VALUE,0.0,NULL,NULL);
    *sc = 0.0;
    AVSmodify_float_parameter("scale",AVS_VALUE,0.0,NULL,NULL);

    /* turn off all active dials */
    xron = 0;
    AVSmodify_parameter("XROTon",AVS_VALUE,0,NULL,NULL);
    yron = 0;
    AVSmodify_parameter("YROTon",AVS_VALUE,0,NULL,NULL);
    zron = 0;
    AVSmodify_parameter("ZROTon",AVS_VALUE,0,NULL,NULL);
    xton = 0;
    AVSmodify_parameter("XTRNon",AVS_VALUE,0,NULL,NULL);
    yton = 0;
    AVSmodify_parameter("YTRNon",AVS_VALUE,0,NULL,NULL);
    zton = 0;
    AVSmodify_parameter("ZTRNon",AVS_VALUE,0,NULL,NULL);
    scon = 0;
    AVSmodify_parameter("SCLEon",AVS_VALUE,0,NULL,NULL);

    update = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
  }
  
  /* step backward or forward to the next keyframe */
  else if (AVSparameter_changed("prev key")) {
    if (frame > start) frame = PrevKey(start,frame);
    else frame = end;
    AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
  }
  else if (AVSparameter_changed("next key")) {
    if (frame < end) frame = NextKey(frame,end);
    else frame = start;
    AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
  }
  /* step forward of backward some frames */
  else if (AVSparameter_changed("   -->")) {
    frame+=speed;
    if (frame > end) frame = start;
    AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
  }
  else if (AVSparameter_changed("   <--")) {
    frame-=speed;
    if (frame < start) frame = end;
    AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
  }
  
  /* save current objects, keyframes, and frame information */
  else if (AVSparameter_changed("save anim")) {
    if (filename == NULL) return(0);

    /* see if the animation window is smaller than the animation */
    s = start;
    e = end;
    if ((end < Totframes) || (start > 1)) {
      mess = AVSmessage(VERSION,AVS_Warning,NULL,"SAVE ANIM",
	"SAVE!SAVEALL!ABORT",
	"Press SAVE to save ONLY frames %d to %d!\n\n%s (%d frames).\n\n%s\n",
			start,end,
			"Press SAVEALL to save ALL frames of the animation",
			Totframes,
			"Press ABORT to abort save.");
      if (!strcmp(mess,"ABORT")) return(0);
      if (!strcmp(mess,"SAVEALL")) {
	s = 1;
	e = Totframes;
      }
    }
    /* see if there are any EMPTY objects */
    k = 1;
    j = 0;
    for(i=0; i<Totobjs; i++) if (!strncmp(Objlist[i].name,"EMPTY",5)) j++;
    if ((j > 0) && (j < Totobjs)) {
      mess = AVSmessage(VERSION,AVS_Warning,NULL,"SAVE ANIM",
	      "SAVE!SAVEALL!ABORT",
	      "Press SAVE to save ONLY the %d %s!\n\n%s (%d objects).\n\n%s\n",
			Totobjs-j,
			"object(s) that are NOT \"EMPTY\"",
			"Press SAVEALL to save ALL objects in the animation",
			Totobjs,
			"Press ABORT to abort save.");
      if (!strcmp(mess,"ABORT")) return(0);
      if (!strcmp(mess,"SAVE")) k = 0;
    }
    /* see if the file already exists */
    if ((fd = fopen(filename,"r")) != NULL) {
      fclose(fd);
      mess = AVSmessage(VERSION,AVS_Warning,NULL,"SAVE ANIM","REPLACE!ABORT",
			 "%s %s %s\n\n%s\n\n%s\n",
			 "The file",
			 filename,
			 "already exists!",
			 "Press REPLACE to replace it.",
			 "Press ABORT to abort save.");
      if (!strcmp(mess,"ABORT")) return(0);
    }

    /* start writing the file */
    if ((fd = fopen(filename,"w")) == NULL) return(0);
    if (k) l = Totobjs;
    else l = Totobjs-j;
    fprintf(stderr,
          "ANIM:  Writing animation file %s (frames %d-%d, %d object(s))...\n",
	  filename,s,e,l);

    /* write version, total frames, and total objects */
    fprintf(fd,"%s\n",VERSION);
    fprintf(fd,"%d %d\n",e-s+1,l);
    /* write object table */
    l = 0;
    for(i=0; i<Totobjs; i++) {
      if (k || strncmp(Objlist[i].name,"EMPTY",5)) {
	l++;
	fprintf(fd,"obj%02d: %s %s %s %s\n",
		l,Objlist[i].name,Objlist[i].parent,Objlist[i].rotation,
		Objlist[i].colortype);
      }
    }

    /* write out each frame of the animation */
    for(i=s-1; i<e; i++) {
      fprintf(fd,"frame%05d: %d\n",i-s+2,Framelist[i].keyframe);
      l = 0;
      for (j=0; j<Totobjs; j++) {
	if (k || strncmp(Objlist[j].name,"EMPTY",5)) {
	  l++;
	  fprintf(fd,"     obj%02d: %f\n",l,Anim[i][j][SIZE]);
	  fprintf(fd,"            %f %f %f\n",
		  Anim[i][j][XROT],Anim[i][j][YROT],Anim[i][j][ZROT]);
	  fprintf(fd,"            %f %f %f %f\n",Anim[i][j][QTRC],
		  Anim[i][j][QTRX],Anim[i][j][QTRY],Anim[i][j][QTRZ]);
	  fprintf(fd,"            %f %f %f\n",
		  Anim[i][j][XTRN],Anim[i][j][YTRN],Anim[i][j][ZTRN]);
	}
      }
    }
    fclose(fd);

    return(0);
  }
  /* load current objects, keyframes, and frame information */
  else if (AVSparameter_changed("load anim")) {
    if (filename == NULL) return(0);

    s = 0;
    e = 0;
    mess = AVSmessage(VERSION,AVS_Warning,NULL,"LOAD ANIM",
		      "LOAD!MERGE!APPEND!ABORT",
		      "%s\n%s %s.\n\n%s\n\n%s\n",
		      "Loading animation will destroy frame information",
		      "currently in memory!  Press LOAD to load",
		      filename,
		      "Press MERGE to merge, APPEND to append animations.",
		      "Press ABORT to abort load.");
    if (!strcmp(mess,"ABORT")) return(0);
    else if (!strcmp(mess,"MERGE")) e = Totobjs;
    else if (!strcmp(mess,"APPEND")) s = Totframes;

    if ((fd = fopen(filename,"r")) == NULL) return(0);

    fscanf(fd,"%s",ver);
    if (strcmp(ver,VERSION)) {
      mess = AVSmessage(VERSION,AVS_Warning,NULL,"LOAD ANIM",
	"ABORT!LOAD",
	"\n%s (%s)\n%s (%s)!\n\n%s\n",
	"The version number of the saved animation",
	ver,
	"does not match this version of the Keyframe Animator module",
        VERSION,
	"Press ABORT to abort load, LOAD to attempt load anyway.");
      if (!strcmp(mess,"ABORT")) {
	fclose(fd);
	return(0);
      }
    }
    
    /* reset all objects */
    for (i=0; i<Totobjs; i++) {
      if (strncmp(Objlist[i].name,"EMPTY",5)) {
	GEOMedit_transform_mode(*output,Objlist[i].name,"normal",
				BUTTON_UP|BUTTON_MOVING);
	GEOMedit_selection_mode(*output,Objlist[i].name,"normal",
				BUTTON_DOWN);
      }
    }

    fscanf(fd,"%d %d",&end,&OBJ);
    fprintf(stderr,
	    "ANIM:  Reading animation file %s (%d frames, %d object(s))...\n",
	    filename,end,OBJ);

    end += s;
    /* add more frames if need be */
    if (end>Totframes) if (Anim_addframes(end-Totframes) < 0) {
      AVSfatal("\n\nUnable to allocate memory for frame information!\n");
      return(0);
    }

    OBJ += e;
    /* add more objects if need be */
    if (OBJ>Totobjs) if (Anim_addobjects(OBJ-Totobjs) < 0) {
      AVSfatal("\n\nUnable to allocate memory for object information!\n");
      return(0);
    }

    /* read object table */
    for(i=e; i<OBJ; i++) fscanf(fd,"%*s %s %s %s %s",
				Objlist[i].name,Objlist[i].parent,
				Objlist[i].rotation,Objlist[i].colortype);
    /* read frame information */
    for(i=s; i<end; i++) {
      fscanf(fd,"%*s %d",&Framelist[i].keyframe);
      for (j=e; j<OBJ; j++) {
	fscanf(fd,"%*s %f",&Anim[i][j][SIZE]);
	fscanf(fd,"%f %f %f",
	       &Anim[i][j][XROT],&Anim[i][j][YROT],&Anim[i][j][ZROT]);
	fscanf(fd,"%f %f %f %f",&Anim[i][j][QTRC],
	       &Anim[i][j][QTRX],&Anim[i][j][QTRY],&Anim[i][j][QTRZ]);
	fscanf(fd,"%f %f %f",
	       &Anim[i][j][XTRN],&Anim[i][j][YTRN],&Anim[i][j][ZTRN]);
      }
    }
    fclose(fd);

    /* initialize certain parameters */
    OBJ = 0;
    start = 1;
    AVSmodify_parameter("anim start",AVS_VALUE,start,NULL,NULL);
    frame = 1;
    AVSmodify_parameter("animation frame",AVS_VALUE|AVS_MINVAL|AVS_MAXVAL,
			frame,start,end);
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE|AVS_MINVAL|AVS_MAXVAL,
			cf,start,end);
    AVSmodify_parameter("anim end",AVS_VALUE,end,NULL,NULL);

    AVSmodify_parameter("object attributes",AVS_VALUE,"name",NULL,NULL);
    AVSmodify_parameter(">>>",AVS_VALUE,Objlist[OBJ].name,NULL,NULL);
    if (!strcmp(Objlist[OBJ].rotation,"quaternion")) quatrot = 1;
    else quatrot = 0;
    if (!strcmp(Objlist[OBJ].colortype,"RGB")) coltype = 0;
    else coltype = 1;

    update = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
    oldrotx = 0.0;
    oldroty = 0.0;
    oldrotz = 0.0;
    changex = 0.0;
    changey = 0.0;
    changez = 0.0;
    Quat_init(Q);

    /* set up all objects for manipulation with the mouse */
    for (i=0; i<Totobjs; i++) {
      if (strncmp(Objlist[i].name,"EMPTY",5)) {
	GEOMedit_transform_mode(*output,Objlist[i].name,"notify",
				BUTTON_DOWN|BUTTON_UP|BUTTON_MOVING);
	GEOMedit_selection_mode(*output,Objlist[i].name,"ignore",
				BUTTON_UP|BUTTON_DOWN|BUTTON_MOVING);
      }
    }

    /* reset rotations */
    *rotx = 0.0;
    AVSmodify_float_parameter("rot x",AVS_VALUE,0.0,NULL,NULL);
    *roty = 0.0;
    AVSmodify_float_parameter("rot y",AVS_VALUE,0.0,NULL,NULL);
    *rotz = 0.0;
    AVSmodify_float_parameter("rot z",AVS_VALUE,0.0,NULL,NULL);
    *tx = 0.0;
    AVSmodify_float_parameter("trans x",AVS_VALUE,0.0,NULL,NULL);
    *ty = 0.0;
    AVSmodify_float_parameter("trans y",AVS_VALUE,0.0,NULL,NULL);
    *tz = 0.0;
    AVSmodify_float_parameter("trans z",AVS_VALUE,0.0,NULL,NULL);
    *sc = 0.0;
    AVSmodify_float_parameter("scale",AVS_VALUE,0.0,NULL,NULL);

    /* turn off all active dials */
    xron = 0;
    AVSmodify_parameter("XROTon",AVS_VALUE,0,NULL,NULL);
    yron = 0;
    AVSmodify_parameter("YROTon",AVS_VALUE,0,NULL,NULL);
    zron = 0;
    AVSmodify_parameter("ZROTon",AVS_VALUE,0,NULL,NULL);
    xton = 0;
    AVSmodify_parameter("XTRNon",AVS_VALUE,0,NULL,NULL);
    yton = 0;
    AVSmodify_parameter("YTRNon",AVS_VALUE,0,NULL,NULL);
    zton = 0;
    AVSmodify_parameter("ZTRNon",AVS_VALUE,0,NULL,NULL);
    scon = 0;
    AVSmodify_parameter("SCLEon",AVS_VALUE,0,NULL,NULL);
  }

  /* make sure that the active button comes on when its dial is moved */
  else if (AVSparameter_changed("rot x")) {
    if (ddisable) {
      if (quatrot) {
	*rotx = oldrotx;
	AVSmodify_float_parameter("rot x",AVS_VALUE,*rotx,NULL,NULL);
      }
      return(0);
    }
    AVSmodify_parameter("XROTon",AVS_VALUE,1,NULL,NULL);
    xron = 1;
    if (quatrot) {
      AVSmodify_parameter("YROTon",AVS_VALUE,1,NULL,NULL);
      yron = 1;
      AVSmodify_parameter("ZROTon",AVS_VALUE,1,NULL,NULL);
      zron = 1;
    }
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("rot y")) {
    if (ddisable) {
      if (quatrot) {
	*roty = oldroty;
	AVSmodify_float_parameter("rot y",AVS_VALUE,*roty,NULL,NULL);
      }
      return(0);
    }
    AVSmodify_parameter("YROTon",AVS_VALUE,1,NULL,NULL);
    yron = 1;
    if (quatrot) {
      AVSmodify_parameter("XROTon",AVS_VALUE,1,NULL,NULL);
      xron = 1;
      AVSmodify_parameter("ZROTon",AVS_VALUE,1,NULL,NULL);
      zron = 1;
    }
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("rot z")) {
    if (ddisable) {
      if (quatrot) {
	*rotz = oldrotz;
	AVSmodify_float_parameter("rot z",AVS_VALUE,*rotz,NULL,NULL);
      }
      return(0);
    }
    AVSmodify_parameter("ZROTon",AVS_VALUE,1,NULL,NULL);
    zron = 1;
    if (quatrot) {
      AVSmodify_parameter("XROTon",AVS_VALUE,1,NULL,NULL);
      xron = 1;
      AVSmodify_parameter("YROTon",AVS_VALUE,1,NULL,NULL);
      yron = 1;
    }
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("trans x")) {
    if (ddisable) return(0);
    AVSmodify_parameter("XTRNon",AVS_VALUE,1,NULL,NULL);
    xton = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("trans y")) {
    if (ddisable) return(0);
    AVSmodify_parameter("YTRNon",AVS_VALUE,1,NULL,NULL);
    yton = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("trans z")) {
    if (ddisable) return(0);
    AVSmodify_parameter("ZTRNon",AVS_VALUE,1,NULL,NULL);
    zton = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }
  else if (AVSparameter_changed("scale")) {
    if (ddisable) return(0);
    AVSmodify_parameter("SCLEon",AVS_VALUE,1,NULL,NULL);
    scon = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,0,NULL,NULL);
    update = 0;
  }

  /* turn all active buttons on or off */
  else if (AVSparameter_changed("ALLon")) {
    AVSmodify_parameter("XROTon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("YROTon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("ZROTon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("XTRNon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("YTRNon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("ZTRNon",AVS_VALUE,1,NULL,NULL);
    AVSmodify_parameter("SCLEon",AVS_VALUE,1,NULL,NULL);
    xron = 1;
    yron = 1;
    zron = 1;
    xton = 1;
    yton = 1;
    zton = 1;
    scon = 1;
    return(0);
  }
  else if (AVSparameter_changed("ALLoff")) {
    AVSmodify_parameter("XROTon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("YROTon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("ZROTon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("XTRNon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("YTRNon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("ZTRNon",AVS_VALUE,0,NULL,NULL);
    AVSmodify_parameter("SCLEon",AVS_VALUE,0,NULL,NULL);
    xron = 0;
    yron = 0;
    zron = 0;
    xton = 0;
    yton = 0;
    zton = 0;
    scon = 0;
    return(0);
  }
  
  /* make sure that the current frame and animation frame are the same */
  else if (AVSparameter_changed("curr frame")) {
    frame = cf;
    AVSmodify_parameter("animation frame",AVS_VALUE,frame,NULL,NULL);
  }
  else if (AVSparameter_changed("animation frame")) {
    cf = frame;
    AVSmodify_parameter("curr frame",AVS_VALUE,cf,NULL,NULL);
  }
  
  /* make sure that if we are using quaternions, rotation buttons are */
  /* connected. */
  else if (AVSparameter_changed("XROTon")) {
    if (quatrot) {
      AVSmodify_parameter("YROTon",AVS_VALUE,xron,NULL,NULL);
      AVSmodify_parameter("ZROTon",AVS_VALUE,xron,NULL,NULL);
      yron = xron;
      zron = xron;
    }
    return(0);
  }
  else if (AVSparameter_changed("YROTon")) {
    if (quatrot) {
      AVSmodify_parameter("XROTon",AVS_VALUE,yron,NULL,NULL);
      AVSmodify_parameter("ZROTon",AVS_VALUE,yron,NULL,NULL);
      xron = yron;
      zron = yron;
    }
    return(0);
  }
  else if (AVSparameter_changed("ZROTon")) {
    if (quatrot) {
      AVSmodify_parameter("XROTon",AVS_VALUE,zron,NULL,NULL);
      AVSmodify_parameter("YROTon",AVS_VALUE,zron,NULL,NULL);
      xron = zron;
      yron = zron;
    }
    return(0);
  }
  
  /* clear the values of active dials */
  else if (AVSparameter_changed("clear frame information")) {
    mess = AVSmessage(VERSION,AVS_Warning,NULL,"CLEAR FRAME INFO",
		      "ABORT!CLEAR",
     "%s %d to %d!\n\n%s\n%s\n",
     "This command will clear all stored values of active dials for frames",
     start,end,
     "Press CLEAR to clear frame information.",
     "Press ABORT to abort clear.");
    if (!strcmp(mess,"ABORT")) return(0);

    for(i=start-1; i<end; i++) {
      if (quatrot && (xron || yron || zron)) {
	Anim[i][OBJ][QTRC] = 1.0;
	Anim[i][OBJ][QTRX] = 0.0;
	Anim[i][OBJ][QTRY] = 0.0;
	Anim[i][OBJ][QTRZ] = 0.0;
      }
      else {
	if (xron) Anim[i][OBJ][XROT] = 0.0;
	if (yron) Anim[i][OBJ][YROT] = 0.0;
	if (zron) Anim[i][OBJ][ZROT] = 0.0;
      }
      if (xton) Anim[i][OBJ][XTRN] = 0.0;
      if (yton) Anim[i][OBJ][YTRN] = 0.0;
      if (zton) Anim[i][OBJ][ZTRN] = 0.0;
      if (scon) Anim[i][OBJ][SIZE] = 0.0;
    }
  }     
  
  /* clear current keyframe */
  else if (AVSparameter_changed("clear keyframe")) {
    Framelist[frame-1].keyframe = 0;
    return(0);
  }
  /* clear all keyframes */
  else if (AVSparameter_changed("clear all keyfms")) {
    for(i=start-1; i<end; i++) Framelist[i].keyframe = 0;
    return(0);
  }
  
  /* create a linear interpolation based on the current keyframes */
  else if (AVSparameter_changed("create linear interpolation")) { 
    Framelist[start-1].keyframe = 1;
    Framelist[end-1].keyframe = 1;
    Interp_linear(start,end,easein,easeout,OBJ+1,
			     quatrot,xron,yron,zron,xton,yton,zton,scon);
    update = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
  }
  /* create a spline interpolation based on the current keyframes */
  else if (AVSparameter_changed("create spline interpolation")) {
    /* make sure that the start and end frames are keyframes */
    Framelist[start-1].keyframe = 1;
    Framelist[end-1].keyframe = 1;

    /* for now, linearly interpolate quaternions */
    Interp_linear(start,end,easein,easeout,OBJ+1,
			     quatrot,0,0,0,0,0,0,0);
    /* create spline interpolations */
    Interp_spline(start,end,easein,easeout,OBJ+1,
			     0,xron,yron,zron,xton,yton,zton,scon);

    update = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
  }
  /* create a hold based on the current frame */
  else if (AVSparameter_changed("create hold")) {
    for (i=start-1; i<end; i++) {
      if (quatrot && (xron || yron || zron)) {
	Anim[i][OBJ][QTRC] = Anim[frame-1][OBJ][QTRC];
	Anim[i][OBJ][QTRX] = Anim[frame-1][OBJ][QTRX];
	Anim[i][OBJ][QTRY] = Anim[frame-1][OBJ][QTRY];
	Anim[i][OBJ][QTRZ] = Anim[frame-1][OBJ][QTRZ];
      }
      else {
	if (xron) Anim[i][OBJ][XROT] = Anim[frame-1][OBJ][XROT];
	if (yron) Anim[i][OBJ][YROT] = Anim[frame-1][OBJ][YROT];
	if (zron) Anim[i][OBJ][ZROT] = Anim[frame-1][OBJ][ZROT];
      }
      if (xton) Anim[i][OBJ][XTRN] = Anim[frame-1][OBJ][XTRN];
      if (yton) Anim[i][OBJ][YTRN] = Anim[frame-1][OBJ][YTRN];
      if (zton) Anim[i][OBJ][ZTRN] = Anim[frame-1][OBJ][ZTRN];
      if (scon) Anim[i][OBJ][SIZE] = Anim[frame-1][OBJ][SIZE];
    }
    update = 1;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
  }
  
  /* turn on/off path traces */
  else if (AVSparameter_changed("trace object path")) {
    traceobj = GEOMcreate_obj(GEOM_POLYTRI,NULL);

    if (trace) {
      i = end-start+1;
      s = start-1;
      e = 0;

      /* allocate memory for trace */
      Traceverts = (float *) malloc(i*3*sizeof(float));

      /* calculate trace path */
      for (j=0; j<i; j++) {
	Traceverts[e++] = (Anim[j+s][OBJ][XTRN])/100.0;
	Traceverts[e++] = (Anim[j+s][OBJ][YTRN])/100.0;
	Traceverts[e++] = (Anim[j+s][OBJ][ZTRN])/100.0;
      }

      /* create the polyline and free memory */
      GEOMadd_polyline(traceobj,Traceverts,GEOM_NULL,i,GEOM_COPY_DATA);
      free(Traceverts);
    }

    /* output the trace path object to AVS */

    /* sprintf(mess,"%s-%d","ANIM-Trace",OBJ+1); */
    GEOMedit_geometry(*output,"ANIM-Trace",traceobj);
    GEOMedit_selection_mode(*output,"ANIM-Trace","ignore",
			    BUTTON_DOWN|BUTTON_MOVING);
    GEOMedit_parent(*output,"ANIM-Trace",Objlist[OBJ].parent);
    GEOMdestroy_obj(traceobj);
    return(1);
  }

  /* reset active dials to zero */
  else if (AVSparameter_changed("initialize dials")) {
    if (quatrot && (xron || yron || zron)) {
      Quat_init(Q);
      oldrotx = 0.;
      oldroty = 0.;
      oldrotz = 0.;
      changex = 0.;
      changey = 0.;
      changez = 0.;
      AVSmodify_float_parameter("rot x",AVS_VALUE,0,NULL,NULL);
      *rotx = 0.;
      AVSmodify_float_parameter("rot y",AVS_VALUE,0,NULL,NULL);
      *roty = 0.;
      AVSmodify_float_parameter("rot z",AVS_VALUE,0,NULL,NULL);
      *rotz = 0.;
    }
    else {
      if (xron) {
	AVSmodify_float_parameter("rot x",AVS_VALUE,0,NULL,NULL);
	*rotx = 0.;
      }
      if (yron) {
	AVSmodify_float_parameter("rot y",AVS_VALUE,0,NULL,NULL);
	*roty = 0.;
      }
      if (zron) {
	AVSmodify_float_parameter("rot z",AVS_VALUE,0,NULL,NULL);
	*rotz = 0.;
      }
    }
    if (xton) {
      AVSmodify_float_parameter("trans x",AVS_VALUE,0,NULL,NULL);
      *tx = 0.;
    }
    if (yton) {
      AVSmodify_float_parameter("trans y",AVS_VALUE,0,NULL,NULL);
      *ty = 0.;
    }
    if (zton) {
      AVSmodify_float_parameter("trans z",AVS_VALUE,0,NULL,NULL);
      *tz = 0.;
    }
    if (scon) {
      AVSmodify_float_parameter("scale",AVS_VALUE,0,NULL,NULL);
      *sc = 0.;
    }
    update = 0;
    AVSmodify_parameter("update frame",AVS_VALUE,update,NULL,NULL);
  }
  
  /* mark the current positions for the currently active dials as */
  /* a keyframe */
  else if (AVSparameter_changed("save keyframe")) {
    /* save keyframe position of active channels */
    if (quatrot && (xron || yron || zron)) {
      Anim[frame-1][OBJ][QTRC] = Q[0];
      Anim[frame-1][OBJ][QTRX] = Q[1];
      Anim[frame-1][OBJ][QTRY] = Q[2];
      Anim[frame-1][OBJ][QTRZ] = Q[3];
    }
    else {
      if (xron) Anim[frame-1][OBJ][XROT] = *rotx;
      if (yron) Anim[frame-1][OBJ][YROT] = *roty;
      if (zron) Anim[frame-1][OBJ][ZROT] = *rotz;
    }
    if (xton) Anim[frame-1][OBJ][XTRN] = *tx;
    if (yton) Anim[frame-1][OBJ][YTRN] = *ty;
    if (zton) Anim[frame-1][OBJ][ZTRN] = *tz;
    if (scon) Anim[frame-1][OBJ][SIZE] = *sc;
    Framelist[frame-1].keyframe = 1;
    return(0);
  }
  

  /*************************************
   * DO TRANSFORMATIONS ON THE OBJECTS *
   *************************************/

  /* do transformations on the current object */
  if (strncmp(Objlist[OBJ].name,"EMPTY",5)) {
    if (update) {
      if (quatrot) {
	Q[0] = Anim[frame-1][OBJ][QTRC];
	Q[1] = Anim[frame-1][OBJ][QTRX];
	Q[2] = Anim[frame-1][OBJ][QTRY];
	Q[3] = Anim[frame-1][OBJ][QTRZ];
      }
      else {
	*rotx = Anim[frame-1][OBJ][XROT];
	*roty = Anim[frame-1][OBJ][YROT];
	*rotz = Anim[frame-1][OBJ][ZROT];
      }
      *tx = Anim[frame-1][OBJ][XTRN];
      *ty = Anim[frame-1][OBJ][YTRN];
      *tz = Anim[frame-1][OBJ][ZTRN];
      *sc = Anim[frame-1][OBJ][SIZE];
    }
  
    /* do rotate */
    if (quatrot) {
      /* calculate relative rotation change since last frame */
      changex = *rotx - oldrotx;
      oldrotx = *rotx;
      changey = *roty - oldroty;
      oldroty = *roty;
      changez = *rotz - oldrotz;
      oldrotz = *rotz;

      Quat_rotate(Q,changex,1);
      Quat_rotate(Q,changey,2);
      Quat_rotate(Q,changez,3);

      Quat_evalmatrix(xform,Q);
    }
    else {
      mat_x_rotate(*rotx,xform);
      mat_y_rotate(*roty,tmat);
      mat_multiply(xform,tmat,xform);
      mat_z_rotate(*rotz,tmat);
      mat_multiply(xform,tmat,xform);
    }

    /* do scale */
    scale = 1.0 + (*sc/100.0);
    mat_scale(tmat,scale,scale,scale);
    mat_multiply(xform,tmat,xform);
    
    /* do translate */
    mat_translate(tmat,*tx/100.0,*ty/100.0,*tz/100.0);
    mat_multiply(xform,tmat,xform);

    GEOMedit_set_matrix(*output, Objlist[OBJ].name, xform); 
  }

  /* update the current dials */
  if (update) {
    if (!quatrot) {
      AVSmodify_float_parameter("rot x",AVS_VALUE,Anim[frame-1][OBJ][XROT],
				NULL,NULL);
      AVSmodify_float_parameter("rot y",AVS_VALUE,Anim[frame-1][OBJ][YROT],
				NULL,NULL);
      AVSmodify_float_parameter("rot z",AVS_VALUE,Anim[frame-1][OBJ][ZROT],
				NULL,NULL);
    }
    AVSmodify_float_parameter("trans x",AVS_VALUE,Anim[frame-1][OBJ][XTRN],
			      NULL,NULL);
    AVSmodify_float_parameter("trans y",AVS_VALUE,Anim[frame-1][OBJ][YTRN],
			      NULL,NULL);
    AVSmodify_float_parameter("trans z",AVS_VALUE,Anim[frame-1][OBJ][ZTRN],
			      NULL,NULL);
    AVSmodify_float_parameter("scale",AVS_VALUE,Anim[frame-1][OBJ][SIZE],
			      NULL,NULL);
  }
  
  /* update all other objects (except the current object) */
  /* set temporary transformations so that they wont be changed */

  for (i=0; i<Totobjs; i++) { 
    if ((i != OBJ) && (strncmp(Objlist[i].name,"EMPTY",5))) {
      if (!strcmp(Objlist[i].rotation,"quaternion")) tempquatrot = 1;
      else tempquatrot = 0;

      if (tempquatrot) {
	tempQ[0] = Anim[frame-1][i][QTRC];
	tempQ[1] = Anim[frame-1][i][QTRX];
	tempQ[2] = Anim[frame-1][i][QTRY];
	tempQ[3] = Anim[frame-1][i][QTRZ];
      }
      else {
	temprotx = Anim[frame-1][i][XROT];
	temproty = Anim[frame-1][i][YROT];
	temprotz = Anim[frame-1][i][ZROT];
      }
      temptx = Anim[frame-1][i][XTRN];
      tempty = Anim[frame-1][i][YTRN];
      temptz = Anim[frame-1][i][ZTRN];
      tempsc = Anim[frame-1][i][SIZE];

      /* do rotate */
      if (tempquatrot) Quat_evalmatrix(xform,tempQ);
      else {
	mat_x_rotate(temprotx,xform);
	mat_y_rotate(temproty,tmat);
	mat_multiply(xform,tmat,xform);
	mat_z_rotate(temprotz,tmat);
	mat_multiply(xform,tmat,xform);
      }

      /* do scale */
      scale = 1.0 + (tempsc/100.0);
      mat_scale(tmat,scale,scale,scale);
      mat_multiply(xform,tmat,xform);

      /* do translate */
      mat_translate
	(tmat,temptx/100.0,tempty/100.0,temptz/100.0);
      mat_multiply(xform,tmat,xform);

      GEOMedit_set_matrix(*output, Objlist[i].name, xform); 
    }
  }

  /************************
   * SET THE FRAME OUTPUT *
   ************************/

  *frameout = frame;

  /*********
   * DONE! *
   *********/

  /* return a 1 to signify that everything went alright */
  return(1);
}


/*********************************
 * THE INIT AND DESTROY ROUTINES *
 *********************************/

keyframe_init()
/* set up global structures before invoking the module */
{
  fprintf(stderr,"%s (%s)\n%s\n%s\n",
	  "KEYFRAME ANIMATOR",VERSION,
	  "   Copyright (c) 1991 Brian Kaplan, CICA, Indiana University",
	  "   All rights reserved.");
  Anim_init(NUMFRAMES,NUMOBJS,NUMCHANNELS);
}

keyframe_destroy()
/* free global structures before destroying the module */
{
  Anim_free();
}

