/* 
 * KEYFRAME ANIMATOR:
 * created by Brian Kaplan
 *      kaplan@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * Copyright (c) 1993 Brian Kaplan, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

/***********
 * DEFINES *
 ***********/

#define VERSION "V3.0b2"                               /* the version number */
#define ANIMEXT ".anim"		    /* the extension for the animation files */
#define MAXNAMELENGTH 24         /* maximum number of characters in a string */

/* define the names of the transformation channels */
#define XTRN 0                                             /*  X translation */
#define YTRN 1                                             /*  Y translation */
#define ZTRN 2                                             /*  Z translation */
#define SIZE 3                                        /* size, (X,Y,Z scale) */
#define QTRX 4                           /* the quaternion rotation channels */
#define QTRY 5
#define QTRZ 6
#define QTRC 7

/* special channels (NOT USED) */
#define MODE 11                                  /* the object's render mode */
#define COL1 12                                                    /* R or H */
#define COL2 13                                                    /* G or S */
#define COL3 14                                                    /* B or V */
#define TRANSP 15                                   /* object's transparency */

/* animation modes */
#define AMODE_UNKNOWN 0
#define LOOP 1
#define SWING 2
#define ONCE 3
#define OFF 4

#define NUMCHANNELS 8                   /* the number of above channels used */
#define NUMFRAMES 150              /* default number of frames for animation */
#define NUMOBJS 1                 /* default number of objects for animation */

/* defines for the translation trace object */
#define TRACERED 1              /* the color of the translation trace object */
#define TRACEGREEN 1
#define TRACEBLUE .5

/* defines for the keyframe markers */
#define KEYT_UNKNOWN 0
#define NUMERICKEYS 1                      /* keyframes displayed as numbers */
#define SPHEREKEYS 2                       /* keyframes displayed as spheres */
#define NOKEYS 3		                 /* no key markers displayed */
#define KEYTYPE NUMERICKEYS
#define KEYRED 1.0                      /* the color of the keyframe markers */
#define KEYGREEN 0.0
#define KEYBLUE 0.0
#define KEYSIZE 0.1			 /* radius for spherical key markers */

/* load/save modes */
#define LOADREPLACE 0
#define LOADMERGE 1
#define LOADAPPEND 2
#define SAVEALL 0
#define SAVENONEMPTY 1

/* database access routine templates */
int Anim_init(int, int, int);
void Anim_free();
int Anim_addframes(int);
int Anim_addobjects(int);

int GetNumobjs();
int GetNumframes();
int GetNumchannels();
int NextKey(int , int);
int PrevKey(int , int);
void SetKey(int, int);
int GetKey(int);
void SetName(int, char *);
char *GetName(int);
void SetParent(int, char *);
char *GetParent(int);
void SetChan(int, int, int, double);
double GetChan(int, int, int);
void SetRot(int, int, double *);
void GetRot(double *, int, int);
void SetTrans(int, int, double *);
void GetTrans(double *, int, int);
void SetSize(int, int, double);
void GetSize(double *, int, int);
