/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* 
 * KEYFRAME ANIMATOR:
 * created by Brian Kaplan
 *      kaplan@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * Copyright (c) 1993 Brian Kaplan, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

#include <math.h>
#include "quaternion.h"

quat_dot(Q,F,G)
/**************************************************************/
/* Take the dot product of quaternions F and G, putting the   */
/* result in Q                                                */
/**************************************************************/
     double Q[4];
     double F[4];
     double G[4];
{
  float temp;
  int i;

  /* Perform a quaternion dot-product. */
  Q[3] = (F[3] * G[3]) - ((F[0] * G[0]) + (F[1] * G[1]) + (F[2] * G[2]));
  Q[0] = (F[3] * G[0]) + (G[3] * F[0]) + ((F[1] * G[2]) - (F[2] * G[1]));
  Q[1] = (F[3] * G[1]) + (G[3] * F[1]) + ((F[2] * G[0]) - (F[0] * G[2]));
  Q[2] = (F[3] * G[2]) + (G[3] * F[2]) + ((F[0] * G[1]) - (F[1] * G[0]));

  /* make sure the resulting quaternion is a unit quaternion */
  temp = sqrt((double)(Q[0]*Q[0] + Q[1]*Q[1] + Q[2]*Q[2] + Q[3]*Q[3]));
  for (i=0; i<4; i++) Q[i] = Q[i]/temp;
}

Quat_init(Q)
/**************************************************************/
/* Initializes quaternion Q to its default values (1,0,0,0)   */
/* which specifies NO rotation.                               */ 
/**************************************************************/
     double Q[4];
{
  int i;

  for (i = 0; i < 3; i++) Q[i] = 0.0;
  Q[3] = 1.0;
}

/* Multiply two quaternions */
void qmul(quaternion result, quaternion q1, quaternion q2)
{
  quaternion temp;
  int i;
  temp[X] = q1[W]*q2[X]+q1[X]*q2[W]+q1[Y]*q2[Z]-q1[Z]*q2[Y];
  temp[Y] = q1[W]*q2[Y]+q1[Y]*q2[W]+q1[Z]*q2[X]-q1[X]*q2[Z];
  temp[Z] = q1[W]*q2[Z]+q1[Z]*q2[W]+q1[X]*q2[Y]-q1[Y]*q2[X];
  temp[W] = q1[W]*q2[W]-q1[X]*q2[X]-q1[Y]*q2[Y]-q1[Z]*q2[Z];

  for (i=X;i<=W;i++)
    result[i] = temp[i];
}

void qcnj(quaternion qq, quaternion q)
{
  qq[X] = -q[X]; qq[Y] = -q[Y]; qq[Z] = -q[Z]; qq[W] = q[W];
}

void qneg(quaternion q, quaternion r)
{
  /* place the negative quaternion of r in quaternion q */
  
  q[X] = -r[X];
  q[Y] = -r[Y];
  q[Z] = -r[Z];
  q[W] = -r[W];
}

double qangle(quaternion q, quaternion r)
{
  double t;
  
  /* if negative, the angle between the quaternions is greater  */
  /* than 180 degrees.  To make the angle less than 180 degrees */
  /* you can take the negative of either quaternion.            */

  t = (q[X]*r[X])+(q[Y]*r[Y])+(q[Z]*r[Z])+(q[W]*r[W]);
  return(t);
}

double length(quaternion q)
{
  return sqrt(q[X]*q[X]+q[Y]*q[Y]+q[Z]*q[Z]+q[W]*q[W]);
}

void qnormalize(quaternion q)
{
  double l=length(q);
  int i;
  for (i=X;i<=W;i++) q[i]/=l;
}

void qinv(quaternion result, quaternion q)
{
  result[X] = -q[X];
  result[Y] = -q[Y];
  result[Z] = -q[Z];
  result[W] = q[W];
}

Quat_evalmatrix(mat,q)
/**************************************************************/
/* Convert a quaternion into a 4 by 4 rotation matrix         */
/**************************************************************/
  float mat[4][4];
  double q[4];
{
  double s,xs,ys,zs,wx,wy,wz,xx,xy,xz,yy,yz,zz;
  int i;
  
  s=2.0;

  xs = q[0]*s;  ys = q[1]*s;  zs = q[2]*s;
  wx = q[3]*xs; wy = q[3]*ys; wz = q[3]*zs;
  xx = q[0]*xs; xy = q[0]*ys; xz = q[0]*zs;
  yy = q[1]*ys; yz = q[1]*zs; zz = q[2]*zs;

  mat[0][0] = (float)(1.0 - (yy+zz));
  mat[1][0] = (float)(xy-wz);
  mat[2][0] = (float)(xz+wy);

  mat[0][1] = (float)(xy+wz);
  mat[1][1] = (float)(1.0 - (xx+zz));
  mat[2][1] = (float)(yz-wx);

  mat[0][2] = (float)(xz-wy);
  mat[1][2] = (float)(yz+wx);
  mat[2][2] = (float)(1.0 - (xx+yy));

  for (i=0; i<3; i++)
  {
    mat[i][3] = 0.0;
    mat[3][i] = 0.0;
  }
  mat[3][3] = 1.0;
}

mattoquat(q, mat)
/**************************************************************/
/* Convert a 3 by 3 rotation matrix into a quaternion         */
/**************************************************************/
    double q[4];
    double mat[3][3];
{
  double trace=0.0, s=0.0;
  int i,j,k;

  for (i=X;i<=Z;i++)
    trace += mat[i][i];

  if (trace>0.0){
    s = sqrt(trace + 1.0);
    q[W] = s*0.5;
    s = 0.5 / s;

    for (i=X;i<=Z;i++){
      j=xyz_next(i);
      k=xyz_next(j);
      q[i] = (mat[k][j]-mat[j][k]) * s;
    }
  }else{
    i=X;
    if (mat[Y][Y]>mat[X][X]) i=Y;
    if (mat[Z][Z]>mat[i][i]) i=Z;
    j=xyz_next(i); k=xyz_next(j);

    s = sqrt((mat[i][i] - (mat[j][j]+mat[k][k]))+1.0);
    q[i] = s*0.5;
    s = 0.5/s;
    q[W] = (mat[k][j] - mat[j][k])*s;
    q[j] = (mat[j][i] + mat[i][j])*s;
    q[k] = (mat[k][i] + mat[i][k])*s;
  }
}
