/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* 
 * SIMPLE MOUSE/KEYBOARD DETECTOR
 * detects mouse and keyboard presses via simple Xwindows library calls.
 *
 * created by Eric Ost
 *      emo@cica.indiana.edu
 *      Center for Innovative Computer Applications (CICA)
 *      Indiana University
 *
 * Copyright (c) 1991 Eric Ost, CICA, Indiana University
 * All rights reserved.
 *
 * This material was developed at the Center for Innovative Computer
 * Applications (CICA), Indiana University.  Permission to copy this
 * software or any portion of it, to redistribute it, and to use it for
 * any purpose and without fee is granted, subject to the following
 * restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright notice
 * in full.  Any materials containing this software or any part of this
 * software must include this copyright notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the Center for Innovative Computer Applications any improvements
 * or extensions that they make, so that these may be included in future
 * releases; and (b) to inform Indiana University of noteworthy uses of this
 * software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the usual
 * standards of acknowledging credit in academic research.
 *
 * 4. Indiana University has made no warrantee or representation that the
 * operation of this software will be error-free, and Indiana University
 * is under no obligation to provide any services, by way of maintenance,
 * update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this material,
 * there shall be no use of the name of Indiana University or the Center
 * for Innovative Computer Applications nor of any adaptation thereof in
 * any advertising, promotional, or sales literature without prior written
 * consent from Indiana University in each case.
 *
 */

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

button1pressed()
/*********************************************************/
/* Returns 1 if mouse button 1 (left) is pressed.        */
/* Returns 0 otherwise (including if there is an error). */
/*********************************************************/
{
  int i;

  if ((i = getbuttons()) < 1) return(0);

  return (i & Button1Mask);
}

button2pressed()
/*********************************************************/
/* Returns 1 if mouse button 2 (middle) is pressed.      */
/* Returns 0 otherwise (including if there is an error). */
/*********************************************************/
{
  int i;

  if ((i = getbuttons()) < 1) return(0);

  return (i & Button2Mask);
}

button3pressed()
/*********************************************************/
/* Returns 1 if mouse button 3 (right) is pressed.       */
/* Returns 0 otherwise (including if there is an error). */
/*********************************************************/
{
  int i;

  if ((i = getbuttons()) < 1) return(0);

  return (i & Button3Mask);
}

shiftpressed()
/*****************************************************************/
/* Returns 1 if either the left or right shift keys are pressed. */
/* Returns 0 otherwise (including if there is an error).         */
/*****************************************************************/
{
  int i,j;

  if ((i = getkey(XK_Shift_L)) < 0) return(0);
  if ((j = getkey(XK_Shift_R)) < 0) return(0);

  return (i || j);
}

/*************************/

Display *
GetAVSDisplay()
/* Returns the Display pointer for the current AVS session. */
{
  static Display *dsp = (Display *) 0;

  if (dsp != (Display *)0) return(dsp);

  if ((dsp = XOpenDisplay("")) == NULL) 
    fprintf(stderr, "ANIM:  ERROR -- Cannot open default display!\n");
  return (dsp);
}

getbuttons()
/* Returns a mask which indicates the state of the pointer buttons. */
{
  Display *dsp, *GetAVSDisplay();
  int root, child, root_x, root_y, win_x, win_y;
  unsigned int mask;

  if ((dsp = GetAVSDisplay()) == NULL) return(-1);
  XQueryPointer(dsp, RootWindow(dsp, 0), 
		&root, &child, &root_x, &root_y, &win_x, &win_y,
		&mask);

  return ((int) mask);
}

getkey(keysym)
/* Given an X Keysym (see X11/keysymdefs.h and Xlib docs) */
/* Returns 1 if that key is pressed, and 0 if it is not pressed. */
  KeySym keysym;
{
  Display *dsp, *GetAVSDisplay();
  char keys[32];
  KeyCode keycode;

  if ((dsp = GetAVSDisplay()) == NULL) return(-1);

  if (XQueryKeymap(dsp, keys) < 0) {
    fprintf(stderr,"ANIM:  ERROR -- Cannot query keymap!\n");
    return(-1);
  }
  keycode = XKeysymToKeycode(dsp,keysym);

  return ((keys[(keycode>>3)] & (1 << (keycode & 0x7))) ? 1:0);
}

