/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int LABELS_UNITS_desc()
{

	int in_port, in_2port, out_port, param;
	extern int LABELS_UNITS_compute();

	AVSset_module_name("LABELS UNITS", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input field", "field", REQUIRED);

	in_port = AVScreate_input_port("input slice axis", "string", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("textout", "string");

	param = AVSadd_parameter("Label Slice Only", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(LABELS_UNITS_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int LABELS_UNITS_compute(input_field, input_slice_axis, textout, slice_only)
	AVSfield_float *input_field;
	char *input_slice_axis;
	char **textout;
	int slice_only;
{
#define SPECIES input_field->labels+1
#define UNITS input_field->units+1

#define XCOORD_MIN input_field->points[0]
#define XCOORD_MAX input_field->points[1]
#define YCOORD_MIN input_field->points[2]
#define YCOORD_MAX input_field->points[3]
#define ZCOORD_MIN input_field->points[4]
#define ZCOORD_MAX input_field->points[5]
 
#define NX ((int) (XCOORD_MAX - XCOORD_MIN + 1.0))
#define NY ((int) (YCOORD_MAX - YCOORD_MIN + 1.0))
#define NZ ((int) (ZCOORD_MAX - ZCOORD_MIN + 1.0))

#define COLUMN (XCOORD_MIN + 1)
#define ROW (YCOORD_MIN + 1)
#define LAYER (ZCOORD_MIN + 1)

char *str = NULL;
char *colstr = NULL;
char *rowstr = NULL;
char *layerstr = NULL;

#define SLICE_XAXIS 1
#define SLICE_YAXIS 2
#define SLICE_ZAXIS 3
 
int n, slice_axis;

if (input_slice_axis != NULL)
	{
	if (!strcmp(input_slice_axis, "X"))
		slice_axis = SLICE_XAXIS;
	else if (!strcmp(input_slice_axis, "Y"))
		slice_axis = SLICE_YAXIS;
	else if (!strcmp(input_slice_axis, "Z"))
		slice_axis = SLICE_ZAXIS;
	else
		{
		AVSerror("Slice axis must be X or Y or Z.");
		return(0);
		}
	}

if (str != NULL)

/* IAC CODE CHANGE : 	free((char *) str); */
	 free( str);
n = strlen(SPECIES) + strlen(UNITS) + 132;

if ((str = ((char *) malloc(sizeof(char) * n))) == NULL)
	{
	AVSerror("Cannot allocate string for output!"); 
	return(0);
	}
if ((colstr = ((char *) malloc(sizeof(char) * 32))) == NULL)
	{
	AVSerror("Cannot allocate string for column output!"); 

/* IAC CODE CHANGE : 	free((char *) str); */
	 free( str);
	return(0);
	}
if ((rowstr = ((char *) malloc(sizeof(char) * 32))) == NULL)
	{
	AVSerror("Cannot allocate string for row output!"); 

/* IAC CODE CHANGE : 	free((char *) str); */
	 free( str);

/* IAC CODE CHANGE : 	free((char *) colstr); */
	 free( colstr);
	return(0);
	}
if ((layerstr = ((char *) malloc(sizeof(char) * 32))) == NULL)
	{
	AVSerror("Cannot allocate string for layer output!"); 

/* IAC CODE CHANGE : 	free((char *) str); */
	 free( str);

/* IAC CODE CHANGE : 	free((char *) colstr); */
	 free( colstr);

/* IAC CODE CHANGE : 	free((char *) rowstr); */
	 free( rowstr);
	return(0);
	}
  
if (NX == 1)
	sprintf(colstr, "Column %g", COLUMN);
else
	sprintf(colstr, "Columns (%g,%g)", XCOORD_MIN + 1, XCOORD_MAX + 1);
if (NY == 1)
	sprintf(rowstr, "Row %g", ROW);
else
	sprintf(rowstr, "Rows (%g,%g)", YCOORD_MIN + 1, YCOORD_MAX + 1);
if (NZ == 1)
	sprintf(layerstr, "Layer %g", LAYER);
else
	sprintf(layerstr, "Layers (%g,%g)", ZCOORD_MIN + 1, ZCOORD_MAX + 1);


if ((slice_only) && (input_slice_axis != NULL))
	{
	if (slice_axis == SLICE_XAXIS)
		sprintf(str, "%s (%s) %s", SPECIES, UNITS, colstr);
	else if (slice_axis == SLICE_YAXIS)
		sprintf(str, "%s (%s) %s", SPECIES, UNITS, rowstr);
	else if (slice_axis == SLICE_ZAXIS)
		sprintf(str, "%s (%s) %s", SPECIES, UNITS, layerstr);
	}
else
	sprintf(str, "%s (%s) %s; %s; %s",
		 SPECIES, UNITS, colstr, rowstr, layerstr);

*textout = str;
free((char *) colstr);
free((char *) rowstr);
free((char *) layerstr);
return(1);
}

#ifdef SEPARATE_MODULES
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	LABELS_UNITS_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

