/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce bez_vol.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  bez_vol.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  bez_vol.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     bez_vol.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
bez_vol.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	415-486-6626
	ewbethel@lbl.gov
*/

/**
  * this file contains, among other things, the "main" routine
  * for the avs module "bez volume" which performs analytic rendering
  * of curvilinear volume data.
  *
  * 17 may 1991
**/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/geomdata.h>
#include <avs/field.h>
#include <avs/colormap.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include "matrix.h"
#include "opacity.h"
#include "voxel.h"
#include "alpha_wts.h"

#define TRICUBIC 0
#define CURVILINEAR 1
#define BIGNUM 6666666.666
#define SMALLNUM -666666.666

float Map_min,Map_scale;
int Map_size;
static matrix4x4 control_points_x[4],control_points_y[4],control_points_z[4],
    data_values[4];
static matrix4x4 view;

static float *opacity_correction_table=NULL;
double *root_table=NULL;
dmatrix4x4 *fwd_diff_table=NULL;

int last_voxel_type= -1;
Voxel *voxel_list=NULL;
CVoxel *cvoxel_list=NULL;
int *voxel_indeces=NULL;



int
destroy_tables()
{

/* IAC CODE CHANGE :     free((char *)opacity_correction_table); */
     free(opacity_correction_table);
    opacity_correction_table = NULL;

/* IAC CODE CHANGE :     free((char *)root_table); */
     free(root_table);
    if (voxel_indeces != NULL)
	free((char *)voxel_indeces);
    if (cvoxel_list != NULL)
	free((char *)cvoxel_list);
    if (voxel_list != NULL)
	free((char *)voxel_list);
    if (fwd_diff_table != NULL)
	free((char *)fwd_diff_table);
}

int
make_tables()
{

    if (opacity_correction_table != NULL)
	free((char *)opacity_correction_table);
    if (root_table != NULL)
	free((char *)root_table);
    if (fwd_diff_table != NULL)
	free((char *)fwd_diff_table);
    
    /* malloc and create the opacity correction table. */
    opacity_correction_table = (float *)malloc(sizeof(float)*(ALPHA_RESOLUTION+1)*MAX_LAYERS);
    if (opacity_correction_table == NULL)
    {
	AVSwarning("Can't malloc the opacity correction table. ");
	return(0);
    }
    build_opacity_correction(opacity_correction_table,ALPHA_RESOLUTION,MAX_LAYERS);
    /* malloc and create the square root table */
    root_table = (double *)malloc(sizeof(double)*ROOT_TABLE_SIZE);
    build_root_table(root_table,ROOT_TABLE_SIZE);

    /* malloc and create the tricubic forward difference matrix table */

    fwd_diff_table = (dmatrix4x4 *)malloc(sizeof(dmatrix4x4)*MAX_LAYERS);
    build_fwd_diff_table(fwd_diff_table,MAX_LAYERS);

    
}

AVSinit_modules()
{
   int bez_vol();
   AVSmodule_from_desc(bez_vol);
}

bez_vol()
{
   int bez_vol_p(),compute_opacity_correction_table(),destroy_opacity_table();
   int p;

   AVSset_module_name("LBL bezier volume", MODULE_MAPPER);
   AVScreate_input_port("Colormap","colormap",REQUIRED);
   AVScreate_input_port("Input CP","field scalar",REQUIRED);
   AVScreate_output_port("Output Image","field 2D 4-vector float");

   p=AVSadd_parameter("dummy1","string","Image Size","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p=AVSadd_parameter("Image Size","integer",256,32,1024);
   AVSconnect_widget(p,"typein_integer");

   p=AVSadd_parameter("dummy3","string","Rendering Style","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   
   p=AVSadd_parameter("RenderStyle","choice","Volume","Dots!Volume","!");
   AVSconnect_widget(p,"radio buttons");
   
   p=AVSadd_parameter("dummy4","string","Interpolation Method","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p=AVSadd_parameter("InterpChoice","choice","tricubic","tricubic!trilinear","!");
   p=AVSconnect_widget(p,"radio buttons");
   
   p=AVSadd_parameter("dummy5","string","Bounding Hull Control","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p = AVSadd_parameter("HullChoice","choice","volume only",
       "volume only!hull only!volume & hull","!");
   AVSconnect_widget(p,"radio buttons");

   p=AVSadd_parameter("dummy6","string","Voxel Sort Control","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p = AVSadd_parameter("Sort Voxels","boolean",1,0,1);
   AVSconnect_widget(p,"toggle");

   p=AVSadd_parameter("dummy7","string","Voxel Input Type","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p = AVSadd_parameter("VoxelChoice","choice","curvilinear",
       "tricubic voxels!curvilinear","!");
   AVSconnect_widget(p,"radio buttons");

   p=AVSadd_parameter("dummy8","string","Rendering Throttle","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p=AVSadd_float_parameter("Epsilon",1.0,0.01,5.0);
   AVSconnect_widget(p,"typein_real");
   
   p=AVSadd_parameter("dummy9","string","Opacity Transfer Function","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p = AVSadd_parameter("OpacityChoice","choice","none",
       "none!linear!log","!");
   AVSconnect_widget(p,"radio buttons");

   p=AVSadd_float_parameter("OpacityScalar",1.0,0.0,10.0);
   AVSconnect_widget(p,"typein_real");
   
   p=AVSadd_parameter("dummy10","string","AntiAlias","","");
   AVSconnect_widget(p,"text");
   p=AVSadd_parameter("Antialias","boolean",0,0,1);
   
   p=AVSadd_parameter("dummy11","string","Beta-tension","","");
   AVSconnect_widget(p,"text");
   AVSadd_parameter_prop(p,"width","integer",4);
   p=AVSadd_float_parameter("Beta",1.0,0.0,10.0);
   AVSconnect_widget(p,"typein_real");

#ifndef STARDENT
   AVSset_init_proc(make_tables);
   AVSset_destroy_proc(destroy_tables);
#endif
   AVSset_compute_proc(bez_vol_p);
}

bez_vol_p(cm,inf,img,dummy1,size,
	  dummy3,rendering_choice,
	  dummy4,interp_choice,
	  dummy5,hull_control,
	  dummy6,sort_flag,
	  dummy7,voxel_input_type,
	  dummy8,throttle,
	  dummy9,opacity_choice,opacity_scalar,
	  dummy10,anti,
	  dummy11,beta) 
char *dummy1,*dummy3,*dummy4,*dummy5,*dummy6,*dummy7,*dummy8,*dummy9,*dummy10,
    *dummy11;
char *rendering_choice,*interp_choice,*hull_control,*voxel_input_type,
    *opacity_choice;
float *throttle,*opacity_scalar,*beta;
AVScolormap *cm;
AVSfield *inf;
AVSfield_float **img;
int size;
int sort_flag;
int anti;
{
    float *f;
    float *rgba;
    int i,j,k;
    AVSfield_float template;
    int dims[2];
    float *alpha_buf;
    float *zbuf;
    float zero=0.0;
    int izero=0;
    float *d;
    int num_voxels,num_points;
    Voxel t_voxel;
    int fast;
    int cubic_interp;
    int hull_choice = AVSchoice_number("HullChoice",hull_control)-1;
    int macro_apply;
    int opacity_method = AVSchoice_number("OpacityChoice",opacity_choice)-1;
    int input_type=AVSchoice_number("VoxelChoice",voxel_input_type)-1;
    int show_hull,hull_only;
    int min_dimension;
#ifdef AVS3
    float percent,delta;
    int ipercent;
#endif
#ifdef STARDENT
    extern double log();
#else
    extern double log2();
#endif
    double ldim;

#ifdef STARDENT
    make_tables();
#endif

    show_hull = hull_only = 0;
    if (hull_choice == 0)  /* volume only */
	show_hull = 0;
    else if (hull_choice == 1)  /* hull only */
    {
	show_hull = 1;
	hull_only = 1;
    }
    else  /* volume and hull */
	show_hull = 1;

    if (AVSchoice_number("RenderStyle",rendering_choice) == 1) /* dots only */
	fast = 1;
    else /* regular voxel subdivision rendering */
	fast = 0;

    if (AVSchoice_number("InterpChoice",interp_choice) == 1) /* tricubic */
	cubic_interp = 1;
    else if (AVSchoice_number("InterpChoice",interp_choice)== 2) /* trilinear */
	cubic_interp = 0;

    /* convert colormap from hsva to rgba */
    rgba = (float *)malloc(sizeof(float)*cm->size * 4);
    convert_cmap(cm,rgba);
    setup_map(cm);

    if (input_type == TRICUBIC)
    {
	/* want a 3d field w 4 cp's in each direction */
	if ((inf->ndim != 3) ||
	    (inf->dimensions[0] != 4) || (inf->dimensions[1] != 4) ||
	    (inf->dimensions[2] != 4))
	{
	    /* or proper number so that tricubic volumes may be computed. */
	    if (((inf->dimensions[0]-1)%3 != 0) ||
		((inf->dimensions[1]-1)%3 != 0) ||
		((inf->dimensions[2]-1)%3 != 0))
	    {
		AVSwarning(" field size or dimensions error.");
		return(0);
	    }
	}
    }
    else /* curvilinear data - just check for 3d */
    {
	if (inf->ndim != 3)
	{
	    AVSwarning(" input field must be 3d. ");
	    return(0);
	}
    }

    /* verify scalar field */
    if (inf->veclen != 1)
    {
	AVSwarning(" only scalar fields are allowed ");
	return(0);
    }
    /* verify float field */
    if (inf->type != AVS_TYPE_REAL)
    {
	AVSwarning(" only floating point scalar fields are allowed.\n");
	return(0);
    }

    /* set up output field */

    if (*img)
	AVSfield_free(*img);

    memset((char *)&template,0,sizeof(AVSfield));
    template.ndim = 2;
    template.nspace = 0;
    template.uniform = UNIFORM;
    template.veclen = 4;
    template.size = sizeof(float);
    template.type = AVS_TYPE_REAL;
    dims[0] = dims[1] = size;
    *img = (AVSfield_float *)AVSfield_alloc(&template,dims);
    if (*img == NULL)
    {
	AVSwarning(" can't malloc memory for image field.");
	return(0);
    }

    /* set output image to zero. note: it's square !! */
    d = (*img)->data;
    memset((char *)d,izero,sizeof(float)*size*size*4);
    
    /* malloc the alpha buffer -- same size as image */
    alpha_buf = (float *)malloc(sizeof(float)*dims[0]*dims[1]);
    if (alpha_buf == NULL)
    {
	AVSwarning(" can't malloc the alpha buffer. \n");
	return(0);
    }
    /* set the alpha buffer to zero */
    f = alpha_buf;
    memset((char *)f,izero,sizeof(float)*size*size);

    /* malloc the z-buffer used for hull rendering */
    zbuf = (float *)malloc(sizeof(float)*size*size);
    if (zbuf == NULL)
    {
	AVSwarning(" can't malloc the z buffer.");
	return(0);
    }
    /* set the z buffer to some large negative number */
    f = zbuf;
    for (i=0;i<size*size;i++)
	*f++ = BIGNUM;
    
    num_points = inf->dimensions[0] * inf->dimensions[1] * inf->dimensions[2];

    /* define the opacity transfer function. */

    if (opacity_method == 0)  /* user selected "none" */
	macro_apply = 0;
    else
    {
	/* compute the size of the smallest logical dimension */
	min_dimension = (inf->dimensions[0] < inf->dimensions[1]) ?
	    inf->dimensions[0] : inf->dimensions[1];
	min_dimension = (min_dimension < inf->dimensions[2]) ?
	    min_dimension : inf->dimensions[2];

	macro_apply = 1;
	if (opacity_method == 1) /* user selected "linear" */
	{
	    ldim = min_dimension;
	    ldim = min_dimension * *opacity_scalar;
	    min_dimension = (ldim < 1.) ? 1 : (int)ldim;
	}
	else /* assume user selected "log" */
	{
	    ldim = min_dimension;
#ifdef STARDENT
	    ldim =  *opacity_scalar * log(ldim);
#else
	    ldim =  *opacity_scalar * log2(ldim);
#endif
	    min_dimension = (ldim < 1.) ? 1 : (int)ldim;
	}
    }
    
    /* set up viewing matrix.. assume the input range of coordinates
       is in a  canonical viewing volume.  this means that the edges
       of the display window correspond to -1..1 in x & y.  don't
       really care what z is.   assume that at least a portion of the
       voxel is in the screen. */

    set_up_view_matrix(&view,size);

    if (hull_only != 1)
    {
#if 0
	if (cubic_interp != 2) /* if not forward differencing */
	    setup_weight_matrices(cubic_interp);
#endif
	if (input_type == TRICUBIC)
	{
	    if ((last_voxel_type != input_type) ||
		(AVSinput_changed("Input CP",0)) ||
		(voxel_list == NULL))
	    {
		if (setup_voxels(&voxel_list,inf,&num_voxels) == 0)
		{
		    AVSwarning(" malloc failure in setup_voxels.");
		    return(0);
		}
	    }
	}
	else /* input type is curvilinear */
	{
	    if ((last_voxel_type != input_type) ||
		(AVSinput_changed("Input CP",0)) ||
		(cvoxel_list == NULL))
	    {
		if (cvoxel_list != NULL)
		{

/* IAC CODE CHANGE : 		    free((char *)cvoxel_list); */
		     free(cvoxel_list);
		    cvoxel_list = NULL;
		}
		if (setup_cvoxels(&cvoxel_list,inf,&num_voxels) == 0)
		{
		    AVSwarning(" malloc failure in setup_cvoxels.");
		    return(0);
		}
	    }
	}

	if ((last_voxel_type != input_type) ||
	    (AVSinput_changed("Input CP",0)) ||
	    (voxel_indeces == NULL))
	{
	    if (voxel_indeces != NULL)
	    {
		free((char *)voxel_indeces);
		voxel_indeces=NULL;
	    }
	    voxel_indeces = (int *)malloc(sizeof(int)*num_voxels);
	    if (voxel_indeces == NULL)
	    {
		AVSwarning(" malloc failure for voxel indeces");
		return(0);
	    }
	    for (i=0;i<num_voxels;i++)
		voxel_indeces[i] = i;
    
	    if (sort_flag)
	    {
		if (input_type == TRICUBIC)
		    sort_voxels(voxel_list,voxel_indeces,num_voxels,1);
		else
		{
		    sort_cvoxels(cvoxel_list,voxel_indeces,num_voxels,1);
		    ldim = cvoxel_list[voxel_indeces[0]].min_z;
		    for (i=1;i<num_voxels;i++)
		    {
			if (cvoxel_list[voxel_indeces[i]].min_z < ldim)
			    fprintf(stderr," found a less than zmin at voxel index %d.  %g < %g\n",i,cvoxel_list[voxel_indeces[i]].min_z,ldim);
		    }
		}
	    }
	}
	

	start_timer();
	
#ifdef AVS3
	percent = 0.;
	delta = 1./(float)num_voxels;
	ipercent = 0;
	AVSmodule_status("rendering voxels",ipercent);
#endif
	for (i=0;i<num_voxels;i++)
	{
	/* transform the control points to screen space from the
	   canonical view volume */

	    if (input_type == TRICUBIC)
	    {
		transform_cps((voxel_list+(*(voxel_indeces+i)))->x,
			      (voxel_list+(*(voxel_indeces+i)))->y,
			      (voxel_list+(*(voxel_indeces+i)))->z);

		render_voxel((voxel_list+(*(voxel_indeces+i))),*img,size,rgba,alpha_buf,fast,i,cubic_interp,zbuf,opacity_correction_table,throttle,min_dimension,macro_apply,anti);
	    }
	    else /* curvilinear */
	    {
		make_tricubic_voxel(&t_voxel,cvoxel_list+voxel_indeces[i],inf,num_points,beta);
		transform_cps(t_voxel.x,
			      t_voxel.y,
			      t_voxel.z);

		render_voxel(&t_voxel,*img,size,rgba,alpha_buf,fast,i,cubic_interp,zbuf,opacity_correction_table,throttle,min_dimension,macro_apply,anti);
	    }
#ifdef AVS3
	    percent += delta;
	    ipercent = (int)(percent*100.0);
	    AVSmodule_status("rendering voxels",ipercent);
#endif
	}
    }

    stop_and_print_timer();
    
    /* display the hull, if requested */
    if (show_hull)
    {
	if (input_type == TRICUBIC)
	    render_hull(inf,*img,size,alpha_buf,cubic_interp,zbuf);
	else /* type is CURVILINEAR */
	    render_chull(inf,*img,size,alpha_buf,cubic_interp,zbuf,beta);
    }
    
    /* need to do a final composite of image with alpha buffer */
    matte_image(*img,alpha_buf,size);


/* IAC CODE CHANGE :     free((char *)alpha_buf); */
     free(alpha_buf);

/* IAC CODE CHANGE :     free((char *)rgba); */
     free(rgba);

/* IAC CODE CHANGE :     free((char *)zbuf); */
     free(zbuf);
    
    last_voxel_type = input_type;

#ifdef STARDENT
    destroy_tables();
#endif

    return(1);
}

render_voxel(vlist,img,size,rgba,ab,fast,i,cubic_flag,zbuf,oct,throttle,min_d,
	     macro_apply,anti)
int i;
Voxel *vlist;
AVSfield_float *img;
int size;  /* of image, assumed square */
float *rgba;
float *ab;
int fast;
int cubic_flag;
float *zbuf;
float *oct;
float *throttle;
int min_d;
int macro_apply;
int anti;
{
    matrix4x4 xm[4],ym[4],zm[4],dm[4];

    /* do the rendering */

    if (fast)
	render_cps(vlist,size,img,rgba,ab);
    else if (cubic_flag == 1) /* use tricubic forward differencing */
	fwd_diff_voxel(vlist,size,img,rgba,ab,cubic_flag,zbuf,oct,throttle,min_d,macro_apply,anti);
    else
	fwd_diff_linear_voxel(vlist,size,img,rgba,ab,zbuf,oct,throttle,min_d,macro_apply,anti);
    
    return(1);
}


copy_control_points(f,px,py,pz,d,x,y,z)
AVSfield *f;
matrix4x4 *px,*py,*pz,*d;
{
    int i,j,k;
    float *pt;
    int num_pts;
    int row_offset,slice_offset;

    row_offset = f->dimensions[0];
    slice_offset = f->dimensions[0] * f->dimensions[1];
    num_pts = f->dimensions[0] * f->dimensions[1] * f->dimensions[2];

    /* do x points */
    pt = f->points + z*slice_offset*3 + y*row_offset*3 + x*3;
    for(k=0;k<4;k++)
	for (i=0;i<4;i++)
	{
	    for (j=0;j<4;j++)
		(px+k)->m[j][i] = *(pt+j + row_offset*i + slice_offset*k);
	}

    /* do y points */
    pt += num_pts;
    for(k=0;k<4;k++)
	for (i=0;i<4;i++)
	{
	    for (j=0;j<4;j++)
		(py+k)->m[j][i] = *(pt+j + row_offset*i + slice_offset*k);
	}

    /* do z points */
    pt += num_pts;
    for(k=0;k<4;k++)
	for (i=0;i<4;i++)
	    for (j=0;j<4;j++)
		(pz+k)->m[j][i] = *(pt+j + row_offset*i + slice_offset*k);

    /* do data */
    pt = f->field_union.field_data_float_u +
	z*slice_offset*3 + y*row_offset*3 + x*3;

    
    for(k=0;k<4;k++)
	for (i=0;i<4;i++)
	    for (j=0;j<4;j++)
		(d+k)->m[j][i] = *(pt+j + row_offset*i + slice_offset*k);
}

set_up_matrices(cp,xp,mb,mbt)
matrix4x4 *cp,*xp,*mb,*mbt;
{
    /* from foley and vd...*/
    /* compute matrix product of mb*cp*mbt, return result in xp. */
    
    identity_4x4(xp);
    mmul_4x4(xp,mb);
    mmul_4x4(xp,cp);
    mmul_4x4(xp,mbt);
}
convert_cmap(cm,rgba)
AVScolormap *cm;
float *rgba;
{
    int i;
    
    for (i=0;i<cm->size;i++)
    {
	hsv_to_rgb((rgba+i*4),(rgba+i*4+1),(rgba+i*4+2),*(cm->hue+i),*(cm->saturation+i),*(cm->value+i));
	*(rgba+i*4+3) = *(cm->alpha+i);
    }
}

set_up_view_matrix(view,size)
matrix4x4 *view;
int size;
{
    identity_4x4(view);
    view->m[1][1] = view->m[0][0] = (float)(size-1)/2.0;
    view->m[3][0] = view->m[3][1] = (float)(size-1)/2.0;
    /* don't worry about z. */
}

transform_cps(cx,cy,cz)
matrix4x4 *cx,*cy,*cz;
/**
  * assume control points consist of 3 parallel 4x4x4 arrays.
**/
{
    int i,j,k;
    vector4 t,u;
    for (i=0;i<4;i++)
    {
	for (j=0;j<4;j++)
	{
	    for (k=0;k<4;k++)
	    {
		t.v[0] = (cx+i)->m[j][k];
		t.v[1] = (cy+i)->m[j][k];
		t.v[2] = (cz+i)->m[j][k];
		t.v[3] = 1.0;
		vector_matrix_mult_4(&t,&view,&u);
		(cx+i)->m[j][k] = u.v[0];
		(cy+i)->m[j][k] = u.v[1];
		(cz+i)->m[j][k] = u.v[2];
	    }
	}
    }
}


mapping_function(r,g,b,a,d,rgba)
float *rgba;
float *r,*g,*b,*a;
double *d;
{
    float t;
    int i;
    
    t = (*d - Map_min) * Map_scale;
    if ( t < 0.)
	t = 0.;
    else if (t > Map_size)
	t = Map_size;
    i = (int)t;
    i *= 4; /* index into rgba table */
    *r = *(rgba+i);
    *g = *(rgba+i+1);
    *b = *(rgba+i+2);
    *a = *(rgba+i+3);
}

setup_map(cm)
AVScolormap *cm;
{
    Map_min = cm->lower;
    Map_scale = (float)(cm->size - 1) /(cm->upper - cm->lower);
    Map_size = cm->size-1;
}

matte_image(img,alpha_buf,size)
AVSfield_float *img;
float *alpha_buf;
int size;
{
    int i,j,k;
/*    unsigned char *im; */
    float *im;
    float *f,fi;

    im = img->data;
    f = alpha_buf;
    for (i=0;i<size;i++)
	for (j=0;j<size;j++,f++)
	{
	    im++; /* skip alpha portion of image */
	    for (k=0;k<3;k++,im++)
	    {
		fi = *im;
		/* took out if (fi <= 1.0) */
		fi = fi * *f;
		*im = fi;
	    }
	}
}

#define CLIP_LIMIT 63

clip_voxel(cx,cy,cz,size)
matrix4x4 *cx,*cy,*cz;
int size;
{
    float *d;
    int count_in;
    int i,j,k;
    float zero,fsize;

    zero = 0.0;
    fsize = (float)(size-1);
 
    count_in = 0; 
    d = &(cx->m[0][0]);
    for (k=0;k<4;k++)
	for (j=0;j<4;j++)
	    for(i=0;i<4;i++,d++)
		if ((*d >= zero) && (*d <= fsize))
		    count_in++;
#if 0    
    if (some_in == 0)
	return(1); /* it's out of bounds */
#endif
    if (count_in < CLIP_LIMIT)
	return(1);  /* it's mostly out of bounds */
    
    count_in = 0; 
    d = &(cy->m[0][0]);
    for (k=0;k<4;k++)
	for (j=0;j<4;j++)
	    for(i=0;i<4;i++,d++)
		if ((*d >= zero) && (*d <= fsize))
		    count_in++;
    
    if (count_in < CLIP_LIMIT)
	return(1); /* it's mostly out of bounds */

    return(0);
}

/**
  * this routine will take the average of the x,y,z points for the
  * voxel, and data, and just composite one dot into the img buffer.
**/

render_cps(vlist,size,img,rgba,ab)
Voxel *vlist;
int size; /* of image -- it's a square */
AVSfield_float *img;
float *rgba;
float *ab;
{
    float x,y,d; 
    float fraction = 1.0;
    matrix4x4 *cx,*cy,*cz,*dv;
    int i,j,k;

    cx = vlist->x;
    cy = vlist->y;
    cz = vlist->z;
    dv = vlist->d;

    if (clip_voxel(cx,cy,cz,size))
    {
	fprintf(stderr," renderhull -- clipping voxel. \n");
	return;
    }

    for (k=0;k<4;k++)
	for (j=0;j<4;j++)
	    for (i=0;i<4;i++)
	    {
		x = (cx+k)->m[i][j];
		y = (cy+k)->m[i][j];
		d = (dv+k)->m[i][j];
		alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
	    }

#if 0
    /* do the eight corners of the voxel */
    /* 0,0,0 */
    x = (cx+0)->m[0][0];
    y = (cy+0)->m[0][0];
    d = (dv+0)->m[0][0];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 1,0,0 */
    x = (cx+0)->m[3][0];
    y = (cy+0)->m[3][0];
    d = (dv+0)->m[3][0];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 0,1,0 */
    x = (cx+0)->m[0][3];
    y = (cy+0)->m[0][3];
    d = (dv+0)->m[0][3];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 1,1,0 */
    x = (cx+0)->m[3][3];
    y = (cy+0)->m[3][3];
    d = (dv+0)->m[3][3];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 0,0,1 */
    x = (cx+3)->m[0][0];
    y = (cy+3)->m[0][0];
    d = (dv+3)->m[0][0];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 1,0,1 */
    x = (cx+3)->m[3][0];
    y = (cy+3)->m[3][0];
    d = (dv+3)->m[3][0];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 0,1,1 */
    x = (cx+3)->m[0][3];
    y = (cy+3)->m[0][3];
    d = (dv+3)->m[0][3];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
    /* 1,1,1 */
    x = (cx+3)->m[3][3];
    y = (cy+3)->m[3][3];
    d = (dv+3)->m[3][3];
    alpha_composite(&x,&y,&d,img,rgba,ab,size,&fraction);
#endif
    
}

alpha_composite(x,y,d,img,rgba,ab,size,fraction)
float *x,*y,*d;
float *rgba;
float *ab,*fraction;
int size;
AVSfield_float *img;
{
    float *p;
    float *a;
    float r,g,b,alpha;
    double df;
    float alpha_w;
    float old;
    int ix,iy;
    int offset;
    
    /** convert from data space to color space, w/opacity **/

    df = *d;
    mapping_function(&r,&g,&b,&alpha,&df,rgba);
    
    /* have alpha, need to do opacity correction. rows represent
       alpha bins, while columns represent subdivision levels. */

    offset = ((int)(*y))*size + (int)(*x);
    a = ab + offset;

    p = img->data + ((int)(*y))*size*4 + ((int)(*x))*4;

    if (*a >= 1.0) 
	return;

    alpha_w = alpha;

	/* do red */
    old = *(p+1);
    old = r * alpha + old*(1.-alpha);
    old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
    *(p+1) = old;
    
	/* do green */
    old = *(p+2);
    old = g * alpha + old*(1.-alpha);
    old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
    *(p+2) = old;
    
    /* do blue */
    old = *(p+3);
    old = b * alpha + old*(1.-alpha);
    old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
    *(p+3) = old;

    *a = *a + (1.0- *a)*alpha_w;  
    
    if (*a > 1.0)
	*a = 1.0;
    else if (*a < 0.)
	*a = 0.;
}

build_root_table(table,size)
double *table;
int size;
{
    extern double sqrt();
    double s;
    int i;

    for (i=0;i<size;i++)
    {
	s = (double)i;
	*(table+i) = sqrt(s);
    }
    
}

transform_vec(v)
vector4 *v;
{
    vector4 t;
    vector_matrix_mult_4(v,&view,&t);
    vec4_copy(v,&t);
}

