/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>

build_opacity_correction(table,alpha_res,layers)
float *table;
int alpha_res,layers;
{
    double *alphas,*sizes,*phi;
    double minus_one = -1.;
    double e;
    int i,j;
    extern double pow(),exp(),log();

    e = exp(1.0);

    alphas = (double *)malloc(sizeof(double)*(alpha_res+1));
    sizes = (double *)malloc(sizeof(double)*layers);
    phi = (double *)malloc(sizeof(double)*(alpha_res+1));

    for (i=0;i<=alpha_res;i++)
	alphas[i] = (double)i/(double)alpha_res;
    for (i=0;i<layers;i++)
	sizes[i] = 1./(double)(i+1);
    for (i=0;i<alpha_res;i++)
	phi[i] = -1.  * log(1. - alphas[i]);
    phi[alpha_res] = e;
    for (i=0;i<alpha_res;i++)
	phi[i] = (phi[i] < 0.) ? 0. : (phi[i] > e) ? e : phi[i];

    /**
      * in this table, rows represent each alpha bin, while
      * columns represent the alpha value used if subdividing
      * a layer into "column" uniform-thickness chunks.
    **/
    
    for (i=0;i<=alpha_res;i++)
	for (j=0;j<layers;j++)
	    table[i*layers+j] = 1. -  exp(-1. * phi[i] * sizes[j]);


/* IAC CODE CHANGE :     free((char *)alphas); */
     free(alphas);

/* IAC CODE CHANGE :     free((char *)layers); */
     free(layers);

/* IAC CODE CHANGE :     free((char *)phi); */
     free(phi);
}
