/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce renderhull.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  renderhull.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  renderhull.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     renderhull.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
renderhull.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	415-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include "matrix.h"

#define EPSILON 0.01
    
static matrix4x4 control_points_x[4],control_points_y[4],control_points_z[4],
    data_values[4];
    
render_hull(inf,img,size,alpha_buf,cubic_interp,zbuf)
AVSfield *inf;
AVSfield_float *img;
int size;
float *alpha_buf;
int cubic_interp;
float *zbuf;
{
    int ivoxels,jvoxels,kvoxels;
    int i,j,k,l;
    vector4 bx,by,bz;
    
    ivoxels = (inf->dimensions[0]+2)/3 - 1;
    jvoxels = (inf->dimensions[1]+2)/3 - 1;
    kvoxels = (inf->dimensions[2]+2)/3 - 1;

    k=0;
    j=0;
    for(i=0;i<ivoxels;i++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[0].m[l][0];
	    by.v[l] = control_points_y[0].m[l][0];
	    bz.v[l] = control_points_z[0].m[l][0];
	}
	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }

    k=0;j=jvoxels-1;
    for (i=0;i<ivoxels;i++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[0].m[l][3];
	    by.v[l] = control_points_y[0].m[l][3];
	    bz.v[l] = control_points_z[0].m[l][3];
	}
	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }

    k=kvoxels-1;
    j=0;
    for (i=0;i<ivoxels;i++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[3].m[l][0];
	    by.v[l] = control_points_y[3].m[l][0];
	    bz.v[l] = control_points_z[3].m[l][0];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }

    k=kvoxels-1;
    j=jvoxels-1;
    for (i=0;i<ivoxels;i++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[3].m[l][3];
	    by.v[l] = control_points_y[3].m[l][3];
	    bz.v[l] = control_points_z[3].m[l][3];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
	
    k=0;
    i=0;
    for (j=0;j<jvoxels;j++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[0].m[0][l];
	    by.v[l] = control_points_y[0].m[0][l];
	    bz.v[l] = control_points_z[0].m[0][l];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    
    k=0;
    i=ivoxels-1;
    for (j=0;j<jvoxels;j++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[0].m[3][l];
	    by.v[l] = control_points_y[0].m[3][l];
	    bz.v[l] = control_points_z[0].m[3][l];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    k=kvoxels-1;
    i=0;
    for (j=0;j<jvoxels;j++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[3].m[0][l];
	    by.v[l] = control_points_y[3].m[0][l];
	    bz.v[l] = control_points_z[3].m[0][l];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    k=kvoxels-1;
    i=ivoxels-1;
    for (j=0;j<jvoxels;j++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[3].m[3][l];
	    by.v[l] = control_points_y[3].m[3][l];
	    bz.v[l] = control_points_z[3].m[3][l];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    i=0;
    j=0;
    for (k=0;k<kvoxels;k++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[l].m[0][0];
	    by.v[l] = control_points_y[l].m[0][0];
	    bz.v[l] = control_points_z[l].m[0][0];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    i=ivoxels-1;
    j=0;
    for (k=0;k<kvoxels;k++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[l].m[3][0];
	    by.v[l] = control_points_y[l].m[3][0];
	    bz.v[l] = control_points_z[l].m[3][0];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    i=0;
    j=jvoxels-1;
    for (k=0;k<kvoxels;k++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[l].m[0][3];
	    by.v[l] = control_points_y[l].m[0][3];
	    bz.v[l] = control_points_z[l].m[0][3];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
    }
    i=ivoxels-1;
    j=jvoxels-1;
    for (k=0;k<kvoxels;k++)
    {
	copy_control_points(inf,control_points_x,control_points_y,
			    control_points_z,data_values,i,j,k);
	transform_cps(control_points_x,control_points_y,control_points_z);
	for (l=0;l<4;l++)
	{
	    bx.v[l] = control_points_x[l].m[3][3];
	    by.v[l] = control_points_y[l].m[3][3];
	    bz.v[l] = control_points_z[l].m[3][3];
	}

	render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);

    }

}

render_bez_curve(bx,by,bz,img,size,alpha_buf,cubic_interp,zbuf)
vector4 *bx,*by,*bz;
AVSfield_float *img;
int size;
float *alpha_buf;
int cubic_interp;
float *zbuf;
{
    vector4 nbx,nby,nbz;
    int bez_renderable();

    if (bez_renderable(bx,by))
	composite_pixel(bx,by,img,size,alpha_buf,bz,zbuf);
    else
    {
	/* do left half of curve. */

	if (cubic_interp != 0)
	{
	    nbx.v[0] = bx->v[0];
	    nbx.v[1] = 0.5 * (bx->v[0]+bx->v[1]);
	    nbx.v[2] = 0.25 * (bx->v[0] + 2.*bx->v[1] + bx->v[2]);
	    nbx.v[3] = 0.125 * (bx->v[0] + 3.*bx->v[1] + 3.*bx->v[2] + bx->v[3]);
	
	    nby.v[0] = by->v[0];
	    nby.v[1] = 0.5 * (by->v[0]+by->v[1]);
	    nby.v[2] = 0.25 * (by->v[0] + 2.*by->v[1] + by->v[2]);
	    nby.v[3] = 0.125 * (by->v[0] + 3.*by->v[1] + 3.*by->v[2] + by->v[3]);
	    nbz.v[0] = bz->v[0];
	    nbz.v[1] = 0.5 * (bz->v[0]+bz->v[1]);
	    nbz.v[2] = 0.25 * (bz->v[0] + 2.*bz->v[1] + bz->v[2]);
	    nbz.v[3] = 0.125 * (bz->v[0] + 3.*bz->v[1] + 3.*bz->v[2] + bz->v[3]);
	}
	else
	{
	    nbx.v[1] = nbx.v[0] = bx->v[0];
	    nbx.v[2] = nbx.v[3] = 0.5 * (bx->v[0] + bx->v[3]);
/*	    nbx.v[2] = nbx.v[1] = 0.5 * (nbx.v[0]+nbx.v[3]); */
	    
	    nby.v[1] = nby.v[0] = by->v[0];
	    nby.v[2] = nby.v[3] = 0.5 * (by->v[0] + by->v[3]);
/*	    nby.v[1] = nby.v[2] = 0.5 * (nby.v[0] + nby.v[3]); */
	    
	    nbz.v[1] = nbz.v[0] = bz->v[0];
	    nbz.v[2] = nbz.v[3] = 0.5 * (bz->v[0] + bz->v[3]);
	} 

	render_bez_curve(&nbx,&nby,&nbz,img,size,alpha_buf,cubic_interp,zbuf);

	/* do right half of curve */
	if (cubic_interp != 0)
	{
	    nbx.v[3] = bx->v[3];
	    nbx.v[2] = 0.5 * (bx->v[2]+bx->v[3]);
	    nbx.v[1] = 0.25 * (bx->v[1] + 2.*bx->v[2] + bx->v[3]);
	    nbx.v[0] = 0.125 * (bx->v[0] + 3.*bx->v[1] + 3.*bx->v[2] + bx->v[3]);
	
	    nby.v[3] = by->v[3];
	    nby.v[2] = 0.5 * (by->v[2]+by->v[3]);
	    nby.v[1] = 0.25 * (by->v[1] + 2.*by->v[2] + by->v[3]);
	    nby.v[0] = 0.125 * (by->v[0] + 3.*by->v[1] + 3.*by->v[2] + by->v[3]);
	    nbz.v[3] = bz->v[3];
	    nbz.v[2] = 0.5 * (bz->v[2]+bz->v[3]);
	    nbz.v[1] = 0.25 * (bz->v[1] + 2.*bz->v[2] + bz->v[3]);
	    nbz.v[0] = 0.125 * (bz->v[0] + 3.*bz->v[1] + 3.*bz->v[2] + bz->v[3]);
	}
	else
	{
	    nbx.v[1] = nbx.v[0] = bx->v[3];
	    nbx.v[2] = nbx.v[3] = 0.5 * (bx->v[0] + bx->v[3]);
/*	    nbx.v[1] = nbx.v[2] = 0.5 * (nbx.v[0] + nbx.v[3]); */
	    nby.v[1] = nby.v[0] = by->v[3];
	    nby.v[2] = nby.v[3] = 0.5 * (by->v[0] + by->v[3]);
/*	    nby.v[1] = nby.v[2] = 0.5 * (nby.v[0]+nby.v[3]); */
	    nbz.v[1] = nbz.v[0] = bz->v[3];
	    nbz.v[2] = nbz.v[3] = 0.5 * (bz->v[0] + bz->v[3]);
	}
	
	render_bez_curve(&nbx,&nby,&nbz,img,size,alpha_buf,cubic_interp,zbuf);
    }
}

#define BIGNUM 6666666.666
#define SMALLNUM -666666.666
#define LIMIT 0.4
int
bez_renderable(bx,by)
vector4 *bx,*by;
{
    float minx,miny,maxx,maxy;
    int i;

    minx = BIGNUM;
    maxx = SMALLNUM;
    for (i=0;i<4;i++)
    {
	if (bx->v[i] < minx)
	    minx = bx->v[i];
	if (bx->v[i] > maxx)
	    maxx = bx->v[i];
    }
    miny = BIGNUM;
    maxy = SMALLNUM;
    for (i=0;i<4;i++)
    {
	if (by->v[i] < miny)
	    miny = by->v[i];
	if (by->v[i] > maxy)
	    maxy = by->v[i];
    }

    if ((fabs(maxx - minx) < LIMIT) && (fabs(maxy - miny) < LIMIT))  
	return(1);
    else
	return(0);
}

#define INV_SCALE 1./255.
#define SCALE 255.0

composite_pixel(bx,by,img,size,alpha_buf,bz,zbuf)
vector4 *bx,*by;
AVSfield_float *img;
int size;
float *alpha_buf;
vector4 *bz;
float *zbuf;
{
    int x,y;
/*    unsigned char *p; */
    float *p;
    float old;
    float *a;
    float r,g,b;
    float alpha = 1.0;
    int offset;
    float z;

    r = g= b = 0.8;

    x = (int)(0.5 * (bx->v[0] + bx->v[3]));
    y = (int)(0.5 * (by->v[0] + by->v[3]));
    z = (bz->v[0] > bz->v[3]) ? bz->v[0] : bz->v[3]; 
    if ((x > 0) && (x < size -1) && (y > 0) && (y<size-1)) /* crude clipping */
    {

	offset = y*size;
	p = img->data + offset*4 + x*4;
    
	a = alpha_buf + offset + x;

	/* decide whether to just write the pixel or composite it
	   based on the value in the z buffer. */

	if (z-EPSILON <= *(zbuf + offset + x))
	{
	    /* just write the pixel -- no need to composite */
	    *(p+1) = r;
	    *(p+2) = g;
	    *(p+3) = b;
	    *a = alpha;
	}
	else /* must composite the pixel */
	{
	    if (*a >= 1.0)
		return;
    
	    /* do red */
	    old = *(p+1);
	    old = old * *a + r*(1.-*a);
	    *(p+1) = old;
    
	    /* do green */
	    old = *(p+2);
	    old = old * *a + g*(1.-*a);
	    *(p+2) = old;
    
	    /* do blue */
	    old = *(p+3);
	    old = old * *a + b*(1.-*a);
	    *(p+3) = old;
	    
	    *a = *a + (1.0- *a)*alpha;
	}
    }
}

render_chull(inf,img,size,alpha_buf,cubic_interp,zbuf,beta)
AVSfield *inf;
AVSfield_float *img;
int size;
float *alpha_buf;
int cubic_interp;
float *zbuf;
float *beta;
{
    int i,j,k,m;
    float d[3],p1[3],p2[3],p3[3]; 
    vector4 bp[4];
    float *x,*y,*z;
    int npoints;
    vector4 bx,by,bz;
#define NSEGS 12
    int base[NSEGS],offset[NSEGS],limits[NSEGS];

    npoints = inf->dimensions[0]*inf->dimensions[1]*inf->dimensions[2];

    base[0] = 0;
    base[1] = inf->dimensions[0]*(inf->dimensions[1]-1);
    base[2] = inf->dimensions[0]*inf->dimensions[1]*(inf->dimensions[2]-1);
    base[3] = npoints - inf->dimensions[0];
    base[4] = 0;
    base[5] = inf->dimensions[0]-1;
    base[6] = (inf->dimensions[0]*inf->dimensions[1]*(inf->dimensions[2]-1));
    base[7] = (inf->dimensions[0]*inf->dimensions[1]*(inf->dimensions[2]-1)) + inf->dimensions[0]-1;
    base[8] = 0;
    base[9] = inf->dimensions[0]-1;
    base[10] = inf->dimensions[0]*(inf->dimensions[1]-1);
    base[11] = inf->dimensions[0]*(inf->dimensions[1]-1) + inf->dimensions[0]-1;

    offset[0] = 1;
    offset[1] = 1;
    offset[2] = 1;
    offset[3] = 1;
    offset[4] = inf->dimensions[0];
    offset[5] = inf->dimensions[0];
    offset[6] = inf->dimensions[0];
    offset[7] = inf->dimensions[0];
    offset[8] = inf->dimensions[0]*inf->dimensions[1];
    offset[9] = inf->dimensions[0]*inf->dimensions[1];
    offset[10] = inf->dimensions[0]*inf->dimensions[1];
    offset[11] = inf->dimensions[0]*inf->dimensions[1];

    limits[0] = inf->dimensions[0];
    limits[1] = inf->dimensions[0];
    limits[2] = inf->dimensions[0];
    limits[3] = inf->dimensions[0];
    limits[4] = inf->dimensions[1];
    limits[5] = inf->dimensions[1];
    limits[6] = inf->dimensions[1];
    limits[7] = inf->dimensions[1];
    limits[8] = inf->dimensions[2];
    limits[9] = inf->dimensions[2];
    limits[10] = inf->dimensions[2];
    limits[11] = inf->dimensions[2];

    for (m=0;m<NSEGS ;m++)
    {
	/* do u at v=w=0 */
	x = inf->points + base[m];
	y = x + npoints;
	z = y + npoints;

	for (i=0;i<limits[m]-1;i++,x+=offset[m],y+=offset[m],z+=offset[m])
	{
	    p2[0] = *x;
	    p2[1] = *y;
	    p2[2] = *z;

	    for (j=0;j<3;j++)
		bp[0].v[j] = p2[j];
	    bp[0].v[3] = 1.0;

	    if (i==0)
	    {
		p1[0] = *x;
		p1[1] = *y;
		p1[2] = *z;
	    }
	    else
	    {
		p1[0] = *(x-offset[m]);
		p1[1] = *(y-offset[m]);
		p1[2] = *(z-offset[m]);
	    }

	    if (i == limits[m]-1)
	    {
		p3[0] = *x;
		p3[1] = *y;
		p3[2] = *z;
	    }
	    else
	    {
		p3[0] = *(x+offset[m]);
		p3[1] = *(y+offset[m]);
		p3[2] = *(z+offset[m]);
	    }
	    catmull_rom_v(d,p1,p2,p3,beta);
	
	    for (j=0;j<3;j++)
		bp[1].v[j] = d[j];
	    bp[1].v[3] = 1.0;
#if 0
	    for (j=0;j<3;j++)
		p2[j] = p3[j];
	    for (j=0;j<3;j++)
		p3[j] = p1[j];
#endif
	    for (j=0;j<3;j++)
		p1[j] = p2[j];
	    for (j=0;j<3;j++)
		p2[j] = p3[j];
	    for (j=0;j<3;j++)
		p3[j] = p1[j];
	
	    if (i == limits[m]-2)
	    {

		p1[0] = *(x+offset[m]);
		p1[1] = *(y+offset[m]);
		p1[2] = *(z+offset[m]);
#if 0
		p1[0] = *(x);
		p1[1] = *(y);
		p1[2] = *(z);
#endif
	    }
	    else
	    {
		p1[0] = *(x+2*offset[m]);
		p1[1] = *(y+2*offset[m]);
		p1[2] = *(z+2*offset[m]);
	    }
	
	    catmull_rom_v(d,p1,p2,p3,beta);
	    
	    for (j=0;j<3;j++)
		bp[2].v[j] = d[j];
	    bp[2].v[3] = 1.0;
	
	    for (j=0;j<3;j++)
		bp[3].v[j] = p2[j];
	    bp[3].v[3] = 1.0;

	    for (j=0;j<4;j++)
		transform_vec(bp+j);

	    for (j=0;j<4;j++)
	    {
		bx.v[j] = bp[j].v[0];
		by.v[j] = bp[j].v[1];
		bz.v[j] = bp[j].v[2];
	    }
	    render_bez_curve(&bx,&by,&bz,img,size,alpha_buf,cubic_interp,zbuf);
	}
    }
}
