/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
#include <stdio.h>
#include "matrix.h"

#define NUM_PTS 16
static vector4 points[NUM_PTS] =
{
    { 0.0, 0.0, 0.0, 1.0 },
    { 5.0, -5.0, 0.0, 1.0},
    { 10.0, -5.0, 0.0, 1.0},
    {15.0, 0.0, 0.0, 1.0},
    {-5.0, 5.0, 0.0, 1.0},
    {2.5,2.5,0.0,1.0},
    {12.5,2.5,0.0,1.0},
    {20.0, 5.0,0.0,1.0},
    {-5.0,10.0,0.0,1.0},
    {2.5,12.5,0.0,1.0},
    {12.5,12.5,0.0,1.0},
    {20.0,10.0,0.0,1.0},
    {0.0,15.0,0.0,1.0},
    {5.0,15.0,0.0,1.0},
    {10.0,15.0,0.0,1.0},
    {15.0,15.0,0.0,1.0}
};

static double data[NUM_PTS] =
{
    0.,1.,2.,3.,
    0.,1.,2.,3.,
    0.,1.,2.,3.,
    0.,1.,2.,3.,
};

#define DEGREES_TO_RADIANS(a) ((a)/180.0 * 3.14159)
main()
{
    matrix4x4 xlate1,scale,xlate2,xl;
    matrix4x4 yrot,cat,cat2;
    double y_angle,d_angle;
    int steps=13;
    int i,j;
    vector4 base_pts[NUM_PTS];
    extern double cos(),sin();
    vector4 yrot90[NUM_PTS],yrot180[NUM_PTS],yrot270[NUM_PTS];

    identity_4x4(&xlate1);
    xlate1.m[3][0] = -7.5;
    xlate1.m[3][1] = -7.5;  /* xlate center of patch to 0,0,0 */

    identity_4x4(&scale);
    scale.m[1][1] = scale.m[0][0] = 1./25.0;  /* unit radius */

    identity_4x4(&xlate2);
    xlate2.m[3][0] = 2.0;
    
    identity_4x4(&cat);
    mmul_4x4(&cat,&xlate1);
    mmul_4x4(&cat,&scale);
    mmul_4x4(&cat,&xlate2);

    for (i=0;i<NUM_PTS;i++)
	vector_matrix_mult_4(points+i,&cat,base_pts+i);

    y_angle = 0.0;
    d_angle = 90.0;

    dump_pts(base_pts,data);

    identity_4x4(&xl);
    xl.m[3][2] = 1.0;
    for (i=0;i<NUM_PTS;i++)
	vector_matrix_mult_4(base_pts+i,&xl,yrot90+i);
    dump_pts(yrot90,data);
    
    identity_4x4(&yrot);
    y_angle = 90.0;
    yrot.m[0][0] = cos(DEGREES_TO_RADIANS(y_angle));
    yrot.m[0][2] = sin(DEGREES_TO_RADIANS(y_angle));
    yrot.m[2][0] = -1. * sin(DEGREES_TO_RADIANS(y_angle));;
    yrot.m[2][2] = cos(DEGREES_TO_RADIANS(y_angle));
    identity_4x4(&xl);
    xl.m[3][0] = 1.0;
    for (i=0;i<NUM_PTS;i++)
    {
	vector_matrix_mult_4(base_pts+i,&yrot,yrot90+i);
	vector_matrix_mult_4(yrot90+i,&xl,yrot180+i);
    }
    dump_pts(yrot180,data);
    dump_pts(yrot90,data);
    
    
    identity_4x4(&xl);
    xl.m[3][0] = -1.0;
    for (i=0;i<NUM_PTS;i++)
    {
	vector_matrix_mult_4(base_pts+i,&yrot,yrot90+i);
	vector_matrix_mult_4(yrot90+i,&xl,yrot180+i);
    }
    dump_pts(yrot180,data);
    
    identity_4x4(&yrot);
    y_angle = 180.0;
    yrot.m[0][0] = cos(DEGREES_TO_RADIANS(y_angle));
    yrot.m[0][2] = sin(DEGREES_TO_RADIANS(y_angle));
    yrot.m[2][0] = -1. * sin(DEGREES_TO_RADIANS(y_angle));;
    yrot.m[2][2] = cos(DEGREES_TO_RADIANS(y_angle));
    identity_4x4(&xl);
    xl.m[3][2] = 1.0;
    for (i=0;i<NUM_PTS;i++)
    {
	vector_matrix_mult_4(base_pts+i,&yrot,yrot90+i);
	vector_matrix_mult_4(yrot90+i,&xl,yrot180+i);
    }
    dump_pts(yrot180,data);
    dump_pts(yrot90,data);

    identity_4x4(&xl);
    xl.m[3][2] = -1.0;
    for (i=0;i<NUM_PTS;i++)
    {
	vector_matrix_mult_4(base_pts+i,&yrot,yrot90+i);
	vector_matrix_mult_4(yrot90+i,&xl,yrot180+i);
    }
    dump_pts(yrot180,data);
    
    identity_4x4(&yrot);
    y_angle = 270.0;
    yrot.m[0][0] = cos(DEGREES_TO_RADIANS(y_angle));
    yrot.m[0][2] = sin(DEGREES_TO_RADIANS(y_angle));
    yrot.m[2][0] = -1. * sin(DEGREES_TO_RADIANS(y_angle));;
    yrot.m[2][2] = cos(DEGREES_TO_RADIANS(y_angle));
    identity_4x4(&xl);
    xl.m[3][0] = -1.0;
    for (i=0;i<NUM_PTS;i++)
    {
	vector_matrix_mult_4(base_pts+i,&yrot,yrot90+i);
	vector_matrix_mult_4(yrot90+i,&xl,yrot180+i);
    }
    dump_pts(yrot180,data);
    dump_pts(yrot90,data);
}

dump_pts(bp,d)
vector4 *bp;
double *d;
{
    int i;
    for (i=0;i<NUM_PTS;i++)
	fprintf(stdout," %f %f %f %f\n",(bp+i)->v[0],(bp+i)->v[1],(bp+i)->v[2],*(d+i));
}
