/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include "matrix.h"

#define BETA 1.15
#define BETA2 BETA*BETA
#define BETA3 BETA*BETA*BETA
    
catmull_rom_scalar(d1,d2,d3,dd,ds)
double *d1,*d2,*d3,*dd,*ds;
{
    *dd = *d2 + (*d3 - *d1) * 0.5;
    *ds = *d2 - (*d3 - *d1) * 0.5;
}
catmull_rom_4vector(p1,p2,p3,sp,dp)
float *p1,*p2,*p3,*sp,*dp;
{
    double p1p3[4],p1p2[4],p2p3[4];
    double m1,m2,m3;
    float u[3];
    int i;
    extern double sqrt();

    for (i=0;i<4;i++)
	p1p3[i] = p3[i] - p1[i];
    m1 = sqrt(p1p3[0]*p1p3[0] + p1p3[1]*p1p3[1] + p1p3[2]*p1p3[2] +
	      p1p3[3]*p1p3[3]);

    for (i=0;i<4;i++)
	p1p2[i] = p2[i] - p1[i];
    m2 = sqrt(p1p2[0]*p1p2[0] + p1p2[1]*p1p2[1] + p1p2[2]*p1p2[2] +
	      p1p2[3]*p1p2[3]);

    for (i=0;i<4;i++)
	p2p3[i] = p3[i] - p2[i];
    m3 = sqrt(p2p3[0]*p2p3[0] + p2p3[1]*p2p3[1] + p2p3[2]*p2p3[2] +
	      p2p3[3]*p2p3[3]);

    for (i=0;i<4;i++)
	u[i] = p1p3[i] / m1;  /* get the unit vector */
#if 0    
    for (i=0;i<3;i++)
	sp[i] = p2[i] - u[i] * m2 * 0.3333334;

    for (i=0;i<3;i++)
	dp[i] = p2[i] + u[i] * m3 * 0.3333334;
#endif
    for (i=0;i<4;i++)
	sp[i] = p2[i] - u[i] * m2 * m2 / m1 * 0.5;

    for (i=0;i<4;i++)
	dp[i] = p2[i] + u[i] * m3 * m3 / m1 * 0.5;
    
}

/** 0.1655 is 1/2 * 1/3 **/

catmull_rom(d,s1,s2,s3,n,mask,beta)
float *d,*s1,*s2,*s3;
int n,*mask;
float *beta;
{
    register int i;
    for (i=0;i<n;i++)
	if (mask[i])
	    d[i] = s2[i] + *beta*0.1655*(s3[i]-s1[i]);
}

catmull_rom_v(d,s1,s2,s3,beta)
float *d,*s1,*s2,*s3,*beta;
{
    int i;
    for (i=0;i<3;i++)
	d[i] = s2[i] + *beta*0.1655*(s3[i]-s1[i]);
}

/** 0.041666 is 1/24 **/
#define INDEX(a,b,c) (a + (b<<2) + (c<<4))

catmull_rom_2partial(p0,p1,p2,p3,p4,p5,p6,n,mask,coords,vol_d,xsize,xysize,beta)
int p0[64][3],p1[64][3],p2[64][3],p3[64][3],p4[64][3],p5[64][3],p6[64][3],*mask;
matrix4x4 *coords;
float *vol_d,*beta;
{
    int i,ii,jj,kk;
    double part2;
    double p;
    double b2;

    b2 = *beta;
    b2 = b2*b2;
    
    for (i=0;i<n;i++)
	if (mask[i])
	{
	    ii = i & 0x03;
	    jj = (i & 0x0c) >> 2;
	    kk = (i & 0x030) >> 4;
	    
	    p = coords[p0[i][2]].m[p0[i][0]][p0[i][1]];

	    part2 = ((vol_d[p3[i][0] + p3[i][1]*xsize + p3[i][2]*xysize]) -
		     (vol_d[p4[i][0]+p4[i][1]*xsize+p4[i][2]*xysize]) -
		     (vol_d[p5[i][0]+p5[i][1]*xsize+p5[i][2]*xysize]) +
		     (vol_d[p6[i][0]+p6[i][1]*xsize+p6[i][2]*xysize]));
/*	    part2 *= 0.04166666; /*  1/24 */
	    part2 *= b2*0.027777;  /*  1/36 */

	    coords[kk].m[ii][jj] = p + part2;
	    coords[kk].m[ii][jj] += (coords[p1[i][2]].m[p1[i][0]][p1[i][1]] - p);
	    coords[kk].m[ii][jj] += (coords[p2[i][2]].m[p2[i][0]][p1[i][1]] - p);
	}
}

catmull_rom_3partial(p0,p1,p2,p3,p21,p22,p23,pa,pb,pc,pd,
		     pe,pf,pg,ph,voxel_d,volume_d,xsize,xysize,i,beta)
int p0[64][3],p1[64][3],p2[64][3],p3[64][3],p21[64][3],p22[64][3],
    p23[64][3],pa[64][3],pb[64][3],pc[64][3],pd[64][3],pe[64][3],pf[64][3],
    pg[64][3], ph[64][3];
float *volume_d;
matrix4x4 *voxel_d;
int xsize,xysize,i;
float *beta;
{
    double mixed3,mixed2,partial;
    double p;
    float *t;
    double b3;
    int ii,jj,kk;

    /* compute the third order mixed partial. */

    b3 = *beta;
    b3 = b3*b3*b3;

    p = voxel_d[p0[i][2]].m[p0[i][0]][p0[i][1]];

    mixed3 =  (volume_d[pa[i][0] + pa[i][1]*xsize + pa[i][2]*xysize]
		    - volume_d[pb[i][0] + pb[i][1]*xsize + pb[i][2]*xysize]);
    mixed3 -= (volume_d[pc[i][0] + pc[i][1]*xsize + pc[i][2]*xysize]
		     - volume_d[pd[i][0] + pd[i][1]*xsize + pd[i][2]*xysize]);
    mixed3 -= (volume_d[pe[i][0] + pe[i][1]*xsize + pe[i][2]*xysize]
		     - volume_d[pf[i][0] + pf[i][1]*xsize + pf[i][2]*xysize]);
    mixed3 +=  (volume_d[pg[i][0] + pg[i][1]*xsize + pg[i][2]*xysize]
		     - volume_d[ph[i][0] + ph[i][1]*xsize + ph[i][2]*xysize]);
/*    mixed3 *= 0.03125; 1/32 */
    mixed3 *= b3*0.004629629;  /* 1/27 * 1/8 */

    mixed2 = (voxel_d[p21[i][2]].m[p21[i][0]][p21[i][1]] - p);
    mixed2 += (voxel_d[p22[i][2]].m[p22[i][0]][p22[i][1]] - p);
    mixed2 += (voxel_d[p23[i][2]].m[p23[i][0]][p23[i][1]] - p);

    partial = (voxel_d[p1[i][2]].m[p1[i][0]][p1[i][1]] - p);
    partial += (voxel_d[p2[i][2]].m[p2[i][0]][p2[i][1]] - p);
    partial += (voxel_d[p3[i][2]].m[p3[i][0]][p3[i][1]] - p);

    ii = i & 0x3;
    jj = (i & 0x0c) >> 2;
    kk = (i & 0x030) >> 4;

/*    voxel_d[kk].m[ii][jj] = p + partial + mixed2 + mixed3;  */
    voxel_d[kk].m[ii][jj] = p + partial + 0.1111 * mixed2;
}
