/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce fwd_diff.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  fwd_diff.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  fwd_diff.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     fwd_diff.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
fwd_diff.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/


#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include "matrix.h"
#include "opacity.h"
#include "voxel.h"

static double X[1024],Y[1024],Z[1024],D[1024];
static double Xlast[1024],Ylast[1024];

#if 0
#define MAX_STEPS 256
static double Xs[MAX_STEPS*MAX_STEPS],
    Ys[MAX_STEPS*MAX_STEPS],
    Zs[MAX_STEPS*MAX_STEPS],
    Ds[MAX_STEPS*MAX_STEPS];
#endif

static dmatrix4x4 Mbez =
{
    {
    { -1.,3.,-3.,1.},
    { 3.,-6.,3.,0.},
    { -3.,3.,0.,0.},
    { 1.,0.,0.,0.}
    }
};

#define MAX(a,b) ((a) >= (b)) ? (a) : (b)
#define MIN_STEPS 1.0

fwd_diff_linear_voxel(v,size,img,rgba,ab,zbuf,oct,throttle,min_d,ma,anti)
Voxel *v;  /* the voxel to render. */
AVSfield_float *img;  /* pointer to output image */
float *rgba;  /* colormap of rgba tuples */
float *ab;    /* alpha buffer */
int size; /* of output image, assumed square. */
float *zbuf;
float *oct; /* opacity correction table */
float *throttle;
int min_d;
int ma;
int anti;
{
    double x[2][2][2],y[2][2][2],z[2][2][2],d[2][2][2];
    dmatrix4x4 temp[4];
    double usteps,vsteps,u_eps,v_eps,wsteps,w_eps;
    int iw_steps,iu_steps,iv_steps;

    if (clip_voxel(v->x,v->y,v->z,size))
    {
	fprintf(stderr," clipping voxel. \n");
	return;
    }
    
    set_min_max(v);

    compute_voxel_nsteps(v,&usteps,&vsteps,&wsteps,throttle);
    
    iu_steps = usteps;
    u_eps = 1./usteps;
    
    iv_steps = vsteps;
    v_eps = 1./vsteps;
    
    iw_steps = wsteps;
    w_eps = 1./wsteps;
 
    /* compute #of parametric steps in w direction */

    build_L(x,v->x,&u_eps,&v_eps,&w_eps);
    build_L(y,v->y,&u_eps,&v_eps,&w_eps);
    build_L(z,v->z,&u_eps,&v_eps,&w_eps);
    build_L(d,v->d,&u_eps,&v_eps,&w_eps);

    trilin_interp_voxel(x,y,z,d,img,size,rgba,ab,iu_steps,iv_steps,iw_steps,zbuf,oct,min_d,ma,anti);
}

build_L(x,v,xeps,yeps,weps)
double x[2][2][2];
matrix4x4 *v;
double *xeps,*yeps,*weps;
{
    double x0[2][2],x1[2][2],x2[2][2];
    double t1,t2;
    int i,j;

    x0[0][0] = v[0].m[0][0];
    x0[1][0] = (v[0].m[3][0] - v[0].m[0][0])* *xeps;
    x0[0][1] = (v[0].m[0][3] - v[0].m[0][0])* *yeps;
    t1 = (v[0].m[3][3] - v[0].m[0][3])* *xeps;
    t2 = (v[0].m[3][0] - v[0].m[0][0]) * *xeps;
    x0[1][1] = (t1 - t2) * *yeps;
/*    x0[1][1] = ((v[0].m[3][3] - v[0].m[0][3])* *xeps -
		(v[0].m[3][0] - v[0].m[0][0]) * *xeps) * *yeps; */

    x1[0][0] = v[3].m[0][0];
    x1[1][0] = (v[3].m[3][0] - v[3].m[0][0])* *xeps;
    x1[0][1] = (v[3].m[0][3] - v[3].m[0][0])* *yeps;
    x1[1][1] = ((v[3].m[3][3] - v[3].m[0][3])* *xeps -
		(v[3].m[3][0] - v[3].m[0][0]) * *xeps) * *yeps;

    for (j=0;j<2;j++)
	for (i=0;i<2;i++)
	    x2[i][j] = (x1[i][j] - x0[i][j]) * *weps;

    for (j=0;j<2;j++)
	for (i=0;i<2;i++)
	    x[i][j][0] = x0[i][j];
    for (j=0;j<2;j++)
	for (i=0;i<2;i++)
	    x[i][j][1] = x2[i][j];
}

trilin_interp_voxel(x,y,z,d,img,size,rgba,ab,un,vn,wn,zbuf,oct,min_d,ma,anti)
double x[2][2][2],y[2][2][2],z[2][2][2],d[2][2][2];
AVSfield_float *img;
int size;
int un,vn,wn;  /* number of steps in each direction */
float *rgba,*ab;
float *zbuf;
float *oct;
int min_d;
int ma;
int anti;
{
    int i,j,k,l,m;
    double xv[2],yv[2],zv[2],dv[2];
    double xm[2][2],ym[2][2],zm[2][2],dm[2][2];
    double xlast,ylast,dx,dy,xl,yl;
    int xd,yd,xd2,yd2,xplast,yplast,jlast;

    for (k=0;k<wn;k++) 
    {
	for (l=0;l<2;l++)
	{
	    for (m=0;m<2;m++)
	    {
		xm[l][m] = x[l][m][0];
		ym[l][m] = y[l][m][0];
		zm[l][m] = z[l][m][0];
		dm[l][m] = d[l][m][0];
	    }
	}
	
	for (j=0;j<=vn;j++)
	{
/*	    if ((j==vn) || (j==0)) */
	    if (j==vn)
		jlast = 1;
	    else
		jlast = 0;
		
	    for (l=0;l<2;l++)
	    {
		xv[l] = xm[l][0];
		yv[l] = ym[l][0];
		zv[l] = zm[l][0];
		dv[l] = dm[l][0];
	    }
#ifdef SUN
	    load_lvectors_(X,xv,&un);
	    load_lvectors_(Y,yv,&un);
	    load_lvectors_(D,dv,&un);
	    load_lvectors_(Z,zv,&un);
#elif STARDENT
	    LOAD_LVECTORS(X,xv,&un);
	    LOAD_LVECTORS(Y,yv,&un);
	    LOAD_LVECTORS(D,dv,&un);
	    LOAD_LVECTORS(Z,zv,&un);
#endif
	    xlast = X[0];
	    ylast = Y[0];
	    
	    xplast = X[un];
	    yplast = Y[un];
	    
	    for (i=0;i<=un;i++)
	    {
		dx = X[i];
		dy = Y[i];
#if 0		
		xd = (int)dx - (int)xlast;
		yd = (int)dy - (int)ylast;
		
		if ((i!=0)&&(xd == 0) && (yd == 0))
		{
		    xlast = dx;
		    ylast = dy;
		}
		else
		{
#endif
		    xd = (int)dx - xplast;
		    yd = (int)dy - yplast; 
		    
		    if ((xd == 0) && (yd == 0) || jlast)
			f_alpha_composite(X+i,Y+i,D+i,img,rgba,ab,size,Z+i,zbuf,oct,un,vn,wn,min_d,ma,anti,1);
		    else 
			f_alpha_composite(X+i,Y+i,D+i,img,rgba,ab,size,Z+i,zbuf,oct,un,vn,wn,min_d,ma,anti,0); 
/*		    xlast = dx; 
		    ylast = dy; */
		}
/*	    } */
#if 0	    
	    memcpy((char *)Xlast,(char *)X,sizeof(double)*un);
	    memcpy((char *)Ylast,(char *)Y,sizeof(double)*un);
#endif
	    xm[0][0] += xm[0][1];
	    ym[0][0] += ym[0][1];
	    zm[0][0] += zm[0][1];
	    dm[0][0] += dm[0][1];
	    xm[1][0] += xm[1][1];
	    ym[1][0] += ym[1][1];
	    zm[1][0] += zm[1][1];
	    dm[1][0] += dm[1][1];
	}  /* end v-loop */


	for (l=0;l<2;l++)
	{
	    for (m=0;m<2;m++)
	    {
		x[m][l][0] += x[m][l][1];
		y[m][l][0] += y[m][l][1];
		z[m][l][0] += z[m][l][1];
		d[m][l][0] += d[m][l][1];
	    }
	}
    }
}

int
fwd_diff_voxel(v,size,img,rgba,ab,cubic_flag,zbuf,oct,throttle,min_d,ma,anti)
Voxel *v;  /* the voxel to render. */
AVSfield_float *img;  /* pointer to output image */
float *rgba;  /* colormap of rgba tuples */
float *ab;    /* alpha buffer */
int size; /* of output image, assumed square. */
int cubic_flag;
float *zbuf;
float *oct; /* opacity correction table */
float *throttle;
int min_d;
int ma;
int anti;
{
    int zsteps,the_steps;
    double usteps,vsteps,wsteps;
    int i,iw_steps,iu_steps,iv_steps;
    extern double sqrt(),ceil(),floor();
    double u_eps,v_eps,w_eps;
    dmatrix4x4 Ex[4],Ey[4],Ez[4],Data[4],temp[4];

    if (clip_voxel(v->x,v->y,v->z,size))
    {
	fprintf(stderr," clipping voxel. \n");
	return;
    }

    /**
      * NOTE: in the following section of code, we compute the
      * parametric step size.  this code is a hack.  the way
      * it should be done is outlined in Kaufman's 87 siggraph
      * paper where the first and second derivatives are employed.
      * the run time of this code is directly related to this step
      * size.  the larger the step size, the quicker the code, but
      * at the increased liklihood of "holes" in the volume.
    **/
    
    set_min_max(v);
    
    compute_voxel_nsteps(v,&usteps,&vsteps,&wsteps,throttle);
    
    iu_steps = usteps;
    u_eps = 1./usteps;
    
    iv_steps = vsteps;
    v_eps = 1./vsteps;
    
    iw_steps = wsteps;
    w_eps = 1./wsteps;

    copy_pile_f_to_d(v->x,temp);
    build_E(Ex,iu_steps,iv_steps,iw_steps,temp);
    
    copy_pile_f_to_d(v->y,temp);
    build_E(Ey,iu_steps,iv_steps,iw_steps,temp);
    
    copy_pile_f_to_d(v->z,temp);
    build_E(Ez,iu_steps,iv_steps,iw_steps,temp);
    
    copy_pile_f_to_d(v->d,temp);
    build_E(Data,iu_steps,iv_steps,iw_steps,temp);

    fwd_interp_voxel(Ex,Ey,Ez,Data,img,size,rgba,ab,iu_steps,iv_steps,iw_steps,zbuf,oct,min_d,ma,anti);
}

#define UNDEFINED 6666666.6
#define ABS(a) ((a) < 0) ? (-1*(a)) : a

    
fwd_interp_voxel(Ex,Ey,Ez,Data,img,size,rgba,ab,un,vn,wn,zbuf,oct,min_d,ma,anti)
dmatrix4x4 *Ex,*Ey,*Ez,*Data;
AVSfield_float *img;
int size;
int un,vn,wn;  /* number of steps in each direction */
float *rgba,*ab;
float *zbuf;
float *oct;
int min_d;
int anti;
{
    int i,j,k,l;
    int foo;
    int xd,yd,xd2,yd2,xplast,yplast,jlast;
    double t;
    dvector4 xv,yv,dv,zv;
    dmatrix4x4 xm,ym,dm,zm;
    double xlast,ylast;
    double dx,dy;
    int uedge;

    for (l=0;l<wn;l++)
    {
	dcopy_4x4(&xm,Ex);
	dcopy_4x4(&ym,Ey);
	dcopy_4x4(&zm,Ez);
	dcopy_4x4(&dm,Data);
	
	for (j=0;j<=vn;j++)
	{
	    if ((j==0) || (j==vn) || (j==1))
		jlast = 1;
	    else
		jlast = 0;
	    
	    /* load 1d vectors */
	    for (k=0;k<4;k++)
		xv.v[k] = xm.m[k][0];
	    for (k=0;k<4;k++)
		yv.v[k] = ym.m[k][0];
	    for (k=0;k<4;k++)
		zv.v[k] = zm.m[k][0];
	    for (k=0;k<4;k++)
		dv.v[k] = dm.m[k][0];

#ifdef SUN
	    load_dvectors_(X,xv.v,&un);
	    load_dvectors_(Y,yv.v,&un);
	    load_dvectors_(Z,zv.v,&un);
	    load_dvectors_(D,dv.v,&un);
#elif STARDENT
	    LOAD_DVECTORS(X,xv.v,&un);
	    LOAD_DVECTORS(Y,yv.v,&un);
	    LOAD_DVECTORS(Z,zv.v,&un);
	    LOAD_DVECTORS(D,dv.v,&un);
#endif
	    
	    xlast = X[0];
	    ylast = Y[0];

	    for (i=0;i<=un;i++)
	    {
		if ((i==0) || (i==un))
		    uedge = 1;
		else
		    uedge = 0;

		if (uedge || jlast)
		    f_alpha_composite(X+i,Y+i,D+i,img,rgba,ab,size,Z+i,zbuf,oct,un,vn,wn,min_d,ma,anti,1);
		else 
		    f_alpha_composite(X+i,Y+i,D+i,img,rgba,ab,size,Z+i,zbuf,oct,un,vn,wn,min_d,ma,anti,0);
	    }
	    update_matrix(&xm);
	    update_matrix(&ym);
	    update_matrix(&zm);
	    update_matrix(&dm);
	}
	update_pile(Ex);
	update_pile(Ey);
	update_pile(Ez);
	update_pile(Data);
    }
}

update_pile(p)
dmatrix4x4 *p;
{
    int i,j,k;

    for (k=0;k<3;k++)
	for (j=0;j<4;j++)
	    for (i=0;i<4;i++)
		p[k].m[i][j] += p[k+1].m[i][j];
}

update_matrix(m)
dmatrix4x4 *m;
{
    int i,j;

    for (j=0;j<3;j++)
	for (i=0;i<4;i++)
	    m->m[i][j] += m->m[i][j+1];

}

update_vec(v)
dvector4 *v;
{
    int i;

    for (i=0;i<3;i++)
	v->v[i] += v->v[i+1];
}

build_E(m,usteps,vsteps,wsteps,d)
dmatrix4x4 *m;  /* the destination for the forward difference matrix */
dmatrix4x4 *d;  /* the location of the geometry or data */
int usteps,vsteps,wsteps;
{
#if 0
    dmatrix4x4 temp[4],temp2[4];
    dmatrix4x4 *tu,*tv,*tw;
    double x,x2,x3,acc1,acc2;
    int i,j,k;
    extern dmatrix4x4 *fwd_diff_table;
#endif
    dmatrix4x4 tu,tv,temp[4],temp2[4],tw;
    double x,x2,x3,acc1,acc2;
    int i,j,k;

    x = 1./(double)usteps;
    x2 = x * x;
    x3 = x2 * x;

    dclear_4x4(&tu);
    tu.m[0][3] = 1.0;
    tu.m[1][0] = x3;
    tu.m[1][1] = x2;
    tu.m[1][2] = x;
    tu.m[2][0] = 6.0 * x3;
    tu.m[2][1] = 2.0 * x2;
    tu.m[3][0] = 6.0 * x3;
    dmmul_4x4(&tu,&Mbez);

    x = 1./(double)vsteps;
    x2 = x*x;
    x3 = x2*x;
    
    dclear_4x4(&tv);
    tv.m[0][3] = 1.0;
    tv.m[1][0] = x3;
    tv.m[1][1] = x2;
    tv.m[1][2] = x;
    tv.m[2][0] = 6.0 * x3;
    tv.m[2][1] = 2.0 * x2;
    tv.m[3][0] = 6.0 * x3;
    dmmul_4x4(&tv,&Mbez);
    

    x = 1./(double)wsteps;
    x2 = x*x;
    x3 = x2*x;
    
    dclear_4x4(&tw);
    tw.m[0][3] = 1.0;
    tw.m[1][0] = x3;
    tw.m[1][1] = x2;
    tw.m[1][2] = x;
    tw.m[2][0] = 6.0 * x3;
    tw.m[2][1] = 2.0 * x2;
    tw.m[3][0] = 6.0 * x3;
    dmmul_4x4(&tw,&Mbez);

    for (i=0;i<4;i++)
    {
	dcopy_4x4(temp+i,&tu);
	dmmul_4x4(temp+i,d+i);

	dcopy_4x4(temp2+i,&tv);
	dtranspose_4x4(temp2+i);
	dmmul_4x4(temp+i,temp2+i);
    }

    for (k=0;k<4;k++)
    {
	for (j=0;j<4;j++)
	{
	    for (i=0;i<4;i++)
	    {
		acc1 = tw.m[k][0] * temp[0].m[i][j];
		acc2 = tw.m[k][1] * temp[1].m[i][j];
		acc1+=acc2;
		acc2 = tw.m[k][2] * temp[2].m[i][j];
		acc1+=acc2;
		acc2 = tw.m[k][3] * temp[3].m[i][j];
		acc1+= acc2;
		m[k].m[i][j] = acc1;
#if 0
		m[k].m[i][j] = t.m[k][0] * temp[0].m[i][j] +
		    t.m[k][1] * temp[1].m[i][j] +
			t.m[k][2] * temp[2].m[i][j] +
			    t.m[k][3] * temp[3].m[i][j];
#endif
	    }
	}
    }
    
#if 0    
    tu = fwd_diff_table+(usteps-1);
    tv = fwd_diff_table+(vsteps-1);
    tw = fwd_diff_table+(wsteps-1);
    
    for (i=0;i<4;i++)
    {
	dcopy_4x4(temp+i,tu);
	dmmul_4x4(temp+i,d+i);

	dcopy_4x4(temp2+i,tv);
	dtranspose_4x4(temp2+i);
	dmmul_4x4(temp+i,temp2+i);
    }

    for (k=0;k<4;k++)
    {
	for (j=0;j<4;j++)
	{
	    for (i=0;i<4;i++)
	    {
		acc1 = tw->m[k][0] * temp[0].m[i][j];
		acc2 = tw->m[k][1] * temp[1].m[i][j];
		acc1+=acc2;
		acc2 = tw->m[k][2] * temp[2].m[i][j];
		acc1+=acc2;
		acc2 = tw->m[k][3] * temp[3].m[i][j];
		acc1+= acc2;
		m[k].m[i][j] = acc1;
#if 0
		m[k].m[i][j] = t.m[k][0] * temp[0].m[i][j] +
		    t.m[k][1] * temp[1].m[i][j] +
			t.m[k][2] * temp[2].m[i][j] +
			    t.m[k][3] * temp[3].m[i][j];
#endif
	    }
	}
    }
#endif
    
}

set_min_max(v)
Voxel *v;
{
    float barf;
    /* find min Z value. */
#ifdef STARDENT
    F_PILE_MIN(&(v->z[0].m[0][0]),&barf);
#elif SUN
    f_pile_min_(&(v->z[0].m[0][0]),&barf);
#endif
    v->min_extent[2] = barf;

    /* find min X value. */
#ifdef STARDENT
    F_PILE_MIN(&(v->x[0].m[0][0]),&barf);
#elif SUN
    f_pile_min_(&(v->x[0].m[0][0]),&barf);
#endif
    v->min_extent[0] = barf;

    /* find min Y value */
#ifdef STARDENT
    F_PILE_MIN(&(v->y[0].m[0][0]),&barf);
#elif SUN
    f_pile_min_(&(v->y[0].m[0][0]),&barf);
#endif
    v->min_extent[1] = barf;

    /* find Max x value */
#ifdef STARDENT
    F_PILE_MAX(&(v->x[0].m[0][0]),&barf);
#elif SUN
    f_pile_max_(&(v->x[0].m[0][0]),&barf);
#endif
    v->max_extent[0] = barf;

    /* find max y value */
#ifdef STARDENT
    F_PILE_MAX(&(v->y[0].m[0][0]),&barf);
#elif SUN
    f_pile_max_(&(v->y[0].m[0][0]),&barf);
#endif
    v->max_extent[1] = barf;

    /* find max Z value */
#ifdef STARDENT
    F_PILE_MAX(&(v->z[0].m[0][0]),&barf);
#elif SUN
    f_pile_max_(&(v->z[0].m[0][0]),&barf);
#endif
    v->max_extent[2] = barf;
}


#define FUDGE 1.5
/** the following is 1/pi **/
#define SCALE_FACTOR 0.3183 
/* #define SCALE_FACTOR 0.25 */
#define BLUR_SCALE 0.3333

f_alpha_composite(x,y,d,img,rgba,ab,size,z,zbuf,oct,un,vn,wn,min_d,ma,anti,blur)
double *x,*y,*d,*z;
float *rgba;
float *ab;
int size;
AVSfield_float *img;
float *zbuf;
float *oct;
int un,vn,wn;
int min_d;
int ma;
int anti;
int blur;
{
    float *p;
    float *a;
    float r,g,b,alpha;
    float alpha_w;
    float old;
    int ix,iy;
    int offset;
    extern double pow(),sqrt();
    double sx,sy;
    double frac_x,frac_y;
    double d_alpha;
    int dx,dy;
    int i,num_loops;
    int xc[9],yc[9];
    double w[9];

    if (anti != 0)
    {
	sx = *x;
	sy = *y;
    
	frac_x = sx - (int)sx;
	frac_y = sy - (int)sy;
	/** the following code disperses the sample energy over up
	  to 9 output pixels. **/
	xc[0] = (int) *x;
	yc[0] = (int) *y;
	if (blur)
	    w[0] = BLUR_SCALE*BLUR_SCALE;
	else   
	    w[0] = 1.0;

	xc[1] = xc[0]+1;
	yc[1] = yc[0];
	w[1] = frac_x;

	xc[2] = xc[0]-1;
	yc[2] = yc[0];
	w[2] = 1. - frac_x;

	xc[3] = xc[0];
	yc[3] = yc[0]+1;
	w[3] = frac_y;

	xc[4] = xc[0]+1;  /* used the +1 computation for ease of reading */
	yc[4] = yc[0]+1;
	w[4] = frac_x * frac_y;

	xc[5] = xc[0]-1;
	yc[5] = yc[0]+1;
	w[5] = (1. - frac_x)*frac_y;

	xc[6] = xc[0];
	yc[6] = yc[0]-1;
	w[6] = 1.-frac_y;

	xc[7] = xc[0]-1;
	yc[7] = yc[0]-1;
	w[7] = (1. - frac_x) * (1 - frac_y);

	xc[8] = xc[0]+1;
	yc[8] = yc[0]-1;
	w[8] = (1. - frac_y) * frac_x;

	for (i=0;i<9;i++)
	    w[i] *= SCALE_FACTOR;

	num_loops=9;
    }
    else
    {
	xc[0] = (int)*x;
	yc[0] = (int)*y;
	if (blur)
	    w[0] = BLUR_SCALE;  /* scale alpha */
	else
	    w[0] = 1.;
	num_loops=1;
    }

    /** convert from data space to color space, w/opacity **/
    
    mapping_function(&r,&g,&b,&alpha,d,rgba);
    
    /* have alpha, need to do opacity correction. rows represent
       alpha bins, while columns represent subdivision levels. */

    if (ma)  /* user has selected macro alpha correction */
    {
	offset = (int)(alpha * (double)(ALPHA_RESOLUTION-1));  /* the correct row. */
	offset *= MAX_LAYERS;
	if (min_d >= MAX_LAYERS)
	    min_d = MAX_LAYERS-1;
	alpha = *(oct+min_d+offset);
    }
    
    offset = (int)(alpha * (double)(ALPHA_RESOLUTION-1));  /* the correct row. */
    offset *= MAX_LAYERS;
    if (wn >= MAX_LAYERS)
	wn = MAX_LAYERS-1;
    alpha = *(oct+wn+offset);
    
    for (i=0;i<num_loops;i++)
    {
	offset = yc[i]*size + xc[i];
	a = ab + offset;

	if (*z < *(zbuf+offset))
	    *(zbuf+offset) = *z;

	p = img->data + yc[i]*size*4 + xc[i]*4;

	if (*a >= 1.0) 
	    continue;


	if (blur)
	{
	    offset = (int)(alpha * (double)(ALPHA_RESOLUTION-1));
	    offset *= MAX_LAYERS;
	    alpha_w = *(oct+3+offset); /* say divide alpha over two steps. */
	}
	else
	    alpha_w = alpha * w[i];

	/* do red */
	old = *(p+1);
	old = r * alpha + old*(1.-alpha);
/*	old = (r*w[i]) * alpha_w + old*(1.-alpha_w); */
	old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
	/*    old = (old < 0.) ? 0.0 : old; */
	*(p+1) = old;
    
	/* do green */
	old = *(p+2);
	old = g * alpha + old*(1.-alpha);
/*	old = (g*w[i]) * alpha_w + old*(1.-alpha_w); */
	old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
	/*    old = (old < 0.) ? 0.0 : old; */
	*(p+2) = old;
    
	/* do blue */
	old = *(p+3);
/*	old = (b*w[i]) * alpha_w + old*(1.-alpha_w); */
	old = b * alpha + old*(1.-alpha);
	old = (old > 1.) ? 1.0 : (old < 0.) ? 0. : old;
	/*    old = (old < 0.) ? 0.0 : old; */
	*(p+3) = old;

	*a = *a + (1.0- *a)*alpha_w;  
    
	if (*a > 1.0)
	    *a = 1.0;
	else if (*a < 0.)
	    *a = 0.;
    }
}


copy_pile_f_to_d(f,d)
matrix4x4 *f;
dmatrix4x4 *d;
{
    int i,j,k;
    for (k=0;k<4;k++)
	for (j=0;j<4;j++)
	    for (i=0;i<4;i++)
		d[k].m[i][j] = f[k].m[i][j];
}


compute_voxel_nsteps(v,usteps,vsteps,wsteps,throttle)
Voxel *v;
double *usteps,*vsteps,*wsteps;
float *throttle;
{
    double tx,ty,zdiffs[4];
    int i;
    extern double *root_table;
    
    /* compute #of parametric steps in u direction */

    tx = (v->x[0].m[0][0] - v->x[0].m[3][0]);
    ty = (v->y[0].m[0][0] - v->y[0].m[3][0]);
    zdiffs[0] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[0].m[0][3] - v->x[0].m[3][3]);
    ty = (v->y[0].m[0][3] - v->y[0].m[3][3]);
    zdiffs[1] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[3].m[0][3] - v->x[3].m[3][3]);
    ty = (v->y[3].m[0][3] - v->y[3].m[3][3]);
    zdiffs[2] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[3].m[0][0] - v->x[3].m[3][0]);
    ty = (v->y[3].m[0][0] - v->y[3].m[3][0]);
    zdiffs[3] = root_table[(int)(tx*tx + ty*ty)];

    *usteps = MIN_STEPS;
    for (i=0;i<4;i++)
	if (zdiffs[i] > *usteps)
	    *usteps = zdiffs[i];

    if (*usteps > MIN_STEPS)
	*usteps *= *throttle;
    *usteps = (*usteps < MIN_STEPS) ? MIN_STEPS : *usteps;
    
    /* compute #of parametric steps in v direction */

    tx = (v->x[0].m[0][0] - v->x[0].m[0][3]);
    ty = (v->y[0].m[0][0] - v->y[0].m[0][3]);
    zdiffs[0] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[0].m[3][0] - v->x[0].m[3][3]);
    ty = (v->y[0].m[3][0] - v->y[0].m[3][3]);
    zdiffs[1] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[3].m[0][0] - v->x[3].m[0][3]);
    ty = (v->y[3].m[0][0] - v->y[3].m[0][3]);
    zdiffs[2] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[3].m[3][0] - v->x[3].m[3][3]);
    ty = (v->y[3].m[3][0] - v->y[3].m[3][3]);
    zdiffs[3] = root_table[(int)(tx*tx + ty*ty)];

    *vsteps = MIN_STEPS;
    for (i=0;i<4;i++)
	if (zdiffs[i] > *vsteps)
	    *vsteps = zdiffs[i];

    if (*vsteps > MIN_STEPS)
	*vsteps *= *throttle;
    *vsteps = (*vsteps < MIN_STEPS) ? MIN_STEPS : *vsteps;
    
    tx = (v->x[0].m[0][0] - v->x[3].m[0][0]);
    ty = (v->y[0].m[0][0] - v->y[3].m[0][0]);
    zdiffs[0] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[0].m[3][0] - v->x[3].m[3][0]);
    ty = (v->y[0].m[3][0] - v->y[3].m[3][0]);
    zdiffs[1] = root_table[(int)(tx*tx + ty*ty)];
    
    tx = (v->x[0].m[0][3] - v->x[3].m[0][3]);
    ty = (v->y[0].m[0][3] - v->y[3].m[0][3]);
    zdiffs[2] = root_table[(int)(tx*tx + ty*ty)];

    tx = (v->x[0].m[3][3] - v->x[3].m[3][3]);
    ty = (v->y[0].m[3][3] - v->y[3].m[3][3]);
    zdiffs[3] = root_table[(int)(tx*tx + ty*ty)];

    *wsteps=MIN_STEPS; 
    for (i=0;i<4;i++)
	if (zdiffs[i] > *wsteps)
	    *wsteps = zdiffs[i];

    if (*throttle > 1.)
	*wsteps *= *throttle;    /* no throttle on wsteps !! */
    *wsteps = (*wsteps < MIN_STEPS) ? MIN_STEPS : *wsteps;
}

build_fwd_diff_table(fwd_diff_table,n)
dmatrix4x4 *fwd_diff_table;
{
    int i,j,k,l;
    dmatrix4x4 tu,tv,temp[4],temp2[4],tw;
    double x,x2,x3,acc1,acc2;


    /**
      * in this routine, for each step size 1/1,1/2,...1/n, we compute
      * the matrix product EM, where E is the basis matrix defined
      * in Kaufman's 87 siggraph paper, or foley&vandam, and M is
      * the bezier basis matrix.
    **/
#if 0
    for (l=1;l<=n;l++)
    {
	x = 1./(double)l;
	x2 = x * x;
	x3 = x2 * x;
	
	dclear_4x4(fwd_diff_table+(l-1));
	
	fwd_diff_table[l-1].m[0][3] = 1.0;
	fwd_diff_table[l-1].m[1][0] = x3;
	fwd_diff_table[l-1].m[1][1] = x2;
	fwd_diff_table[l-1].m[1][2] = x;
	fwd_diff_table[l-1].m[2][0] = 6.0 * x3;
	fwd_diff_table[l-1].m[2][1] = 2.0 * x2;
	fwd_diff_table[l-1].m[3][0] = 6.0 * x3;
	dmmul_4x4(fwd_diff_table+l-1,&Mbez);
    }
#endif
}
