/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
void hsv_to_rgb(r,g,b,h,s,v)
float h,s,v,*r,*g,*b;
{
    static hsv_to_pixel();
   
    hsv_to_pixel(r,g,b,h,s,v);
}

static
hsv_to_pixel(R,G,B,h,s,v)
float *R,*G,*B;
float h,s,v;
{
    float f, p, q, t;
    float r, g, b;
    float ht;
    int i;
 
/*  Make sure not to trash the input colormap */
    ht = h;

    if (v == 0.)
    {
	r=0.;
	g=0.;
	b=0.;
    }
    else
    {
	if (s == 0.)
	{
	    r = v;
	    g = v;
	    b = v;
	}
	else
	{
	    ht = ht * 6.0;
	    if (ht >= 6.0)
		ht = 0.0;
      
	    i = ht;
	    f = ht - i;
	    p = v*(1.0-s);
	    q = v*(1.0-s*f);
	    t = v*(1.0-s*(1.0-f));
      
 	    if (i == 0) 
	    {
		r = v;
		g = t;
		b = p;
	    }
	    else if (i == 1)
	    {
		r = q;
		g = v;
		b = p;
	    }
	    else if (i == 2)
	    {
		r = p;
		g = v;
		b = t;
	    }
	    else if (i == 3)
	    {
		r = p;
		g = q;
		b = v;
	    }
	    else if (i == 4)
	    {
		r = t;
		g = p;
		b = v;
	    }
	    else if (i == 5)
	    {
		r = v;
		g = p;
		b = q;
	    }
	}
    }
    *R = r;
    *G = g;
    *B = b;
#if 0
    ir = r*255.0;
    ig = g*255.0;
    ib = b*255.0;

    *rgb = (unsigned char)ia;
    *(rgb+1) = (unsigned char)ir;
    *(rgb+2) = (unsigned char)ig;
    *(rgb+3) = (unsigned char)ib;
#endif
}
