/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include "matrix.h"

vector_cross(a,b,c)
avs_vertex *a,*b,*c;
{
    float t1,t2;
#if 0
    c->v[0] = a->v[1]*b->v[2] - a->v[2]*b->v[1];
    c->v[1] = a->v[2]*b->v[0] - a->v[0]*b->v[2];
    c->v[2] = a->v[0]*b->v[1] - a->v[1]*b->v[0];
#endif
    t1 = a->v[1]*b->v[2];
    t2 = a->v[2]*b->v[1];
    c->v[0] = t1-t2;
    
    t1 = a->v[2]*b->v[0];
    t2 = a->v[0]*b->v[2];
    c->v[1] = t1-t2;

    t1 = a->v[0]*b->v[1];
    t2 = a->v[1]*b->v[0];
    c->v[2] = t1-t2;
}
vector_unit(a)
register avs_vertex *a;
{
    register float mag;
    extern double sqrt();
    mag = sqrt((a->v[0]*a->v[0]) + (a->v[1]*a->v[1]) + (a->v[2]*a->v[2]));
    if (mag != 0.0)
    {
	mag = 1.0/mag;
	a->v[0] = a->v[0] * mag;
	a->v[1] = a->v[1] * mag;
	a->v[2] = a->v[2] * mag;
    }
}

row_copy_to_vec(v,m,row)
vector4 *v;
matrix4x4 *m;
int row;
{
    int i;
    for (i=0;i<4;i++)
	v->v[i] = m->m[row][i];
}

vec_copy_to_row(v,m,row)
vector4 *v;
matrix4x4 *m;
int row;
{
    int i;
    for (i=0;i<4;i++)
	m->m[row][i] = v->v[i];
}

copy_4x4(a,b)
matrix4x4 *a,*b;
{
    int i,j;

    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    a->m[i][j] = b->m[i][j];
}


dcopy_4x4(a,b)
dmatrix4x4 *a,*b;
{
    int i,j;

    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    a->m[i][j] = b->m[i][j];
}

transpose_4x4(m)
matrix4x4 *m;
{
    matrix4x4 temp;
    int i,j;
    
    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    temp.m[i][j] = m->m[j][i];
    copy_4x4(m,&temp);
}

dtranspose_4x4(m)
dmatrix4x4 *m;
{
    dmatrix4x4 temp;
    int i,j;
    
    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    temp.m[i][j] = m->m[j][i];
    dcopy_4x4(m,&temp);
}

identity_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = ((i==j) ? 1. : 0.);
}
didentity_4x4(m)
dmatrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = ((i==j) ? 1. : 0.);
}


clear_4x4(m)
matrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = 0.;
}

dclear_4x4(m)
dmatrix4x4 *m;
{
    int i,j;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    m->m[i][j] = 0.;
}

vector_4_dot(v1,v2,d)
vector4 *v1,*v2;
float *d;
{
    float t=0;
    int i;

    for (i=0;i<4;i++)
	t += v1->v[i]*v2->v[i];
    *d = t;
}

mmul_4x4(a,b)
matrix4x4 *a,*b;  /* take product of a and b, put result in a */
{
    matrix4x4 tmp;
    int row,col;

    clear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}

dmmul_4x4(a,b)
dmatrix4x4 *a,*b;  /* take product of a and b, put result in a */
{
    dmatrix4x4 tmp;
    int row,col;

    dclear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}

dfmmul_4x4(a,b)
dmatrix4x4 *a;
matrix4x4 *b;  /* take product of a and b, put result in a */
{
    dmatrix4x4 tmp;
    int row,col;

    dclear_4x4(&tmp);

    for (row=0;row<4;row++)
    {
	for (col=0;col<4;col++)
	    tmp.m[row][col] = a->m[row][0]*b->m[0][col] +
		a->m[row][1]*b->m[1][col] + a->m[row][2]*b->m[2][col] +
		    a->m[row][3]*b->m[3][col];
    }
    for (row=0;row<4;row++)
	for (col=0;col<4;col++)
	    a->m[row][col] = tmp.m[row][col];
}


vector_matrix_mult_4(v,m,result)
vector4 *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<4;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<4;i++)
	    result->v[j] += v->v[i] * m->m[i][j];
    }
}
matrix_vector_mult_4(m,v,result)
vector4 *v,*result;
matrix4x4 *m;
{
    int i,j;

    for (j=0;j<4;j++)
    {
	result->v[j] = 0.;
	for (i=0;i<4;i++)
	    result->v[j] += v->v[i] * m->m[j][i];
    }
}

powervec_4(v,t)
vector4 *v;
float *t;
{ /* returns u^3 u^2 u 1. in a 4-vector. */
    float f;
    f = *t;
    v->v[3] = 1.;
    v->v[2] = f;
    f = f*f;
    v->v[1] = f;
    v->v[0] = f* *t;
}

print_matrix_4x4(m)
matrix4x4 *m;
{
    int i,j;
    
    for(i=0;i<4;i++)
    {
	for (j=0;j<4;j++)
	    fprintf(stderr," %lf ",m->m[i][j]);
	fprintf(stderr,"\n");
    }
    fprintf(stderr,"\n");

}

print_vector_4(v)
vector4 *v;
{
    int i;
    for (i=0;i<4;i++)
	fprintf(stderr," %lf ",v->v[i]);
    fprintf(stderr,"\n");
}

vec4_copy(dest,src)
vector4 *dest,*src;
{
    int i;
    for (i=0;i<4;i++)
	dest->v[i] = src->v[i];
}

vec_matrix_mult_positionwise(v,m)
vector4 *v;
matrix4x4 *m;
{
    int i,j;
    
    for(j=0;j<4;j++) /* do each column */
    {
	for (i=0;i<4;i++)
	    m->m[i][j] = m->m[i][j] * v->v[i];
    }
}
copy_vec_to_pile(w,t)
vector4 *w;
matrix4x4 *t;
{
    int i,j;
    int k;
    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    for (k=0;k<4;k++)
		(t+k)->m[i][j] = w->v[k];
}

matrix_pile_mult(m,p)
matrix4x4 *m,*p;
{
    int i;

    for (i=0;i<4;i++)
    {
#ifdef STARDENT
	/* use vectorized fortran code.. */
	M4_POS_MUL(&((p+i)->m[0][0]),&(m->m[0][0]));
#else
	matrix_matrix_mult_positionwise((p+i),m);
#endif
    }

}
matrix_matrix_mult_positionwise(m1,m2)
matrix4x4 *m1,*m2;
{
    int i,j;
    for (j=0;j<4;j++)
	for (i=0;i<4;i++)
	    m1->m[i][j] = m1->m[i][j] * m2->m[i][j];
}

pile_copy(src,dest)
matrix4x4 *src,*dest;
{
#ifdef STARDENT
    F_PILE_COPY(&((dest+0)->m[0][0]),&((src+0)->m[0][0]));
#elif SUN
    f_pile_copy_(&((dest+0)->m[0][0]),&((src+0)->m[0][0]));
#endif
}


sum_pile(p,new_value)
matrix4x4 *p;
float *new_value;
{
#ifdef STARDENT
    PILE_SUM(&(p->m[0][0]),new_value);
#elif SUN
    pile_sum_(&(p->m[0][0]),new_value);
#endif
}
#if 0
C      subroutine f_mult_sum_8(v1,v2,scalar)
C      float precision v1(1),v2(1),scalar

C      integer ii
C      scalar = 0.0
C      do ii=1,8
C         scalar = scalar + v1(i)*v2(i)
C      end do
C      return
C      end

F_MULT_SUM_8(v1,v2,s)
vector8 *v1,*v2;
float *s;
{
    int i;
    *s = 0.0;
    for (i=0;i<8;i++)
	*s += v1->v[i]*v2->v[i];
	
}

F_8VECT_MIN(zp,z_min)
vector8 *zp;
float *z_min;
{
    int i;
    register float *d,zm;

    
    d = zp->v;
    zm = 1000000000.0;
    for (i=0;i<8;i++,d++)
	if (*d < zm)
	    zm = *d;
    *z_min = zm;

}

F_8VECT_MAX(zp,z_min)
vector8 *zp;
float *z_min;
{
    int i;
    register float *d,zm;

    
    d = zp->v;
    zm = -100000000.0;
    for (i=0;i<8;i++,d++)
	if (*d > zm)
	    zm = *d;
    *z_min = zm;

}

#endif
