/**
  * the following two numbers are used to dimension out the
  * opacity correction table.  the MAX_LAYERS number indicates
  * the maximum number of subdivisions which will be allowed. this
  * number corresponds (more or less) to the length of the side of
  * a square which surrounds a single voxel. if you get "weird"
  * results with super-large voxels, up this value.
  * The alpha resolution
  * gives the coarseness in alpha.  1/256 should be sufficient.
  *
  * the MAX_LAYERS define also affect the construction of the foward difference
  * matrix tables.
**/
#define MAX_LAYERS 512
#define ALPHA_RESOLUTION 256

/**
  * the following size for the root table will support voxels up to
  * 256 pixels in length per side.  if large voxels start to not
  * get renderered, or appear "weird", and they are not being
  * clipped, up this value to
  * whatever seems appropriate.
**/
#define ROOT_TABLE_SIZE 65536
