/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

Author:  "insert name" (if users state on release form that they wish to
remain anonymous, a control number will be placed at this location)
Modifications:  Who modified, date modified ( so donor does not receive blame
if modifications made and passed on to others do not work as described)
******************************************************************************/
/*   
     This software is copyright (C) 1991,  Regents  of  the
University  of  California.   Anyone may reproduce split_voxel,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  split_voxel  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  split_voxel  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     split_voxel is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
split_voxel, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	415-486-6626
	ewbethel@lbl.gov
*/

#include <stdio.h>
#include "matrix.h"
#include "voxel.h"

#define ABS(a) ((a) < 0.0 ? (-1.0*(a)) : (a))
/* sun uses an ansi C compiler */
#ifdef SUN
static vector8 trilin_weights[8][8]=
{

	{1.,0.,0.,0.,0.,0.,0.,0.},
	{0.5,0.5,0.,0.,0.,0.,0.,0.},
	{0.5,0.,0.5,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.5,0.,0.,0.,0.5,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},

	{0.5,0.5,0.,0.,0.,0.,0.,0.},
	{0.,1.,0.,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.5,0.,0.5,0.,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.,0.5,0.,0.,0.,0.5,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	
	{0.5,0.,0.5,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.,1.,0.,0.,0.,0.,0.},
	{0.,0.,0.5,0.5,0.,0.,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.5,0.,0.,0.,0.5,0.},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.5,0.,0.5,0.,0.,0.,0.},
	{0.,0.,0.5,0.5,0.,0.,0.,0.},
	{0.,0.,0.,1.,0.,0.,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.5,0.,0.,0.,0.5},

	{0.5,0.,0.,0.,0.5,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.,0.,1.,0.,0.,0.},
	{0.,0.,0.,0.,0.5,0.5,0.,0.},
	{0.,0.,0.,0.,0.5,0.,0.5,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},

	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.,0.5,0.,0.,0.,0.5,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.,0.,0.5,0.5,0.,0.},
	{0.,0.,0.,0.,0.,1.,0.,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.5,0.,0.5},

	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.5,0.,0.,0.,0.5,0.},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.,0.5,0.,0.5,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.,1.,0.},
	{0.,0.,0.,0.,0.,0.,0.5,0.5},

	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.5,0.,0.,0.,0.5},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.5,0.,0.5},
	{0.,0.,0.,0.,0.,0.,0.5,0.5},
	{0.,0.,0.,0.,0.,0.,0.,1.}
};
#else
/* assume K&R C */
static vector8 trilin_weights[8][8]=
{
    {
	{1.,0.,0.,0.,0.,0.,0.,0.},
	{0.5,0.5,0.,0.,0.,0.,0.,0.},
	{0.5,0.,0.5,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.5,0.,0.,0.,0.5,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125}
    },
    {
	{0.5,0.5,0.,0.,0.,0.,0.,0.},
	{0.,1.,0.,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.5,0.,0.5,0.,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.,0.5,0.,0.,0.,0.5,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25}
    },
    {
	{0.5,0.,0.5,0.,0.,0.,0.,0.},
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.,1.,0.,0.,0.,0.,0.},
	{0.,0.,0.5,0.5,0.,0.,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.5,0.,0.,0.,0.5,0.},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25}
    },
    {
	{0.25,0.25,0.25,0.25,0.,0.,0.,0.},
	{0.,0.5,0.,0.5,0.,0.,0.,0.},
	{0.,0.,0.5,0.5,0.,0.,0.,0.},
	{0.,0.,0.,1.,0.,0.,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.5,0.,0.,0.,0.5}
    },
    {
	{0.5,0.,0.,0.,0.5,0.,0.,0.},
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.,0.,1.,0.,0.,0.},
	{0.,0.,0.,0.,0.5,0.5,0.,0.},
	{0.,0.,0.,0.,0.5,0.,0.5,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25}
    },
    {
	{0.25,0.25,0.,0.,0.25,0.25,0.,0.},
	{0.,0.5,0.,0.,0.,0.5,0.,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.,0.,0.5,0.5,0.,0.},
	{0.,0.,0.,0.,0.,1.,0.,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.5,0.,0.5}
    },
    {
	{0.25,0.,0.25,0.,0.25,0.,0.25,0.},
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.,0.5,0.,0.,0.,0.5,0.},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.,0.5,0.,0.5,0.},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.,1.,0.},
	{0.,0.,0.,0.,0.,0.,0.5,0.5}
    },
    {
	{0.125,0.125,0.125,0.125,0.125,0.125,0.125,0.125},
	{0.,0.25,0.,0.25,0.,0.25,0.,0.25},
	{0.,0.,0.25,0.25,0.,0.,0.25,0.25},
	{0.,0.,0.,0.5,0.,0.,0.,0.5},
	{0.,0.,0.,0.,0.25,0.25,0.25,0.25},
	{0.,0.,0.,0.,0.,0.5,0.,0.5},
	{0.,0.,0.,0.,0.,0.,0.5,0.5},
	{0.,0.,0.,0.,0.,0.,0.,1.}
    }
};

#endif
static vector4 bez_weights[7] =
{
    {
	{1.0,0.,0.,0.}
    },
    {
	{0.5,0.5,0.,0.}
    },
    {
	{0.25,0.5,0.25,0.}
    },
    {
	{0.125,0.375,0.375,0.125}
    },
    {
	{0.,0.25,0.5,0.25}
    },
    {
	{0.,0.,0.5,0.5}
    },
    {
	{0.,0.,0.,1.}
    }
};

static vector4 linear_weights[7] =
{
    {
	{1.0,0.0,0.0,0.0}
    },
    {
	{1.0,0.0,0.0,0.0}
    },
    {
	{0.5,0.0,0.0,0.5}
    },
    {
	{0.5,0.0,0.0,0.5}
    },
    {
	{0.5,0.0,0.0,0.5}
    },
    {
	{0.,0.0,0.0,1.0}
    },
    {
	{0.,0.0,0.0,1.0}
    }
};

static matrix4x4 *weights=NULL;
setup_weight_matrices(cubic_interp)
int cubic_interp;
{
    int i,j,k,l;
    matrix4x4 temp;
    matrix4x4 template[4];
    vector4 t;
    vector4 *weight_vectors;

    if (cubic_interp == 1)
	weight_vectors = bez_weights;
    else
	weight_vectors = linear_weights;
    
    weights = (matrix4x4 *)malloc(sizeof(matrix4x4)*8*8*8*4);
    /* 4x4x4 matrix at each of 256 locations */
    for (k=0;k<8;k++) /* do all z-planes */
    {
	for (j=0;j<8;j++) /* do all y-planes */
	{
	    for (i=0;i<8;i++) /* do all x-planes */
	    {
		vec4_copy(&t,weight_vectors+i);
		
		for (l=0;l<4;l++)
		    vec_copy_to_row(weight_vectors+j,&temp,l); 
		vec_matrix_mult_positionwise(&t,&temp);
		copy_vec_to_pile(weight_vectors+k,template);
		matrix_pile_mult(&temp,template);
#ifdef STARDENT
		F_PILE_COPY(weights+i*4+j*8*4+k*8*8*4,&((template+0)->m[0][0]));
#elif SUN
		f_pile_copy_(weights+i*4+j*8*4+k*8*8*4,&((template+0)->m[0][0]));
#endif
	    }
	}
    }
}

get_weight(x,y,z,m)
int x,y,z;
matrix4x4 *m;
{
    int i,j,k;
    matrix4x4 *w;

    w = weights + x*4 + (y*8*4) + (z*64*4);
    
    for (k=0;k<4;k++)
	for (j=0;j<4;j++)
	    for (i=0;i<4;i++)
		(m+k)->m[i][j] = (w+i)->m[i][j];
}



cleanup_weight_matrices()
{
    if (weights != NULL)
	free((char *)weights);
}

split_voxel(sx,sy,sz,sd,dx,dy,dz,dd,index)
matrix4x4 *sx,*sy,*sz,*sd,*dx,*dy,*dz,*dd;
int index;
{
    int start_x,start_y,start_z;
    
    switch (index)
    {
    case 0:
	start_x = start_y = start_z = 0;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 1:
	start_x = 3;
	start_y = start_z = 0;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 2:
	start_x = start_z = 0;
	start_y = 3;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 3:
	start_z = 0;
	start_x = start_y = 3;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 4:
	start_z = 3;
	start_x = start_y = 0;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 5:
	start_z = start_x = 3;
	start_y = 0;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 6:
	start_z = start_y = 3;
	start_x = 0;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;
    case 7:
	start_x = start_y = start_z = 3;
	voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,start_x,start_y,start_z);
	break;

    } ;
}

#define weight_index(x,y,z) \
    (weights + (x*4)+(y*8*4)+(z*8*8*4))

voxel_weight(sx,sy,sz,sd,dx,dy,dz,dd,x,y,z)
matrix4x4 *sx,*sy,*sz,*sd,*dx,*dy,*dz,*dd;
int x,y,z;
{
    matrix4x4 *w;
    matrix4x4 work[4];
    int i,j,k;
    float new_value;
    
    w = weights + x*4 + (y*8*4) + (z*64*4);

    for (k=z;k<z+4;k++)
	for (j=y;j<y+4;j++)
	    for(i=x;i<x+4;i++)
	    {
		w = weight_index(i,j,k); /* get appropriate weighting mx. */
		/* run all points thru weight matrix. */
		/* x points */
/*		f_pile_copy(&((work+0)->m[0][0]),&((sx+0)->m[0][0])); */
/*		pile_mult(work,w); */
/*		pile_mult(&((sx+0)->m[0][0]),w,&((work+0)->m[0][0]));
		pile_sum(&((work+0)->m[0][0]),&new_value);  */
#ifdef STARDENT
		PILE_MULT_SUM(&((sx+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#elif SUN
		pile_mult_sum_(&((sx+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#endif
		(dx+k-z)->m[i-x][j-y] = new_value;
		
		/* y points */
/*		f_pile_copy(&((work+0)->m[0][0]),&((sy+0)->m[0][0])); 
		pile_mult(work,w); */
/*		pile_mult(&((sy+0)->m[0][0]),w,&((work+0)->m[0][0]));
		pile_sum(&((work+0)->m[0][0]),&new_value); */
#ifdef STARDENT
		PILE_MULT_SUM(&((sy+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#elif SUN
		pile_mult_sum_(&((sy+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#endif
		(dy+k-z)->m[i-x][j-y] = new_value;
		
		/* z points */
/*		f_pile_copy(&((work+0)->m[0][0]),&((sz+0)->m[0][0]));
		pile_mult(work,w); */
/*		pile_mult(&((sz+0)->m[0][0]),w,&((work+0)->m[0][0]));
		pile_sum(&((work+0)->m[0][0]),&new_value);  */
#ifdef STARDENT
		PILE_MULT_SUM(&((sz+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#elif SUN
		pile_mult_sum_(&((sz+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#endif
		(dz+k-z)->m[i-x][j-y] = new_value;
		
		/* data points */
/*		f_pile_copy(&((work+0)->m[0][0]),&((sd+0)->m[0][0]));  
 		pile_mult(work,w); */
/*		pile_mult(&((sd+0)->m[0][0]),w,&((work+0)->m[0][0]));
		pile_sum(&((work+0)->m[0][0]),&new_value);  */
#ifdef STARDENT
		PILE_MULT_SUM(&((sd+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#elif SUN
		pile_mult_sum_(&((sd+0)->m[0][0]),w,&((work+0)->m[0][0]),&new_value);
#endif
		(dd+k-z)->m[i-x][j-y] = new_value;
	    }
}

int
homogeneous(cx,cy,cz,epsilon)
matrix4x4 *cx,*cy,*cz;
float *epsilon;
{
    avs_vertex a,b;
    avs_vertex n[4];
    int i,next;
    float suma,sumb,sumc;
    
    /**
      * what we want to do in this routine is to determine if
      * each of the bounding faces of the voxel are planar
      * (within some epsilon value).  if so, we return a 1,
      * and the voxel will be subsequently renderered using
      * trilinear interpolation rather than tricubic.
      *
      * this is accomplished by computing the planar coefficients
      * at each corner of each face of the voxel.  if the planar
      * coefficients are "similar" at each vertex on a per face
      * basis (for each face), then the voxel is determined to be
      * "homogeneous"
    **/
#if 0
a = (y1-y0)*(z2-z1) - (y2-y1)*(z1-z0)
b = (z1-z0)*(x2-x1) - (z2-z1)*(x1-x0)
c = (x1-x0)*(y2-y1) - (x2-x1)*(y1-y0)
d = -a*x0 - b*y0 - c*z0
#endif

    /* do corner at u=0,v=0 */
    a.v[0] = cx[0].m[1][0] - cx[0].m[0][0];
    a.v[1] = cy[0].m[1][0] - cy[0].m[0][0];
    a.v[2] = cz[0].m[1][0] - cz[0].m[0][0];
    b.v[0] = cx[0].m[0][0] - cx[0].m[0][1];
    b.v[1] = cy[0].m[0][0] - cy[0].m[0][1];
    b.v[2] = cz[0].m[0][0] - cz[0].m[0][1];
    vector_cross(&a,&b,n);
    vector_unit(n);

    /* do corner at u=0,v=1 */
    a.v[0] = cx[0].m[0][2] - cx[0].m[0][3];
    a.v[1] = cy[0].m[0][2] - cy[0].m[0][3];
    a.v[2] = cz[0].m[0][2] - cz[0].m[0][3];
    b.v[0] = cx[0].m[0][3] - cx[0].m[1][3];
    b.v[1] = cy[0].m[0][3] - cy[0].m[1][3];
    b.v[2] = cz[0].m[0][3] - cz[0].m[1][3];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    /* do corner at u=1,v=1 */
    a.v[0] = cx[0].m[2][3] - cx[0].m[3][3];
    a.v[1] = cy[0].m[2][3] - cy[0].m[3][3];
    a.v[2] = cz[0].m[2][3] - cz[0].m[3][3];
    b.v[0] = cx[0].m[3][3] - cx[0].m[3][2];
    b.v[1] = cy[0].m[3][3] - cy[0].m[3][2];
    b.v[2] = cz[0].m[3][3] - cz[0].m[3][2];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    /* do corner at u=1,v=0 */
    a.v[0] = cx[0].m[3][1] - cx[0].m[3][0];
    a.v[1] = cy[0].m[3][1] - cy[0].m[3][0];
    a.v[2] = cz[0].m[3][1] - cz[0].m[3][0];
    b.v[0] = cx[0].m[3][0] - cx[0].m[2][3];
    b.v[1] = cy[0].m[3][0] - cy[0].m[2][3];
    b.v[2] = cz[0].m[3][0] - cz[0].m[2][3];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);

    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);


    /* now do plane at w=1 */
    /* do corner at u=0,v=0 */
    a.v[0] = cx[3].m[1][0] - cx[3].m[0][0];
    a.v[1] = cy[3].m[1][0] - cy[3].m[0][0];
    a.v[2] = cz[3].m[1][0] - cz[3].m[0][0];
    b.v[0] = cx[3].m[0][0] - cx[3].m[0][1];
    b.v[1] = cy[3].m[0][0] - cy[3].m[0][1];
    b.v[2] = cz[3].m[0][0] - cz[3].m[0][1];
    vector_cross(&a,&b,n);
    vector_unit(n);

    /* do corner at u=0,v=1 */
    a.v[0] = cx[3].m[0][2] - cx[3].m[0][3];
    a.v[1] = cy[3].m[0][2] - cy[3].m[0][3];
    a.v[2] = cz[3].m[0][2] - cz[3].m[0][3];
    b.v[0] = cx[3].m[0][3] - cx[3].m[1][3];
    b.v[1] = cy[3].m[0][3] - cy[3].m[1][3];
    b.v[2] = cz[3].m[0][3] - cz[3].m[1][3];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    /* do corner at u=1,v=1 */
    a.v[0] = cx[3].m[2][3] - cx[3].m[3][3];
    a.v[1] = cy[3].m[2][3] - cy[3].m[3][3];
    a.v[2] = cz[3].m[2][3] - cz[3].m[3][3];
    b.v[0] = cx[3].m[3][3] - cx[3].m[3][2];
    b.v[1] = cy[3].m[3][3] - cy[3].m[3][2];
    b.v[2] = cz[3].m[3][3] - cz[3].m[3][2];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    /* do corner at u=1,v=0 */
    a.v[0] = cx[3].m[3][1] - cx[3].m[3][0];
    a.v[1] = cy[3].m[3][1] - cy[3].m[3][0];
    a.v[2] = cz[3].m[3][1] - cz[3].m[3][0];
    b.v[0] = cx[3].m[3][0] - cx[3].m[2][3];
    b.v[1] = cy[3].m[3][0] - cy[3].m[2][3];
    b.v[2] = cz[3].m[3][0] - cz[3].m[2][3];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);

    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);

    /* do plane of u=0 */

    a.v[0] = cx[1].m[0][0] - cx[0].m[0][0];
    a.v[1] = cy[1].m[0][0] - cy[0].m[0][0];
    a.v[2] = cz[1].m[0][0] - cz[0].m[0][0];
    b.v[0] = cx[0].m[0][0] - cx[0].m[0][1];
    b.v[1] = cy[0].m[0][0] - cy[0].m[0][1];
    b.v[2] = cz[0].m[0][0] - cz[0].m[0][1];
    vector_cross(&a,&b,n);
    vector_unit(n);

    a.v[0] = cx[3].m[0][1] - cx[3].m[0][0];
    a.v[1] = cy[3].m[0][1] - cy[3].m[0][0];
    a.v[2] = cz[3].m[0][1] - cz[3].m[0][0];
    b.v[0] = cx[3].m[0][0] - cx[2].m[0][0];
    b.v[1] = cy[3].m[0][0] - cy[2].m[0][0];
    b.v[2] = cz[3].m[0][0] - cz[2].m[0][0];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    a.v[0] = cx[2].m[0][3] - cx[3].m[0][3];
    a.v[1] = cy[2].m[0][3] - cy[3].m[0][3];
    a.v[2] = cz[2].m[0][3] - cz[3].m[0][3];
    b.v[0] = cx[3].m[0][3] - cx[3].m[0][2];
    b.v[1] = cy[3].m[0][3] - cy[3].m[0][2];
    b.v[2] = cz[3].m[0][3] - cz[3].m[0][2];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    a.v[0] = cx[0].m[0][2] - cx[0].m[0][3];
    a.v[1] = cy[0].m[0][2] - cy[0].m[0][3];
    a.v[2] = cz[0].m[0][2] - cz[0].m[0][3];
    b.v[0] = cx[0].m[0][3] - cx[1].m[0][3];
    b.v[1] = cy[0].m[0][3] - cy[1].m[0][3];
    b.v[2] = cz[0].m[0][3] - cz[1].m[0][3];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);
    
    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);

    /* do plane of u=1 */

    a.v[0] = cx[1].m[3][0] - cx[0].m[3][0];
    a.v[1] = cy[1].m[3][0] - cy[0].m[3][0];
    a.v[2] = cz[1].m[3][0] - cz[0].m[3][0];
    b.v[0] = cx[0].m[3][0] - cx[0].m[3][1];
    b.v[1] = cy[0].m[3][0] - cy[0].m[3][1];
    b.v[2] = cz[0].m[3][0] - cz[0].m[3][1];
    vector_cross(&a,&b,n);
    vector_unit(n);

    a.v[0] = cx[3].m[3][1] - cx[3].m[3][0];
    a.v[1] = cy[3].m[3][1] - cy[3].m[3][0];
    a.v[2] = cz[3].m[3][1] - cz[3].m[3][0];
    b.v[0] = cx[3].m[3][0] - cx[2].m[3][0];
    b.v[1] = cy[3].m[3][0] - cy[2].m[3][0];
    b.v[2] = cz[3].m[3][0] - cz[2].m[3][0];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    a.v[0] = cx[2].m[3][3] - cx[3].m[3][3];
    a.v[1] = cy[2].m[3][3] - cy[3].m[3][3];
    a.v[2] = cz[2].m[3][3] - cz[3].m[3][3];
    b.v[0] = cx[3].m[3][3] - cx[3].m[3][2];
    b.v[1] = cy[3].m[3][3] - cy[3].m[3][2];
    b.v[2] = cz[3].m[3][3] - cz[3].m[3][2];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    a.v[0] = cx[0].m[3][2] - cx[0].m[3][3];
    a.v[1] = cy[0].m[3][2] - cy[0].m[3][3];
    a.v[2] = cz[0].m[3][2] - cz[0].m[3][3];
    b.v[0] = cx[0].m[3][3] - cx[1].m[3][3];
    b.v[1] = cy[0].m[3][3] - cy[1].m[3][3];
    b.v[2] = cz[0].m[3][3] - cz[1].m[3][3];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);
    
    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);

    /* do plane of v=0 */
    /* corner of u=0,w=0 */
    a.v[0] = cx[0].m[1][0] - cx[0].m[0][0];
    a.v[1] = cy[0].m[1][0] - cy[0].m[0][0];
    a.v[2] = cz[0].m[1][0] - cz[0].m[0][0];
    b.v[0] = cx[0].m[0][0] - cx[1].m[0][0];
    b.v[1] = cy[0].m[0][0] - cy[1].m[0][0];
    b.v[2] = cz[0].m[0][0] - cz[1].m[0][0];
    vector_cross(&a,&b,n);
    vector_unit(n);

    /* corner of u=1,w=0 */
    a.v[0] = cx[1].m[3][0] - cx[0].m[3][0];
    a.v[1] = cy[1].m[3][0] - cy[0].m[3][0];
    a.v[2] = cz[1].m[3][0] - cz[0].m[3][0];
    b.v[0] = cx[0].m[3][0] - cx[0].m[2][0];
    b.v[1] = cy[0].m[3][0] - cy[0].m[2][0];
    b.v[2] = cz[0].m[3][0] - cz[0].m[2][0];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    /* corner of u=1,w=1 */
    a.v[0] = cx[3].m[2][0] - cx[3].m[3][0];
    a.v[1] = cy[3].m[2][0] - cy[3].m[3][0];
    a.v[2] = cz[3].m[2][0] - cz[3].m[3][0];
    b.v[0] = cx[3].m[3][0] - cx[2].m[3][0];
    b.v[1] = cy[3].m[3][0] - cy[2].m[3][0];
    b.v[2] = cz[3].m[3][0] - cz[2].m[3][0];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    /* corner of u=0,w=1 */
    a.v[0] = cx[2].m[0][0] - cx[3].m[0][0];
    a.v[1] = cy[2].m[0][0] - cy[3].m[0][0];
    a.v[2] = cz[2].m[0][0] - cz[3].m[0][0];
    b.v[0] = cx[3].m[0][0] - cx[3].m[1][0];
    b.v[1] = cy[3].m[0][0] - cy[3].m[1][0];
    b.v[2] = cz[3].m[0][0] - cz[3].m[1][0];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);
    
    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);
    
    /* do plane of v=1 */
    /* corner of u=0,w=0 */
    a.v[0] = cx[0].m[1][3] - cx[0].m[0][3];
    a.v[1] = cy[0].m[1][3] - cy[0].m[0][3];
    a.v[2] = cz[0].m[1][3] - cz[0].m[0][3];
    b.v[0] = cx[0].m[0][3] - cx[1].m[0][3];
    b.v[1] = cy[0].m[0][3] - cy[1].m[0][3];
    b.v[2] = cz[0].m[0][3] - cz[1].m[0][3];
    vector_cross(&a,&b,n);
    vector_unit(n);

    /* corner of u=1,w=0 */
    a.v[0] = cx[1].m[3][3] - cx[0].m[3][3];
    a.v[1] = cy[1].m[3][3] - cy[0].m[3][3];
    a.v[2] = cz[1].m[3][3] - cz[0].m[3][3];
    b.v[0] = cx[0].m[3][3] - cx[0].m[2][3];
    b.v[1] = cy[0].m[3][3] - cy[0].m[2][3];
    b.v[2] = cz[0].m[3][3] - cz[0].m[2][3];
    vector_cross(&a,&b,n+1);
    vector_unit(n+1);

    /* corner of u=1,w=1 */
    a.v[0] = cx[3].m[2][3] - cx[3].m[3][3];
    a.v[1] = cy[3].m[2][3] - cy[3].m[3][3];
    a.v[2] = cz[3].m[2][3] - cz[3].m[3][3];
    b.v[0] = cx[3].m[3][3] - cx[2].m[3][3];
    b.v[1] = cy[3].m[3][3] - cy[2].m[3][3];
    b.v[2] = cz[3].m[3][3] - cz[2].m[3][3];
    vector_cross(&a,&b,n+2);
    vector_unit(n+2);

    /* corner of u=1,w=0 */
    a.v[0] = cx[2].m[0][3] - cx[3].m[0][3];
    a.v[1] = cy[2].m[0][3] - cy[3].m[0][3];
    a.v[2] = cz[2].m[0][3] - cz[3].m[0][3];
    b.v[0] = cx[3].m[0][3] - cx[3].m[1][3];
    b.v[1] = cy[3].m[0][3] - cy[3].m[1][3];
    b.v[2] = cz[3].m[0][3] - cz[3].m[1][3];
    vector_cross(&a,&b,n+3);
    vector_unit(n+3);
    
    suma = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	suma += ABS(n[i].v[0] - n[next].v[0]);
    }
	
    sumb = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumb += ABS(n[i].v[1] - n[next].v[1]);
    }
	
    sumc = 0.0;
    for (i=0;i<4;i++)
    {
	next = (i==3) ? 0 : i+1;
	sumc += ABS(n[i].v[2] - n[next].v[2]);
    }

    if ((suma > *epsilon) || (sumb > *epsilon) || (sumc > *epsilon))
	return(0);
    

    return(1);

}

void
split_voxel_trilinear(sv,dv,index)
trivox *sv,*dv;
int index;
{
    int i;
    
    for (i=0;i<8;i++)
    {
#ifdef STARDENT
	F_MULT_SUM_8(&(trilin_weights[index][i]),&(sv->xp),&(dv->xp.v[i]));
	F_MULT_SUM_8(&(trilin_weights[index][i]),&(sv->yp),&(dv->yp.v[i]));
	F_MULT_SUM_8(&(trilin_weights[index][i]),&(sv->zp),&(dv->zp.v[i]));
	F_MULT_SUM_8(&(trilin_weights[index][i]),&(sv->dp),&(dv->dp.v[i]));
#elif SUN
	f_mult_sum_8_(&(trilin_weights[index][i]),&(sv->xp),&(dv->xp.v[i]));
	f_mult_sum_8_(&(trilin_weights[index][i]),&(sv->yp),&(dv->yp.v[i]));
	f_mult_sum_8_(&(trilin_weights[index][i]),&(sv->zp),&(dv->zp.v[i]));
	f_mult_sum_8_(&(trilin_weights[index][i]),&(sv->dp),&(dv->dp.v[i]));
#endif
    }
#ifdef STARDENT
    F_8VECT_MIN(&(dv->zp.v[0]),&(dv->min_z));
#elif SUN
    f_8vect_min_(&(dv->zp.v[0]),&(dv->min_z));
#endif
}

copy_trivox(src,dst)
trivox *src,*dst;
{
    int i;
    for (i=0;i<8;i++)
	dst->xp.v[i] = src->xp.v[i];
    for (i=0;i<8;i++)
	dst->yp.v[i] = src->yp.v[i];
    for (i=0;i<8;i++)
	dst->zp.v[i] = src->zp.v[i];
    for (i=0;i<8;i++)
	dst->dp.v[i] = src->dp.v[i];
}
