/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int MINMAX_REPORT_desc()
{

	int in_port, in_2port, out_port, param;
	extern int MINMAX_REPORT_compute();

	AVSset_module_name("MINMAX REPORT", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input field", 
		"field 2D uniform 1-vector float", REQUIRED);

  	param = AVSadd_parameter("MinMax Status", "string_block",
                 "Min Max Report:\n\n\n\n\n\n\n\n", NULL, NULL);
        AVSconnect_widget(param, "textblock");
        AVSadd_parameter_prop(param, "width", "integer", 4);
        AVSadd_parameter_prop(param, "height", "integer", 8);
      
	AVSset_compute_proc(MINMAX_REPORT_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int MINMAX_REPORT_compute(input_field, minmax_status)
	AVSfield_float *input_field;
	char *minmax_status;	
{
register int i, j, in;

static float minval, maxval;
static int minx, miny;
static int maxx, maxy;
static char minmax_str[1024];

double sqrt();

double accum;
double sumsq;
double mean;
double var;
double stdev;
double sterr;

#define INPUT input_field->data[in]

#define DIM1 input_field->dimensions[0]
#define DIM2 input_field->dimensions[1]

minval = 32767.;
maxval = -32768.;
minx = miny = -1;
maxx = maxy = -1;
in = 0;
accum = 0.0;
sumsq = 0.0;
for (j = 0; j < DIM2; ++j)
	for (i = 0; i < DIM1; ++i)
		{
		if (INPUT < minval)
			{
			minval = INPUT;
			minx = i;
			miny = j;
			}
		if (INPUT > maxval)
			{
			maxval = INPUT;
			maxx = i;
			maxy = j;
			}
		accum += INPUT;
		sumsq += INPUT * INPUT;
		++in;
		}

mean = accum/(in*1.);
if (in > 1)
	{
	var = ((in * sumsq) - (accum * accum))/(in * (in - 1) * 1.);
	stdev = sqrt(var);
	sterr = sqrt(var/in);
	}
else
	var = stdev = sterr = 0.;

sprintf(minmax_str, 
"MinMax Report\n\nMIN (%3d,%3d) = %g\nMAX (%3d,%3d) = %g\nDIM1:DIM2 (%3d,%3d)\nMEAN = %g\nST DEV = %g\nST ERR = %g\nVAR = %g\n",
minx, miny, minval, maxx, maxy, maxval, DIM1, DIM2, mean, stdev, sterr, var);

AVSmodify_parameter("MinMax Status", AVS_VALUE, minmax_str, NULL, NULL);
return(1);
}
 
#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	MINMAX_REPORT_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

