/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/

/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
 * Name:
 * marker_draw - generate marker bitmaps from marker input list
 *
 * Type: Mapper - image filter for Image viewer 
 *
 * Author: Ian Curington, AVS/UNIRAS Ltd.
 *
 * Language: K&R C
 * 
 * Description:
 *
 * This module to takes a marker coordinate specification
 * vector XY-pair list on
 * an input port from another module, combine this with an
 * an input image, and create a composit display image.
 * The input image is copied to the output, then marker polygonal
 * shapes are scan converted and filled using an edge fill
 * algoriythm, with the fill color computed based on
 * hue parameters. 
 * It is designed and tested with several other marker
 * modules, such as marker_pick or marker_select as source
 * The vector marker list is defined by structures in the
 * "marker.h" header file, defining the structure and usage
 * of the field data type for markers.
 * Each marker has a compile-time defined shape, but runtime
 * attributes of position, size, color, etc.
 *
 * Inputs:
 *   Ref-Image    - Any AVS image, in full color.
 *   Marker-Input - marker specification list input
 *   
 * Outputs:
 *   ROI Out - Modified full color image, input plus markers
 *
 * Parameters:
 *   Marker Hue - Hue, part of a color specification for all
 *                markers except of type "X". Saturation and
 *                value are prefixed.
 *   Hilite Hue - Similar control, but for any "X" markers
 *
 * ---------------------------
 *
 * Revision:
 *  7 Feb 94 ianc: Orig
 * 27 May 94 ianc: updated with direct image gen
 *                 rather than roi bit field
 *  6 June 94 ianc: added secondary pick color control
 *  9 June 94 ianc: update cleanup
 *
 */


/*
                  Copyright (c) 1992, 1993, 1994 by
                  Advanced Visual Systems Inc.
                  All Rights Reserved

      This software comprises unpublished confidential information of
      Advanced Visual Systems Inc. and may not be used, copied or made
      available to anyone, except in accordance with the license
      under which it is furnished.

*/

/* mod_gen Version 1                                                     */
/* Module Name: "marker_draw" (Mapper) (Subroutine)                       */
/* Author: Ian_Curington                                                 */
/* Date Created: Tue Jun 22 00:01:03 1993                                */
/*                                                                       */
/* input 0 "ref_image" field 2D byte REQUIRED                            */
/* input 1 "marker_input" field 1D 4-vector uniform integer REQUIRED     */
/* output 0 "roi_out" field 2D 1-vector uniform byte                     */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 

#include "marker.h"
 
#define  IMAGE_OUT_SPEC \
	"field 2D uniform 4-vector byte 2-space"

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int marker_draw_desc()
{

	int in_port, out_port, param, iresult;
	extern int marker_draw_compute();

	AVSset_module_name("Marker Draw", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("ref_image", "field 2D byte", REQUIRED);

	in_port = AVScreate_input_port("marker_input", 
		            MARKER_FIELD_SPEC, OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("roi_out", 
		IMAGE_OUT_SPEC );


        /* Parameter Specifications                */
	param = AVSadd_float_parameter("Marker_Hue",
	    0.000000, 0.00000, 1.00000);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Hilite_Hue",
	    0.750000, 0.00000, 1.00000);
	AVSconnect_widget(param, "slider");


	AVSset_compute_proc(marker_draw_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int marker_draw_compute( ref_image,
			 marker_input,
			 roi_out,
			 marker_hue,
			 hilite_hue )

	AVSfield_char  *ref_image;
	AVSfield_int   *marker_input;
	AVSfield_char  **roi_out;
	float          *marker_hue;
	float          *hilite_hue;
{

   int dims[4];
   int size;
   int i;
   int veclen;
   int ref_veclen;
   int x,y,type,sz,fill,endx,endy;
   char fill_value;
   int nverts;
   int *shape_ptr;
   float        roi_col[3];
   unsigned char         roi_red;
   unsigned char         roi_green;
   unsigned char         roi_blue;
   unsigned char         hroi_red;
   unsigned char         hroi_green;
   unsigned char         hroi_blue;
   unsigned char         rr, gg, bb;


   dims[0] = MAXX(ref_image);  /* set the array dimensions */
   dims[1] = MAXY(ref_image);
   size = dims[0] * dims[1];
   ref_veclen = ref_image->veclen;

   if ( size <= 20 )
   {
       printf("marker_draw: reference image is too small\n");
       return(0);
   }

   /* alloc speedup */
   if ( AVSinput_changed("ref_image",0) ||
	*roi_out == NULL )
   {
       if ( *roi_out ) AVSfield_free ( *roi_out );
       *roi_out = (AVSfield_char *)
           AVSdata_alloc( IMAGE_OUT_SPEC ,dims);
   }

   /* clear it out, reset original image */
   memcpy( (*roi_out)->data,
	   (ref_image)->data,
	   size * ref_veclen );

   /* If no markers, send through blank roi */
   if ( !marker_input ) return (1);
   if ( MAXX(marker_input) <= 0 ) return(1);
   veclen = marker_input->veclen;


   /*
    * compute the full rgb color of marker
    */
   FILTERhsv_to_rgb (&(roi_col[0]),
                     &(roi_col[1]),
                     &(roi_col[2]),
                     *marker_hue, 1.0, 1.0 );

   /* Default Full On ROI */
   roi_red   = (unsigned char) (roi_col[0] * 255.0);
   roi_green = (unsigned char) (roi_col[1] * 255.0);
   roi_blue  = (unsigned char) (roi_col[2] * 255.0);


   /*
    * compute the full rgb color of hilite!
    */
   FILTERhsv_to_rgb (&(roi_col[0]),
                     &(roi_col[1]),
                     &(roi_col[2]),
                     *hilite_hue, 1.0, 1.0 );

   /* Default Full On ROI */
   hroi_red   = (unsigned char) (roi_col[0] * 255.0);
   hroi_green = (unsigned char) (roi_col[1] * 255.0);
   hroi_blue  = (unsigned char) (roi_col[2] * 255.0);


   /*
    * Process Markers
    */
   for ( i=0; i < MAXX(marker_input); i++ )
   {
       /*
	* get marker place, size and type
	*/
       x    = marker_input->data[ i * veclen + 0 ];
       y    = marker_input->data[ i * veclen + 1 ];
       type = marker_input->data[ i * veclen + 2 ];
       sz   = marker_input->data[ i * veclen + 3 ];
       fill = marker_input->data[ i * veclen + 4 ];
       endx = marker_input->data[ i * veclen + 5 ];
       endy = marker_input->data[ i * veclen + 6 ];

       /* find center of marker in ref image */
       nverts = mlist_size[type];
       if ( sz <= MIN_MARKER_SIZE ) sz = MIN_MARKER_SIZE;

       rr = roi_red;
       gg = roi_green;
       bb = roi_blue;

       switch (type)
       {
           case MARKER_SQUARE:
	       shape_ptr = (int *)shape_square;
               break;
           case MARKER_DIAMOND:
	       shape_ptr = (int *)shape_diamond;
               break;
           case MARKER_CIRCLE:
	       shape_ptr = (int *)shape_circle;
               break;
           case MARKER_X:    /* ==== special hilite shape ==== */
	       shape_ptr = (int *)shape_x;
               rr = hroi_red;
               gg = hroi_green;
               bb = hroi_blue;
               break;
           case MARKER_FLEUR:
	       shape_ptr = (int *)shape_fleur;
               break;
           case MARKER_POLY:
	       shape_ptr = (int *)shape_poly;
               break;
           default:
	       shape_ptr = (int *)shape_square;
	       nverts = mlist_size[MARKER_SQUARE];
               break;
       }


       /* drop pixels into the ROI to makeup the marker */

       make_roi_from_points(shape_ptr,      /* shape verts list, n x 2 */
                         (*roi_out)->data,  /* output char 2d buffer */
                         dims,              /* size of output array  */
                         rr,                /* value to fill with    */
                         gg,                /* value to fill with    */
                         bb,                /* value to fill with    */
                         nverts,            /* number of verts in shape */
                         fill,              /* fill or edge only mode */
			 x,                 /* offset position */
			 y,                 /* offset position */
			 sz );              /* marker scale size */


   }

   return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
#ifdef sep_exe
int ((*mod_list[])()) = {
	marker_draw_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
#endif

/* ***********************************************************************/
/* Utility Code                   */
/* ***********************************************************************/
/*
 * Make ROI from point list, fill the enclosing area
 *
 * taken from sketch roi, adapted for marker shapes,
 * and edge mode.
 *
 * Adapted by: Ian Curington
 * Revision:
 *    8 Feb 94
 *   27 May 94
 */


#define PBX(i) ((pb[(i)]) * size + x)
#define PBY(i) ((pb[(i)]) * size + y)

/****
#define DEBUG_ROI 1
 ****/

/*
 * supports only ARGB image fills
 */


/*************************************
 *  make roi from points 
 *************************************/

int make_roi_from_points(pb,          /* shape verts list, n x 2 */
			 roi_data,    /* output char 2d buffer */
			 dims,        /* size of output array  */
                         roi_red,           /* value to fill with    */
                         roi_green,         /* value to fill with    */
                         roi_blue,          /* value to fill with    */
			 pverts,      /* number of verts in shape */
			 edge_mode,   /* fill or edge only mode */
                         x,           /* offset position */
                         y,           /* offset position */
                         size )       /* marker scale size */



        int         *pb;
        char        *roi_data;
        int         *dims;
        unsigned char       roi_red;
        unsigned char       roi_green;
        unsigned char       roi_blue;
	int         pverts;
        int         x;
        int         y;
        int         size;
{
  int   i, j, k, scan, ymin, ymax, nxings;
  int   *xb, xbsize, *pbp;
  float dx, dy, ey;
  char  *rdp;
  int   ii;
  int   nverts;

  nverts = pverts * 2;

#ifdef DEBUG_ROI
  pbp = pb;
  printf("nverts %d\n", nverts);
  for (ii=0; ii < nverts; ii++ )
    printf("%d %d\n", *pbp++, *pbp++);
#endif




  /* only if 3 or more points... */
  if (nverts > 4)
  {
    /* init crossings buffer */
    xbsize = 256;
    if ((xb = (int *) malloc(xbsize * sizeof(int))) == NULL)
      return(0);

    /* find the y range */
    ymin = 65536;
    ymax = 0;
    for (i = 1; i < nverts; i += 2)
    {
      if (PBY(i) < ymin)
	ymin = PBY(i);
      if (PBY(i) > ymax)
	ymax = PBY(i);
    }
    if (ymin < 0)
      ymin = 0;
    if (ymax > dims[1])
      ymax = dims[1];

    /* start filling from here */
    rdp = roi_data + (ymin * dims[0]) * 4;

    /* n-1 lines for n points */
    nverts--;
    nverts--;

    /* for each scanline... */
    for (scan = ymin; scan < ymax; scan++)
    {
      /* look for lines crossing this scanline */
      nxings = 0;
      for (i = 1; i < nverts; i += 2)
      {
	/* NOTE! this test should eliminate horizontals */
	if ((PBY(i) >  scan && PBY(i+2) <= scan) ||
	    (PBY(i) <= scan && PBY(i+2) >  scan))
	{
	  /* crosses, calculate the x crossing point */
	  if (nxings >= xbsize)
	  {
	    xbsize *= 2;
	    if ((xb = (int *) realloc(xb, xbsize * sizeof(int))) == NULL)
	      return(0);
	  }

	  /* pretty inefficient to calculate this for every scanline...
	   * should really have an active edge list, compute this once
	   * and do increments off the total delta...
	   */
	  dx = PBX(i-1) - PBX(i+1);
	  dy = PBY(i+2) - PBY(i);
	  ey = PBY(i) - scan;
	  xb[nxings] = PBX(i-1) + (int) ((dx * ey) / dy);
	  nxings++;
	}
      }

/**
#ifdef DEBUG_ROI
      printf("scan %d nxings %d", scan, nxings);
      for (ii = 0; ii < nxings; i++)
        printf(" %d", xb[ii]);
      printf("\n");
#endif
**/

      /* sort the crossings, left to right - simple swap sort */
      for (i = 0; i < nxings; i++)
      {
	k = i;
	for (j = i+1; j < nxings; j++)
	  if (xb[j] < xb[k])
	    k = j;

	if (k != i)
	{
	  j = xb[k];
	  xb[k] = xb[i];
	  xb[i] = j;
	}
      }

#ifdef DEBUG_ROI
      printf("sorted xings");
      for (ii = 0; ii < nxings; ii++)
        printf(" %d", xb[ii]);
      printf("\n");
#endif

      /* should always be an even number of crossing points */
      if (nxings % 2)
	printf("odd %d number of spans!!\n", nxings-1);
      else
      {
	/* do the fill - spans are "off", "on", "off", etc */
	for (i = 0, j = 0; i <= nxings; i++)
	{
	  /* k is the delta between this crossing and the previous;
	   * j is the previous crossing
	   */
	  if (i == nxings)
	    k = dims[0] - j;
	  else
	    k = xb[i] - j;

	  if (k > 0)
	  {
	    /* span inside left edge: clip against right edge */
	    if ((j + k) > dims[0])
	      k = dims[0] - j;

	    if (i % 2)
	    {
	      if ( edge_mode == 2 )
	      {
		  *rdp     = *(rdp+(k-1)*4+0) = 0xff;
		  *(rdp+1) = *(rdp+(k-1)*4+1) = roi_red;
		  *(rdp+2) = *(rdp+(k-1)*4+2) = roi_green;
		  *(rdp+3) = *(rdp+(k-1)*4+3) = roi_blue;
	      }
	      else
                  for (ii = 0; ii < k; ii++)
                  {
                     *(rdp+ii*4+0) = 0xff;
                     *(rdp+ii*4+1) = roi_red;
                     *(rdp+ii*4+2) = roi_green;
                     *(rdp+ii*4+3) = roi_blue;
                  }
	    }
	    rdp += k * 4;
	  }


	  /* set previous crossing for next span */
	  if (xb[i] < 0)
	    j = 0;
	  else if (xb[i] > dims[0])
	    j = dims[0];
	  else
	    j = xb[i];
	}
      }
    }


/* IAC CODE CHANGE :     free(xb); */

/* IAC CODE CHANGE :      free(xb); */
      free(xb);
  }

  return(1);
}

