/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int NEW_CROP_desc()
{

	int in_port, in_2port, out_port, param;
	extern int NEW_CROP_compute();

	AVSset_module_name("NEW CROP", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */

	in_port = AVScreate_input_port("input field", 
		"field uniform float", REQUIRED);

	in_port = AVScreate_input_port("input X-Y map parameters", 
		"string", OPTIONAL);

	/* Output Port Specifications              */

	out_port = AVScreate_output_port("output field", 
		"field uniform float");

	out_port = AVScreate_output_port("output string", "string");

	/* Parameter Specifications                */

	param = AVSadd_parameter("xmin", "integer", -5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("xmax", "integer", 5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("ymin", "integer", -5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("ymax", "integer", 5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("zmin", "integer", -5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("zmax", "integer", 5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("tmin", "integer", -5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("tmax", "integer", 5000, -5000, 5000 );
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("crop method", "choice", "USER CHOICE",
		"DOMAIN GRID:DOMAIN CLIPPED GRID:DOMAIN BOUNDARY:USER CHOICE",
		":");
	AVSconnect_widget(param, "radio_buttons");
	AVSadd_parameter_prop(param, "width", "integer", 4);

	param = AVSadd_parameter("reset field minmax", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("crop limit to 2", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(NEW_CROP_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int NEW_CROP_compute(input_field, input_xy_map_parameters,
	output_field, output_string, 
	xmin, xmax, ymin, ymax, zmin, zmax, tmin, tmax, 
	crop_method, reset_field_minmax, crop_limit_to_2)
	AVSfield_float *input_field;
	char *input_xy_map_parameters;
	AVSfield_float **output_field;
	char **output_string;
	int xmin, xmax;
	int ymin, ymax;
	int zmin, zmax;
	int tmin, tmax;
	char *crop_method;
	int reset_field_minmax;
	int crop_limit_to_2;
{
static int dim[4];
static float minext[3];
static float maxext[3];
static char field_str[132];

int local_slice;
int local_xmin, local_xmax;
int local_ymin, local_ymax;
int local_zmin, local_zmax;
int local_tmin, local_tmax;

static int cropx0, cropx1, cropy0, cropy1;
static float gridx0, gridx1, gridy0, gridy1;
static float clipx0, clipx1, clipy0, clipy1;
static float boundx0, boundx1, boundy0, boundy1;

static char delimiter[2];

char *str = NULL;
register int i, j, k, l, n, iv;
register int in, out;

#define INPUT_POINT input_field->data[in]
#define OUTPUT_POINT (*output_field)->data[out]
#define NDIM input_field->ndim
#define NSPACE input_field->nspace
#define NVEC input_field->veclen

#define INPUT_MIN_XCOORD input_field->points[0]
#define INPUT_MAX_XCOORD input_field->points[1]
#define INPUT_MIN_YCOORD input_field->points[2]
#define INPUT_MAX_YCOORD input_field->points[3]
#define INPUT_MIN_ZCOORD input_field->points[4]
#define INPUT_MAX_ZCOORD input_field->points[5]
#define INPUT_MIN_TCOORD input_field->points[6]
#define INPUT_MAX_TCOORD input_field->points[7]

#define NX ((int) (INPUT_MAX_XCOORD - INPUT_MIN_XCOORD + 1.0))
#define NY ((int) (INPUT_MAX_YCOORD - INPUT_MIN_YCOORD + 1.0))
#define NZ ((int) (INPUT_MAX_ZCOORD - INPUT_MIN_ZCOORD + 1.0))
#define NT ((int) (INPUT_MAX_TCOORD - INPUT_MIN_TCOORD + 1.0))

#define OUTPUT_MIN_XCOORD (*output_field)->points[0]
#define OUTPUT_MAX_XCOORD (*output_field)->points[1]
#define OUTPUT_MIN_YCOORD (*output_field)->points[2]
#define OUTPUT_MAX_YCOORD (*output_field)->points[3]
#define OUTPUT_MIN_ZCOORD (*output_field)->points[4]
#define OUTPUT_MAX_ZCOORD (*output_field)->points[5]
#define OUTPUT_MIN_TCOORD (*output_field)->points[6]
#define OUTPUT_MAX_TCOORD (*output_field)->points[7]


if ((NDIM > 4) || (NSPACE > 3))
	{
	AVSerror("# dimensions must be <= 4 and # coordinates must be <= 3!");
	return(0);
	}

if (!strcmp(crop_method, "USER CHOICE"))
	{
	cropx0 = xmin;
	cropx1 = xmax;
	cropy0 = ymin;
	cropy1 = ymax;
	}
else
	{
	if (input_xy_map_parameters != NULL)
		{
		if (sscanf(input_xy_map_parameters, "%g%g%g%g%g%g%g%g%g%g%g%g",
			&gridx0, &gridx1, &gridy0, &gridy1,
			&clipx0, &clipx1, &clipy0, &clipy1,
			&boundx0, &boundx1, &boundy0, &boundy1) == 12)

			{
			if (!strcmp(crop_method, "DOMAIN GRID"))
				{
				cropx0 = (int) gridx0;
				cropx1 = (int) gridx1;
				cropy0 = (int) gridy0;
				cropy1 = (int) gridy1;
				}
			else if (!strcmp(crop_method, "DOMAIN CLIPPED GRID"))
				{
				cropx0 = (int) clipx0;
				cropx1 = (int) clipx1;
				cropy0 = (int) clipy0;
				cropy1 = (int) clipy1;
				}
			else if (!strcmp(crop_method, "DOMAIN BOUNDARY"))
				{
				cropx0 = (int) boundx0;
				cropx1 = (int) boundx1;
				cropy0 = (int) boundy0;
				cropy1 = (int) boundy1;
				}
			}
		else
			{
			AVSerror("Unexpected # of input X-Y map parameters.");
			return(0);
			}
		}
	else
		{
		AVSerror("NULL X-Y map parameter string.");
		return(0);
		}
	}
		
if (NDIM >= 1)
	{
	i = (int) INPUT_MIN_XCOORD;
	j = (int) INPUT_MAX_XCOORD;
	k = cropx0;
	if ((k < i) || (k > j))
		k = i;
	if (NX > 1)
		{
		AVSparameter_visible("xmin", 1);
		AVSmodify_parameter("xmin",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("xmin", 0);

	local_xmin = k;

	k = cropx1;
	if ((k < i) || (k > j))
		k = j;
	if (NX > 1)
		{
		AVSparameter_visible("xmax", 1);
		AVSmodify_parameter("xmax",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("xmax", 0);

	local_xmax = k;

	if (local_xmax < local_xmin)
		{
		k = local_xmax = local_xmin;
		if (NX > 1) 
			AVSmodify_parameter("xmax", AVS_VALUE, k, NULL, NULL);
		}
	}
else
	{
	AVSparameter_visible("xmin", 0);
	AVSparameter_visible("xmax", 0);
	}

if (NDIM >= 2)
	{
	i = (int) INPUT_MIN_YCOORD;
	j = (int) INPUT_MAX_YCOORD;
	k = cropy0;
	if ((k < i) || (k > j))
		k = i;
	if (NY > 1)
		{
		AVSparameter_visible("ymin", 1);
		AVSmodify_parameter("ymin",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("ymin", 0);

	local_ymin = k;

	k = cropy1;
	if ((k < i) || (k > j))
		k = j;
	if (NY > 1)
		{
		AVSparameter_visible("ymax", 1);
		AVSmodify_parameter("ymax",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("ymax", 0);

	local_ymax = k;

	if (local_ymax < local_ymin)
		{
		k = local_ymax = local_ymin;
		if (NY > 1)
			AVSmodify_parameter("ymax", AVS_VALUE, k, NULL, NULL);
		}
	}
else
	{
	AVSparameter_visible("ymin", 0);
	AVSparameter_visible("ymax", 0);
	}
if (NDIM >= 3)
	{
	i = (int) INPUT_MIN_ZCOORD;
	j = (int) INPUT_MAX_ZCOORD;
	k = zmin;
	if ((k < i) || (k > j))
		k = i;
	if (NZ > 1)
		{
		AVSparameter_visible("zmin", 1);
		AVSmodify_parameter("zmin",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("zmin", 0);

	local_zmin = k;

	k = zmax;
	if ((k < i) || (k > j))
		k = j;
	if (NZ > 1)
		{
		AVSparameter_visible("zmax", 1);
		AVSmodify_parameter("zmax",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("zmax", 0);

	local_zmax = k;

	if (local_zmax < local_zmin)
		{
		k = local_zmax = local_zmin;
		if (NZ > 1)
			AVSmodify_parameter("zmax", AVS_VALUE, k, NULL, NULL);
		}
	}
else
	{
	AVSparameter_visible("zmin", 0);
	AVSparameter_visible("zmax", 0);
	}
if (NDIM >= 4)
	{
	i = (int) INPUT_MIN_TCOORD;
	j = (int) INPUT_MAX_TCOORD;
	k = tmin;
	if ((k < i) || (k > j))
		k = i;
	if (NT > 1)
		{
		AVSparameter_visible("tmin", 1);
		AVSmodify_parameter("tmin",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("tmin", 0);

	local_tmin = k;

	k = tmax;
	if ((k < i) || (k > j))
		k = j;
	if (NT > 1)
		{
		AVSparameter_visible("tmax", 1);
		AVSmodify_parameter("tmax",
			AVS_VALUE | AVS_MINVAL | AVS_MAXVAL, k, i, j);
		}
	else
		AVSparameter_visible("tmax", 0);

	local_tmax = k;

	if (local_tmax < local_tmin)
		{
		k = local_tmax = local_tmin;
		if (NT > 1)
			AVSmodify_parameter("tmax", AVS_VALUE, k, NULL, NULL);
		}
	}
else
	{
	AVSparameter_visible("tmin", 0);
	AVSparameter_visible("tmax", 0);
	}

dim[0] = local_xmax - local_xmin + 1;
dim[1] = local_ymax - local_ymin + 1;
dim[2] = local_zmax - local_zmin + 1;
dim[3] = local_tmax - local_tmin + 1;

/* If this routine is used with AVS field-to-mesh, dimensions must be at
   least 2; user module NEWTILE can accept dimensions of 1 because a
   variable is passed from the NEWCROP (and NEWSLICE) module indicating
   what the slice axis is.  AVS modules apparently rely on a missing 
   dimension with coordinate ranges of 1 to indicate the slice axis.
*/
if (crop_limit_to_2)
	{
	for (i = 0; i < NDIM; ++i)
		{
		if ((dim[i] < 2) && (i != 3))	/* allow single TIME dim */
			{
			AVSerror("All output dimensions must be at least 2.");
			return(0);
			}
		}
	}

sprintf(field_str, "field %dD %d-space %d-vector uniform float",
	NDIM, NSPACE, NVEC);

if (*output_field)
	AVSfield_free((AVSfield *) *output_field);
if ((*output_field = (AVSfield_float *) 
	AVSdata_alloc(field_str, dim)) == NULL)
	{
	AVSerror("Cannot allocate memory for output field!");
	return(0);
	}	

in = out = 0;
switch(NDIM)
	{
	case 4:
		{
		for (l = INPUT_MIN_TCOORD; l <= INPUT_MAX_TCOORD ; ++l)
			{
			for (k = INPUT_MIN_ZCOORD; k <= INPUT_MAX_ZCOORD; ++k)
				{
				for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
					{
					for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
						{
						for (iv = 0; iv < NVEC; ++iv)
							{
							if (
							(l >= local_tmin) &&
							(l <= local_tmax) &&	
							(k >= local_zmin) &&
							(k <= local_zmax) &&
							(j >= local_ymin) &&
							(j <= local_ymax) &&
							(i >= local_xmin) &&
							(i <= local_xmax))
								{
						OUTPUT_POINT = INPUT_POINT;
								++out;
								}
							++in;
							}
						}
					}
				}
			}
		break;
		}
	case 3:
		{
		for (k = INPUT_MIN_ZCOORD; k <= INPUT_MAX_ZCOORD; ++k)
			{
			for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
				{
				for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
					{
					for (iv = 0; iv < NVEC; ++iv)
						{
						if (
						(k >= local_zmin) &&
						(k <= local_zmax) &&
						(j >= local_ymin) &&
						(j <= local_ymax) &&
						(i >= local_xmin) &&
						(i <= local_xmax))
							{
						OUTPUT_POINT = INPUT_POINT;
							++out;
							}
						++in;
						}
					}
				}
			}
		break;
		}
	case 2:
		{
		for (j = INPUT_MIN_YCOORD; j <= INPUT_MAX_YCOORD; ++j)
			{
			for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
				{
				for (iv = 0; iv < NVEC; ++iv)
					{
					if (
					(j >= local_ymin) &&
					(j <= local_ymax) &&
					(i >= local_xmin) &&
					(i <= local_xmax))
						{
						OUTPUT_POINT = INPUT_POINT;
						++out;
						}
					++in;
					}
				}
			}
		break;
		}
	case 1:
		{
		for (i = INPUT_MIN_XCOORD; i <= INPUT_MAX_XCOORD; ++i)
			{
			for (iv = 0; iv < NVEC; ++iv)
				{
				if (
					(i >= local_xmin) &&
					(i <= local_xmax))
					{
					OUTPUT_POINT = INPUT_POINT;
					++out;
					}
				++in;
				}
			}
		break;
		}
	}

if (NDIM >= 1)
	{
	minext[0] = input_field->min_extent[0];
	maxext[0] = input_field->max_extent[0];
	OUTPUT_MIN_XCOORD = local_xmin;
	OUTPUT_MAX_XCOORD = local_xmax;
	}
if (NDIM >= 2)
	{
	minext[1] = input_field->min_extent[1];
	maxext[1] = input_field->max_extent[1];
	OUTPUT_MIN_YCOORD = local_ymin;
	OUTPUT_MAX_YCOORD = local_ymax;
	}
if (NDIM >= 3)
	{
	minext[2] = input_field->min_extent[2];
	maxext[2] = input_field->max_extent[2];
	OUTPUT_MIN_ZCOORD = local_zmin;
	OUTPUT_MAX_ZCOORD = local_zmax;
	}
if (NDIM >= 4)
	{
	OUTPUT_MIN_TCOORD = local_tmin;
	OUTPUT_MAX_TCOORD = local_tmax;
	}

AVSfield_set_extent((AVSfield *) *output_field, minext, maxext);

if (reset_field_minmax)
	AVSfield_reset_minmax((AVSfield *) *output_field);
else
        {
        (*output_field)->minimum = input_field->minimum;
        (*output_field)->maximum = input_field->maximum;
        }

sscanf(input_field->labels, "%c", delimiter);
delimiter[1] = '\0';
AVSfield_set_labels((AVSfield *) (*output_field), input_field->labels+1,
	delimiter);

sscanf(input_field->units, "%c", delimiter);
delimiter[1] = '\0';
AVSfield_set_units((AVSfield *) (*output_field), input_field->units+1,
	delimiter);

if (str != NULL)

/* IAC CODE CHANGE :         free((char *) str); */
         free( str);
 
if ((str = ((char *) malloc(sizeof(char) * 1024))) == NULL)
        {
        AVSerror("Cannot allocate string for output!"); 
        return(0);
        }
sprintf(str, "%d %d %d %d %d %d %d %d",
	local_xmin, local_xmax, local_ymin, local_ymax,
	local_zmin, local_zmax, local_tmin, local_tmax);

*output_string = str;
 
return(1);
}

#ifdef SEPARATE_MODULES
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	NEW_CROP_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

