/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
/* IAC CODE CHANGE : #include <math.h>  */
#include <avs/avs_math.h>
#include "separate.h"

/* NOTE:  The unsigned integer function for color as implemented here does
   not work correctly on the DEC __alpha, so floating point colors are
   used instead for that machine.  This should be investigated further.
*/ 

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int NEW_LEGEND_desc()
{

	int in_port, out_port, param;
	extern int NEW_LEGEND_compute();

	AVSset_module_name("NEW LEGEND", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */

	in_port = AVScreate_input_port("input_color_map", "colormap",
		REQUIRED);

	in_port = AVScreate_input_port("Data Minimum", "real", REQUIRED);

	in_port = AVScreate_input_port("Data Maximum", "real", REQUIRED);

	in_port = AVScreate_input_port("Map Info", "string", OPTIONAL);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("geom_output", "geom");

	/* Parameter Specifications */
	param = AVSadd_parameter("Color Bins", "integer", 8, 1, 256);
	AVSconnect_widget(param, "idial");

	param = AVSadd_parameter("Labels", "integer", 8, 1, 256);
	AVSconnect_widget(param, "idial");

	param = AVSadd_float_parameter("X Scale", 1.0, 0.0, FLOAT_UNBOUND); 
	AVSconnect_widget(param, "dial");

	param = AVSadd_float_parameter("Y Scale", 1.0, 0.0, FLOAT_UNBOUND); 
	AVSconnect_widget(param, "dial");

	param = AVSadd_float_parameter("X Offset", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param, "dial");

	param = AVSadd_float_parameter("Y Offset", 0.0,
		FLOAT_UNBOUND, FLOAT_UNBOUND); 
	AVSconnect_widget(param, "dial");

	param = AVSadd_float_parameter("Font Height", 0.06, 0.0, 1.0); 
	AVSconnect_widget(param, "typein_real");

	param = AVSadd_parameter("Label Format",
		 "string", "%7.3f", NULL, NULL); 
	AVSconnect_widget(param, "typein");

	param = AVSadd_parameter("Border", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("Number Line", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("Use Map Info", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	param = AVSadd_parameter("Font", "integer", 0, 0, 21);
	AVSconnect_widget(param, "islider");

	param = AVSadd_parameter("Legend Type", "choice", 
		"VERTICAL", "VERTICAL:HORIZONTAL", ":");
	AVSconnect_widget(param, "radio_buttons");

	param = AVSadd_parameter("Vertical Label Position", "choice", 
		"RIGHT", "LEFT:RIGHT", ":");
	AVSconnect_widget(param, "radio_buttons");

	param = AVSadd_parameter("Horizontal Label Position", "choice", 
		"ALTERNATING", "TOP:BOTTOM:ALTERNATING", ":");
	AVSconnect_widget(param, "radio_buttons");

	param = AVSadd_float_parameter("Line Red", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Line Green", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Line Blue", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Label Red", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Label Green", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	param = AVSadd_float_parameter("Label Blue", 1.0, 0.0, 1.0);
	AVSconnect_widget(param, "slider");

	AVSset_compute_proc(NEW_LEGEND_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int NEW_LEGEND_compute(input_color_map, data_min, data_max, 
	map_info, geom_output,
	nbin, nlabel, xscale, yscale, xoffset, yoffset,
	font_height, label_format, border, number_line, use_map_info,
	font_number, legend_type, vlabel_pos, hlabel_pos,
	line_red, line_green, line_blue, label_red, label_green, label_blue)
AVScolormap *input_color_map;
float *data_min;
float *data_max;
char *map_info;
GEOMedit_list *geom_output;
int nbin;
int nlabel;
float *xscale;
float *yscale;
float *xoffset;
float *yoffset;
float *font_height;
char *label_format;
int border;
int number_line;
int use_map_info;
int font_number;
char *legend_type;
char *vlabel_pos;
char *hlabel_pos;
float *line_red;
float *line_green;
float *line_blue;
float *label_red;
float *label_green;
float *label_blue;
{

GEOMobj *obj;
GEOMobj *label_obj;
GEOMobj *line_obj;

float x, y, x0, y0, x1, y1, z; 
float binwidth, labelwidth, colorscale;
float xinc, yinc;
float data;

float local_xoffset;
float local_yoffset;
float local_xscale;
float local_yscale;

static int title = 0;
static int background = 0;
static int drop = 0;
static int align = 0;
static int stroke = 0;

static float ref_point[3];
static float offset[3];
static float lineverts[6];
static float linecolors[6];
static float label_colors[6];
static char str[64];

static float vert_xoffset, vert_yoffset;
static float vert_xscale, vert_yscale;
static float horiz_xoffset, horiz_yoffset;
static float horiz_xscale, horiz_yscale;

int label_flags;

float *verts = NULL;

#ifdef __alpha
float *colors = NULL;
float red, green, blue;
#else
unsigned int *colors = NULL;
unsigned int rgb_color;
#endif

int *plist = NULL;

register int i, j, k, in, ncolor, zbin, color_index, nverts;

if ((verts = ((float *) malloc(sizeof(float) * 12 * nbin))) == NULL)
	{
	AVSerror("Cannot allocate vertices buffer in new legend.");
	return(0);
	}
if ((plist = ((int *) malloc(sizeof(int) * (5 * nbin + 1)))) == NULL)
	{
	AVSerror("Cannot allocate polygon list buffer in new legend.");
	return(0);
	}

#ifdef __alpha
if ((colors = ((float *) malloc(sizeof(float)
	 * 3 * 4 * nbin))) == NULL)
	{
	AVSerror("Cannot allocate colors buffer in new legend.");
	return(0);
	}
#else
if ((colors = ((unsigned int *) malloc(sizeof(unsigned int)
	 * 4 * nbin))) == NULL)
	{
	AVSerror("Cannot allocate colors buffer in new legend.");
	return(0);
	}
#endif

binwidth = (*data_max - *data_min)/((float) nbin);
labelwidth = (*data_max - *data_min)/((float) nlabel);
	
if (nbin > 1)
	colorscale = 255.0/((float) (nbin - 1));
else
	colorscale = 0.0;

linecolors[0] = linecolors[3] = *line_red;
linecolors[1] = linecolors[4] = *line_green;
linecolors[2] = linecolors[5] = *line_blue;

label_colors[0] = label_colors[3] = *label_red;
label_colors[1] = label_colors[4] = *label_green;
label_colors[2] = label_colors[5] = *label_blue;


if (use_map_info)
	{
	if (map_info == NULL)
		{
		AVSerror("Cannot use NULL map info input.");
		return(0);	
		} 

	if (sscanf(map_info, "%g%g%g%g%g%g%g%g",
		&vert_xoffset, &vert_yoffset, &vert_xscale, &vert_yscale,
		&horiz_xoffset, &horiz_yoffset, &horiz_xscale, &horiz_yscale)
		 == 8)
		{
		if (!strcmp(legend_type, "VERTICAL"))
			{
			local_xoffset = vert_xoffset;
			local_yoffset = vert_yoffset;
			local_xscale = vert_xscale;
			local_yscale = vert_yscale;
			}
		else if (!strcmp(legend_type, "HORIZONTAL"))
			{
			local_xoffset = horiz_xoffset;
			local_yoffset = horiz_yoffset;
			local_xscale = horiz_xscale;
			local_yscale = horiz_yscale;
			}
		AVSmodify_float_parameter("X Offset",
			AVS_VALUE, local_xoffset, 0.0, 0.0);
		AVSmodify_float_parameter("Y Offset",
			AVS_VALUE, local_yoffset, 0.0, 0.0);
		AVSmodify_float_parameter("X Scale", 
			AVS_VALUE, local_xscale, 0.0, 0.0);
		AVSmodify_float_parameter("Y Scale", 
			AVS_VALUE, local_yscale, 0.0, 0.0);
		}
	}
else
	{
	local_xoffset = *xoffset;
	local_yoffset = *yoffset;
	local_xscale = *xscale;
	local_yscale = *yscale;
	}

obj = GEOMcreate_obj(GEOM_POLYHEDRON, GEOM_NULL);
line_obj = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
label_obj = GEOMcreate_obj(GEOM_LABEL, GEOM_NULL);

if (!strcmp(legend_type, "VERTICAL"))
	{

	AVSparameter_visible("Vertical Label Position", 1);
	AVSparameter_visible("Horizontal Label Position", 0);

	/* left justify label on RIGHT side of color bar;
	   right justify label on LEFT side of color bar */

	if (!strcmp(vlabel_pos, "RIGHT"))
		align = GEOM_LABEL_LEFT;
	else if (!strcmp(vlabel_pos, "LEFT"))
		align = GEOM_LABEL_RIGHT;

	label_flags = GEOMcreate_label_flags(font_number, title, background, drop,
		align, stroke);

	x0 = local_xoffset;
	x1 = x0 + local_xscale;
	y = local_yoffset;
	yinc = local_yscale/((float) nbin);

	nverts = k = ncolor = 0;
	for (i = 0; i < nbin; ++i)
		{
		y0 = y;
		y1 = y + yinc;

		verts[0+k] = x0;
		verts[1+k] = y0;
		verts[2+k] = verts[5+k] = verts[8+k] = verts[11+k] = 0.0;
		verts[3+k] = x0;
		verts[4+k] = y1;
		verts[6+k] = x1;
		verts[7+k] = y1;
		verts[9+k] = x1;
		verts[10+k] = y0;

		j = (int) (i * colorscale + .5);
#ifdef __alpha
		hsv2rgb(input_color_map->hue[j] * 360.0,
			input_color_map->saturation[j],
			input_color_map->value[j],
			&red, &green, &blue);
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
#else
		hsv2rgb_byte(input_color_map->hue[j] * 360.0,
			input_color_map->saturation[j],
			input_color_map->value[j],
			&rgb_color);
		colors[ncolor] = colors[ncolor+1] = colors[ncolor+2] = 
			colors[ncolor+3] = rgb_color;
		ncolor += 4;
#endif

		k += 12;
		nverts += 4;
		y = y1;
		}

	j = 1;
	for (i = 0; i < nbin * 5; i += 5)
		{
		*(plist+i) = 4;
		*(plist+i+1) = j++;
		*(plist+i+2) = j++;
		*(plist+i+3) = j++;
		*(plist+i+4) = j++;
		}
	*(plist+i) = 0; 

	x0 = local_xoffset;
	x1 = x0 + local_xscale;
	y = local_yoffset;
	yinc = local_yscale/((float) nlabel);
	data = *data_min;

	offset[0] = offset[2] = 0.0;
	offset[1] = -(*font_height)/3.0;
	for (i = 0; i <= nlabel; ++i)
		{
		y0 = y;
		y1 = y + yinc;

		sprintf(str, label_format, data);
		if (!strcmp(vlabel_pos, "RIGHT"))
			ref_point[0] = x1 + local_xscale;
		else
			ref_point[0] = x0 - local_xscale;
		ref_point[1] = y;
		ref_point[2] = 0.0; 
		GEOMadd_label(label_obj, str, ref_point, offset, *font_height,
			label_colors, label_flags); 
		if (number_line)
			{
			lineverts[0] = x0;
			lineverts[1] = y0;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[3] = x1;
			lineverts[4] = y0;
			GEOMadd_disjoint_line(line_obj, lineverts,
				 linecolors, 2, GEOM_COPY_DATA);
			}
		data += labelwidth;
		y = y1;
		}

	if (border)
		{
		lineverts[0] = lineverts[3] = local_xoffset;
		lineverts[1] = local_yoffset;
		lineverts[2] = lineverts[5] = 0.0;
		lineverts[4] = local_yoffset + local_yscale;
		GEOMadd_disjoint_line(line_obj, lineverts, linecolors,
			 2, GEOM_COPY_DATA);

		lineverts[0] = lineverts[3] = local_xoffset + local_xscale;
		lineverts[1] = local_yoffset;
		lineverts[2] = lineverts[5] = 0.0;
		lineverts[4] = local_yoffset + local_yscale;
		GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 
			2, GEOM_COPY_DATA);
		if (!number_line)
			{
			lineverts[0] = local_xoffset;
			lineverts[1] = lineverts[4] = local_yoffset;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[3] = local_xoffset + local_xscale;
			GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 2, 
					GEOM_COPY_DATA);
			lineverts[0] = local_xoffset;
			lineverts[1] = lineverts[4] = local_yoffset + local_yscale;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[3] = local_xoffset + local_xscale;
			GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 2, 
					GEOM_COPY_DATA);
			}
		}
	}
else if (!strcmp(legend_type, "HORIZONTAL"))
	{

	AVSparameter_visible("Vertical Label Position", 0);
	AVSparameter_visible("Horizontal Label Position", 1);

	align = GEOM_LABEL_CENTER;

	label_flags = GEOMcreate_label_flags(font_number, title, background, drop,
		align, stroke);

	y0 = local_yoffset;
	y1 = y0 + local_yscale;
	x = local_xoffset;
	xinc = local_xscale/((float) nbin);

	nverts = k = ncolor = 0;
	for (i = 0; i < nbin; ++i)
		{
		x0 = x;
		x1 = x + xinc;

		verts[0+k] = x0;
		verts[1+k] = y0;
		verts[2+k] = verts[5+k] = verts[8+k] = verts[11+k] = 0.0;
		verts[3+k] = x0;
		verts[4+k] = y1;
		verts[6+k] = x1;
		verts[7+k] = y1;
		verts[9+k] = x1;
		verts[10+k] = y0;

		j = (int) (i * colorscale + .5);
#ifdef __alpha
		hsv2rgb(input_color_map->hue[j] * 360.0,
			input_color_map->saturation[j],
			input_color_map->value[j],
			&red, &green, &blue);
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
		colors[ncolor++] = red;
		colors[ncolor++] = green;
		colors[ncolor++] = blue;
#else
		hsv2rgb_byte(input_color_map->hue[j] * 360.0,
			input_color_map->saturation[j],
			input_color_map->value[j],
			&rgb_color);
		colors[ncolor] = colors[ncolor+1] = colors[ncolor+2] = 
			colors[ncolor+3] = rgb_color;
		ncolor += 4;
#endif
		k += 12;
		nverts += 4;
		x = x1;
		}

	j = 1;
	for (i = 0; i < nbin * 5; i += 5)
		{
		*(plist+i) = 4;
		*(plist+i+1) = j++;
		*(plist+i+2) = j++;
		*(plist+i+3) = j++;
		*(plist+i+4) = j++;
		}
	*(plist+i) = 0; 

	y0 = local_yoffset;
	y1 = y0 + local_yscale;
	x = local_xoffset;
	xinc = local_xscale/((float) nlabel);
	data = *data_min;

	offset[0] = offset[1] = offset[2] = 0.0;
	for (i = 0; i <= nlabel; ++i)
		{
		x0 = x;
		x1 = x + xinc;

		sprintf(str, label_format, data);
		if (!strcmp(hlabel_pos, "TOP"))
			ref_point[1] = y1 + local_yscale;
		else if (!strcmp(hlabel_pos, "BOTTOM"))
			ref_point[1] = y0 - local_yscale * 2.0;
		else if (!strcmp(hlabel_pos, "ALTERNATING"))
			{
			if (i % 2)
				ref_point[1] = y1 + local_yscale;
			else 
				ref_point[1] = y0 - local_yscale * 2.0;
			}

		ref_point[0] = x;
		ref_point[2] = 0.0; 
		GEOMadd_label(label_obj, str, ref_point, offset, *font_height,
			label_colors, label_flags); 
		if (number_line)
			{
			lineverts[0] = x0;
			lineverts[1] = y0;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[3] = x0;
			lineverts[4] = y1;
			GEOMadd_disjoint_line(line_obj, lineverts,
				 linecolors, 2, GEOM_COPY_DATA);
			}
		data += labelwidth;
		x = x1;
		}

	if (border)
		{
		lineverts[0] = local_xoffset;
		lineverts[1] = lineverts[4] = local_yoffset;
		lineverts[2] = lineverts[5] = 0.0;
		lineverts[3] = local_xoffset + local_xscale;
		GEOMadd_disjoint_line(line_obj, lineverts, linecolors,
			 2, GEOM_COPY_DATA);

		lineverts[0] = local_xoffset;
		lineverts[1] = lineverts[4] = local_yoffset + local_yscale;
		lineverts[2] = lineverts[5] = 0.0;
		lineverts[3] = local_xoffset + local_xscale;
		GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 
			2, GEOM_COPY_DATA);
		if (!number_line)
			{
			lineverts[0] = lineverts[3] = local_xoffset;
			lineverts[1] = local_yoffset;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[4] = local_yoffset + local_yscale;
			GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 2, 
					GEOM_COPY_DATA);
			lineverts[0] = lineverts[3] = local_xoffset + local_xscale;
			lineverts[1] = local_yoffset;
			lineverts[2] = lineverts[5] = 0.0;
			lineverts[4] = local_yoffset + local_yscale;
			GEOMadd_disjoint_line(line_obj, lineverts, linecolors, 2, 
					GEOM_COPY_DATA);
			}
		}
	}

GEOMadd_vertices(obj, verts, nverts, GEOM_COPY_DATA);
GEOMadd_polygons(obj, plist, GEOM_CONVEX, GEOM_COPY_DATA);

#ifdef __alpha
if (input_color_map != NULL)
	GEOMadd_float_colors(obj, colors, ncolor, GEOM_COPY_DATA);
#else
if (input_color_map != NULL)
	GEOMadd_int_colors(obj, colors, ncolor, GEOM_COPY_DATA);
#endif

*geom_output = GEOMinit_edit_list(*geom_output);
GEOMedit_geometry(*geom_output, "legend_object", obj);
GEOMedit_geometry(*geom_output, "legend_label_object", label_obj);
GEOMedit_geometry(*geom_output, "legend_line_object", line_obj);
GEOMedit_render_mode(*geom_output, "legend_object", "no_light");
GEOMdestroy_obj(obj);
GEOMdestroy_obj(label_obj);
GEOMdestroy_obj(line_obj);
if (verts != NULL)

/* IAC CODE CHANGE : 	free((char *) verts); */
	 free( verts);
if (colors != NULL)

/* IAC CODE CHANGE : 	free((char *) colors); */
	 free( colors);
if (plist != NULL)

/* IAC CODE CHANGE : 	free((char *) plist); */
	 free( plist);
return(1);
}

#ifdef SEPARATE_MODULES

/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
NEW_LEGEND_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif


