/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/colormap.h>
/* IAC CODE CHANGE : #include <math.h>  */
#include <avs/avs_math.h>
#include "separate.h"
 
/* NOTE:  The unsigned integer function for color as implemented here does
   not work correctly on the DEC __alpha, so floating point colors are
   used instead for that machine.  This should be investigated further.
*/
 

/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int NEW_TILE_desc()
{

int in_port, out_port, param;
extern int NEW_TILE_compute();

AVSset_module_name("NEW TILE", MODULE_MAPPER);
AVSset_module_flags(COOPERATIVE);

/* Input Port Specifications               */
in_port = AVScreate_input_port("input_field", 
	"field uniform float", REQUIRED);

in_port = AVScreate_input_port("input_color_map", "colormap",
	OPTIONAL);

in_port = AVScreate_input_port("Data Minimum", "real", REQUIRED);

in_port = AVScreate_input_port("Data Maximum", "real", REQUIRED);

in_port = AVScreate_input_port("slice axis", "string", REQUIRED);

/* Output Port Specifications              */
out_port = AVScreate_output_port("geom_output", "geom");

/* Parameter Specifications */
param = AVSadd_parameter("Color Bins", "integer", 8, 1, 256);
AVSconnect_widget(param, "idial");

param = AVSadd_parameter("Mesh", "boolean", 0, 0, 1);
AVSconnect_widget(param, "toggle");

param = AVSadd_float_parameter("Mesh Red", 1.0, 0.0, 1.0);
AVSconnect_widget(param, "slider");

param = AVSadd_float_parameter("Mesh Green", 1.0, 0.0, 1.0);
AVSconnect_widget(param, "slider");

param = AVSadd_float_parameter("Mesh Blue", 1.0, 0.0, 1.0);
AVSconnect_widget(param, "slider");

AVSset_compute_proc(NEW_TILE_compute);
return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int NEW_TILE_compute(input_field, input_color_map, data_min, data_max,
	 input_slice_axis,
	 geom_output, nbin, mesh, mesh_red, mesh_green, mesh_blue)
AVSfield_float *input_field;
AVScolormap *input_color_map;
float *data_min, *data_max;
char *input_slice_axis;
GEOMedit_list *geom_output;
int nbin;
int mesh;
float *mesh_red, *mesh_green, *mesh_blue;
{
GEOMobj *obj;
GEOMobj *mesh_obj;
float x, y, z, x0, y0, x1, y1, z0, z1; 
float red, green, blue;
float binwidth, colorscale;

float *verts = NULL;
int *plist = NULL;

int slice_axis;

register int i, j, k, in, ncolor, zbin, color_index, nverts, out, iz;

static float datatable[256];

#ifdef __alpha
static float redcolortable[256];
static float greencolortable[256];
static float bluecolortable[256];
float *colors = NULL;
#else
static unsigned int colortable[256];
unsigned int *colors = NULL;
#endif

static int firsttime = 1;
static int data_firsttime = 1;
static int mesh_visible = 0;

int ir, ig, ib;
int prev_color;

#define INPUT input_field->data[in]

#define XCOORD_MIN ((int) (input_field->points[0]))
#define XCOORD_MAX ((int) (input_field->points[1]))
#define YCOORD_MIN ((int) (input_field->points[2]))
#define YCOORD_MAX ((int) (input_field->points[3]))
#define ZCOORD_MIN ((int) (input_field->points[4]))
#define ZCOORD_MAX ((int) (input_field->points[5]))

#define NX ((int) ((XCOORD_MAX - XCOORD_MIN) + 1) )
#define NY ((int) ((YCOORD_MAX - YCOORD_MIN) + 1) )
#define NZ ((int) ((ZCOORD_MAX - ZCOORD_MIN) + 1) )

#define SLICE_XAXIS 1
#define SLICE_YAXIS 2
#define SLICE_ZAXIS 3

if (!strcmp(input_slice_axis, "X"))
	slice_axis = SLICE_XAXIS;
else if (!strcmp(input_slice_axis, "Y"))
	slice_axis = SLICE_YAXIS;
else if (!strcmp(input_slice_axis, "Z"))
	slice_axis = SLICE_ZAXIS;
else
	{
	AVSerror("Slice axis must be X or Y or Z.");
	return(0);
	}

if ((verts = ((float *) malloc(sizeof(float) * 12 * NX * NY * NZ))) == NULL)
	{
	AVSerror("Cannot allocate vertices buffer in new tile.");
	return(0);
	}
if ((plist = ((int *) malloc(sizeof(int) * (5 * NX * NY  * NZ + 1)))) == NULL)
	{
	AVSerror("Cannot allocate polygon list buffer in new tile.");

/* IAC CODE CHANGE : 	free((char *) verts); */
	 free( verts);
	return(0);
	}
if ((AVSinput_changed("Data Minimum", 0)) || 
    (AVSinput_changed("Data Maximum", 0)) || 
    (AVSinput_changed("input_color_map", 0)) ||
    (AVSparameter_changed("Color Bins")) || (data_firsttime))
	{
	if (*data_max == *data_min)
		binwidth = 1.0;
	else
		binwidth = (*data_max - *data_min)/((float) nbin);
	for (i = 0; i < nbin; ++i)
		{
		datatable[i] = (float) (*data_min + i * binwidth);
		}
	data_firsttime = 0;
	}
if (input_color_map != NULL)
	{
#ifdef __alpha
	if ((colors = ((float *) malloc(sizeof(float)
		 * 3 * 4 * NX * NY * NZ))) == NULL)
		{
		AVSerror("Cannot allocate colors buffer in new tile.");

/* IAC CODE CHANGE : 		free((char *) verts); */
		 free( verts);

/* IAC CODE CHANGE : 		free((char *) plist); */
		 free( plist);
		return(0);
		}
#else
	if ((colors = ((unsigned int *) malloc(sizeof(unsigned int)
		 * 4 * NX * NY * NZ))) == NULL)
		{
		AVSerror("Cannot allocate colors buffer in new tile.");

/* IAC CODE CHANGE : 		free((char *) verts); */
		 free( verts);

/* IAC CODE CHANGE : 		free((char *) plist); */
		 free( plist);
		return(0);
		}
#endif
	if ((AVSinput_changed("input_color_map", 0)) || 
		(AVSparameter_changed("Color Bins")) || (firsttime) ||
		(AVSinput_changed("Data Minimum", 0)) || 
    		(AVSinput_changed("Data Maximum", 0)))  
		{
		if (nbin > 1)
			colorscale = 255.0/((float) (nbin - 1));
		else
			colorscale = 0.0;
		for (i = 0; i < nbin; ++i)
			{
			j = (int) (i * colorscale + .5);
			if (j < 0)
				j = 0;
			if (j > 255)
				j = 255;
			
#ifdef __alpha
			hsv2rgb(input_color_map->hue[j] * 360.0,
				input_color_map->saturation[j],
				input_color_map->value[j],
				redcolortable+i,
				greencolortable+i,
				bluecolortable+i);
#else
			hsv2rgb_byte(input_color_map->hue[j] * 360.0,
				input_color_map->saturation[j],
				input_color_map->value[j],
				colortable+i);
#endif
			}
		firsttime = 0;
		}
	}

in = out = nverts = k = ncolor = 0;
for (iz = ZCOORD_MIN; iz <= ZCOORD_MAX; ++iz)
	{
	for (j = YCOORD_MIN; j <= YCOORD_MAX; ++j)
		{
		for (i = XCOORD_MIN; i <= XCOORD_MAX; ++i)
			{
			if (input_color_map != NULL)
				{
				for (color_index = 0; color_index < nbin-1;
			 		++color_index)
					if ((INPUT >= datatable[color_index]) &&
			    		(INPUT < datatable[color_index+1]))
						break;
				if (INPUT >= datatable[nbin-1])
					color_index = nbin -1;
				if (INPUT <= datatable[0])
					color_index = 0;
				}
			else
				color_index = -1;

			if (slice_axis == SLICE_XAXIS)
				{
				x0 = x1 = ((float)(i));
				y0 = ((float) j) - .5;
				y1 = ((float) j) + .5;
				z0 = ((float) iz) - .5;
				z1 = ((float) iz) + .5;
				}
			else if (slice_axis == SLICE_YAXIS)
				{
				x0 = ((float) i) - .5;
				x1 = ((float) i) + .5;
				y0 = y1 = ((float) (j));
				z0 = ((float) iz) - .5;
				z1 = ((float) iz) + .5;
				}
			else if (slice_axis == SLICE_ZAXIS)
				{
				x0 = ((float) i) - .5;
				x1 = ((float) i) + .5;
				y0 = ((float) j) - .5;
				y1 = ((float) j) + .5;
				z0 = z1 = ((float) (iz));
				}

/* For optimization of Z slices, adjacent squares on the same row of
   identical color will be drawn as a single polygon of that color.
   Don't do this if mesh is required.  Optimization in the X and Y
   directions may be less critical since the volume of data will likely
   be much less, and it is not done here though it may be added at a 
   later time.
*/

			if ((i > XCOORD_MIN) && (color_index == prev_color) &&
				(slice_axis == SLICE_ZAXIS) && (!mesh))
				{
				verts[k-6] = x1;
                        	verts[k-3] = x1;
				}
			else
				{
				verts[0+k] = x0;
				verts[1+k] = y0;
				if (slice_axis == SLICE_YAXIS)
					{
					verts[2+k] = verts[11+k] = z0;
					verts[5+k] = verts[8+k] = z1;
					}
				else
					{
					verts[2+k] = verts[5+k] = z0;
					verts[8+k] = verts[11+k] = z1;
					}
				verts[3+k] = x0;
				verts[4+k] = y1;
				verts[6+k] = x1;
				verts[7+k] = y1;
				verts[9+k] = x1;
				verts[10+k] = y0;
	
				if (input_color_map != NULL)
					{
#ifdef __alpha
				colors[ncolor++] = redcolortable[color_index];
				colors[ncolor++] = greencolortable[color_index];
				colors[ncolor++] = bluecolortable[color_index];
				colors[ncolor++] = redcolortable[color_index];
				colors[ncolor++] = greencolortable[color_index];
				colors[ncolor++] = bluecolortable[color_index];
				colors[ncolor++] = redcolortable[color_index];
				colors[ncolor++] = greencolortable[color_index];
				colors[ncolor++] = bluecolortable[color_index];
				colors[ncolor++] = redcolortable[color_index];
				colors[ncolor++] = greencolortable[color_index];
				colors[ncolor++] = bluecolortable[color_index];
#else
					colors[ncolor] = colors[ncolor+1] =
				 	colors[ncolor+2] = colors[ncolor+3] =
						 colortable[color_index];
					ncolor += 4;
#endif
					}
				k += 12;
				++out;
				nverts += 4;
				}
			prev_color = color_index;
			++in;
			}
		}
	}
j = 1;
for (i = 0; i < out * 5; i += 5)
	{
	*(plist+i) = 4;
	*(plist+i+1) = j++;
	*(plist+i+2) = j++;
	*(plist+i+3) = j++;
	*(plist+i+4) = j++;
	}
*(plist+i) = 0; 

obj = GEOMcreate_obj(GEOM_POLYHEDRON, GEOM_NULL);
GEOMadd_vertices(obj, verts, nverts, GEOM_COPY_DATA);
GEOMadd_polygons(obj, plist, GEOM_CONVEX, GEOM_COPY_DATA);

#ifdef __alpha
if (input_color_map != NULL)
	GEOMadd_float_colors(obj, colors, ncolor, GEOM_COPY_DATA);
#else
if (input_color_map != NULL)
	GEOMadd_int_colors(obj, colors, ncolor, GEOM_COPY_DATA);
#endif

*geom_output = GEOMinit_edit_list(*geom_output);
GEOMedit_geometry(*geom_output, "tile_object", obj);
GEOMedit_render_mode(*geom_output, "tile_object", "no_light");

if (mesh)
	{
	for (i = 0; i < ncolor; ++i)
		{
		ir = (int) (*mesh_red * 255.0);
		ig = (int) (*mesh_green * 255.0);
		ib = (int) (*mesh_blue * 255.0);
		colors[i] = (unsigned int)
((ir << AVS_RED_SHIFT) | (ig << AVS_GREEN_SHIFT) | (ib << AVS_BLUE_SHIFT));
		}

	mesh_obj = GEOMcreate_obj(GEOM_POLYHEDRON, GEOM_NULL);
	GEOMadd_vertices(mesh_obj, verts, nverts, GEOM_COPY_DATA);
	GEOMadd_polygons(mesh_obj, plist, GEOM_CONVEX, GEOM_COPY_DATA);
	GEOMadd_int_colors(mesh_obj, colors, ncolor, GEOM_COPY_DATA);
	GEOMedit_geometry(*geom_output, "tile_mesh_object", mesh_obj);
	GEOMedit_render_mode(*geom_output, "tile_mesh_object", "lines");
	mesh_visible = 1;
	GEOMedit_visibility(*geom_output, "tile_mesh_object", mesh_visible);
	}
else if (mesh_visible)
	{
	mesh_visible = 0;
	GEOMedit_visibility(*geom_output, "tile_mesh_object", mesh_visible);
	}

GEOMdestroy_obj(obj);
if (verts != NULL)

/* IAC CODE CHANGE : 	free((char *) verts); */
	 free( verts);
if (colors != NULL)

/* IAC CODE CHANGE : 	free((char *) colors); */
	 free( colors);
if (plist != NULL)

/* IAC CODE CHANGE : 	free((char *) plist); */
	 free( plist);
return(1);
}

#ifdef SEPARATE_MODULES
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
NEW_TILE_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
AVSinit_from_module_list(mod_list, NMODS);
}

#endif

