/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* NOTE:  THIS MODULE AND SOURCE CODE IS FOR USE 
   WITH THE AVS SOFTWARE ENVIRONMENT ONLY */
/*
 * Ortho_Texture
 *
 * Displays a 2D section mesh
 * as a textured low-res geometry,
 * rather than a high-res vertex colored geometry.
 * Input field must be uniform.
 *
 * Author:
 *  Scott Goodyear, Advanced Visual Systems, Inc.
 *
 * A variation on field_to_mesh
 *
 * Revision History:
 *  18 May 92, ianc Adapted for UK demos
 *
 */
#ifdef SCCS
static char sccsid[]="@(#)field2mesh.c	8.4 Stardent 93/01/12";
#endif
/*
			Copyright (c) 1989 by
			Stardent Computer Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Stardent Computer Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at Stardent in:
	/sccs1.p/avs/modules/mappers/s.field2mesh.c
	
*/
/* 
 * AVS primitive mapper module wrappers.
 */


#include <stdio.h>

#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/geomdata.h>
#include <avs/colormap.h>


/**********************************************************************/

MODfield_to_mesh()
{
	int field_to_mesh_compute();

	AVSset_module_name("Ortho Texture", MODULE_MAPPER);
	AVSset_module_flags( COOPERATIVE | REENTRANT );
	AVScreate_input_port("Field Input","field 2D scalar", REQUIRED);
        AVScreate_input_port("texture", "field 2D 4-vector byte", OPTIONAL);
	
	AVScreate_output_port("geometry", "geom");
#ifdef NORMALIZE
        AVSadd_parameter("Normalize", "boolean", 0, 0, 1);
#endif
	AVSset_compute_proc(field_to_mesh_compute);
}

#ifdef NORMALIZE
static
field_to_mesh_compute(input, output, normalize)
AVSfield *input;
GEOMedit_list *output;
int   normalize;
#else
static
field_to_mesh_compute(input, texture, output)
AVSfield *input;
AVSfield *texture;
GEOMedit_list *output;
#endif
{
   GEOMobj *obj;
   float   *fmesh, min, max;
   AVScolormap *colormap;
   unsigned int color_lut[BYTE_TABLE], *colors;
   int size, i, j, indexer;
   int  axis;
   float   extent[6], min_extent[3], max_extent[3];
   float	tx, ty, tz;
   float        x0, y0, z0, xmax, ymax, zmax;
   float   verts[4][3];
   float   uvs[4][2];

#ifdef NORMALIZE
   /* normalize the data if necessary */
   if (normalize) 
     AVSfield_normalize(input);
#endif

#ifdef AUTO_TRANSFORM
   if (!AVSfield_get_extent (input, min_extent, max_extent)) {
      for (i = 0; i < 3; i++) {
	 min_extent[i] = 0.0;
         max_extent[i] = 1.0;
      }  /* end for */
   }  /* end if */
   else {
      min_extent[2] = 0.0;
      if (input->points != NULL)
         max_extent[2] = input->points[2];
      else
         max_extent[2] = 1.0;
   }  /* end else */

   /* find the extent of the bounding hull */
   for (i = 0; i < 3; i++) {
      extent[i*2]   = min_extent[i];
      extent[i*2+1] = max_extent[i];
   }  /* end for */
#endif

   size = MAXX(input) * MAXY(input);

#ifdef OFF
   if (colormap) {
      colors = (unsigned int *) ALLOC_LOCAL (size * sizeof(unsigned int));
      for (i=0; i<colormap->size; i++) 
	 PIXELhsva_to_pixel (&color_lut[i], colormap->hue[i], 
			colormap->saturation[i],
			colormap->value[i], colormap->alpha[i]);
   }  /* end if */
#endif

   axis = 2;   /* default axes */

   if (input->uniform == IRREGULAR) {
     AVSwarning("Warning: IRREGULAR data not supported yet...");
#ifdef OFF
     fmesh = (float *) ALLOC_LOCAL (3 * size * sizeof(float));
     switch (input->nspace) {
       case 3:
	 for (i=0; i<size; i++) {
	     fmesh[i*3+0] = input->points[i];
	     fmesh[i*3+1] = input->points[i+size];
	     fmesh[i*3+2] = input->points[i+2*size];
	 }
	 break;
       case 2:
	 for (i=0; i<size; i++) {
	     fmesh[i*3+0] = input->points[i];
	     fmesh[i*3+1] = input->points[i+size];
	     fmesh[i*3+2] = 0.0;
	 }
	 break;
       case 1:
       default:
	 for (i=0; i<size; i++) {
	     fmesh[i*3+0] = input->points[i];
	     fmesh[i*3+1] = fmesh[i*3+2] = 0.0;
         }
	 break;
     }
#endif
   } else if (input->uniform == RECTILINEAR) {
     AVSwarning("Warning: RECTILINEAR data not supported yet...");
#ifdef OFF
     fmesh = (float *) ALLOC_LOCAL (3 * size * sizeof(float));
     if (input->nspace == 3) {
	 if (input->min_extent[0] == input->max_extent[0])
	   axis = 0;
	 else if (input->min_extent[1] == input->max_extent[1])
	   axis = 1;
     } 

     for (i=0; i<MAXY(input); i++) {
       for (j=0; j<MAXX(input); j++) {
	   switch (axis) {
	     case 0:
	       fmesh[(i*MAXX(input)+j)*3+0] = input->min_extent[0];
	       fmesh[(i*MAXX(input)+j)*3+1] = input->points[j];
	       fmesh[(i*MAXX(input)+j)*3+2] = input->points[i+MAXX(input)];
	       break;
	     case 1:
	       fmesh[(i*MAXX(input)+j)*3+0] = input->points[j];
	       fmesh[(i*MAXX(input)+j)*3+1] = input->min_extent[1];
	       fmesh[(i*MAXX(input)+j)*3+2] = input->points[i+MAXX(input)];
	       break;
	     case 2:
	       fmesh[(i*MAXX(input)+j)*3+0] = input->points[j];
	       fmesh[(i*MAXX(input)+j)*3+1] = input->points[i+MAXX(input)];
	       fmesh[(i*MAXX(input)+j)*3+2] = (input->nspace == 3) ? 
		 input->min_extent[2] : 0.0;
	       break;
	 }
       }  /* end for j */
     }  /* End for i */
#endif
   } else if (input->uniform == UNIFORM) {
     fmesh = (float *) ALLOC_LOCAL (3 * size * sizeof(float));
     axis = 0;
     if (input->points[2] == input->points[3])
	axis = 1;
     else if ((input->nspace == 3) && (input->points[4] == input->points[5]))
	axis = 2;
/*
     for (i=0; i<MAXY(input); i++) {
        for (j=0; j<MAXX(input); j++) {
*/
	   if (input->nspace == 3) { 	/* slices comes from a volume */
	       if (axis == 0) {  	/* X Axis */
                   i = j = 0;
		   UTILget_world_coords (&tx, &ty, &tz, (int)(input->points[0]),
					 j, i, input);

                   fprintf(stderr,"X:\ni=j=0 tx=%f ty=%f tz=%f\n",tx,ty,tz);

                   j = MAXX(input)-1;
                   i = MAXY(input)-1;
		   UTILget_world_coords (&tx, &ty, &tz, (int)(input->points[0]),
					 j, i, input);

                   fprintf(stderr,"i=j=%d tx=%f ty=%f tz=%f\n\n",i,tx,ty,tz);

                   verts[0][0] = tx;
                   verts[0][1] = 0.0;
                   verts[0][2] = 0.0;

                   verts[1][0] = tx;
                   verts[1][1] = 0.0;
                   verts[1][2] = tz;

                   verts[2][0] = tx;
                   verts[2][1] = ty;
                   verts[2][2] = tz;

                   verts[3][0] = tx;
                   verts[3][1] = ty;
                   verts[3][2] = 0.0;

	       }  /* end if */ 
	       else if (axis == 1) {  /* Y Axis */
                   i = j = 0;
		   UTILget_world_coords (&tx, &ty, &tz, j, 
					 (int) (input->points[2]), i, input);

                   fprintf(stderr,"Y:\ni=j=0 tx=%f ty=%f tz=%f\n",tx,ty,tz);

                   i = MAXY(input)-1;
                   j = MAXX(input)-1;
		   UTILget_world_coords (&tx, &ty, &tz, j, 
					 (int) (input->points[2]), i, input);

                   fprintf(stderr,"i=j=%d tx=%f ty=%f tz=%f\n\n",i,tx,ty,tz);

                   verts[0][0] = 0.0;
                   verts[0][1] = ty;
                   verts[0][2] = 0.0;

                   verts[1][0] = tx;
                   verts[1][1] = ty;
                   verts[1][2] = 0.0;

                   verts[2][0] = tx;
                   verts[2][1] = ty;
                   verts[2][2] = tz;

                   verts[3][0] = 0.0;
                   verts[3][1] = ty;
                   verts[3][2] = tz;
	       }  /* end else if */ 
	       else  {                /* Z Axis */
                   i = j = 0;
		   UTILget_world_coords (&tx, &ty, &tz, j, i, 
					 (int) (input->points[4]), input);
                   fprintf(stderr,"Z:\ni=j=0 tx=%f ty=%f tz=%f\n",tx,ty,tz);
                   /* Compute X, Y, Z locations for corners of polygon */
                   x0 = tx;
                   y0 = ty;
                   z0 = tz;
                   /* Compute the MAX X, Y, Z locations for corners of polygon */
                   i = MAXY(input)-1;
                   j = MAXX(input)-1;
		   UTILget_world_coords (&tx, &ty, &tz, j, i, 
					 (int) (input->points[4]), input);
                   fprintf(stderr,"i=j=%d tx=%f ty=%f tz=%f\n\n",i,tx,ty,tz);

                   xmax = tx;
                   ymax = ty;
                   zmax = tz;
                   /* Assign each vertex a value */
                   verts[0][0] = 0.0;
                   verts[0][1] = 0.0;
                   verts[0][2] = tz;

                   verts[1][0] = tx;
                   verts[1][1] = 0.0;
                   verts[1][2] = tz;
                   
                   verts[2][0] = tx;
                   verts[2][1] = ty;
                   verts[2][2] = tz;

                   verts[3][0] = 0.0;
                   verts[3][1] = ty;
                   verts[3][2] = tz;


	       }  /* end else */ 
	   } /* end if for 3-space */
	   else {					/* 2D images */
              AVSwarning("Warning: 2D images not supported yet...");
              /*
              fmesh[(i*MAXX(input)+j)*3+0] = (float) j;
              fmesh[(i*MAXX(input)+j)*3+1] = (float)(MAXY(input)-i-1.0);
	      fmesh[(i*MAXX(input)+j)*3+2] = 0.0;
	      axis = 2;
              */
	   }  /* end else for images */
#ifdef OFF
         }  /* end for j */
     }  /* end for i */
#endif
   }  /* end else if */

   switch (input->type) {
   case AVS_TYPE_BYTE:
       for (i=0; i<MAXY(input); i++) 
	 for (j=0; j<MAXX(input); j++) 
	   fmesh[(i*MAXX(input)+j)*3+axis] += 
	     (float)(input->field_data[i*MAXX(input)+j])/255.0;
#ifdef OFF
     if (colormap)  {
       for (i=0; i<MAXY(input); i++) {
	 for (j=0; j<MAXX(input); j++) {
	     indexer = PIXELget_index(colormap, 
		     (float)(input->field_data[i*MAXX(input)+j]));
	     colors[i*MAXX(input)+j] = color_lut[indexer];
         }
       }
     }
#endif
     break;

   case AVS_TYPE_REAL:
#ifdef OFF
       AVSwarning("Warning: AVS_REAL data not supported yet...");
       min = max = input->field_data_float[0];
       for (i=0; i<size; i++) {
	   min = (input->field_data_float[i] < min ) ? input->field_data_float[i] : min;
	   max = (input->field_data_float[i] > max ) ? input->field_data_float[i] : max;
       }
       if (max == min) {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 0;
       } else {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] +=
		 ((float)(input->field_data_float[i*MAXX(input)+j]) - min) / (max-min);
       }
       if (colormap)  {
	   if (max == min) {
	       for (i=0; i<MAXY(input); i++) 
		 for (j=0; j<MAXX(input); j++) 
		   colors[i*MAXX(input)+j] = color_lut[0];
	   } else {
	       for (i=0; i<MAXY(input); i++) {
		   for (j=0; j<MAXX(input); j++) {
		       indexer = PIXELget_index(colormap, 
					      input->field_data_float[i*MAXX(input)+j]);
		       colors[i*MAXX(input)+j] = color_lut[indexer];
		   }
	       }
	   }
       }
#endif
       break;

     case AVS_TYPE_DOUBLE:
       AVSwarning("Warning: AVS_DOUBLE data not supported yet...");
#ifdef OFF
       min = max = input->field_data_double[0];
       for (i=0; i<size; i++) {
	   min = (input->field_data_double[i] < min ) ? input->field_data_double[i] : min;
	   max = (input->field_data_double[i] > max ) ? input->field_data_double[i] : max;
       }
       if (max == min) {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 0.0;
       } else {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 
		 ((double)(input->field_data_double[i*MAXX(input)+j]) - min) / (max-min);
	   
       }
       if (colormap)  {
	   if (max == min) {
	       for (i=0; i<MAXY(input); i++) 
		 for (j=0; j<MAXX(input); j++) 
		   colors[i*MAXX(input)+j] = color_lut[0];
	   } else {
	       for (i=0; i<MAXY(input); i++) {
		   for (j=0; j<MAXX(input); j++) {
		       indexer = PIXELget_index(colormap, 
					      (float)(input->field_data_double[i*MAXX(input)+j]));
		       colors[i*MAXX(input)+j] = color_lut[indexer];
		   }
	       }
	   }
       }
#endif
       break;

     case AVS_TYPE_INTEGER:
       AVSwarning("Warning: AVS_INTEGER data not supported yet...");
#ifdef OFF
       min = max = input->field_data_int[0];
       for (i=0; i<size; i++) {
	   min = (input->field_data_int[i] < min ) ? input->field_data_int[i] : min;
	   max = (input->field_data_int[i] > max ) ? input->field_data_int[i] : max;
       }
       if (max == min) {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 0.0;
       } else {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] +=
		 ((float)(input->field_data_int[i*MAXX(input)+j]) - min) / (max-min);
       }
       
       if (colormap)  {
	   if (max == min) {
	       for (i=0; i<MAXY(input); i++) 
		 for (j=0; j<MAXX(input); j++) 
		   colors[i*MAXX(input)+j] = color_lut[0];
	   } else {
	       for (i=0; i<MAXY(input); i++) {
		   for (j=0; j<MAXX(input); j++) {
		       indexer = PIXELget_index(colormap, 
					      (float)(input->field_data_int[i*MAXX(input)+j]));
		       colors[i*MAXX(input)+j] = color_lut[indexer];
		   }
	       }
	   }
       }
#endif
       break;

     case AVS_TYPE_SHORT:
       AVSwarning("Warning: AVS_SHORT data not supported yet...");
#ifdef OFF
       min = max = input->field_data_short[0];
       for (i=0; i<size; i++) {
	   min = (input->field_data_short[i] < min ) ? input->field_data_short[i] : min;
	   max = (input->field_data_short[i] > max ) ? input->field_data_short[i] : max;
       }
       if (max == min) {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 0.0;
       } else {
	   for (i=0; i<MAXY(input); i++) 
	     for (j=0; j<MAXX(input); j++) 
	       fmesh[(i*MAXX(input)+j)*3+axis] += 
		 ((float)(input->field_data_short[i*MAXX(input)+j]) - min) / (max-min);
       }
       
       if (colormap)  {
	   if (max == min) {
	       for (i=0; i<MAXY(input); i++) 
		 for (j=0; j<MAXX(input); j++) 
		   colors[i*MAXX(input)+j] = color_lut[0];
	   } else {
	       for (i=0; i<MAXY(input); i++) {
		   for (j=0; j<MAXX(input); j++) {
		       indexer = PIXELget_index(colormap, 
					      (float)(input->field_data_short[i*MAXX(input)+j]));
		       colors[i*MAXX(input)+j] = color_lut[indexer];
		   }
	       }
	   }
       }
#endif
       break;
       
   }

   obj = GEOMcreate_obj(GEOM_POLYHEDRON,NULL); 
   GEOMadd_disjoint_polygon(obj,verts,NULL,NULL,4,GEOM_NOT_SHARED,0);
   GEOMgen_normals(obj, 0); 

   /* ADD U and V 's */
   uvs[0][0] = 0; uvs[0][1] = 0;
   uvs[1][0] = 1; uvs[1][1] = 0;
   uvs[2][0] = 1; uvs[2][1] = 1;
   uvs[3][0] = 0; uvs[3][1] = 1;
   GEOMadd_uvs(obj,uvs,4,GEOM_COPY_DATA);

/*
   obj = GEOMcreate_mesh_with_data(NULL, fmesh, NULL, NULL, MAXX(input),
				   MAXY(input), GEOM_COPY_DATA);
*/

/*
   if (colormap) 
     GEOMadd_int_colors(obj, colors, size, GEOM_COPY_DATA);

   GEOMcvt_mesh_to_polytri(obj, GEOM_SURFACE | GEOM_WIREFRAME);
*/

#ifdef OFF
   if (input->uniform == UNIFORM) {
      if ( input->nspace == 3 ) 
	;
#ifdef AUTO_TRANSFORM
	GEOMset_computed_extent (obj, extent);
#endif
      else 
	GEOMflip_normals(obj);
#ifdef AUTO_TRANSFORM
      GEOMauto_transform (obj);
#endif
   }  /* end if */
#endif
   
   *output = GEOMinit_edit_list(*output);
   /* Make call to GEOMedit_render_mode here */
   /* Make call to GEOMedit_field_texture here */
   if (texture) {
      GEOMedit_field_texture(*output,"field tpoly", texture);
   } else
      fprintf(stderr,"Warning: no texture send to this module\n");

   GEOMedit_geometry(*output,"field tpoly",obj);
   if (input->nspace < 3)
	   GEOMedit_transform_mode(*output, "field tpoly", "normal",0); 
   else
	   GEOMedit_transform_mode(*output, "field tpoly", "parent",0);
   GEOMdestroy_obj(obj);

   FREE_LOCAL(fmesh);
/*
   if (colormap) 
     FREE_LOCAL(colors);
*/

   return(1);
}

#ifdef SEPARATE_MODULES
/*
 * initialization for modules contained in this file.
 */

int ((*mapper_mod_list[])()) = {
  MODfield_to_mesh,
};

#define NMODS sizeof(mapper_mod_list) / sizeof(char *) 

AVSinit_modules()
{
	AVSinit_from_module_list(mapper_mod_list, NMODS);
}
#endif

