/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
#include "separate.h"
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int TIME_SPAN_TEXT_desc()
{

	int in_port, in_2port, out_port, param;
	extern int TIME_SPAN_TEXT_compute();

	AVSset_module_name("TIME SPAN TEXT", MODULE_MAPPER);
	AVSset_module_flags(COOPERATIVE);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input timestamp", "string", REQUIRED);
	in_port = AVScreate_input_port("input cropslice", "string", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("textout", "string");

	AVSset_compute_proc(TIME_SPAN_TEXT_compute);
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int TIME_SPAN_TEXT_compute(input_timestamp, input_cropslice, textout)
	char *input_timestamp;
	char *input_cropslice;
	char **textout;
{
char *str = NULL;
int x0, x1, y0, y1, z0, z1, t0, t1; 
register int i, j, linelength, n;

if (str != NULL)

/* IAC CODE CHANGE : 	free((char *) str); */
	 free( str);

if ((str = ((char *) malloc(sizeof(char) * 1024))) == NULL)
	{
	AVSerror("Cannot allocate string for output!"); 
	return(0);
	}

sscanf(input_cropslice,
	 "%d%d%d%d%d%d%d%d", &x0, &x1, &y0, &y1, &z0, &z1, &t0, &t1);

n = strlen(input_timestamp);
j = 0;
while (input_timestamp[j] != '\n')
	++j;	
linelength = j + 1;

i = linelength * t0;
j = 0;
while ((i < n) && (input_timestamp[i] != '\n'))
	str[j++] = input_timestamp[i++];

if (t1 > t0)
	{
	str[j++] = ' ';
	str[j++] = '-';
	str[j++] = ' ';

	i = linelength * t1;
	while ((i < n) && (input_timestamp[i] != '\n'))
		str[j++] = input_timestamp[i++];
	}
str[j] = '\0';

*textout = str;
return(1);
}

#ifdef SEPARATE_MODULES
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	TIME_SPAN_TEXT_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}

#endif

