/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "UCD grid" (Mapper) (Subroutine)                  	 */
/* Author:  Penny Rheingans, US EPA Scientific Visualization Cener       */
/* Date Created: Thu Jun 25 11:29:24 1992                                */
/*                                                                       */
/* This file is automatically generated by the Module Generator (mod_gen)*/
/* Please do not modify or move the contents of this comment block as    */
/* mod_gen needs it in order to read module sources back in.             */
/*                                                                       */
/* output 0 "data" ucd	 						 */
/* output 0 "GridGeom" geom Mesh                                         */
/* param 0 "Spacing" dial 0.000000 0.000000 10000.000000                 */
/* param 1 "Plane" radio_buttons   :                                     */
/* param 2 "Show Labels" toggle 0 0 1                                    */
/* param 3 "Show Grid" toggle 0 0 1                                      */
/* param 4 "Show Axes" toggle 0 0 1                                      */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/geom.h>
#include <avs/font.h>
#include <avs/ucd_defs.h>
 
/* ----> START OF USER-SUPPLIED CODE SECTION #1 (INCLUDE FILES, GLOBAL VARIABLES)*/
static float origin[3] = {0.0, 0.0, 0.0};
/* <---- END OF USER-SUPPLIED CODE SECTION #1                            */
 
/* *****************************************/
/*  Module Specification                   */
/* *****************************************/
int UCD_grid_spec()
{

	int in_port, out_port, param;
	extern int UCD_grid_compute();

	AVSset_module_name("UCD grid", MODULE_MAPPER);

	/* Inport Port Specifications */
	in_port = AVScreate_input_port("data", "ucd", REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("GridGeom", "geom");

	/* Parameter Specifications                */
	param = AVSadd_float_parameter("Spacing", 1.000000, 0.000001, 
		10000.000000);
	AVSconnect_widget(param, "dial");
	param = AVSadd_parameter("Plane", "choice", "NONE", "NONE:X:Y:Z", ":");
	AVSconnect_widget(param, "radio_buttons");
	param = AVSadd_parameter("Show Labels", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Show Grid", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Show Axes", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");
	param = AVSadd_parameter("Position", "choice", 
					"Origin", "Origin:Min:Max", ":");
	AVSconnect_widget(param, "radio_buttons");

	AVSset_compute_proc(UCD_grid_compute);
/* ----> START OF USER-SUPPLIED CODE SECTION #2 (ADDITIONAL SPECIFICATION INFO)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #2                            */
	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int UCD_grid_compute( Data, GridGeom, Spacing, Plane, Show_Labels, 
Show_Grid, Show_Axes, Position)
	UCD_structure *Data;
	GEOMedit_list *GridGeom;
	float *Spacing;
	char *Plane;
	int Show_Labels;
	int Show_Grid;
	int Show_Axes;
	char *Position;
{

/* ----> START OF USER-SUPPLIED CODE SECTION #3 (COMPUTE ROUTINE BODY)   */
 	GEOMobj *obj0;                                                       
 	GEOMobj *obj1;                                                       
 	GEOMobj *obj2;                                                       
	char plane_id = Plane[0];
	float i, j, k;
	float verts[2][3];
	float ref_point[3], offset[3];
	int label_flags;
	char label[BUFSIZ];
	float color[3];
	float *min=Data->min_extent;
	float *max=Data->max_extent;
	float *position;

	if (!strcmp(Position, "Origin")) 
	    position = &(origin[0]);
	else if (!strcmp(Position, "Min"))
	    position = &(min[0]);
	else if (!strcmp(Position, "Max"))
	    position = &(max[0]);

	offset[0] = 0.0;
	offset[1] = 0.0;
	offset[2] = 0.0;
	color[0] = 1.0;
	color[1] = 1.0;
	color[2] = 1.0;
	obj0 = GEOMcreate_obj(GEOM_POLYTRI, GEOM_NULL);
	label_flags = GEOMcreate_label_flags(FONT_TIMES, 
				0, 0, 0, GEOM_LABEL_CENTER, 0);
	obj1 = GEOMcreate_label(GEOM_NULL, label_flags);

	/* make labels if desired */
	if (Show_Labels) {
	  for (k = min[2]; k < max[2] + *Spacing; k+= *Spacing) {
	    verts[0][0] = position[0];
	    verts[0][1] = position[1];
	    verts[0][2] = k;
	    sprintf(label, "%.1f", k);
	    GEOMadd_label(obj1, label, verts[0], offset, 0.05, 
					    color, label_flags);
	    }
	  for(j = min[1]; j < max[1] + *Spacing; j+= *Spacing) {
	    verts[0][0] = position[0];
	    verts[0][1] = j;
	    verts[0][2] = position[2];
	    sprintf(label, "%.1f", j);
	    GEOMadd_label(obj1, label, verts[0], offset, 0.05, 
					    color, label_flags);
	    }
	  for (i = min[0]; i < max[0] + *Spacing; i+= *Spacing) {
	    verts[0][0] = i;
	    verts[0][1] = position[1];
	    verts[0][2] = position[2];
	    sprintf(label, "%.1f", i);
	    GEOMadd_label(obj1, label, verts[0], offset, 0.05, 
					    color, label_flags);
	    }
	  }

	/* make grid if desired */
	if (Show_Grid) {
	  switch (plane_id) {
	    case 'N': /* no grid */
	      break;
	    case 'X': /* grid in YZ plane */
	      for(j = min[1]; j < max[1] + *Spacing; j+= *Spacing)
		for(k = min[2]; k < max[2]; k+= *Spacing) {
		  verts[0][0] = position[0];
		  verts[0][1] = j;
		  verts[0][2] = k;
		  verts[1][0] = position[0];
		  verts[1][1] = j;
		  verts[1][2] = k + *Spacing;
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }

	      for (k = min[2]; k < max[2] + *Spacing; k+= *Spacing) {
		for (j = min[1]; j < max[1]; j+= *Spacing) {
		  verts[0][0] = position[0];
		  verts[0][1] = j;
		  verts[0][2] = k;
		  verts[1][0] = position[0];
		  verts[1][1] = j + *Spacing;
		  verts[1][2] = k;
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }
		}
	      break;
	    case 'Y': /* grid in XZ plane */
	      for(k = min[2]; k < max[2] + *Spacing; k+= *Spacing)
		for(i = min[0]; i < max[0]; i+= *Spacing) {
		  verts[0][0] = i;
		  verts[0][1] = position[1];
		  verts[0][2] = k;
		  verts[1][0] = i + *Spacing;
		  verts[1][1] = position[1];
		  verts[1][2] = k;
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }

	      for (i = min[0]; i < max[0] + *Spacing; i+= *Spacing) {
		for (k = min[2]; k < max[2]; k+= *Spacing) {
		  verts[0][0] = i;
		  verts[0][1] = position[1];
		  verts[0][2] = k;
		  verts[1][0] = i;
		  verts[1][1] = position[1];
		  verts[1][2] = k + *Spacing;
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }
		}
	      break;
	    case 'Z': /* grid in XY plane */
	      for(j = min[1]; j < max[1] + *Spacing; j+= *Spacing)
		for(i = min[0]; i < max[0]; i+= *Spacing) {
		  verts[0][0] = i;
		  verts[0][1] = j;
		  verts[0][2] = position[2];
		  verts[1][0] = i + *Spacing;
		  verts[1][1] = j;
		  verts[1][2] = position[2];
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }

	      for (i = min[0]; i < max[0] + *Spacing; i+= *Spacing) {
		for (j = min[1]; j < max[1]; j+= *Spacing) {
		  verts[0][0] = i;
		  verts[0][1] = j;
		  verts[0][2] = position[2];
		  verts[1][0] = i;
		  verts[1][1] = j + *Spacing;
		  verts[1][2] = position[2];
		  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
		  }
		}
	      break;
	    }
	  }

	/* create axes if desired */
	if (Show_Axes) {
	  verts[0][0] = min[0];
	  verts[0][1] = position[1];
	  verts[0][2] = position[2];
	  verts[1][0] = max[0];
	  verts[1][1] = position[1];
	  verts[1][2] = position[2];
	  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	  verts[0][0] = position[0];
	  verts[0][1] = min[1];
	  verts[0][2] = position[2];
	  verts[1][0] = position[0];
	  verts[1][1] = max[1];
	  verts[1][2] = position[2];
	  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	  verts[0][0] = position[0];
	  verts[0][1] = position[1];
	  verts[0][2] = min[2];
	  verts[1][0] = position[0];
	  verts[1][1] = position[1];
	  verts[1][2] = max[2];
	  GEOMadd_disjoint_line(obj0,verts,GEOM_NULL,2,GEOM_COPY_DATA);
	  }

	/* Create the GEOM Edit List for GridGeom                      */
 	*GridGeom = GEOMinit_edit_list(*GridGeom);                          
 	GEOMedit_geometry(*GridGeom, "GridGeom", obj0);                    
 	GEOMedit_geometry(*GridGeom, "GridGeom", obj1);                    
 	GEOMdestroy_obj(obj0);                                            
/* <---- END OF USER-SUPPLIED CODE SECTION #3                            */
	return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*filter_mod_list[])()) = {
	UCD_grid_spec,
};
#define NMODS (sizeof(filter_mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(filter_mod_list, NMODS);
}
 
/* ----> START OF USER-SUPPLIED CODE SECTION #4 (SUBROUTINES, FUNCTIONS, UTILITY ROUTINES)*/
/* <---- END OF USER-SUPPLIED CODE SECTION #4                            */
