/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/fatal.c,v 1.3 1991/06/25 20:13:28 creiman Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: fatal.c,v $
 * Revision 1.3  1991/06/25  20:13:28  creiman
 * Removed varargs and dtm_fatal.
 *
 * Revision 1.2  1991/06/11  15:19:57  sreedhar
 * disclaimer added
 *
 * Revision 1.1  1990/11/08  16:33:22  jefft
 * Initial revision
 *

#endif


#include	<stdio.h>
#include	<sys/types.h>
#include	<netinet/in.h>

#include	"dtmint.h"

static char	*err_msg[] = {
	"No error",
	"Out of memory - can not create port",
	"Invalid port name - should be 'hostname:tcp port'",
	"Out of DTM ports - 256 ports max",
	"Couldn't initialize port",
	"DTM routines called in wrong order",
	"Encounted EOF",
	"Error creating socket",
	"Bad hostname",
	"Timeout waiting for connection",
	"Couldn't connect",
	"DTM read error",
	"DTM write error",
	"DTM header to long for buffer"
	};



DTMerr          DTMerrno = DTMNOERR;




void dtmversion()
{
  fprintf(stderr, "\nDTMlib version %s.\n", DTM_VERSION);
}


char	*DTMerrmsg(quiet)
  int	quiet;
{

  if (!quiet)
    fprintf(stderr, "\nDTMerrno = %d: %s\n", DTMerrno, err_msg[(int)DTMerrno]);

  return err_msg[(int)DTMerrno];
}

