/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/************************************************************************
**
**  mdd.c - Multi-Dimensional Data set routines
**	
*************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/mdd.c,v 1.2 1991/06/11 15:22:06 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: mdd.c,v $
 * Revision 1.2  1991/06/11  15:22:06  sreedhar
 * disclaimer added
 *
 * Revision 1.1  1990/11/08  16:37:13  jefft
 * Initial revision
 *

#endif


#include	<stdio.h>
#include	<string.h>

#include	"dtm.h"
#include	"mdd.h"


extern int	atoi();
extern double	atof();


void MDDsetDimensions(h, rank, dims)
  char	*h;
  int	rank, *dims;
{
  char	num[8];
  int	i;

  sprintf(num, "%d ", rank);
  strcat(h, MDDdims); strcat(h, " ");
  strcat(h, num);

  for (i=0; i<rank; i+=1)  {
    sprintf(num, "%d ", dims[i]);
    strcat(h, num);
    }
}


int MDDgetDimensions(h, rank, dims, len)
  char	*h;
  int	*rank, *dims, len;
{
  int	i;

  if ((h = dtm_find_tag(h, MDDdims)) == NULL)
    return DTMERROR;
  else
    h = strchr(h, ' ')+1;

  *rank = atoi(h);

  for (i=0; i<*rank && i<len; i+=1)
    if ((h = strchr(h, ' ')) == NULL)
      return DTMERROR;
    else
      dims[i] = atoi(++h);

  return 0;
}


int MDDnumElements(rank, dims)
  int	rank, *dims;
{
  int	size;

  size = *dims++;
  while (--rank > 0)
    size *= *dims++;

  return size;
}


void MDDsetMinMax(h, min, max)
  char	*h;
  float	min, max;
{
  char	num[12];

  strcat(h, MDDminmax);  strcat(h, " ");

  sprintf(num, "%f ", min);
  strcat(h, num);

  sprintf(num, "%f ", max);
  strcat(h, num);
}


int MDDgetMinMax(h, min, max)
  char	*h;
  float	*min, *max;
{

  if ((h = dtm_find_tag(h, MDDminmax)) == NULL)
    return DTMERROR;
  else
    h = strchr(h, ' ')+1;


  *min = atof(h); 

  h = strchr(h, ' ') + 1;
  *max = atof(h); 
  
  return 0;
}


void MDDfindMinMax(h, mdd, min, max)
  char	*h;
  float	*mdd, *min, *max;
{
  int	i, rank, dims[10];

  MDDgetDimensions(h, &rank, dims, sizeof dims);
  rank = MDDnumElements(rank, dims);

  *min = *max = *mdd++;
  for (i=1; i<rank; mdd+=1, i+=1)
    if (*mdd < *min)
      *min = *mdd;
    if (*mdd > *max)
      *max = *mdd;
}
