/*
	Author	: Sreedhar Sivakumaran
	Purpose	: Set of library calls for name server applications to use.
	Notes	:
			This file contains functions to send and receive
			DTM control messages such MREG, MROUTE etc.

			The fd parameter should be removed from all calls
			for portability.
*/

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/uio.h>
#include <sys/errno.h>
#include "dtmint.h"
#include "dtmnserv.h"
#include <stdio.h>
#include "debug.h"

static	char	mbuf[ MAX132 ] ;	/* buffer to build messages */
 
/*
	Function to send a DTM control message ( messages like MREG, MROUTE etc. )
	Notes	:
*/

static dtm_send_control( fd, msg, msize, sendto_addr )
int	fd ;
char	*msg ;
int	msize ;
char	*sendto_addr ;		/* read-only */
{
struct	sockaddr_in	sockaddr ;	/* destination address in sockaddr_in structure */
struct	iovec	iov[ 1 ] ;		/* message iovec */
int	status ;			/* return value from a call */
int	tmp ;				/* temporary */
char	sendaddr[ MAX132 ] ;

	DBGFLOW( "dtm_send_control called\n" );
	DBGINT( "dtm_send_control: sendto_addr is '%s'\n", sendto_addr );

	/* Get destination address in sockaddr_in structure */

	strncpy( sendaddr, sendto_addr, (MAX132 - 1)) ;
	sendaddr[ MAX132 - 1 ] = '\0' ;

        sockaddr.sin_family = AF_INET ;
	ipaddr( strtok( sendaddr, COLON ), &sockaddr.sin_addr.s_addr );
	sockaddr.sin_port = htons( (unsigned short)atol( strtok( NULL, COLON )) );

	/* Prepare iovec and send message length */

	tmp = msize ;
	STDINT( tmp );
	iov[ 0 ].iov_base = (char *)&tmp ;
	iov[ 0 ].iov_len = 4 ;

	if( (status = dtm_writev_buffer( fd, iov, 1, 4, (struct sockaddr *)&sockaddr,
			sizeof( struct sockaddr_in ))) < 0 )
	{
		DBGFLOW( "dtm_send_control: message length send error\n" );
		return status ;
	} 

	/* Prepare iovec and send message */
		
	iov[ 0 ].iov_base = msg ;
	iov[ 0 ].iov_len = msize ;

	return dtm_writev_buffer( fd, iov, 1, msize, (struct sockaddr *)&sockaddr,
					sizeof( struct sockaddr_in )) ;
}

/*
	Function to send a routing message to designated address.
	Notes	: 	delcount parameter to be added, currently
			forced to zero.
			Destination address, and array of addresses are in
			format IPaddr( dotted decimal ):portid.
*/

int DTMsendRoute( fd, sendto_addr, addcount, add_addresses ) 
int	fd ;			/* output socket */
char	*sendto_addr ;		/* destination address - dotted decimal addr:port number */
int	addcount ;		/* number of addresses to connect to */
char	**add_addresses ;	/* array of addresses to connect to */
{
	DBGFLOW( "DTMsendRoute called\n" );

	/* Prepare MROUTE message and send it */

	sprintf( mbuf, MROUTE, MROUTEID, 0, addcount ) ;
	while( addcount-- )
	{
		strncat( mbuf, " ", (MAX132-1));
		strncat( mbuf, add_addresses[ addcount ], (MAX132 - 1)); 
	}
	mbuf[ MAX132 - 1 ] = '\0' ; 

	DBGFLOW( "DTMsendRoute: Message:- " ); DBGFLOW( mbuf ); DBGFLOW( "\n" );

	return dtm_send_control( fd, mbuf, (strlen( mbuf ) + 1), sendto_addr );  
}

/*
	Function to send ack to routing message to designated address.
*/

dtm_nsend_ackroute( fd, sendto_addr, refname, portname )
int	fd ;
char	*sendto_addr ;
char	*refname ;
char	*portname ;
{
	DBGFLOW( "dtm_nsend_ackroute called\n" );

	/* Prepare Ackroute, send it */

	sprintf( mbuf, MACKROUTE, MACKROUTEID, refname, portname );
	mbuf[ MAX132 - 1 ] = '\0' ;

	DBGFLOW( "dtm_nsend_ackroute: Message:- " ); DBGFLOW( mbuf ); DBGFLOW( "\n" );

	return dtm_send_control( fd, mbuf, (strlen( mbuf ) + 1), sendto_addr );  
}

/*
	Function to send self's socket address to name server process.
*/

dtm_nsend_sockaddr( fd, sendto_addr, refname, portname, sockaddr )
int	fd ;
char	*sendto_addr ;
char	*refname ;
char	*portname ;
struct	sockaddr_in	*sockaddr ;
{
struct	in_addr inaddr ;

	DBGFLOW( "dtm_nsend_sockaddr called\n" );

	/* Prepare MREG, send it */

	inaddr.s_addr = sockaddr -> sin_addr.s_addr ;
	sprintf( mbuf, MREG, MREGID, refname, portname,
		 inet_ntoa( inaddr ), ntohs( sockaddr -> sin_port ) );
	mbuf[ MAX132 - 1 ] = '\0' ;

	DBGFLOW( "dtm_nsend_sockaddr: Message:- " ); DBGFLOW( mbuf ); DBGFLOW( "\n" );

	return dtm_send_control( fd, mbuf, (strlen( mbuf ) + 1), sendto_addr );
}

/*
	Function to recieve registation messages from other processes.
	Notes	:	does not block, return length is message
			received, 0 otherwise

*/
int DTMrecvRegistration(fd, buffer, len)
  int	fd, len;
  char	*buffer;
{
  int	count;

	if( dtm_quick_select(fd, &count) )
		return dtm_recv_header(fd, buffer, len);
        else
		return 0;
}


/*
	Function to create a nameserver port for receiving registration
		messages and sending routing messages.

*/
		
int DTMmakeNameServerPort(portid)
  char	*portid;
{
  struct sockaddr_in	saddr;
  

  saddr.sin_family = AF_INET;
  saddr.sin_addr.s_addr = 0;

  if (strcmp(portid, ":0") != 0)
    saddr.sin_port = htons((unsigned short)atoi(strchr(portid, ':')+1));

  return dtm_socket_init( &saddr, OUTPORTTYPE, NOT_LOGICAL_NAME );
}


/*

	Fucntion to get the port address of the name server port.

++++	should be a socket.c function that returns bound address of
		socket file descriptor

*/

int DTMgetNameServerAddr(fd, name, len)
  int	fd, len;
  char	*name;
{
  char			pnum[8];
  struct sockaddr_in	saddr;
  int			saddr_size = sizeof (struct sockaddr_in);

  if (dtm_get_ipaddr(name) == 0)  {
    DTMerrno = DTMHOST;
    return DTMERROR;
    }

  if (getsockname( fd, &saddr, &saddr_size ) < 0 )  {
	extern	int	errno ;
    DBGINT( "dtm_socket_init: Unable to get sin_port, errno %d\n", errno );
    DTMerrno = DTMSOCK ;
    return -1 ;
    }

  sprintf(pnum, ":%d", (int)ntohs( saddr.sin_port ));
  strcat(name, pnum);

  return 0;
}
