/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/ris.c,v 1.3 1991/06/11 15:21:05 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: ris.c,v $
 * Revision 1.3  1991/06/11  15:21:05  sreedhar
 * disclaimer added
 *
 * Revision 1.2  1991/05/30  15:53:16  sreedhar
 * Changes for readMsg/writeMsg internal release
 *
 * Revision 1.1  1990/11/08  16:37:49  jefft
 * Initial revision
 *

#endif


#include	<stdio.h>
#include	<string.h>

#include	"dtm.h"
#include	"ris.h"


char		PAL[] = "PAL ";



void RISsetDimensions(h, x, y)
  char	*h;
  int	x, y;
{
  char	append[32];

  sprintf(append, "%s 2 %d %d ", RISdims, x, y);
  strcat(h, append);
}


int RISgetDimensions(h, x, y)
  char	*h;
  int	*x, *y;
{

  if ((h = dtm_find_tag(h, RISdims)) == NULL)
    return DTMERROR;
  else
    h = strchr(h, ' ')+1;

  /* skip rank */
  h = strchr(h, ' ')+1;

  *x = atoi(h);
  h = strchr(h, ' ') + 1;
  *y = atoi(h);

  return 0;
}


void RISsetPalette(port, pal)
  int	port;
  char	*pal;
{
  DTMbeginWrite(port, PAL, sizeof PAL);
  DTMwriteDataset(port, pal, 768, DTM_CHAR);
  DTMendWrite(port);
}


void RISgetPalette(port, pal)
  int	port;
  char	*pal;
{
  DTMreadDataset(port, pal, 768, DTM_CHAR);
}


void RIS8putImage(port, image, x, y)
  int	port, x, y;
  char	*image;
{
  char	h[RISsize];

  RIS8setClass(h);
  RISsetDimensions(h, x, y);

  DTMbeginWrite(port, h, strlen(h)+1);
  DTMwriteDataset(port, image, x * y, DTM_CHAR);
  DTMendWrite(port);
}


void RIS24putImage(port, image, x, y)
  int	port, x, y;
  char	*image;
{
  char	h[RISsize];

  RIS24setClass(h);
  RISsetDimensions(h, x, y);

  DTMbeginWrite(port, h, strlen(h)+1);
  DTMwriteDataset(port, image, x * y * 3, DTM_CHAR);
  DTMendRead(port);
}


void RIS8getImage(port, image, x, y)
  int	port, x, y;
  char	*image;
{

  DTMreadDataset(port, image, x * y, DTM_CHAR);
}


void RIS24getImage(port, image, x, y)
  int	port, x, y;
  char	*image;
{

  DTMreadDataset(port, image, x * y * 3, DTM_CHAR);
}
