/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/**************************************************************************
**
**  Surface Description Language include file - contains constants used
**     with the SDL header type.  
**
**
**
**************************************************************************/

/*
 * $Log: sdl.h,v $
 * Revision 1.6  1991/09/10  15:07:55  jefft
 * cleaned-up message class macros.
 *
 * Revision 1.5  1991/07/25  22:22:27  jefft
 * Added transformation triplet enum types
 *
 * Revision 1.4  1991/07/18  16:29:43  jefft
 * corrected the spelling of "primitive" and added macros for backwards
 * compatibility.
 *
 * Revision 1.3  1991/06/11  15:22:58  sreedhar
 * disclaimer added
 *
 * Revision 1.2  1991/03/01  10:27:13  jefft
 * Added SDLcompareClass functions and enum for triplet types
 *
 * Revision 1.1  90/11/08  16:38:51  jefft
 * Initial revision
 * 
 */



#define	SDLclass		"SDL"
#define SDLsize			1024
#define SDLprimitive		"PT"

#define VCTRLclass		"VCTRL"
#define VCTRLsize		1024




#define SDLsetClass(h)			dtm_set_class((h), SDLclass)
#define	SDLcompareClass(h)		dtm_compare_class((h), SDLclass)
#define	SDLsetTitle			dtm_set_title
#define	SDLgetTitle			dtm_get_title
#define SDLsetPrimitive(h, p)		dtm_set_int((h), SDLprimitive, (p))
#define SDLgetPrimitive(h, p)		dtm_get_int((h), SDLprimitive, (p))


#define VCTRLsetClass(h)		dtm_set_class((h), VCTRLclass)
#define	VCTRLcompareClass(h)		dtm_compare_class((h), VCTRLclass)



typedef enum {
   SDLpoint = 1, SDLlineseg, SDLtriangle, SDLquad, SDLsphere
   } SDLprim_t;


typedef enum {
   SDLposition, SDLcolor, SDLnormal, SDLtranslate, SDLrotate, SDLscale
   } SDLtriplet;


typedef enum {
   SDLflat, SDLgouraud, SDLphong
   } SDLshade_t;


typedef enum {
   SDLpoints, SDLlines, SDLpolygons
   } SDLdraw_t;


#define VCTRLsetGTM(h)			strcat(h, "GTM ")
#define VCTRLgetGTM(h)		((dtm_find_tag(h, "GTM") == NULL) ? 0 : 1)
