/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/**************************************************************************
**
**  Scientific Data Set include file - contains constants used with the
**	SDS header type.
**
**************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/sds.h,v 1.3 1991/09/10 15:07:10 jefft Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: sds.h,v $
 * Revision 1.3  1991/09/10  15:07:10  jefft
 * cleaned-up message class macros.
 *
 * Revision 1.2  1991/06/11  15:22:52  sreedhar
 * disclaimer added
 *
 * Revision 1.1  1990/11/08  16:39:26  jefft
 * Initial revision
 *

#endif


#define	SDSclass		"SDS"
#define SDSsize			256

/* SDS specific tags */
#define SDSdims			"DIM"
#define SDSminmax		"MM"


/* SDS specific macros */
#define SDSsetClass(h)			dtm_set_class(h, SDSclass)
#define SDScompareClass(h)		dtm_compare_class(h, SDSclass)

/* SDS rename macros */
#define SDSheaderLength			dtm_header_length
#define	SDSHL				dtm_header_length

#define SDSsetType			dtm_set_type
#define	SDSgetType			dtm_get_type

#define SDSsetTitle			dtm_set_title
#define SDSgetTitle			dtm_get_title


/* SDS routines */
extern void	SDSsetDimensions();
extern int	SDSgetDimensions();
extern void	SDSsetMinMax();
extern int	SDSgetMinMax();
