/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <avs/geom.h>
#include <stdio.h>
#include "view_share.h"

#define CVT_FLAGS GEOM_SURFACE | GEOM_WIREFRAME
#define SPHERE_SIDE 1

GEOMobj *process_geometry (geometry,output_geom)
   GEOMobj *geometry;
   GEOMobj **output_geom;
{
   int i,k;

   switch ( geometry->type )
   {
      case GEOM_MESH       :    GEOMcvt_mesh_to_polytri(geometry, CVT_FLAGS);
  				break; 
      case GEOM_POLYHEDRON :  	GEOMcvt_polyh_to_polytri(geometry, CVT_FLAGS);
  				break; 
      case GEOM_SPHERE	   :    geometry=
				GEOMcvt_sphere_to_polytri(geometry, 
							SPHERE_SIDE,CVT_FLAGS);
				break;
      case GEOM_LABEL	   :    fprintf(stderr,"DTM : Cannot Broadcast Label Geometry Objects\n");
				return NULL;
 			        break;	
      case GEOM_POLYTRI    :    break;
      default		   :    fprintf(stderr,"DTM : UNKNOWN OBJECT TYPE\n");	
				return NULL;
 				break;
   }

   for (k=0;k<NUM_STRIPS(geometry);k++)
      if (DATA(geometry) & GEOM_NORMALS)
         if (DATA(geometry) & GEOM_VCOLORS)
            GEOMadd_polytriangle(*output_geom,
               VERTS(geometry),NORMALS(geometry),COLORS(geometry),
 	       NUM_VERTS(geometry),GEOM_COPY_DATA );
         else
            GEOMadd_polytriangle(*output_geom,
               VERTS(geometry),NORMALS(geometry),GEOM_NULL,
	       NUM_VERTS(geometry),GEOM_COPY_DATA);
      else
         if (DATA(geometry) & GEOM_VCOLORS)
            GEOMadd_polytriangle(*output_geom,
               VERTS(geometry),GEOM_NULL,COLORS(geometry),
	       NUM_VERTS(geometry),GEOM_COPY_DATA );
         else
            GEOMadd_polytriangle(*output_geom,
               VERTS(geometry),GEOM_NULL,GEOM_NULL,
	       NUM_VERTS(geometry),GEOM_COPY_DATA );

   return (*output_geom);
}
