/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include "view_share.h"

/* *****************************************/
/*  Module Specification                   */
/* *****************************************/

int view_share_spec()
{
   int in_port, out_port, param;
   extern int view_destroy_proc();

   AVSset_module_name("VIEW SHARE", MODULE_MAPPER);

   AVSset_destroy_proc(view_destroy_proc);

   in_port=AVScreate_input_port ( "upstream_tfx","struct upstream_transform",OPTIONAL | INVISIBLE );
   AVSset_input_class(in_port, "upstream_transform");
   in_port=AVScreate_input_port ( "upstream_geom","struct upstream_geom",OPTIONAL | INVISIBLE );
   AVSset_input_class(in_port, "upstream_geom");
   in_port=AVScreate_input_port ( "xfer","geom",OPTIONAL );

   param = AVSadd_parameter("Show Connection List", "boolean", 0, 0, 1 );
   AVSadd_parameter_prop(param,"width","integer",3 );
   AVSconnect_widget(param, "toggle");

   param = AVSadd_parameter("Receive", "boolean", 0, 0, 1 );
   AVSadd_parameter_prop(param,"width","integer",3 );
   AVSconnect_widget(param, "toggle");

   param = AVSadd_parameter("Broadcast", "boolean", 0, 0, 1 );
   AVSadd_parameter_prop(param,"width","integer",3 );
   AVSconnect_widget(param, "toggle");

   param = AVSadd_parameter("Connection List", "string", "Connection List", "", "" );
   AVSadd_parameter_prop(param,"width","integer",2 );
   AVSconnect_widget(param, "text");

   param = AVSadd_parameter("Local Integer","integer",0,INT_UNBOUND,INT_UNBOUND );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_float_parameter("Local Float",0.0,FLOAT_UNBOUND,FLOAT_UNBOUND );
   AVSconnect_widget(param, "typein_real");
   param = AVSadd_parameter("Local String","string",NULL,NULL,NULL );
   AVSconnect_widget(param, "typein");

/* --------------------------- */
   param = AVSadd_parameter("Listen Port 1", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 1", "string", NULL, NULL, NULL);
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 1", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 2", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 2", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 2", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 3", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 3", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 3", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 4", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 4", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 4", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 5", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 5", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 5", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 6", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 6", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 6", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 7", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 7", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 7", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 8", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 8", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 8", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */
   param = AVSadd_parameter("Listen Port 9", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Listen Port" );
   AVSconnect_widget(param, "typein_integer");
   param = AVSadd_parameter("Hostname 9", "string", NULL , NULL , NULL );
   AVSadd_parameter_prop(param,"title","string","Hostname " );
   AVSconnect_widget(param, "typein");
   param = AVSadd_parameter("Talk Port 9", "integer", 0, INT_UNBOUND, INT_UNBOUND);
   AVSadd_parameter_prop(param,"title","string","Talk Port   " );
   AVSconnect_widget(param, "typein_integer");
/* --------------------------- */

   AVSadd_parameter_prop(param, "layout", "string_block", "\
 panel \"$Module!Connection List\" -w panel -p ui -xy 300,100 -wh 820,350\n\
  manipulator \"$Module:Connection List\" -w text -p \"$Module!Connection List\" -xy 344,17 -wh 236,22\n\
  manipulator \"$Module:Hostname 1\" -w typein -p \"$Module!Connection List\" -xy 20,70 -wh 236,22\n\
  manipulator \"$Module:Talk Port 1\" -w typein_integer -p \"$Module!Connection List\" -xy 20,90 -wh 236,22\n\
  manipulator \"$Module:Listen Port 1\" -w typein_integer -p \"$Module!Connection List\" -xy 20,110 -wh 236,22\n\
  manipulator \"$Module:Hostname 2\" -w typein -p \"$Module!Connection List\" -xy 20,150 -wh 236,22\n\
  manipulator \"$Module:Talk Port 2\" -w typein_integer -p \"$Module!Connection List\" -xy 20,170 -wh 236,22\n\
  manipulator \"$Module:Listen Port 2\" -w typein_integer -p \"$Module!Connection List\" -xy 20,190 -wh 236,22\n\
  manipulator \"$Module:Hostname 3\" -w typein -p \"$Module!Connection List\" -xy 20,230 -wh 236,22\n\
  manipulator \"$Module:Talk Port 3\" -w typein_integer -p \"$Module!Connection List\" -xy 20,250 -wh 236,22\n\
  manipulator \"$Module:Listen Port 3\" -w typein_integer -p \"$Module!Connection List\" -xy 20,270 -wh 236,22\n\
  manipulator \"$Module:Hostname 4\" -w typein -p \"$Module!Connection List\" -xy 280,70 -wh 236,22\n\
  manipulator \"$Module:Talk Port 4\" -w typein_integer -p \"$Module!Connection List\" -xy 280,90 -wh 236,22\n\
  manipulator \"$Module:Listen Port 4\" -w typein_integer -p \"$Module!Connection List\" -xy 280,110 -wh 236,22\n\
  manipulator \"$Module:Hostname 5\" -w typein -p \"$Module!Connection List\" -xy 280,150 -wh 236,22\n\
  manipulator \"$Module:Talk Port 5\" -w typein_integer -p \"$Module!Connection List\" -xy 280,170 -wh 236,22\n\
  manipulator \"$Module:Listen Port 5\" -w typein_integer -p \"$Module!Connection List\" -xy 280,190 -wh 236,22\n\
  manipulator \"$Module:Hostname 6\" -w typein -p \"$Module!Connection List\" -xy 280,230 -wh 236,22\n\
  manipulator \"$Module:Talk Port 6\" -w typein_integer -p \"$Module!Connection List\" -xy 280,250 -wh 236,22\n\
  manipulator \"$Module:Listen Port 6\" -w typein_integer -p \"$Module!Connection List\" -xy 280,270 -wh 236,22\n\
  manipulator \"$Module:Hostname 7\" -w typein -p \"$Module!Connection List\" -xy 560,70 -wh 236,22\n\
  manipulator \"$Module:Talk Port 7\" -w typein_integer -p \"$Module!Connection List\" -xy 560,90 -wh 236,22\n\
  manipulator \"$Module:Listen Port 7\" -w typein_integer -p \"$Module!Connection List\" -xy 560,110 -wh 236,22\n\
  manipulator \"$Module:Hostname 8\" -w typein -p \"$Module!Connection List\" -xy 560,150 -wh 236,22\n\
  manipulator \"$Module:Talk Port 8\" -w typein_integer -p \"$Module!Connection List\" -xy 560,170 -wh 236,22\n\
  manipulator \"$Module:Listen Port 8\" -w typein_integer -p \"$Module!Connection List\" -xy 560,190 -wh 236,22\n\
  manipulator \"$Module:Hostname 9\" -w typein -p \"$Module!Connection List\" -xy 560,230 -wh 236,22\n\
  manipulator \"$Module:Talk Port 9\" -w typein_integer -p \"$Module!Connection List\" -xy 560,250 -wh 236,22\n\
  manipulator \"$Module:Listen Port 9\" -w typein_integer -p \"$Module!Connection List\" -xy 560,270 -wh 236,22\n\
  panel \"$Module!Connection List\" -hide  \n\
");
  
   out_port = AVScreate_output_port ( "Output Integer","integer" );
   out_port = AVScreate_output_port ( "Output Float","real" );
   out_port = AVScreate_output_port ( "Output String","string" );
   out_port = AVScreate_output_port ( "Transformation","geom" );

   return(1);
}
