/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/
/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/deccvt.c,v 1.2 1991/06/11 15:22:22 sreedhar Exp $
**
**********************************************************************/



#ifdef RCSLOG

 $Log: deccvt.c,v $
 * Revision 1.2  1991/06/11  15:22:22  sreedhar
 * diclaimer added
 *
 * Revision 1.1  1991/05/30  15:52:54  sreedhar
 * Initial revision
 *
 * Revision 1.2  1990/11/08  16:48:12  jefft
 * Fixed dtm_triplet and dtm_complex conversion routines.  'size' is set
 * first instead of only on return.
 *
 * Revision 1.1  90/11/08  16:40:06  jefft
 * Initial revision
 * 

#endif


#include	<stdio.h>
#include	<sys/types.h>
#include	<netinet/in.h>

#include	"dtmint.h"
#include	"debug.h"


#define		swap(x,y)	x ^= y;  y ^= x;  x ^= y


static int dtm_char(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  DBGFLOW("# dtm_char called.\n");

  return size;
}

static int dtm_short(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  DBGFLOW("# dtm_short called.\n");

  return ((mode == DTMLOCAL) ? (size / 2) : (size * 2));
}


static int dtm_int(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  int	i;

  DBGFLOW("# dtm_int called.\n");

  size = ((mode == DTMLOCAL) ? (size / 4) : (size * 4));

  if (buf != NULL)
    for (i=0; i<size; i+=1)  {
      swap(*buf, *(buf+3));
      swap(*(buf+1), *(buf+2));
      buf += 4;
      }

  return size;
}


static int dtm_float(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  int	i;

  DBGFLOW("# dtm_float called.\n");

  size = ((mode == DTMLOCAL) ? (size / 4) : (size * 4));

  if (buf != NULL)
    for (i=0; i<size; i+=1)  {
      swap(*buf, *(buf+3));
      swap(*(buf+1), *(buf+2));
      buf += 4;
      }

  return size;
}


static int dtm_double(mode, buf, size)
  int	mode, size;
  char	*buf;
{

  DBGFLOW("# dtm_flt64 called.\n");

  return ((mode == DTMLOCAL) ? (size / 8) : (size * 8));
}


static int dtm_complex(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  int	i;

  DBGFLOW("# dtm_complex called.\n");

  size = ((mode == DTMLOCAL) ? (size / 8) : (size * 8));

  if (buf != NULL)
    for (i=0; i<size*2; i+=1)  {
      swap(*buf, *(buf+3));
      swap(*(buf+1), *(buf+2));
      buf += 4;
      }

  return size;
}


static int dtm_triplet(mode, buf, size)
  int	mode, size;
  char	*buf;
{
  int	i;

  DBGFLOW("# dtm_triplet called.\n");

  size = ((mode == DTMLOCAL) ? (size / 16) : (size * 16));

  if (buf != NULL)
    for (i=0; i<size*4; i+=1)  {
      swap(*buf, *(buf+3));
      swap(*(buf+1), *(buf+2));
      buf += 4;
      }

  return size;
}


/* conversion routine function table */
int	(*DTMconvertRtns[])() = {
		dtm_char,
                dtm_short,
                dtm_int,
                dtm_float,
                dtm_double,
                dtm_complex,
		dtm_triplet
		};
