/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/dtmf77.c,v 1.4 1991/06/11 15:22:00 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: dtmf77.c,v $
 * Revision 1.4  1991/06/11  15:22:00  sreedhar
 * disclaimer added
 *
 * Revision 1.3  1991/05/30  15:53:35  sreedhar
 * Changes for readMsg/writeMsg internal release
 *
 * Revision 1.2  1991/02/01  10:41:40  jefft
 * Fixed bug with DTMBR, the _cptofcd was not used correctly.
 *
 * Revision 1.1  90/11/08  16:31:46  jefft
 * Initial revision
 * 

#endif


#include	<stdio.h>
#include	<fortran.h>
#include	"dtm.h"



int DTMMIP(s)
  _fcd	s;
{
  int	len;
  char	portname[128];

  len = _fcdlen(s);
  strncpy(portname, _fcdtocp(s), len);
  portname[len] = '\0';

  return DTMmakeInPort(portname);
}


int DTMMOP(s)
  _fcd	s;
{
  int	len;
  char	portname[128];

  len = _fcdlen(s);
  strncpy(portname, _fcdtocp(s), len);
  portname[len] = '\0';

  return DTMmakeOutPort(portname);
}


int DTMGPA(p, s, len)
  int	*p, *len;
  _fcd	s;
{  
  char	portaddr[128];


  if (DTMgetPortAddr(*p, portaddr, sizeof portaddr) == DTMERROR)
    return DTMERROR;

  if (strlen(portaddr) > *len)  {
    strncpy(_fcdtocp(s), portaddr, *len); 
    return DTMERROR;
    }

  else  {
    strncpy(_fcdtocp(s), portaddr, strlen(portaddr));
    return 0;
    }
}


int DTMAR(p)
  int	*p;
{
  return DTMavailRead(*p);
}


int DTMBR(p, header, size)
  int		*p, *size;
  _fcd		header;
{

  return DTMbeginRead(*p, _fcdtocp(header), *size);
}


int DTMRD(p, ds, size, type)
  int		*p, *size;
  char		*ds;
  DTMTYPE	*type;
{
  return DTMreadDataset(*p, ds, *size, *type);
}


int DTMER(p)
  int	*p;
{
  return DTMendRead(*p);
}


int DTMAW(p)
  int		*p;
{
  return DTMavailWrite(*p);
}


int DTMBW(p, header, size)
  int		*p, *size;
  _fcd		header;
{
  int	len;
  char	buffer[DTM_MAX_HEADER];

  len = _fcdlen(header);
  strncpy(buffer, _fcdtocp(header), len);
  buffer[len] = '\0';
  
  return DTMbeginWrite(*p, buffer, len+1);
}


int DTMSD(p, ds, size, type)
  int		*p, *size;
  char		*ds;
  DTMTYPE	*type;
{
  return DTMwriteDataset(*p, ds, *size, *type);
}


int DTMEW(p)
  int		*p;
{
  return DTMendWrite(*p);
}
