/*
	Author	: Sreedhar Sivakumaran
	Purpose	: Functions to interact with name server.
	Notes	:
		  +++++ Consider putting dtm_nsend_sockaddr and
			dtm_nrecv_list in nmsg.c +++++
*/

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/uio.h>
#include "dtmint.h"
#include "dtmnserv.h"
#include <stdio.h>
#include "debug.h"

static	char	refname[ REFNAMELEN ] ;
static	char	mbuf[ MAX132 ] ;

/*	
	Function to initialise self's reference name from environment
	variable passed by nameserver.

	Return	value	:	0 on success,
				-1 on error.

	Notes	:	Environment variable	- DTM_REFNAME
*/
 
dtm_refname_init()
{
char	*p ;

	DBGFLOW( "dtm_refname_init called\n" );
	if( (p = getenv( DTM_REFNAME )) == NULL )
	{
		DTMerrno = DTMENV ;
		DTMERR( "dtm_refname_init: Env not setup" );
		return -1 ;
	}
	strncpy( refname, p, (REFNAMELEN - 1) );
	refname[ REFNAMELEN - 1 ] = '\0' ;

	DBGINT( "dtm_refname_init: user process reference name is %s\n",
		 refname );
	return 0 ;
}

/*
	Function to return process reference name.
*/

char	*dtm_get_refname()
{
	if( refname[0] == '\0' ) dtm_refname_init() ;
	return refname ;
}

#ifdef	DEBUGMSG

dtm_display_buf( outp, count, portname )
Outport	*outp ;
int	count ;
char	*portname ;
{
	count = 1 ;
	DBGINT( "dtm_display_buf: Logical port %s\n", portname );
	while( count-- )
	{
		DBGINT( "dtm_display_buf: Nethostid = %x\n", 
			ntohl( outp -> sockaddr.sin_addr.s_addr) );
		DBGINT( "dtm_display_buf: Portid = %d\n", 
			ntohs( outp -> sockaddr.sin_port) );
		++outp ;	
	}
}

#endif

/*
	Function to mark the port entries to be deleted from
	the outport buffer.

	Return values	: 	TRUE, if entry was deleted.
				FALSE, otherwise.

	Notes	: 	The return value maybe used later as a debugging aid.
*/

dtm_del_oldbuf( port, p, count )
Port	*port ;
Outport	*p ;
int	count ;
{
	DBGFLOW( "dtm_del_oldbuf called\n" );
	while( count-- )
	{
		if( (p -> sockaddr.sin_port == port -> portid ) && 
		    (p -> sockaddr.sin_addr.s_addr == port -> nethostid)
		  )
		{
			p -> sockaddr.sin_addr.s_addr = 0 ;
			return TRUE ;
		}
		++p ;
	}
	return FALSE ;
}

/*
	Function to add port entries to outport buffer.
*/

void	dtm_add_newbuf( port, p ) 
Port	*port ;
Outport	*p ;
{
	DBGFLOW( "dtm_add_newbuf called\n" );
	p -> sockaddr.sin_family = AF_INET ;
	p -> sockaddr.sin_port = port -> portid ;
	p -> sockaddr.sin_addr.s_addr = port -> nethostid ;
	p -> connfd = -1 ;
	p -> availwrite = FALSE ;
	p -> seqstart = FALSE ;
}

/*
	Function to transfer port entries from old to new 
	outport buffer, excluding those to be deleted.
*/

void	dtm_transfer_oldtonew( op, np, oldcount )
register Outport *op ;
register Outport *np ;
int	oldcount ;
{
	DBGFLOW( "dtm_transfer_oldtonew called\n" );
	while( oldcount-- )
	{
		if( op -> sockaddr.sin_addr.s_addr != 0 )
		{
			np -> sockaddr = op -> sockaddr ;
			np -> connfd = op -> connfd ;
			np -> availwrite = op -> availwrite ;
			np -> seqstart = op -> seqstart ;		
		}
		++op ; ++np ;
	}	
}

/*
	Function to receive list of outports associated with this port.

	Return values	: 	Count of outports, 	on success.
				0, 			on error.
*/	

dtm_nrecv_list( sockfd, outport, ocount, portname )
int	sockfd ;
Outport	**outport ;
int	ocount ;
char	*portname ;
{
int	tmp ;

	DBGFLOW( "dtm_nrecv_list called\n" );

	/*	
		Receive  message with changes in outports.
		If no outport list exists currently, wait for
		30 secs before timing out, else timeout immediately
		if no message is received.
	*/
	if( dtm_select( sockfd, &tmp, (ocount != 0) ? 0 : 30 ) == FALSE ) 
		return ocount; 

	if( dtm_recv_header( sockfd, mbuf, MAX132 ) == -1 )
	{
		DBGFLOW( "dtm_nrecv_list: No Mport msg from name server\n") ;
		return 0 ;
	}

	/* Ack the route message  
	{
		struct	sockaddr_in	addr ;
		int	fd ;
		char	*tp ;

		tp = dtm_get_naddr( &addr, &fd );
		dtm_nsend_ackroute( fd, tp, refname, portname );   
	}
	*/

	/*
		Algorithm -

		1. For all DEL ports in message, mark the port in the 
		   old outport buffer as to be deleted ( marking is by
		   setting s_addr = 0, it is unused internet nethostid ).

		2. Copy the outports from old to new outport buffer, excluding 
	   	   those marked as to be deleted.

		3. Add the ADD ports in message to the new outport buffer.

		Message format -

		Ports to be DELeted followed by ports to be ADDed.
	*/

	{
	int	opcode ;
	int	addcount ;
	int	delcount ;
	int	ncount ;
	int	tcount ;
	Outport	*noutport ;
	Port	port ;

#ifdef	DEBUGMSG
		if( *outport != NULL )
			dtm_display_buf( *outport, ocount, portname );
#endif
		opcode = atoi( strtok( mbuf, SEP ) ) ;
		delcount = atoi( strtok( NULL, SEP ));
		addcount = atoi( strtok( NULL, SEP ));

		ncount = ocount + addcount - delcount ;

		DBGINT( "dtm_nrecv_list: addcount %d\n", addcount );
		DBGINT( "dtm_nrecv_list: delcount %d\n", delcount );
		DBGINT( "dtm_nrecv_list: ncount %d\n", ncount );
		DBGINT( "dtm_nrecv_list: ocount %d\n", ocount );
		if( (noutport = (Outport *)malloc( sizeof( Outport ) * ncount )) == NULL )
			return 0 ;	

		tcount = delcount ;
		while( tcount -- )
		{
			port.nethostid = inet_addr( strtok( NULL, COLON) );
			port.portid = (unsigned short)atol( strtok( NULL, SEP));
			dtm_del_oldbuf( &port, *outport, ocount ) ;
		}

		if( *outport != NULL )
		{
			dtm_transfer_oldtonew( *outport, noutport, ocount ) ;
			free( *outport );
		}
		*outport = noutport ;

		{
		register Outport *p = *outport + ocount - delcount ;

			while( addcount -- )
			{
				port.nethostid = inet_addr( strtok(NULL, COLON));
				port.portid = (unsigned short)atol( strtok( NULL, SEP));
				dtm_add_newbuf( &port, p ) ;
				++p ;
			}
		}

#ifdef	DEBUGMSG
		dtm_display_buf( *outport, ncount, portname );
#endif

		return ncount ;
	}
}
