/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/**************************************************************************
**
**  Multi-Dimensional Data set include file - contains constants used
**	with the MDD & PAL header type.
**
**
**
**************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/mdd.h,v 1.2 1991/06/11 15:23:09 sreedhar Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: mdd.h,v $
 * Revision 1.2  1991/06/11  15:23:09  sreedhar
 * disclaimer added
 *
 * Revision 1.1  1990/11/08  16:37:32  jefft
 * Initial revision
 *

#endif


#define	MDDclass		"MDD"
#define MDDsize			256

#define PALclass		"PAL"
#define PALsize			64

/* MDD specific tags */
#define	MDDdims			"DIM"
#define MDDminmax		"MM"


/* MDD & PAL specific macros */
#define MDDsetClass(h)			DTMsetClass(h, MDDclass)
#define MDDcompareClass(h)		DTMcompareClass(h, MDDclass)

#define PALsetClass(h)			DTMsetClass(h, PALclass)
#define PALcompareClass(h)		DTMcompareClass(h, PALclass)

#define MDDsetPalette(h, t)		dtm_set_char(h, PALclass, t)
#define MDDgetPalette(h, t, l)		dtm_get_char(h, PALclass, t, l)

/* MDD & PAL rename macros */
#define MDDheaderLength			DTMheaderLength
#define	MDDHL				DTMheaderLength

#define PALheaderLength			DTMheaderLength
#define PALHL				DTMheaderLength

#define MDDsetTitle			DTMsetTitle
#define MDDgetTitle			DTMgetTitle

#define PALsetTitle			DTMsetTitle
#define PALgetTitle			DTMgetTitle

#define MDDsetType			DTMsetType
#define	MDDgetType			DTMgetType


/* MDD routines */
extern void	MDDsetDimensions();
extern int	MDDgetDimensions();
extern void	MDDsetMinMax();
extern int	MDDgetMinMax();
extern void	MDDfindMinMax();
