/*
	Author	: Sreedhar Sivakumaran
	Purpose	: Functions to initialise name server address, fd and to
		  to return it. 
	Notes	:
*/

#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "dtmnserv.h"
#include "dtmint.h"
#include <stdio.h>
#include "debug.h"

static	struct	sockaddr_in	nsaddr ;	/* name server's address */
static	int	nssockfd = -1 ;			/* name server's socket */
static	char	nameserver[ MAX132 ] ;		/* 
						   name server address -
						   dotted decimal: port number 
						*/

/*
	Function to initialise the name server's address by
	looking up the environment variable.

	Return	values	:	-1 on error.
				0  on success.
	Notes		:
				Environment variable format : 
				
				DTM_NAMESERVER=nethostid:portid
			
				e.g. DTM_NAMESERVER=141.142.221.66:9900
*/

dtm_ninit()
{
char	*p ;

	DBGFLOW( "dtm_ninit called\n" );
	if( (p = getenv( DTM_NAMESERVER )) == NULL )
	{
		DTMerrno = DTMENV ;
		DTMERR( "dtm_ninit: Env not setup" );
		return -1 ;
	}
	
	/*	Initialise name server's address, used in send() */

	strncpy( nameserver, p, MAX132 ); 
	DBGINT( "dtm_ninit: Nameserver is %s\n", nameserver );

	nsaddr.sin_family = AF_INET ;
	{
	register char	*p1 = p ;

		while( *p1 != ':' ) ++p1 ;
		*p1 = '\0' ; p1++ ;

		nsaddr.sin_addr.s_addr = inet_addr( p ) ; 
		nsaddr.sin_port = (unsigned short)atol( p1 ) ;
		DBGINT( "dtm_ninit: Nethostid = %x\n", ntohl( nsaddr.sin_addr.s_addr) );
		DBGINT( "dtm_ninit: Portid = %d\n", ntohs( nsaddr.sin_port) ); 
	}

	/*	Acquire socket to be used for sending to name server  */

	if( (nssockfd = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP )) == -1 )
	{
		DTMerrno = DTMSOCK ;
		DBGFLOW( "dtm_ninit: Socket call fails" );
		return -1 ;
	}

	return 0 ;
}

/*
	Function to return name server's address and associated socket fd.
*/

char	*dtm_get_naddr( addr, sockfd )
struct	sockaddr_in	*addr ;
int	*sockfd ;
{
	if( nssockfd < 0 )  dtm_ninit() ;

	*addr = nsaddr ;
	*sockfd = nssockfd ;

	return (nssockfd < 0) ? 0 : nameserver ;
}
