/*****************************************************************************
*
*                         NCSA DTM version 2.0
*                               June 10, 1991
*
* NCSA DTM Version 2.0 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
*
* We ask, but do not require, that the following message be included in all
* derived works:
*
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
*
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
*
*****************************************************************************/

/************************************************************************
**
**  sds.c - Scientific Data Set utility routines.
**	
*************************************************************************/

/*********************************************************************
**
**  $Header: /netdev/dtm/libsrc/RCS/sds.c,v 1.3 1991/09/13 18:01:21 jplevyak Exp $
**
**********************************************************************/

#ifdef RCSLOG

 $Log: sds.c,v $
 * Revision 1.3  1991/09/13  18:01:21  jplevyak
 * Fixed minor bug w/extra argument in call.
 *
 * Revision 1.2  91/06/11  15:20:50  sreedhar
 * disclaimer added
 * 
 * Revision 1.1  1990/11/08  16:39:09  jefft
 * Initial revision
 *

#endif


#include	<stdio.h>
#include	<string.h>

#include	"dtm.h"
#include	"sds.h"


extern int	atoi();
extern double	atof();



void SDSsetDimensions(h, rank, dims)
  char	*h;
  int	rank, *dims;
{
  char	num[8];
  int	i;

  sprintf(num, "%d ", rank);
  strcat(h, SDSdims); strcat(h, " ");
  strcat(h, num);

  for (i=0; i<rank; i+=1)  {
    sprintf(num, "%d ", dims[i]);
    strcat(h, num);
    }
}


int SDSgetDimensions(h, rank, dims, len)
  char	*h;
  int	*rank, *dims, len;
{
  int	i;

  if ((h = dtm_find_tag(h, SDSdims)) == NULL)
    return DTMERROR;
  else
    h = strchr(h, ' ')+1;

  *rank = atoi(h);

  for (i=0; i<*rank && i<len; i+=1)
    if ((h = strchr(h, ' ')) == NULL)
      return DTMERROR;
    else
      dims[i] = atoi(++h);

  return 0;
}


void SDSsetMinMax(h, min, max)
  char	*h;
  float	min, max;
{
  char	num[12];

  strcat(h, SDSminmax);  strcat(h, " ");

  sprintf(num, "%f ", min);
  strcat(h, num);

  sprintf(num, "%f ", max);
  strcat(h, num);
}


int SDSgetMinMax(h, min, max)
  char	*h;
  float	*min, *max;
{

  if ((h = dtm_find_tag(h, SDSminmax)) == NULL)
    return DTMERROR;
  else
    h = strchr(h, ' ')+1;


  *min = atof(h); 

  h = strchr(h, ' ') + 1;
  *max = atof(h); 
  
  return 0;
}


int SDSnumElements(rank, dims)
  int	rank, *dims;
{
  int	size;

  size = *dims++;
  while (--rank > 0)
    size *= *dims++;

  return size;
}

void SDSconvert(h)
  char	*h;
{
  char	*f;
  char	nh[256];
  int	i;
  int	type, rank, dims[10];
  char	title[80];
  

  SDSsetClass(nh);


  if ((f = dtm_find_tag(h, "R")) != NULL)  {
    f = strchr(f, ' ')+1;
    rank = atoi(f);
    for (i=0; i<rank; i+=1)  {
      f = strchr(f, ' ')+1;
      dims[i] = atoi(f);
      }
    }
  else
    SDSgetDimensions(h, &rank, dims, 10);

  SDSsetDimensions(nh, rank, dims);

  if (dtm_get_int(h, "T", &type) == DTMERROR)
    SDSgetType(h, &type);

  SDSsetType(nh, type);

  if ((f = dtm_find_tag(h, "GRP")) != NULL)  {
    f = strchr(f, ' ')+1;
    f = strchr(f, ' ')+1;
    i = strchr(f, ' ')-f;
    strncpy(title, f, i);
    title[i]='\0';
    SDSsetTitle(nh, title);
    }
  else if (SDSgetTitle(h, title, 80) != DTMERROR)
    SDSsetTitle(nh, title);


  strcpy(h, nh);

  return;
}
