/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include "dtm.h"
#include "view_share.h"
#include <avs/avs.h>
#include <avs/port.h>

extern int *talk_id,*listen_id;

int 
New_Listen ( index,port )
   int index,port;
{
   char portname[30];

   sprintf ( portname,"Listen Port %d",(index+1) );
   if ( NEW_PARAM(portname) )
   {
      if (port > SMALL_SOCKET )
      {
	 return(1);
      }
      else
      if (port)
      {
	 fprintf ( stderr,"DTM : Minimum Port Number : %d\n",SMALL_SOCKET );
         RESET_PORTNAME;
         return(0);
      }
   }
   else
   {
      return(0);
   }
}

int 
New_Talk ( index,port )
   int index,port;
{
   char portname[30],portname2[30];

   sprintf ( portname,"Talk Port %d",(index+1) );
   sprintf ( portname2,"Hostname %d",(index+1) );
   if ( NEW_PARAM(portname) || NEW_PARAM(portname2) )
   {
      if (port > SMALL_SOCKET )
      {
         return(1);
      }
      else
      if (port)
      {
         fprintf ( stderr,"DTM : Minimum Port Number : %d\n",SMALL_SOCKET );
         RESET_PORTNAME;
         return(0);
      }
   }
   else
   {
      return(0); 
   }
}

void Create_New_Listen ( listen_id,index,socket )
   int *listen_id,index,socket;
{
   int port_id;
   char portname[30];

   if ( listen_id[index] ) 
   {
      DTMdestroyPort ( listen_id[index] );
      fprintf ( stderr,"DTM : Previous listen connection at portid %d destroyed\n", listen_id[index] );
      listen_id[index]= 0;
   }

   sprintf ( portname,":%d",socket );

   if  ( (port_id = DTMmakeInPort ( portname )) == DTMERROR )
   {    
      fprintf ( stderr,"DTM : Error creating listen port at -%s- \n",portname );
      sprintf ( portname,"Listen Port %d",(index+1) );
      RESET_PORTNAME;
   }
   else
   {
      listen_id[index]=port_id;
      fprintf ( stderr,"DTM: Sucessful listen connection to -%s-  port id:%d\n",
         portname,port_id );
   }
} 

void Create_New_Talk ( talk_id,index,socket,hostname )
   int *talk_id,index,socket;
   char *hostname;
{
   int port_id;
   char portname[30];

   if ( talk_id[index] ) 
   {
      DTMdestroyPort ( talk_id[index] );
      fprintf ( stderr,"DTM : Previous talk connection at portid %d destroyed\n",talk_id[index] );
      talk_id[index]= 0;
   }

   sprintf ( portname,"%s:%d",hostname,socket );

   if  ( (port_id = DTMmakeOutPort ( portname )) == DTMERROR )
   {    
      fprintf ( stderr,"DTM : Error creating talk port at -%s- \n",portname );
      sprintf ( portname,"Talk Port %d",(index+1) );
      RESET_PORTNAME;
   }
   else
   {
      talk_id[index]=port_id;
      fprintf ( stderr,"DTM: Sucessful talk connection to -%s- port id:%d\n",
         portname,port_id );
   }
} 

int 
view_destroy_proc()
{
   int i;

   for (i=0;i<MAX_CONNECTS;i++)
   {
      if (talk_id[i]) DTMdestroyPort(talk_id[i]);
      if (listen_id[i]) DTMdestroyPort(listen_id[i]);
   }
   FREE_LOCAL(talk_id);
   FREE_LOCAL(listen_id);
}
