/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
#include <stdio.h>
#include <avs/avs.h>
#include <avs/flow.h>
#include <avs/field.h>
#include <avs/geom.h>
#include "wide_arrow.h"
/* Used for AVS message() */
static char file_version[]="wide_arrow.c  Evelyn Wright,USGS,Woods Hole,MA  8/92";
AVSinit_modules()	/* Called by main() routine supplied by AVS */
{
	int module_desc();
	AVSmodule_from_desc(module_desc);
}
module_desc()		/* Description function */
{
	int module_compute();
	int inport, outport;
	int widget;
	
	AVSset_module_name( "Wide Arrow", MODULE_MAPPER);
	inport = AVScreate_input_port("Wind Field", 
		"field 1D 2-vector float 3-coord irregular", REQUIRED);
	outport = AVScreate_output_port( "Output_edit_list", "geom" );
        widget = AVSadd_float_parameter("Scale Factor",1.,
					FLOAT_UNBOUND,FLOAT_UNBOUND);
        AVSconnect_widget(widget,"typein_real");
	AVSset_compute_proc(module_compute);
	AVSautofree_output(outport);
}
module_compute(input,output,scale_factr)	/* Computation function */
AVSfield_float *input;
GEOMedit_list *output;
float *scale_factr;
{
	GEOMedit_list GEOMinit_edit_list();
	point		start_vert, end_vert;
	float		width_x, width_y;
	float		hwidth_x, hwidth_y;
	float		colors[12];
	float		verts[12];
	float		color[9];
	float		vert[9];
	float		scal_taux, scal_tauy;
	char		name[81];
	int		x;
	GEOMobj		*obj = GEOM_NULL;

        *output = GEOMinit_edit_list(*output); /* Initialize the edit list */

	/* Set wind vector points */
	start_vert.x = input->points[0];
	start_vert.y = input->points[1];
	start_vert.z = input->points[2];
	scal_taux = *scale_factr * input->data[0];
	scal_tauy = *scale_factr * input->data[1];
	end_vert.x   = start_vert.x + scal_taux;
	end_vert.y   = start_vert.y + scal_tauy;
	end_vert.z   = start_vert.z;

	width_x = - scal_tauy / 4.;
	width_y = scal_taux / 4.;
	hwidth_x = width_x * 1.5;
	hwidth_y = width_y * 1.5; 

	/* Create geometry */
	obj = GEOMcreate_obj( GEOM_POLYTRI, GEOM_NULL );

	verts[0] = start_vert.x - width_x;
	verts[1] = start_vert.y - width_y;
	verts[2] = start_vert.z;

	verts[3] = start_vert.x + width_x;
	verts[4] = start_vert.y + width_y;
	verts[5] = start_vert.z;

	verts[6] = end_vert.x - width_x;
	verts[7] = end_vert.y - width_y;
	verts[8] = start_vert.z;

	verts[9] = end_vert.x + width_x;
	verts[10] = end_vert.y + width_y;
	verts[11] = start_vert.z;

	/* Set color */
	for (x = 0; x < 4; x++) {
	   colors[3*x] = 1.;
	   colors[3*x+1] = 1.;
	   colors[3*x+2] = 0.;
	}
	GEOMadd_polytriangle(obj, verts, GEOM_NULL, colors, 4, GEOM_COPY_DATA);

	vert[0] = end_vert.x + hwidth_x;
	vert[1] = end_vert.y + hwidth_y;
	vert[2] = end_vert.z;

	vert[3] = scal_taux * 5./4. + start_vert.x;
	vert[4] = scal_tauy * 5./4. + start_vert.y;
	vert[5] = end_vert.z;

	vert[6] = end_vert.x - hwidth_x;
	vert[7] = end_vert.y - hwidth_y;
	vert[8] = end_vert.z;

	/* Set color */
	for (x = 0; x < 3; x++) {
	   color[3*x] = 1.;
	   color[3*x+1] = 1.;
	   color[3*x+2] = 0.;
	}
	GEOMadd_polytriangle(obj, vert, GEOM_NULL, color, 3, GEOM_COPY_DATA);

	/* Put vector in edit list with name */
	sprintf( name, "Wind" );
	GEOMedit_geometry( *output, name, obj );
	
	/* Destroy object */
	GEOMdestroy_obj( obj );
	
	return(1);	/* Indicates successful completion */
}
