/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/* mod_gen Version 1                                                     */
/* Module Name: "add polar 2D" (Mapper) (Subroutine)                     */
/* Author:Jeff Knerr, Shawn Mehan,NCSC,248-1100                          */
/* Date Created: Fri Jun  5 13:42:16 1992                                */
/*                                                                       */
/* input 0 "input_data" field 2D 3-space 1-vector float REQUIRED         */
/* output 0 "output_data" field 2D 2-space 1-vector irregular float      */
/* param 0 "grid_theta" radio_buttons "pi" "pi/2:pi:2*pi" ":"            */
/* End of Module Description Comments                                    */

#include <stdio.h>
#include <avs/avs.h>
#include <avs/port.h>
#include <avs/field.h>
 
/* IAC CODE CHANGE : #include <math.h> */
#include <avs/avs_math.h>
#include <string.h>

#define PI 3.141592654
#define PIO2 1.570796327
#define tPIO2 4.71238898
 
/* *****************************************/
/*  Module Description                     */
/* *****************************************/
int add_polar_2D_desc()
{

	int in_port, out_port, param;
	extern int add_polar_2D_compute();

	AVSset_module_name("add polar 2D", MODULE_MAPPER);

	/* Input Port Specifications               */
	in_port = AVScreate_input_port("input_data", "field 2D 3-space 1-vector float", 
		REQUIRED);

	/* Output Port Specifications              */
	out_port = AVScreate_output_port("output_data", 
		"field 2D 2-space 1-vector irregular float");

	/* Parameter Specifications                */
	param = AVSadd_parameter("grid_theta", "choice", "pi", "pi/2:pi:2*pi", 
		":");
	AVSconnect_widget(param, "radio_buttons");

	param = AVSadd_parameter("extend", "boolean", 0, 0, 1);
	AVSconnect_widget(param, "toggle");

	AVSset_compute_proc(add_polar_2D_compute);

	return(1);
}
 
/* *****************************************/
/* Module Compute Routine                  */
/* *****************************************/
int add_polar_2D_compute( input_data, output_data, grid_theta, extend)
	AVSfield_float *input_data;
	AVSfield_float **output_data;
	char *grid_theta;
	int extend;	
{

/* 
** purpose of module: to add polar coordinates to a field. for a uniform field
**                    x and y are calculated for r:0->nx,theta:0->pi/2,pi,or 2pi.
**                    for a rectilinear field, x an y are calculated from the
**                    given coordinates (assumed to be r and theta).
** outline: - read in 2d uniform or rectilinear field
**          - user specifies whether data covers pi/2, pi, or 2*pi radians
**          - depending on that choice, mirror data to 2*pi radians
**	    - if rectilinear field, use supplied coordinates
**          - "extend" toggle for whether user wants data mapped to 2*pi radians
** >>> this module does not currently handle irregular fields <<<
** >>> this module assumes data is cell centered <<<
*/
		int dims0[2];
		int i,j,ix,iy,n,nx,ny,nym1;
		int isuniform;
		float *incoor1,*incoor2;
		float *dummy1,*dummy2;
		float range;
/* actual coordinates */
		float r,theta,inc;
/* choice of whether original data covers whole(2*pi),
 half(pi), or quart(pi/2) of full grid  */
		char *whole;
		char *half;
		char *quart;
                float *min,*max;

/* Free old field data */
	if (*output_data) AVSfield_free(*output_data);
/* Allocate space for new field output */
	whole=(char *) malloc(4);
	half =(char *) malloc(2);
	quart=(char *) malloc(4);
	whole="2*pi";
	half ="pi";
	quart="pi/2";
/* set range, depending on user choice */
	if (strcmp(grid_theta, whole)==0) range=1.0;
	else if(strcmp(grid_theta, half)==0) range=0.5;
	else if(strcmp(grid_theta, quart)==0) range=0.25;

/* dimensions of incoming data */
        nx=MAXX(input_data);
        ny=MAXY(input_data);
        nym1=ny-1;
/* isuniform = 0(UNIFORM),1(RECT),2(IRREGULAR) */
 	isuniform=(input_data)->uniform;

/* alloc space for input_data coordinate arrays */
	incoor1=(float *)calloc(nx,sizeof(float));
        dummy1=incoor1;
/* Test to see if mirroring required*/
/* set dimensions of outgoing data, depending 
   on whether data needs to be mirrored */
/* ny+1 used to fill in space left at end of circle, xtra wedge */
/* allocate space for mirrored output coordinates */
	if (extend) {
           if (range==1.0) {
	   dims0[0] = nx; 
   	   dims0[1] = ny+1;
           incoor2=(float *)calloc(ny+1,sizeof(float));}
           if (range==0.5) {
	   dims0[0] = nx; 
	   dims0[1] = 2*ny+1;
           incoor2=(float *)calloc(2*ny+1,sizeof(float));}
           if (range==0.25) {
	   dims0[0] = nx; 
	   dims0[1] = 4*ny+1;
           incoor2=(float *)calloc(4*ny+1,sizeof(float));}
	}

	else if (!extend) {
	   dims0[0] = nx; 
   	   dims0[1] = ny;
           incoor2=(float *)calloc(ny+1,sizeof(float));}

        dummy2=incoor2;

	*output_data = (AVSfield_float *) AVSdata_alloc(
	    "field 2D 2-space 1-vector irregular float", dims0);
       
/* if mapping to full 2pi */
    if (extend) {
/* if range = 1.0, no need to mirror data */
	if (range==1.0){
          for(j=0;j<ny;j++){
            for(i=0;i<nx;i++){
              I2D(*output_data,i,j) = I2D(input_data,i,j);
            }
          }
          if (isuniform==1)
          {
            for(i=0;i<nx;i++)
            {
              *dummy1=((input_data)->points)[i];
              dummy1++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=((input_data)->points)[nx+i];
              dummy2++;
            }
          }
        }
/* if range = 0.5, mirror once */
         else if (range==0.5){
            for(j=0;j<ny;j++){
              for(i=0;i<nx;i++){
               I2D(*output_data,i,j) = I2D(input_data,i,j);
               I2D(*output_data,i,j+ny) = I2D(input_data,i,nym1-j);
              }
            }
           if (isuniform==1)
            {
            for(i=0;i<nx;i++)
            {
              *dummy1=((input_data)->points)[i];
              dummy1++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=((input_data)->points)[nx+i];
              dummy2++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=(PI+((input_data)->points)[nx+i]);
              dummy2++;
            }
           }
        }
/* if range = 0.25, mirror into other three quadrants */
	else if (range==0.25){
             for(j=0;j<ny;j++){
               for(i=0;i<nx;i++){
                I2D(*output_data,i,j) = I2D(input_data,i,j);
                I2D(*output_data,i,j+ny) = I2D(input_data,i,nym1-j);
                I2D(*output_data,i,j+2*ny) = I2D(input_data,i,j);
                I2D(*output_data,i,j+3*ny) = I2D(input_data,i,nym1-j);
               }
             }
          if (isuniform==1)
          {
            for(i=0;i<nx;i++)
            {
              *dummy1=((input_data)->points)[i];
              dummy1++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=((input_data)->points)[nx+i];
              dummy2++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=(PIO2+((input_data)->points)[nx+i]);
              dummy2++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=(PI+((input_data)->points)[nx+i]);
              dummy2++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=(tPIO2+((input_data)->points)[nx+i]);
              dummy2++;
            }
          }
        }

  } 

/* If not mapping to full 2pi then input data is output data */
	else if (!extend) {
          for(j=0;j<ny;j++){
            for(i=0;i<nx;i++){
              I2D(*output_data,i,j) = I2D(input_data,i,j);
            }
          }
          if (isuniform==1)
          {
            for(i=0;i<nx;i++)
            {
              *dummy1=((input_data)->points)[i];
              dummy1++;
            }
            for(i=0;i<ny;i++)
            {
              *dummy2=((input_data)->points)[nx+i];
              dummy2++;
            }
          }
	}

/* add the missing wedge into 2*pi */
	if (extend) {
          *dummy2=((input_data)->points)[nx];
          for(i=0;i<nx;i++){
            I2D(*output_data,i,dims0[1]-1)=I2D(input_data,i,0);
          }
	}

/* if field is non-uniform then it carries points arrays
** i.e., coordinate arrays. In the case of a rectilinear
** field, this is the x,y axes contained in a single
** 1D arrat of size (xmax+ymax). Need to pull out this information */

/* add polar coordinates to data (map data to 2*pi radians) */
       	n=dims0[0]*dims0[1];
        ix=0;
        iy=n;
/* dims0[1]-1 also used to take out wedge */
/* if mapping to full 2pi		  */
	if (extend) inc=2.0*PI/(float)(dims0[1]-1);

/* if not extendind to full 2pi, test to see what */
/* original calculation was performed on	 */
	else if (!extend) {
           if (range=1.0) inc=2.0*PI/(float)(dims0[1]-1);
           else if (range=0.5) inc=PI/(float)(dims0[1]-1);
           else inc=0.5*PI/(float)(dims0[1]-1);
	}

          theta=0.0;
          dummy2=incoor2;
          for(j=0; j < dims0[1]; j++)
          {
            r=0.0;
	    dummy1=incoor1;
            for(i=0; i < dims0[0]; i++)
            {

	       if (isuniform==0)
	       {
                  ((*output_data)->points)[ix] = r*cos(theta);
                  ((*output_data)->points)[iy] = r*sin(theta);
               }
	       if (isuniform==1)
	       {
	          ((*output_data)->points)[ix] = (*dummy1)*cos(*dummy2);
	          ((*output_data)->points)[iy] = (*dummy1)*sin(*dummy2);
	       }
	       ix++;
               iy++;
	       dummy1++;
               r+=1.0;
            }
            theta=theta+inc;
	    dummy2++;
          }

	 return(1);
}
 
/* ***********************************************************************/
/* Initialization for modules contained in this file.                    */
/* ***********************************************************************/
int ((*mod_list[])()) = {
	add_polar_2D_desc,
};
#define NMODS (sizeof(mod_list) / sizeof(char *))

AVSinit_modules()
{
	AVSinit_from_module_list(mod_list, NMODS);
}
