/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

AUTHOR : Stardent Computer, Inc.
******************************************************************************/
/*
 * area = cross section area evaluator.
 * This module takes an input 2d scalar field, and assumes it
 * has a "doughnut" or "O" shape in it. The simple
 * evaluation algorithm searches for the interior space of the "O",
 * and computes the cross section area of the region.
 * The result (a scalar) is passed in a 1-D ouput array.
 * The module will "accumulate", and pass the history along with
 * the current value.
 * The parameter input controls the current slice, ZERO will reset things.
 * The design was to work with "tubes" with variable cross section.
 * Typical input would come from 3D scalar field --> ortho slice,
 * while typical output would go to the "graph viewer".
 *
 * Author: S. Pass
 *         Stardent Computer Ltd.
 *         Guildford, Surrey, UK
 *         +44-483-505-388
 *
 * Revision:  October 1990  Original     (sdp)
 *            6 March 1991  AVS3 cleanup (ianc)
 *
 */

#include <stdio.h>
#include <avs/flow.h>
#include <avs/avs_data.h>
#include <avs/field.h>

/******************************************************************************/


AVSinit_modules()
{
   int area_init();
   AVSmodule_from_desc(area_init);
}

area_init()
{
	int area();
	int in_port, out_port;	/* temporaries to hold the port numbers */

	/* Set the module name and type */
	AVSset_module_name("area", MODULE_MAPPER);

	/* Create input ports */
	AVScreate_input_port("Slice Input",
	"field 2D uniform scalar byte",REQUIRED);

	/* Create output port */
	AVScreate_output_port("Area output","field 1D uniform scalar int");

	/* Create slice number input */
	AVSadd_parameter("Slice No","integer",0,0,512);

	/* Tell avs what subroutine to call to do the compute */
	AVSset_compute_proc(area);
}


/* compute cross section area from current slice */
area(input, output, slice_no)
AVSfield_char	*input;
AVSfield_int	**output;
int		slice_no;
{
	int i,j,ncross,area[1024],crossing[10];

	area[slice_no] = 0;

	for(i=0; i < MAXY(input); i++)
	{
		ncross = 0;
		for(j=1; j < MAXX(input); j++)
		{
			/* Is this an edge crossing ? */
			if(I2D(input,j-1,i) != I2D(input,j,i))
				crossing[ncross++] = j;
		}

		/* Does this scan line have an artery interior ? */
		if(ncross == 4)
			area[slice_no] += crossing[2] - crossing[1];
	}

	/* Set up output field */
	if(*output != NULL)
		free(*output);

	*output = (AVSfield_int *)AVSbuild_field(1,1,UNIFORM,0,
			AVS_TYPE_INTEGER,slice_no+1,area);

    return(1);
}
