/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*   
     This software is copyright (C) 1992,  Regents  of  the
University  of  California.   Anyone may reproduce bin_field.c,
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  bin_field.c  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  bin_field.c  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     bin_field.c is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
bin_field.c, or any part thereof.     

Author:
	Wes Bethel   
	Lawrence Berkeley Laboratory
	1 Cyclotron Rd.   Mail Stop 50-F
	Berkeley CA 94720
	510-486-6626
	ewbethel@lbl.gov
*/


/**
  * the purpose of this module is to compute the number of points
  * which occupy each spatial bin in the output field from the input
  * field.  the input field consists of 3-space n-dimensional irregular
  * data.  the output field contains counts of the number of occurances
  * of input data points in that grid location.
**/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>

AVSinit_modules()
{
    int bin_field();
    AVSmodule_from_desc(bin_field);
}

int
    bin_field()
{
    int p;
    int bin_field_p();
    AVSset_module_name("bin field",MODULE_MAPPER);
    AVScreate_input_port("input field","field irregular",REQUIRED);
    AVScreate_output_port("output field","field rectilinear integer");
    AVSadd_parameter("bin count","integer",10,10,256);
    AVSset_compute_proc(bin_field_p);
}

int
    bin_field_p(inf,outf,n)
AVSfield *inf;
AVSfield **outf;
int n;
{
    AVSfield template;
    int dims[3],i,j,ix,iy,iz,num_pts,n2;
    float *fp,*xp,*yp,*zp,*xip,*yip,*zip;
    double t,dt;
    int *data;
    int search();
    int npts;
    float mnx[3],mxx[3];
    
    /* input validity checks -- the input field must be in
       3 coord dimensions, any number of data dimensions, any
       vector length, any data type. */
    
    if (inf->nspace != 3)
	{
	    AVSwarning(" Input field must have 3 coordinate dimensions.");
	    return(0);
	}
    
    /* create output field */
    
    memset((char *)&template,0,sizeof(AVSfield));
    
    template.ndim = template.nspace = 3;
    template.veclen = 1;
    template.uniform = RECTILINEAR;
    template.type = AVS_TYPE_INTEGER;
    template.size = sizeof(char);
    
    for (i=0;i<3;i++)
	dims[i] = n+1;
    
    if (*outf)
	AVSfield_free(*outf);
    
    *outf = (AVSfield *)AVSfield_alloc(&template,dims);
    
    /* assume that the extents field in the field structure either
       doesn't exist or is invalid.  we must recompute. */
    
    for (i=0,npts=1;i<inf->ndim;i++)
	npts *= inf->dimensions[i];
    
    mnx[0] = mnx[1] = mnx[2] = 1e10;
    mxx[0] = mxx[1] = mxx[2] = -1e10;

    xp = inf->points;
    yp = xp+npts;
    zp = yp+npts;
    
    for (i=0;i<npts;i++)
    {
	if (xp[i] < mnx[0])
	    mnx[0] = xp[i];
	if (xp[i] > mxx[0])
	    mxx[0] = xp[i];
    }
    for (i=0;i<npts;i++)
    {
	if (yp[i] < mnx[1])
	    mnx[1] = yp[i];
	if (yp[i] > mxx[1])
	    mxx[1] = yp[i];
    }

    for (i=0;i<npts;i++)
    {
	if (zp[i] < mnx[2])
	    mnx[2] = zp[i];
	if (zp[i] > mxx[2])
	    mxx[2] = zp[i];
    }

    AVSfield_set_extent((*outf),mnx,mxx);

    /* clear the data area by setting it to zero. */
    memset((char *)((*outf)->field_union.field_data_int_u),0,sizeof(int)*(n+1)*(n+1)*(n+1));

    /* compute the coordinate values for the rectilinear field. */
    fp = (*outf)->points;

    for (j=0;j<3;j++)
    {
	t = mnx[j];
	dt = (mxx[j] - mnx[j])/(double)(n);
	for (i=0;i<=n;i++,t += dt)
	    *fp++ = t;
    }

    /* now, scan through the input field and bin the data. */
    
    for (i=0,num_pts=1;i<inf->ndim;i++)
	num_pts *= inf->dimensions[i];

    /* output coord pointers */
    xp = (*outf)->points;
    yp = xp+(n+1);
    zp = yp+(n+1);

    /* input coord pointers */
    xip = inf->points;
    yip = xip + num_pts;
    zip = yip + num_pts;

    data = (*outf)->field_union.field_data_int_u;
    n2 = (n+1)*(n+1);
    
    for (i=0;i<num_pts;i++)
    {
	/* first, compute the i,j,k indeces in the output field of
	   the coordinates of the given point in the input field. */

	ix = search(xip,xp,n+1);
	iy = search(yip,yp,n+1);
	iz = search(zip,zp,n+1);

	if ((ix != -1) && (iy != -1) && (iz != -1))
	    *(data+ix+iy*(n+1)+iz*n2) += 1;

	xip++;
	yip++;
	zip++;
    }
    return(1);
}

int
search(inp,outp,n)
float *inp,*outp;
int n;
{
    int i,rvalue = -1;
    
    /* find location of *inp in coords pointed to by *outp, of
       which there are n. if no such container exists, return a -1 */

    for (i=0;i<n;i++)
	if (((*inp) >= outp[i]) && ((*inp <= outp[i+1])))
	{
	    rvalue = i;
	    break;
	}
    return(rvalue);
}
