/****************************************************************************
                  INTERNATIONAL AVS CENTER
	(This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module provide absolutely
NO WARRANTY OF ANY KIND with respect to this software.  The entire risk as to
the quality and performance of this software is with the user.  IN NO EVENT
WILL The International AVS Center, MCNC, the AVS Consortium and the individual
submitting the module and files associated with said module BE LIABLE TO
ANYONE FOR ANY DAMAGES ARISING FROM THE USE OF THIS SOFTWARE, INCLUDING,
WITHOUT LIMITATION, DAMAGES RESULTING FROM LOST DATA OR LOST PROFITS, OR ANY
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@ncsc.org.

Please send AVS module bug reports to avs@ncsc.org.

******************************************************************************/
/*
     City Scape Version 3.0

			Copyright (c) 1989 by
			Stardent Computer Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Stardent Computer Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under sccs control at Stardent in:
	/usr/users/ianc/avs/sccs_avs3.0/modules/mappers/s.city_scape.c
	
*/

/* city scape module
 * derived from the standard "field to mesh" module.
 * Therefore, leave the copyright note in.
 *
 * Author: Ian Curington
 *
 * Revision History:
 *    31 January  92  ianc: Original
 *     4 February 92  ianc: Complete boxes, scale factors
 *     5 February 92  ianc: added averages shadow
 *     8 March    92  ianc: added threshold sheet
 *    12 March    92  ianc: added wireframe base, tickmarks
 *    17 March    92  ianc: added labels on tics
 *    19 March    92  ianc: vertical tics, separate sheet obj
 *    20 March    92  ianc: tidy up, average bug fix
 *
 *       [ major version 2 upgrade ]
 *     9 June     93  ianc: update for version 2
 *                    ianc: added secondary input port for colors
 *                    ianc: added label space increment control
 *                    ianc: added toggle controls for each piece
 *                    ianc: added upstream picking, int output ports
 *
 *       [ major version 3 upgrade ]
 *    28 Jan   94     ianc: update to add cell hilite color on pick
 *    10 June  94     ianc: added extra edit list for pick, no normals
 *                          new text input for edge labels
 *    13 June  94     ianc: added string typeins for edge labels
 *                          fixed up strtok
 */

#include <stdio.h>

#include <avs/port.h>
#include <avs/avs.h>
#include <avs/field.h>
#include <avs/geom.h>
#include <avs/geomdata.h>
#include <avs/colormap.h>
#include <avs/udata.h>

#include <string.h>

#define NUM_V_TICS 10
#define MAX_SIZE 150000


/**********************************************************************/
/* Module Description Section */

MODcity_scape()
{
	int city_scape_compute();
        int param;

        /*********
          Name, Class
         *********/
	AVSset_module_name("city scape", MODULE_MAPPER);
	AVSset_module_flags( COOPERATIVE | REENTRANT );

        /*********
          Inputs 
         *********/
	AVScreate_input_port("Field Input",
                             "field 2D uniform scalar float", 
                             REQUIRED );
	AVScreate_input_port("Second Input",
                             "field 2D uniform scalar float", 
                             OPTIONAL );
	AVScreate_input_port("Input Colormap", "colormap", REQUIRED);

        param = AVScreate_input_port("pick",
              "struct upstream_geom", OPTIONAL | INVISIBLE);
        AVSset_input_class(param,"upstream_geom");

	
        /*********
          Outputs 
         *********/
	param = AVScreate_output_port("geometry", "geom");
        param = AVScreate_output_port( "X-Index", "integer");
        param = AVScreate_output_port( "Y-Index", "integer");


        /*********
          Control Parameters 
         *********/
	param = AVSadd_float_parameter("Z scale",
               1.0, FLOAT_UNBOUND, FLOAT_UNBOUND);
        AVSconnect_widget( param, "typein_real");
	AVSadd_float_parameter("width", 0.8, 0.0, 1.0);
	AVSadd_float_parameter("offset", 0.1, 0.0, 1.0);
	AVSadd_float_parameter("threshold", 0.0, FLOAT_UNBOUND, FLOAT_UNBOUND );
	param = AVSadd_float_parameter("tic scale",
               1.0, FLOAT_UNBOUND, FLOAT_UNBOUND );
        AVSconnect_widget( param, "typein_real");
	param = AVSadd_parameter("h-label inc", "integer", 2, 1, 100 );
        AVSconnect_widget( param, "typein_integer");
	param = AVSadd_parameter("v-label inc", "integer", 2, 1, 100 );
        AVSconnect_widget( param, "typein_integer");
	param = AVSadd_parameter("draw city",     "boolean", 1, 0, 1 );
	param = AVSadd_parameter("draw sidebars", "boolean", 1, 0, 1 );
	param = AVSadd_parameter("draw ticmarks", "boolean", 1, 0, 1 );
	param = AVSadd_parameter("draw labels",   "boolean", 1, 0, 1 );
	param = AVSadd_parameter("draw threshold","boolean", 1, 0, 1 );

	param = AVSadd_parameter("x_axis_text","string", NULL, NULL, NULL );
	param = AVSadd_parameter("y_axis_text","string", NULL, NULL, NULL );

	AVSset_compute_proc(city_scape_compute);
}

/**********************************************************************/
/* Module Compute Function */
city_scape_compute(input, secondary,
        colormap, xgeom, output,
        x_index, y_index,
	zscale, fwidth, foffset,
        threshold, tic_scale,
        h_label_inc, v_label_inc,
        draw_cityscape,
        draw_sidebars,
        draw_ticmarks,
        draw_labels,
        draw_threshold,
        x_axis_text,
        y_axis_text )

        AVSfield_float *input;
        AVSfield_float *secondary;
        AVScolormap *colormap;
        upstream_geom *xgeom;
        GEOMedit_list *output;
        int *x_index;
        int *y_index;
        float *zscale;
        float *fwidth;
        float *foffset;
        float *threshold;
        float *tic_scale;
        int   h_label_inc;
        int   v_label_inc;
        int draw_cityscape;
        int draw_sidebars;
        int draw_ticmarks;
        int draw_labels;
        int draw_threshold;
        char *x_axis_text;
        char *y_axis_text;
{
   GEOMobj *obj;
   GEOMobj *obj_sheet;
   GEOMobj *obj_base;
   GEOMobj *obj_label;
   GEOMobj *obj_pick;
   unsigned int color_lut[BYTE_TABLE];
   int size, size2, i, j, k;
   int index[2][MAX_SIZE];
   static int ix, iy;

   /***********
    * Body    *
    ***********/


   size = MAXX(input) * MAXY(input);

   /* check for match */
   if ( secondary != NULL )
   {
       size2 = MAXX(secondary) * MAXY(secondary);
       if ( size != size2 )
       {
          AVSerror("primary and secondary fields have different size!");
          return(0);
       }
   }
   if ( size > MAX_SIZE )
   {
       AVSerror(" input too big ");
       return(0);
   }

   /* pre-build a color lookup table for speed */
   for (i=0; i<colormap->size; i++) 
   {
	 PIXELhsva_to_pixel (&color_lut[i], colormap->hue[i], 
			colormap->saturation[i],
			colormap->value[i], colormap->alpha[i]);
   }

   /* === Pick Mode === */
   if ( xgeom != NULL &&
        AVSinput_changed( "pick", 0) &&
        xgeom->odata >= 0 )
   {
        /* fill index array */
        for (i = 0; i < MAXX(input); i++)
        {
           for (j = 0; j < MAXY(input); j++)
           {
               k = j * MAXX(input) + i;
               index[0][ k ] = i;
               index[1][ k ] = j;
           }
        }

        ix = index[0][ xgeom->odata ];
        iy = index[1][ xgeom->odata ];
        *x_index = ix;  /* return pointer */
        *y_index = iy;
	/***
        AVSmark_output_unchanged("geometry");
        return(1);
	 ***/
   }
   else
   {
       AVSmark_output_unchanged("X-Index");
       AVSmark_output_unchanged("Y-Index");
   }


   /* create the output geometric structure pointers */
   *output   = GEOMinit_edit_list(*output);
   obj       = GEOMcreate_obj ( GEOM_POLYHEDRON, GEOM_NULL );
   obj_sheet = GEOMcreate_obj ( GEOM_POLYHEDRON, GEOM_NULL );
   obj_base  = GEOMcreate_obj ( GEOM_POLYTRI,    GEOM_NULL );
   obj_label = GEOMcreate_label(GEOM_NULL, NULL);
   obj_pick  = GEOMcreate_obj ( GEOM_POLYHEDRON, GEOM_NULL );


   /* create the main city scape 3D bar chart here */
   if ( draw_cityscape )
   {
       draw_city (obj, obj_pick, input->data, secondary, colormap,
	      color_lut, MAXX(input), MAXY(input),
	      *fwidth, *zscale, ix, iy );
   }
   /* create the side averages here */
   if ( draw_sidebars )
   {
       draw_averages (obj, input->data, colormap,
	      color_lut, MAXX(input), MAXY(input),
	      *fwidth, *zscale, *foffset );
   }
   if ( secondary != NULL && draw_sidebars )
   {
       draw_averages (obj, secondary->data, colormap,
	      color_lut, MAXX(input), MAXY(input),
	      *fwidth, *zscale, 2.0 * (*foffset) );
   }

   /* draw a base sheet, at threshold level */
   if ( draw_threshold )
   {
       draw_sheet (obj_sheet, *fwidth, *zscale, *threshold,
                MAXX(input), MAXY(input) );
   }

   /* draw a base line around city */
   if ( draw_ticmarks )
   {
       draw_base_line (obj_base, *fwidth, MAXX(input), MAXY(input),
                   *foffset, *threshold, *zscale, *tic_scale );
   }

   /* draw in the text labels */
   if ( draw_labels )
   {
       draw_label_object (obj_label, *fwidth, MAXX(input), MAXY(input),
                   *foffset, *threshold, *zscale, *tic_scale,
                   h_label_inc, v_label_inc, x_axis_text, y_axis_text );
   }

   GEOMgen_normals(obj, 0); 
   GEOMcvt_polyh_to_polytri(obj,
	GEOM_NO_CONNECTIVITY | GEOM_SURFACE | GEOM_WIREFRAME);
   GEOMcvt_polyh_to_polytri(obj_pick,
	GEOM_NO_CONNECTIVITY | GEOM_SURFACE | GEOM_WIREFRAME);

   GEOMedit_geometry(*output,"city_scape",obj);
   GEOMedit_geometry(*output,"city_scape",obj_base);
   GEOMedit_geometry(*output,"city_scape",obj_label);
   GEOMedit_geometry(*output,"city_scape_pick",obj_pick);
   GEOMedit_geometry(*output,"city_scape_threshold",obj_sheet);
   GEOMedit_transform_mode(*output, "city_scape", "parent",0);
   GEOMedit_transform_mode(*output, "city_scape_pick", "parent",0);
   GEOMedit_transform_mode(*output, "city_scape_threshold", "parent",0);
   GEOMedit_selection_mode(*output,"city_scape",
                   "notify", BUTTON_MOVING | BUTTON_DOWN );


   GEOMdestroy_obj(obj);
   GEOMdestroy_obj(obj_sheet);
   GEOMdestroy_obj(obj_base);
   GEOMdestroy_obj(obj_label);
   GEOMdestroy_obj(obj_pick);


   return(1);
}

/**********************************************************************/
/* Geometric Object Creation Routine */
draw_city ( obj, obj_pick, fmesh, secondary,
            colormap,  color_lut,
            nx, ny,
            width,
            zscale,
            ix, iy )

    GEOMobj *obj;
    GEOMobj *obj_pick;
    float   *fmesh;
    AVSfield_float *secondary;
    AVScolormap *colormap;
    unsigned int  *color_lut;
    int     nx, ny;
    float   width, zscale;
    int ix, iy;

{

   int i,j;
   int index;
   float xpos, ypos, height;
   float spacing;
   unsigned int color;
   int vdata_tag;
   int hilite;

   if ( nx < ny ) spacing = (float)ny;
   else           spacing = (float)nx;

   for (i=0; i<ny; i++) {
     for (j=0; j<nx; j++) {

       if ( secondary )
           index = PIXELget_index(colormap, secondary->data[i*nx+j]);
       else
           index = PIXELget_index(colormap, fmesh[i*nx+j]);

       color = color_lut[index];
       xpos  = (float) j / spacing;
       ypos  = (float)(ny-i-1) / spacing;
       height = zscale * fmesh[i*nx+j];
       vdata_tag = j * nx + i;

       if ( i==ix && j==iy ) {
           hilite=1;
           draw_a_box (obj_pick, xpos, ypos, height,
                   0.5*width/spacing, color, vdata_tag, hilite );
       }
       else
       {
           hilite=0;
           draw_a_box (obj, xpos, ypos, height,
                   0.5*width/spacing, color, vdata_tag, hilite );
       }


     }
   }

}

/**********************************************************************/
/* Secondary Side Bar Geometric Object Creation Routine */
/**********************************************************************/
draw_averages ( obj, fmesh, colormap,  color_lut,
		nx, ny, width, zscale, offset )
    GEOMobj *obj;
    float   *fmesh;
    AVScolormap *colormap;
    unsigned int  *color_lut;
    int     nx, ny;
    float   width, zscale, offset;
{

   int i,j;
   int index;
   float xpos, ypos, height;
   float spacing, base;
   unsigned int color;
   float average, minimum, maximum;

   if ( nx < ny ) spacing = (float)ny;
   else           spacing = (float)nx;

   for (i=0; i<ny; i++) {
     average = 0;
     minimum = maximum = fmesh[i*nx];
     for (j=0; j<nx; j++) {
       average += fmesh[i*nx+j];
       if ( maximum < fmesh[i*nx+j] ) maximum = fmesh[i*nx+j];
       if ( minimum > fmesh[i*nx+j] ) minimum = fmesh[i*nx+j];
     }
     average /= (float)nx;

     index = PIXELget_index(colormap, minimum);
     color = color_lut[index];
     xpos  = (float) nx / spacing + offset;
     ypos  = ((float)(ny-i-1) / spacing );
     height = zscale * average;
     base   = zscale * minimum;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 0 );

     index = PIXELget_index(colormap, maximum);
     color = color_lut[index];
     height = zscale * maximum;
     base   = zscale * average;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 0 );
   }

   for (j=0; j<nx; j++) {
     average = 0;
     minimum = maximum = fmesh[j];
     for (i=0; i<ny; i++) {
       average += fmesh[i*nx+j];
       if ( maximum < fmesh[i*nx+j] ) maximum = fmesh[i*nx+j];
       if ( minimum > fmesh[i*nx+j] ) minimum = fmesh[i*nx+j];
     }
     average /= (float)ny;

     index = PIXELget_index(colormap, minimum);
     color = color_lut[index];
     xpos  = (float) j / spacing;
     ypos  = 1.0 + offset;
     height = zscale * average;
     base   = zscale * minimum;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 1 );

     index = PIXELget_index(colormap, maximum);
     color = color_lut[index];
     height = zscale * maximum;
     base   = zscale * average;
     draw_a_side (obj, xpos, ypos, base, height, 0.5*width/spacing, color, 1 );
   }


}

/**********************************************************************/
/* routine to draw one box of certain size and position */
/**********************************************************************/

draw_a_box (obj, xpos, ypos, height, width, bcolor, vdata_tag, hilite )
    GEOMobj *obj;
    float xpos, ypos, height, width;
    unsigned int bcolor;
    int vdata_tag;
    int hilite;
{
         float verts[ 4 * 3 ];
         int   cols  [ 4 ];  
         int   vdata [ 4 ];  
	 unsigned int   hi_col;
	 unsigned int   color;

         vdata[0]=vdata[1]=vdata[2]=vdata[3] = vdata_tag;

	 hi_col = 0xffffffff;
	 if ( hilite )
	     color = hi_col;
         else
	     color = bcolor;

         /* draw top quad */
         verts[ 0 * 3 + 0 ] = xpos - width;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = height;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos - width;
	 verts[ 1 * 3 + 1 ] = ypos + width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos + width;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos + width;
	 verts[ 3 * 3 + 1 ] = ypos - width;
	 verts[ 3 * 3 + 2 ] = height;
	 cols [ 3 ]         = color;
         draw_disj_quad( obj, verts, cols, vdata );

         color = bcolor;

         /* draw back quad */
         verts[ 0 * 3 + 0 ] = xpos - width;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = 0.0;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos - width;
	 verts[ 1 * 3 + 1 ] = ypos - width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos - width;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos - width;
	 verts[ 3 * 3 + 1 ] = ypos + width;
	 verts[ 3 * 3 + 2 ] = 0;
	 cols [ 3 ]         = color;
         draw_disj_quad( obj, verts, cols, vdata );

         /* draw front quad */
         verts[ 0 * 3 + 0 ] = xpos - width;
	 verts[ 0 * 3 + 1 ] = ypos + width;
	 verts[ 0 * 3 + 2 ] = 0;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos - width;
	 verts[ 1 * 3 + 1 ] = ypos + width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos + width;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos + width;
	 verts[ 3 * 3 + 1 ] = ypos + width;
	 verts[ 3 * 3 + 2 ] = 0.0;
	 cols [ 3 ]         = color;
         draw_disj_quad( obj, verts, cols, vdata );

         /* draw left side quad */
         verts[ 0 * 3 + 0 ] = xpos - width;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = 0.0;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos - width;
	 verts[ 1 * 3 + 1 ] = ypos - width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos + width;
	 verts[ 2 * 3 + 1 ] = ypos - width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos + width;
	 verts[ 3 * 3 + 1 ] = ypos - width;
	 verts[ 3 * 3 + 2 ] = 0.0;
	 cols [ 3 ]         = color;
         draw_disj_quad( obj, verts, cols, vdata );


         /* draw right side  quad */
         verts[ 0 * 3 + 0 ] = xpos + width;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = 0.0;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos + width;
	 verts[ 1 * 3 + 1 ] = ypos - width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos + width;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos + width;
	 verts[ 3 * 3 + 1 ] = ypos + width;
	 verts[ 3 * 3 + 2 ] = 0.0;
	 cols [ 3 ]         = color;
         draw_disj_quad( obj, verts, cols, vdata );
} 


/**********************************************************************/
/* routine to draw one disjoint quadrilateral utility */
/**********************************************************************/
draw_disj_quad( obj, verts, cols, vdata )

         GEOMobj *obj;
         float *verts;
         int   *cols;  
         int   *vdata;  
{
         int i;
         float l_verts[ 4 * 3 ];

         /**
            ... hollow color experiment, draw a hollow quad ...
         for (i=0; i < 4 * 3; i++ )
             l_verts[i] = verts[i];

          **/
         GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
				   GEOM_NOT_SHARED, GEOM_COPY_DATA);
         GEOMadd_int_colors(obj, cols, 4, GEOM_COPY_DATA);
         GEOMadd_prim_data (obj, vdata, 1, GEOM_COPY_DATA);
}

/**********************************************************************/
/* routine to draw one averaged quadrilateral of certain size and position */
/**********************************************************************/

draw_a_side (obj, xpos, ypos, base, height, width, color, flip )
    GEOMobj *obj;
    float xpos, ypos, height, width, base;
    unsigned int color;
    int flip;
{
       float verts[ 4 * 3 ];
       int   cols [ 4 ];  
       int   vdata [ 4 ];  

       vdata[0]=vdata[1]=vdata[2]=vdata[3] = -1;

       if ( flip == 0 )
       {
         /* draw side average quad */
         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = ypos - width;
	 verts[ 0 * 3 + 2 ] = base;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = ypos - width;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos;
	 verts[ 2 * 3 + 1 ] = ypos + width;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos;
	 verts[ 3 * 3 + 1 ] = ypos + width;
	 verts[ 3 * 3 + 2 ] = base;
	 cols [ 3 ]         = color;

       } else {

         verts[ 0 * 3 + 0 ] = xpos + width;
	 verts[ 0 * 3 + 1 ] = ypos;
	 verts[ 0 * 3 + 2 ] = base;
	 cols [ 0 ]         = color;

         verts[ 1 * 3 + 0 ] = xpos + width;
	 verts[ 1 * 3 + 1 ] = ypos;
	 verts[ 1 * 3 + 2 ] = height;
	 cols [ 1 ]         = color;

         verts[ 2 * 3 + 0 ] = xpos - width;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;
	 cols [ 2 ]         = color;

         verts[ 3 * 3 + 0 ] = xpos - width;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = base;
	 cols [ 3 ]         = color;
       }

       GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
                                  GEOM_NOT_SHARED, GEOM_COPY_DATA);
       GEOMadd_int_colors(obj, cols, 4, GEOM_COPY_DATA);
       GEOMadd_prim_data (obj, vdata, 1, GEOM_COPY_DATA);

} 


/**********************************************************************/
/* routine to draw one threshold quadrilateral over city */
/**********************************************************************/

draw_sheet (obj, width, zscale, threshold, nx, ny )
    GEOMobj *obj;
    float width, zscale, threshold; 
    int nx, ny;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float verts[ 4 * 3 ];
       int   vdata [ 4 ];  

       vdata[0]=vdata[1]=vdata[2]=vdata[3] = -1;

       height = zscale * threshold;
       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

         /* draw one quad */
         verts[ 0 * 3 + 0 ] = minx;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = minx;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = maxx;
	 verts[ 2 * 3 + 1 ] = maxy;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = miny;
	 verts[ 3 * 3 + 2 ] = height;

       GEOMadd_disjoint_polygon ( obj, verts, NULL, NULL, 4,
                                  GEOM_NOT_SHARED, GEOM_COPY_DATA);
       GEOMadd_prim_data (obj, vdata, 1, GEOM_COPY_DATA);
}


/**********************************************************************/
/* routine to draw one base polyline and tick marks */
/**********************************************************************/

draw_base_line (obj, width, nx, ny, offset, threshold, zscale, tic_scale )
    GEOMobj *obj;
    float width; 
    int nx, ny;
    float offset;
    float threshold;
    float zscale;
    float tic_scale;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float xpos, ypos;
       float verts[ 5 * 3 ];
       int i, j;

       height = 0.0;
       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

         /* draw one quad around the base of city */
         verts[ 0 * 3 + 0 ] = minx;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = minx;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = maxx;
	 verts[ 2 * 3 + 1 ] = maxy;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = miny;
	 verts[ 3 * 3 + 2 ] = height;

         verts[ 4 * 3 + 0 ] = minx;
	 verts[ 4 * 3 + 1 ] = miny;
	 verts[ 4 * 3 + 2 ] = height;

       /* draw the two pairs */
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);
       GEOMadd_disjoint_line ( obj, &verts[3], NULL, 4, GEOM_COPY_DATA);

       /* draw some lines at base of shadow averages */
         /* draw two lines */
         xpos  = 1.0 + offset;
         ypos  = 1.0 + offset;

         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = minx;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = height;
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);

       /* draw some lines at threshold sheet near averages */
         /* draw two lines */
         height = threshold * zscale;
         xpos  = 1.0 + offset * 0.98;
         ypos  = 1.0 + offset * 0.98;

         verts[ 0 * 3 + 0 ] = xpos;
	 verts[ 0 * 3 + 1 ] = miny;
	 verts[ 0 * 3 + 2 ] = height;

         verts[ 1 * 3 + 0 ] = xpos;
	 verts[ 1 * 3 + 1 ] = maxy;
	 verts[ 1 * 3 + 2 ] = height;

         verts[ 2 * 3 + 0 ] = minx;
	 verts[ 2 * 3 + 1 ] = ypos;
	 verts[ 2 * 3 + 2 ] = height;

         verts[ 3 * 3 + 0 ] = maxx;
	 verts[ 3 * 3 + 1 ] = ypos;
	 verts[ 3 * 3 + 2 ] = height;
       GEOMadd_disjoint_line ( obj, verts, NULL, 4, GEOM_COPY_DATA);


       /* add some tick marks along front edge */
       height = 0.0;
       for (i=0; i<ny; i++) {
               ypos  = (float)(ny-i-1) / spacing;

               verts[ 0 * 3 + 0 ] = minx;
	       verts[ 0 * 3 + 1 ] = ypos;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = minx - 0.10;
	       verts[ 1 * 3 + 1 ] = ypos;         /* hand code length */
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }

       for (j=0; j<nx; j++) {
               xpos  = (float) j / spacing;
               verts[ 0 * 3 + 0 ] = xpos;
	       verts[ 0 * 3 + 1 ] = miny;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = xpos;
	       verts[ 1 * 3 + 1 ] = miny - 0.10;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }

       /* put some vertical ticks on shadow averages */
       for (i=0; i< NUM_V_TICS; i++) {
               height  = (float) i * tic_scale * zscale;

               verts[ 0 * 3 + 0 ] = 1.0 + offset;
	       verts[ 0 * 3 + 1 ] = miny;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = 1.0 + offset;
	       verts[ 1 * 3 + 1 ] = miny - 0.10;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);

               verts[ 0 * 3 + 0 ] = minx;
	       verts[ 0 * 3 + 1 ] = 1.0 + offset;
	       verts[ 0 * 3 + 2 ] = height;

               verts[ 1 * 3 + 0 ] = minx - 0.10;
	       verts[ 1 * 3 + 1 ] = 1.0 + offset;
	       verts[ 1 * 3 + 2 ] = height;
               GEOMadd_disjoint_line ( obj, verts, NULL, 2, GEOM_COPY_DATA);
       }


}


/**********************************************************************/
/* routine to draw labels */
/**********************************************************************/

draw_label_object (obj, width,
             nx, ny, offset,
             threshold, zscale, tic_scale,
             h_label_inc, v_label_inc,
             x_axis_text, y_axis_text  )

    GEOMobj *obj;
    float width; 
    int nx, ny;
    float offset;
    float threshold;
    float zscale;
    float tic_scale;
    int   h_label_inc, v_label_inc;
    char  *x_axis_text;
    char  *y_axis_text;
{
       float minx, miny, maxx, maxy, height, spacing; 
       float xpos, ypos;
       float verts[ 5 * 3 ];
       int i, j;
       int label_flags;
       int label_flags_r;
       int font, title, background, drop, align, stroke;
       float label_center[3];
       float label_offset[3];
       float label_size;
       char  string[300];
       char  temp[300];
       int   x_axis_str_size;
       int   y_axis_str_size;
       char  x_delim[3];
       char  y_delim[3];
       char  *pp;

       /*
        * Check spacing for label positions
        */
       if ( nx < ny ) spacing = (float)ny;
       else           spacing = (float)nx;
       minx = -width*0.5/spacing;
       miny = -width*0.5/spacing;
       maxx = ((float)(nx-1) + width*0.5)/spacing;
       maxy = ((float)(ny-1) + width*0.5)/spacing;

       /*
        * Set Label Characteristics
        */
       font = 1;                   /* font 0-21 */
       title = 0;                  /* use ref_point */
       background = 1;             /* 1=filled rectable */
       drop = 1;                   /* 0=no, 1=drop shadow */
       stroke = 0;                 /* always zero */
       align = GEOM_LABEL_LEFT;
       label_size = 0.04;          /* height in screen space */
       label_center[2] =
       label_offset[0] = label_offset[1] = label_offset[2] = 0.0;
       label_flags = GEOMcreate_label_flags(
                font, title, background, drop,align, stroke);
       align = GEOM_LABEL_RIGHT;
       label_flags_r = GEOMcreate_label_flags(
                font, title, background, drop,align, stroke);

       /*
        * X axis labels 
        * Pre-process special axis string
        * First char in string is delimiter
        * If label string is null, then use numeric labels
        */
       x_axis_str_size = strlen( x_axis_text );

       if ( x_axis_str_size > 0 )
       {
           strcpy( temp, x_axis_text );
           pp = temp + 1;
           x_delim[0] = x_axis_text[0];
           x_delim[1] = '\0';
       }

       /* add labels to tick marks along front edge */
       for (i=0; i<ny; i += h_label_inc) {
               label_center[0] = minx - 0.15;
               label_center[1] = (float)(ny-i-1) / spacing;

               if ( x_axis_str_size > 1 )
               {
                   sprintf(string, "%s",  strtok( pp, x_delim ));
                   pp = NULL;
               }
               else
               {
                   sprintf(string,"%d",i);
               }

               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }

       /* Y axis labels *
       /* add labels to tick marks along THE OTHER front edge */

       /*
        * Y axis labels 
        * Pre-process special axis string
        */
       y_axis_str_size = strlen( y_axis_text );

       if ( y_axis_str_size > 1 )
       {
           strcpy( temp, y_axis_text );
           pp = temp + 1;
           y_delim[0] = y_axis_text[0];
           y_delim[1] = '\0';
       }


       for (j=0; j<nx; j += h_label_inc) {
               label_center[0] = (float) j / spacing;
               label_center[1] = miny - 0.15;

               if ( y_axis_str_size > 0 )
               {
                   sprintf(string, "%s",  strtok( pp, y_delim ));
                   pp = NULL;
               }
               else
               {
                   sprintf(string,"%d",j);
               }

               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }

       /* put a label on the threshold sheet */
/* dissabled
       label_center[0] = 1.0 + offset;
       label_center[1] = miny;
       label_center[2] = threshold * zscale;
       sprintf(string,"<- %f",threshold);
       GEOMadd_label ( obj, string, label_center,
               label_offset, label_size, GEOM_NULL, label_flags );
*/

       /* put labels on the vertical tics */
       for (i=0; i< NUM_V_TICS; i  += v_label_inc) {
               sprintf(string,"%3.2f", (float)i * tic_scale );
               label_center[2] = (float) i * tic_scale * zscale;
               label_center[0] = minx - 0.15;
               label_center[1] = 1.0 + offset;
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags_r );
               label_center[0] = 1.0 + offset;
               label_center[1] = miny - 0.15;
               GEOMadd_label ( obj, string, label_center,
                       label_offset, label_size, GEOM_NULL, label_flags );
       }
}

/**********************************************************************/
/*
 * initialization for modules contained in this file.
 */
#ifdef sep_exe
int ((*mapper_mod_list[])()) = {
  MODcity_scape,
};

#define NMODS sizeof(mapper_mod_list) / sizeof(char *) 

AVSinit_modules ()
{
	AVSinit_from_module_list(mapper_mod_list, NMODS);
}
#endif
/**********************************************************************/


